/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.NullnessCasts;
import com.google.common.util.concurrent.ParametricNullness;
import com.google.common.util.concurrent.Platform;
import com.google.common.util.concurrent.internal.InternalFutureFailureAccess;
import com.google.common.util.concurrent.internal.InternalFutures;
import com.google.errorprone.annotations.ForOverride;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
abstract class AbstractCatchingFuture<V, X extends Throwable, F, T>
extends FluentFuture.TrustedFuture<V>
implements Runnable {
    @CheckForNull
    @LazyInit
    ListenableFuture<? extends V> inputFuture;
    @CheckForNull
    @LazyInit
    Class<X> exceptionType;
    @CheckForNull
    @LazyInit
    F fallback;

    static <V, X extends Throwable> ListenableFuture<V> create(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, Function<? super X, ? extends V> function, Executor executor) {
        CatchingFuture<? extends V, ? super X> catchingFuture = new CatchingFuture<V, X>(listenableFuture, clazz, function);
        listenableFuture.addListener(catchingFuture, MoreExecutors.rejectionPropagatingExecutor(executor, catchingFuture));
        return catchingFuture;
    }

    static <X extends Throwable, V> ListenableFuture<V> create(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, AsyncFunction<? super X, ? extends V> asyncFunction, Executor executor) {
        AsyncCatchingFuture<? extends V, ? super X> asyncCatchingFuture = new AsyncCatchingFuture<V, X>(listenableFuture, clazz, asyncFunction);
        listenableFuture.addListener(asyncCatchingFuture, MoreExecutors.rejectionPropagatingExecutor(executor, asyncCatchingFuture));
        return asyncCatchingFuture;
    }

    AbstractCatchingFuture(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, F f) {
        this.inputFuture = Preconditions.checkNotNull(listenableFuture);
        this.exceptionType = Preconditions.checkNotNull(clazz);
        this.fallback = Preconditions.checkNotNull(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        T t2;
        F f;
        Class<X> clazz;
        ListenableFuture<V> listenableFuture = this.inputFuture;
        if (listenableFuture == null | (clazz = this.exceptionType) == null | (f = this.fallback) == null || this.isCancelled()) {
            return;
        }
        this.inputFuture = null;
        Object t3 = null;
        Throwable throwable = null;
        try {
            if (listenableFuture instanceof InternalFutureFailureAccess) {
                throwable = InternalFutures.tryInternalFastPathGetFailure((InternalFutureFailureAccess)((Object)listenableFuture));
            }
            if (throwable == null) {
                t3 = Futures.getDone(listenableFuture);
            }
        }
        catch (ExecutionException executionException) {
            throwable = executionException.getCause();
            if (throwable == null) {
                throwable = new NullPointerException("Future type " + listenableFuture.getClass() + " threw " + executionException.getClass() + " without a cause");
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        if (throwable == null) {
            this.set(NullnessCasts.uncheckedCastNullableTToT(t3));
            return;
        }
        if (!Platform.isInstanceOfThrowableClass(throwable, clazz)) {
            this.setFuture(listenableFuture);
            return;
        }
        Throwable throwable3 = throwable;
        try {
            t2 = this.doFallback(f, throwable3);
        }
        catch (Throwable throwable4) {
            Platform.restoreInterruptIfIsInterruptedException(throwable4);
            this.setException(throwable4);
            return;
        }
        finally {
            this.exceptionType = null;
            this.fallback = null;
        }
        this.setResult(t2);
    }

    @Override
    @CheckForNull
    protected String pendingToString() {
        ListenableFuture<? extends V> listenableFuture = this.inputFuture;
        Class<X> clazz = this.exceptionType;
        F f = this.fallback;
        String string = super.pendingToString();
        String string2 = "";
        if (listenableFuture != null) {
            string2 = "inputFuture=[" + listenableFuture + "], ";
        }
        if (clazz != null && f != null) {
            return string2 + "exceptionType=[" + clazz + "], fallback=[" + f + "]";
        }
        if (string != null) {
            return string2 + string;
        }
        return null;
    }

    @ParametricNullness
    @ForOverride
    abstract T doFallback(F var1, X var2) throws Exception;

    @ForOverride
    abstract void setResult(@ParametricNullness T var1);

    @Override
    protected final void afterDone() {
        this.maybePropagateCancellationTo(this.inputFuture);
        this.inputFuture = null;
        this.exceptionType = null;
        this.fallback = null;
    }

    private static final class CatchingFuture<V, X extends Throwable>
    extends AbstractCatchingFuture<V, X, Function<? super X, ? extends V>, V> {
        CatchingFuture(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, Function<? super X, ? extends V> function) {
            super(listenableFuture, clazz, function);
        }

        @Override
        @ParametricNullness
        V doFallback(Function<? super X, ? extends V> function, X x) throws Exception {
            return function.apply(x);
        }

        @Override
        void setResult(@ParametricNullness V v) {
            this.set(v);
        }
    }

    private static final class AsyncCatchingFuture<V, X extends Throwable>
    extends AbstractCatchingFuture<V, X, AsyncFunction<? super X, ? extends V>, ListenableFuture<? extends V>> {
        AsyncCatchingFuture(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, AsyncFunction<? super X, ? extends V> asyncFunction) {
            super(listenableFuture, clazz, asyncFunction);
        }

        @Override
        ListenableFuture<? extends V> doFallback(AsyncFunction<? super X, ? extends V> asyncFunction, X x) throws Exception {
            ListenableFuture<? extends V> listenableFuture = asyncFunction.apply(x);
            Preconditions.checkNotNull(listenableFuture, "AsyncFunction.apply returned null instead of a Future. Did you mean to return immediateFuture(null)? %s", asyncFunction);
            return listenableFuture;
        }

        @Override
        void setResult(ListenableFuture<? extends V> listenableFuture) {
            this.setFuture(listenableFuture);
        }
    }
}

