/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.ElementTypesAreNonnullByDefault;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.TypeCapture;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeResolver;
import com.google.common.reflect.TypeVisitor;
import com.google.common.reflect.Types;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
public abstract class TypeToken<T>
extends TypeCapture<T>
implements Serializable {
    private final Type runtimeType;
    @LazyInit
    @CheckForNull
    private transient TypeResolver invariantTypeResolver;
    @LazyInit
    @CheckForNull
    private transient TypeResolver covariantTypeResolver;
    private static final long serialVersionUID = 3637540370352322684L;

    protected TypeToken() {
        this.runtimeType = this.capture();
        Preconditions.checkState(!(this.runtimeType instanceof TypeVariable), "Cannot construct a TypeToken for a type variable.\nYou probably meant to call new TypeToken<%s>(getClass()) that can resolve the type variable for you.\nIf you do need to create a TypeToken of a type variable, please use TypeToken.of() instead.", (Object)this.runtimeType);
    }

    protected TypeToken(Class<?> clazz) {
        Type type = super.capture();
        this.runtimeType = type instanceof Class ? type : TypeResolver.covariantly(clazz).resolveType(type);
    }

    private TypeToken(Type type) {
        this.runtimeType = Preconditions.checkNotNull(type);
    }

    public static <T> TypeToken<T> of(Class<T> clazz) {
        return new SimpleTypeToken((Type)clazz);
    }

    public static TypeToken<?> of(Type type) {
        return new SimpleTypeToken(type);
    }

    public final Class<? super T> getRawType() {
        Class clazz;
        Class clazz2 = clazz = (Class)this.getRawTypes().iterator().next();
        return clazz2;
    }

    public final Type getType() {
        return this.runtimeType;
    }

    public final <X> TypeToken<T> where(TypeParameter<X> typeParameter, TypeToken<X> typeToken) {
        TypeResolver typeResolver = new TypeResolver().where(ImmutableMap.of(new TypeResolver.TypeVariableKey(typeParameter.typeVariable), typeToken.runtimeType));
        return new SimpleTypeToken(typeResolver.resolveType(this.runtimeType));
    }

    public final <X> TypeToken<T> where(TypeParameter<X> typeParameter, Class<X> clazz) {
        return this.where(typeParameter, TypeToken.of(clazz));
    }

    public final TypeToken<?> resolveType(Type type) {
        Preconditions.checkNotNull(type);
        return TypeToken.of(this.getInvariantTypeResolver().resolveType(type));
    }

    private TypeToken<?> resolveSupertype(Type type) {
        TypeToken<?> typeToken = TypeToken.of(this.getCovariantTypeResolver().resolveType(type));
        typeToken.covariantTypeResolver = this.covariantTypeResolver;
        typeToken.invariantTypeResolver = this.invariantTypeResolver;
        return typeToken;
    }

    @CheckForNull
    final TypeToken<? super T> getGenericSuperclass() {
        if (this.runtimeType instanceof TypeVariable) {
            return this.boundAsSuperclass(((TypeVariable)this.runtimeType).getBounds()[0]);
        }
        if (this.runtimeType instanceof WildcardType) {
            return this.boundAsSuperclass(((WildcardType)this.runtimeType).getUpperBounds()[0]);
        }
        Type type = this.getRawType().getGenericSuperclass();
        if (type == null) {
            return null;
        }
        TypeToken<?> typeToken = this.resolveSupertype(type);
        return typeToken;
    }

    @CheckForNull
    private TypeToken<? super T> boundAsSuperclass(Type type) {
        TypeToken<?> typeToken = TypeToken.of(type);
        if (typeToken.getRawType().isInterface()) {
            return null;
        }
        TypeToken<?> typeToken2 = typeToken;
        return typeToken2;
    }

    final ImmutableList<TypeToken<? super T>> getGenericInterfaces() {
        if (this.runtimeType instanceof TypeVariable) {
            return this.boundsAsInterfaces(((TypeVariable)this.runtimeType).getBounds());
        }
        if (this.runtimeType instanceof WildcardType) {
            return this.boundsAsInterfaces(((WildcardType)this.runtimeType).getUpperBounds());
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Type type : this.getRawType().getGenericInterfaces()) {
            TypeToken<?> typeToken = this.resolveSupertype(type);
            builder.add(typeToken);
        }
        return builder.build();
    }

    private ImmutableList<TypeToken<? super T>> boundsAsInterfaces(Type[] typeArray) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Type type : typeArray) {
            TypeToken<?> typeToken = TypeToken.of(type);
            if (!typeToken.getRawType().isInterface()) continue;
            builder.add(typeToken);
        }
        return builder.build();
    }

    public final TypeSet getTypes() {
        return new TypeSet();
    }

    public final TypeToken<? super T> getSupertype(Class<? super T> clazz) {
        Preconditions.checkArgument(this.someRawTypeIsSubclassOf(clazz), "%s is not a super class of %s", clazz, (Object)this);
        if (this.runtimeType instanceof TypeVariable) {
            return this.getSupertypeFromUpperBounds(clazz, ((TypeVariable)this.runtimeType).getBounds());
        }
        if (this.runtimeType instanceof WildcardType) {
            return this.getSupertypeFromUpperBounds(clazz, ((WildcardType)this.runtimeType).getUpperBounds());
        }
        if (clazz.isArray()) {
            return this.getArraySupertype(clazz);
        }
        TypeToken<?> typeToken = this.resolveSupertype(TypeToken.toGenericType(clazz).runtimeType);
        return typeToken;
    }

    public final TypeToken<? extends T> getSubtype(Class<?> clazz) {
        Preconditions.checkArgument(!(this.runtimeType instanceof TypeVariable), "Cannot get subtype of type variable <%s>", (Object)this);
        if (this.runtimeType instanceof WildcardType) {
            return this.getSubtypeFromLowerBounds(clazz, ((WildcardType)this.runtimeType).getLowerBounds());
        }
        if (this.isArray()) {
            return this.getArraySubtype(clazz);
        }
        Preconditions.checkArgument(this.getRawType().isAssignableFrom(clazz), "%s isn't a subclass of %s", clazz, (Object)this);
        Type type = this.resolveTypeArgsForSubclass(clazz);
        TypeToken<?> typeToken = TypeToken.of(type);
        Preconditions.checkArgument(typeToken.isSubtypeOf(this), "%s does not appear to be a subtype of %s", typeToken, (Object)this);
        return typeToken;
    }

    public final boolean isSupertypeOf(TypeToken<?> typeToken) {
        return typeToken.isSubtypeOf(this.getType());
    }

    public final boolean isSupertypeOf(Type type) {
        return TypeToken.of(type).isSubtypeOf(this.getType());
    }

    public final boolean isSubtypeOf(TypeToken<?> typeToken) {
        return this.isSubtypeOf(typeToken.getType());
    }

    public final boolean isSubtypeOf(Type type) {
        Preconditions.checkNotNull(type);
        if (type instanceof WildcardType) {
            return TypeToken.any(((WildcardType)type).getLowerBounds()).isSupertypeOf(this.runtimeType);
        }
        if (this.runtimeType instanceof WildcardType) {
            return TypeToken.any(((WildcardType)this.runtimeType).getUpperBounds()).isSubtypeOf(type);
        }
        if (this.runtimeType instanceof TypeVariable) {
            return this.runtimeType.equals(type) || TypeToken.any(((TypeVariable)this.runtimeType).getBounds()).isSubtypeOf(type);
        }
        if (this.runtimeType instanceof GenericArrayType) {
            return super.isSupertypeOfArray((GenericArrayType)this.runtimeType);
        }
        if (type instanceof Class) {
            return this.someRawTypeIsSubclassOf((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return this.isSubtypeOfParameterizedType((ParameterizedType)type);
        }
        if (type instanceof GenericArrayType) {
            return this.isSubtypeOfArrayType((GenericArrayType)type);
        }
        return false;
    }

    public final boolean isArray() {
        return this.getComponentType() != null;
    }

    public final boolean isPrimitive() {
        return this.runtimeType instanceof Class && ((Class)this.runtimeType).isPrimitive();
    }

    public final TypeToken<T> wrap() {
        if (this.isPrimitive()) {
            Class clazz = (Class)this.runtimeType;
            return TypeToken.of(Primitives.wrap(clazz));
        }
        return this;
    }

    private boolean isWrapper() {
        return Primitives.allWrapperTypes().contains(this.runtimeType);
    }

    public final TypeToken<T> unwrap() {
        if (this.isWrapper()) {
            Class clazz = (Class)this.runtimeType;
            return TypeToken.of(Primitives.unwrap(clazz));
        }
        return this;
    }

    @CheckForNull
    public final TypeToken<?> getComponentType() {
        Type type = Types.getComponentType(this.runtimeType);
        if (type == null) {
            return null;
        }
        return TypeToken.of(type);
    }

    public final Invokable<T, Object> method(Method method) {
        Preconditions.checkArgument(this.someRawTypeIsSubclassOf(method.getDeclaringClass()), "%s not declared by %s", (Object)method, (Object)this);
        return new Invokable.MethodInvokable<T>(method){

            @Override
            Type getGenericReturnType() {
                return TypeToken.this.getCovariantTypeResolver().resolveType(super.getGenericReturnType());
            }

            @Override
            Type[] getGenericParameterTypes() {
                return TypeToken.this.getInvariantTypeResolver().resolveTypesInPlace(super.getGenericParameterTypes());
            }

            @Override
            Type[] getGenericExceptionTypes() {
                return TypeToken.this.getCovariantTypeResolver().resolveTypesInPlace(super.getGenericExceptionTypes());
            }

            @Override
            public TypeToken<T> getOwnerType() {
                return TypeToken.this;
            }

            @Override
            public String toString() {
                return this.getOwnerType() + "." + super.toString();
            }
        };
    }

    public final Invokable<T, T> constructor(Constructor<?> constructor) {
        Preconditions.checkArgument(constructor.getDeclaringClass() == this.getRawType(), "%s not declared by %s", constructor, this.getRawType());
        return new Invokable.ConstructorInvokable<T>(constructor){

            @Override
            Type getGenericReturnType() {
                return TypeToken.this.getCovariantTypeResolver().resolveType(super.getGenericReturnType());
            }

            @Override
            Type[] getGenericParameterTypes() {
                return TypeToken.this.getInvariantTypeResolver().resolveTypesInPlace(super.getGenericParameterTypes());
            }

            @Override
            Type[] getGenericExceptionTypes() {
                return TypeToken.this.getCovariantTypeResolver().resolveTypesInPlace(super.getGenericExceptionTypes());
            }

            @Override
            public TypeToken<T> getOwnerType() {
                return TypeToken.this;
            }

            @Override
            public String toString() {
                return this.getOwnerType() + "(" + Joiner.on(", ").join(this.getGenericParameterTypes()) + ")";
            }
        };
    }

    public boolean equals(@CheckForNull Object object) {
        if (object instanceof TypeToken) {
            TypeToken typeToken = (TypeToken)object;
            return this.runtimeType.equals(typeToken.runtimeType);
        }
        return false;
    }

    public int hashCode() {
        return this.runtimeType.hashCode();
    }

    public String toString() {
        return Types.toString(this.runtimeType);
    }

    protected Object writeReplace() {
        return TypeToken.of(new TypeResolver().resolveType(this.runtimeType));
    }

    @CanIgnoreReturnValue
    final TypeToken<T> rejectTypeVariables() {
        new TypeVisitor(){

            @Override
            void visitTypeVariable(TypeVariable<?> typeVariable) {
                throw new IllegalArgumentException(TypeToken.this.runtimeType + "contains a type variable and is not safe for the operation");
            }

            @Override
            void visitWildcardType(WildcardType wildcardType) {
                this.visit(wildcardType.getLowerBounds());
                this.visit(wildcardType.getUpperBounds());
            }

            @Override
            void visitParameterizedType(ParameterizedType parameterizedType) {
                this.visit(parameterizedType.getActualTypeArguments());
                this.visit(parameterizedType.getOwnerType());
            }

            @Override
            void visitGenericArrayType(GenericArrayType genericArrayType) {
                this.visit(genericArrayType.getGenericComponentType());
            }
        }.visit(this.runtimeType);
        return this;
    }

    private boolean someRawTypeIsSubclassOf(Class<?> clazz) {
        for (Class clazz2 : this.getRawTypes()) {
            if (!clazz.isAssignableFrom(clazz2)) continue;
            return true;
        }
        return false;
    }

    private boolean isSubtypeOfParameterizedType(ParameterizedType parameterizedType) {
        Class<?> clazz = TypeToken.of(parameterizedType).getRawType();
        if (!this.someRawTypeIsSubclassOf(clazz)) {
            return false;
        }
        TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        for (int i = 0; i < typeVariableArray.length; ++i) {
            Type type = this.getCovariantTypeResolver().resolveType(typeVariableArray[i]);
            if (super.is(typeArray[i], typeVariableArray[i])) continue;
            return false;
        }
        return Modifier.isStatic(((Class)parameterizedType.getRawType()).getModifiers()) || parameterizedType.getOwnerType() == null || this.isOwnedBySubtypeOf(parameterizedType.getOwnerType());
    }

    private boolean isSubtypeOfArrayType(GenericArrayType genericArrayType) {
        if (this.runtimeType instanceof Class) {
            Class clazz = (Class)this.runtimeType;
            if (!clazz.isArray()) {
                return false;
            }
            return TypeToken.of(clazz.getComponentType()).isSubtypeOf(genericArrayType.getGenericComponentType());
        }
        if (this.runtimeType instanceof GenericArrayType) {
            GenericArrayType genericArrayType2 = (GenericArrayType)this.runtimeType;
            return TypeToken.of(genericArrayType2.getGenericComponentType()).isSubtypeOf(genericArrayType.getGenericComponentType());
        }
        return false;
    }

    private boolean isSupertypeOfArray(GenericArrayType genericArrayType) {
        if (this.runtimeType instanceof Class) {
            Class clazz = (Class)this.runtimeType;
            if (!clazz.isArray()) {
                return clazz.isAssignableFrom(Object[].class);
            }
            return TypeToken.of(genericArrayType.getGenericComponentType()).isSubtypeOf(clazz.getComponentType());
        }
        if (this.runtimeType instanceof GenericArrayType) {
            return TypeToken.of(genericArrayType.getGenericComponentType()).isSubtypeOf(((GenericArrayType)this.runtimeType).getGenericComponentType());
        }
        return false;
    }

    private boolean is(Type type, TypeVariable<?> typeVariable) {
        if (this.runtimeType.equals(type)) {
            return true;
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = TypeToken.canonicalizeWildcardType(typeVariable, (WildcardType)type);
            return TypeToken.every(wildcardType.getUpperBounds()).isSupertypeOf(this.runtimeType) && TypeToken.every(wildcardType.getLowerBounds()).isSubtypeOf(this.runtimeType);
        }
        return TypeToken.canonicalizeWildcardsInType(this.runtimeType).equals(TypeToken.canonicalizeWildcardsInType(type));
    }

    private static Type canonicalizeTypeArg(TypeVariable<?> typeVariable, Type type) {
        return type instanceof WildcardType ? TypeToken.canonicalizeWildcardType(typeVariable, (WildcardType)type) : TypeToken.canonicalizeWildcardsInType(type);
    }

    private static Type canonicalizeWildcardsInType(Type type) {
        if (type instanceof ParameterizedType) {
            return TypeToken.canonicalizeWildcardsInParameterizedType((ParameterizedType)type);
        }
        if (type instanceof GenericArrayType) {
            return Types.newArrayType(TypeToken.canonicalizeWildcardsInType(((GenericArrayType)type).getGenericComponentType()));
        }
        return type;
    }

    private static WildcardType canonicalizeWildcardType(TypeVariable<?> typeVariable, WildcardType wildcardType) {
        Type[] typeArray = typeVariable.getBounds();
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (Type type : wildcardType.getUpperBounds()) {
            if (TypeToken.any(typeArray).isSubtypeOf(type)) continue;
            arrayList.add(TypeToken.canonicalizeWildcardsInType(type));
        }
        return new Types.WildcardTypeImpl(wildcardType.getLowerBounds(), arrayList.toArray(new Type[0]));
    }

    private static ParameterizedType canonicalizeWildcardsInParameterizedType(ParameterizedType parameterizedType) {
        Class clazz = (Class)parameterizedType.getRawType();
        TypeVariable<Class<T>>[] typeVariableArray = clazz.getTypeParameters();
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray[i] = TypeToken.canonicalizeTypeArg(typeVariableArray[i], typeArray[i]);
        }
        return Types.newParameterizedTypeWithOwner(parameterizedType.getOwnerType(), clazz, typeArray);
    }

    private static Bounds every(Type[] typeArray) {
        return new Bounds(typeArray, false);
    }

    private static Bounds any(Type[] typeArray) {
        return new Bounds(typeArray, true);
    }

    private ImmutableSet<Class<? super T>> getRawTypes() {
        final ImmutableSet.Builder builder = ImmutableSet.builder();
        new TypeVisitor(this){

            @Override
            void visitTypeVariable(TypeVariable<?> typeVariable) {
                this.visit(typeVariable.getBounds());
            }

            @Override
            void visitWildcardType(WildcardType wildcardType) {
                this.visit(wildcardType.getUpperBounds());
            }

            @Override
            void visitParameterizedType(ParameterizedType parameterizedType) {
                builder.add((Class)parameterizedType.getRawType());
            }

            @Override
            void visitClass(Class<?> clazz) {
                builder.add(clazz);
            }

            @Override
            void visitGenericArrayType(GenericArrayType genericArrayType) {
                builder.add(Types.getArrayClass(TypeToken.of(genericArrayType.getGenericComponentType()).getRawType()));
            }
        }.visit(this.runtimeType);
        ImmutableCollection immutableCollection = builder.build();
        return immutableCollection;
    }

    private boolean isOwnedBySubtypeOf(Type type) {
        for (TypeToken typeToken : this.getTypes()) {
            Type type2 = typeToken.getOwnerTypeIfPresent();
            if (type2 == null || !TypeToken.of(type2).isSubtypeOf(type)) continue;
            return true;
        }
        return false;
    }

    @CheckForNull
    private Type getOwnerTypeIfPresent() {
        if (this.runtimeType instanceof ParameterizedType) {
            return ((ParameterizedType)this.runtimeType).getOwnerType();
        }
        if (this.runtimeType instanceof Class) {
            return ((Class)this.runtimeType).getEnclosingClass();
        }
        return null;
    }

    @VisibleForTesting
    static <T> TypeToken<? extends T> toGenericType(Class<T> clazz) {
        Type type;
        if (clazz.isArray()) {
            Type type2 = Types.newArrayType(TypeToken.toGenericType(clazz.getComponentType()).runtimeType);
            TypeToken<?> typeToken = TypeToken.of(type2);
            return typeToken;
        }
        Type[] typeArray = clazz.getTypeParameters();
        Type type3 = type = clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers()) ? TypeToken.toGenericType(clazz.getEnclosingClass()).runtimeType : null;
        if (typeArray.length > 0 || type != null && type != clazz.getEnclosingClass()) {
            TypeToken<?> typeToken = TypeToken.of(Types.newParameterizedTypeWithOwner(type, clazz, typeArray));
            return typeToken;
        }
        return TypeToken.of(clazz);
    }

    private TypeResolver getCovariantTypeResolver() {
        TypeResolver typeResolver = this.covariantTypeResolver;
        if (typeResolver == null) {
            typeResolver = this.covariantTypeResolver = TypeResolver.covariantly(this.runtimeType);
        }
        return typeResolver;
    }

    private TypeResolver getInvariantTypeResolver() {
        TypeResolver typeResolver = this.invariantTypeResolver;
        if (typeResolver == null) {
            typeResolver = this.invariantTypeResolver = TypeResolver.invariantly(this.runtimeType);
        }
        return typeResolver;
    }

    private TypeToken<? super T> getSupertypeFromUpperBounds(Class<? super T> clazz, Type[] typeArray) {
        for (Type type : typeArray) {
            TypeToken<?> typeToken = TypeToken.of(type);
            if (!typeToken.isSubtypeOf(clazz)) continue;
            TypeToken<? super T> typeToken2 = typeToken.getSupertype(clazz);
            return typeToken2;
        }
        throw new IllegalArgumentException(clazz + " isn't a super type of " + this);
    }

    private TypeToken<? extends T> getSubtypeFromLowerBounds(Class<?> clazz, Type[] typeArray) {
        if (typeArray.length > 0) {
            TypeToken<?> typeToken = TypeToken.of(typeArray[0]);
            return typeToken.getSubtype(clazz);
        }
        throw new IllegalArgumentException(clazz + " isn't a subclass of " + this);
    }

    private TypeToken<? super T> getArraySupertype(Class<? super T> clazz) {
        TypeToken<?> typeToken = this.getComponentType();
        if (typeToken == null) {
            throw new IllegalArgumentException(clazz + " isn't a super type of " + this);
        }
        TypeToken<?> typeToken2 = typeToken.getSupertype(Objects.requireNonNull(clazz.getComponentType()));
        TypeToken<?> typeToken3 = TypeToken.of(TypeToken.newArrayClassOrGenericArrayType(typeToken2.runtimeType));
        return typeToken3;
    }

    private TypeToken<? extends T> getArraySubtype(Class<?> clazz) {
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2 == null) {
            throw new IllegalArgumentException(clazz + " does not appear to be a subtype of " + this);
        }
        TypeToken<?> typeToken = Objects.requireNonNull(this.getComponentType()).getSubtype(clazz2);
        TypeToken<?> typeToken2 = TypeToken.of(TypeToken.newArrayClassOrGenericArrayType(typeToken.runtimeType));
        return typeToken2;
    }

    private Type resolveTypeArgsForSubclass(Class<?> clazz) {
        if (this.runtimeType instanceof Class && (clazz.getTypeParameters().length == 0 || this.getRawType().getTypeParameters().length != 0)) {
            return clazz;
        }
        TypeToken<?> typeToken = TypeToken.toGenericType(clazz);
        Type type = typeToken.getSupertype(this.getRawType()).runtimeType;
        return new TypeResolver().where(type, this.runtimeType).resolveType(typeToken.runtimeType);
    }

    private static Type newArrayClassOrGenericArrayType(Type type) {
        return Types.JavaVersion.JAVA7.newArrayType(type);
    }

    private static abstract class TypeCollector<K> {
        static final TypeCollector<TypeToken<?>> FOR_GENERIC_TYPE = new TypeCollector<TypeToken<?>>(){

            @Override
            Class<?> getRawType(TypeToken<?> typeToken) {
                return typeToken.getRawType();
            }

            @Override
            Iterable<? extends TypeToken<?>> getInterfaces(TypeToken<?> typeToken) {
                return typeToken.getGenericInterfaces();
            }

            @Override
            @CheckForNull
            TypeToken<?> getSuperclass(TypeToken<?> typeToken) {
                return typeToken.getGenericSuperclass();
            }
        };
        static final TypeCollector<Class<?>> FOR_RAW_TYPE = new TypeCollector<Class<?>>(){

            @Override
            Class<?> getRawType(Class<?> clazz) {
                return clazz;
            }

            @Override
            Iterable<? extends Class<?>> getInterfaces(Class<?> clazz) {
                return Arrays.asList(clazz.getInterfaces());
            }

            @Override
            @CheckForNull
            Class<?> getSuperclass(Class<?> clazz) {
                return clazz.getSuperclass();
            }
        };

        private TypeCollector() {
        }

        final TypeCollector<K> classesOnly() {
            return new ForwardingTypeCollector<K>(this, this){

                @Override
                Iterable<? extends K> getInterfaces(K k) {
                    return ImmutableSet.of();
                }

                @Override
                ImmutableList<K> collectTypes(Iterable<? extends K> iterable) {
                    ImmutableList.Builder builder = ImmutableList.builder();
                    for (Object k : iterable) {
                        if (this.getRawType(k).isInterface()) continue;
                        builder.add(k);
                    }
                    return super.collectTypes(builder.build());
                }
            };
        }

        final ImmutableList<K> collectTypes(K k) {
            return this.collectTypes((Iterable<? extends K>)ImmutableList.of(k));
        }

        ImmutableList<K> collectTypes(Iterable<? extends K> iterable) {
            HashMap hashMap = Maps.newHashMap();
            for (K k : iterable) {
                this.collectTypes(k, hashMap);
            }
            return TypeCollector.sortKeysByValue(hashMap, Ordering.natural().reverse());
        }

        @CanIgnoreReturnValue
        private int collectTypes(K k, Map<? super K, Integer> map) {
            Integer n = map.get(k);
            if (n != null) {
                return n;
            }
            int n2 = this.getRawType(k).isInterface() ? 1 : 0;
            for (K k2 : this.getInterfaces(k)) {
                n2 = Math.max(n2, this.collectTypes(k2, map));
            }
            Iterator<K> iterator2 = this.getSuperclass(k);
            if (iterator2 != null) {
                n2 = Math.max(n2, this.collectTypes(iterator2, map));
            }
            map.put(k, n2 + 1);
            return n2 + 1;
        }

        private static <K, V> ImmutableList<K> sortKeysByValue(final Map<K, V> map, final Comparator<? super V> comparator) {
            Ordering ordering = new Ordering<K>(){

                @Override
                public int compare(K k, K k2) {
                    return comparator.compare(Objects.requireNonNull(map.get(k)), Objects.requireNonNull(map.get(k2)));
                }
            };
            return ordering.immutableSortedCopy(map.keySet());
        }

        abstract Class<?> getRawType(K var1);

        abstract Iterable<? extends K> getInterfaces(K var1);

        @CheckForNull
        abstract K getSuperclass(K var1);

        private static class ForwardingTypeCollector<K>
        extends TypeCollector<K> {
            private final TypeCollector<K> delegate;

            ForwardingTypeCollector(TypeCollector<K> typeCollector) {
                this.delegate = typeCollector;
            }

            @Override
            Class<?> getRawType(K k) {
                return this.delegate.getRawType(k);
            }

            @Override
            Iterable<? extends K> getInterfaces(K k) {
                return this.delegate.getInterfaces(k);
            }

            @Override
            @CheckForNull
            K getSuperclass(K k) {
                return this.delegate.getSuperclass(k);
            }
        }
    }

    private static final class SimpleTypeToken<T>
    extends TypeToken<T> {
        private static final long serialVersionUID = 0L;

        SimpleTypeToken(Type type) {
            super(type);
        }
    }

    private static class Bounds {
        private final Type[] bounds;
        private final boolean target;

        Bounds(Type[] typeArray, boolean bl) {
            this.bounds = typeArray;
            this.target = bl;
        }

        boolean isSubtypeOf(Type type) {
            for (Type type2 : this.bounds) {
                if (TypeToken.of(type2).isSubtypeOf(type) != this.target) continue;
                return this.target;
            }
            return !this.target;
        }

        boolean isSupertypeOf(Type type) {
            TypeToken<?> typeToken = TypeToken.of(type);
            for (Type type2 : this.bounds) {
                if (typeToken.isSubtypeOf(type2) != this.target) continue;
                return this.target;
            }
            return !this.target;
        }
    }

    private static enum TypeFilter implements Predicate<TypeToken<?>>
    {
        IGNORE_TYPE_VARIABLE_OR_WILDCARD{

            @Override
            public boolean apply(TypeToken<?> typeToken) {
                return !(((TypeToken)typeToken).runtimeType instanceof TypeVariable) && !(((TypeToken)typeToken).runtimeType instanceof WildcardType);
            }
        }
        ,
        INTERFACE_ONLY{

            @Override
            public boolean apply(TypeToken<?> typeToken) {
                return typeToken.getRawType().isInterface();
            }
        };

    }

    private final class ClassSet
    extends TypeSet {
        @CheckForNull
        private transient ImmutableSet<TypeToken<? super T>> classes;
        private static final long serialVersionUID = 0L;

        private ClassSet() {
        }

        @Override
        protected Set<TypeToken<? super T>> delegate() {
            ImmutableSet immutableSet = this.classes;
            if (immutableSet == null) {
                ImmutableList<TypeToken> immutableList = TypeCollector.FOR_GENERIC_TYPE.classesOnly().collectTypes(TypeToken.this);
                this.classes = FluentIterable.from(immutableList).filter(TypeFilter.IGNORE_TYPE_VARIABLE_OR_WILDCARD).toSet();
                return this.classes;
            }
            return immutableSet;
        }

        @Override
        public TypeSet classes() {
            return this;
        }

        @Override
        public Set<Class<? super T>> rawTypes() {
            ImmutableList<Class<?>> immutableList = TypeCollector.FOR_RAW_TYPE.classesOnly().collectTypes(TypeToken.this.getRawTypes());
            return ImmutableSet.copyOf(immutableList);
        }

        @Override
        public TypeSet interfaces() {
            throw new UnsupportedOperationException("classes().interfaces() not supported.");
        }

        private Object readResolve() {
            return TypeToken.this.getTypes().classes();
        }
    }

    private final class InterfaceSet
    extends TypeSet {
        private final transient TypeSet allTypes;
        @CheckForNull
        private transient ImmutableSet<TypeToken<? super T>> interfaces;
        private static final long serialVersionUID = 0L;

        InterfaceSet(TypeSet typeSet) {
            this.allTypes = typeSet;
        }

        @Override
        protected Set<TypeToken<? super T>> delegate() {
            ImmutableSet immutableSet = this.interfaces;
            if (immutableSet == null) {
                this.interfaces = FluentIterable.from(this.allTypes).filter(TypeFilter.INTERFACE_ONLY).toSet();
                return this.interfaces;
            }
            return immutableSet;
        }

        @Override
        public TypeSet interfaces() {
            return this;
        }

        @Override
        public Set<Class<? super T>> rawTypes() {
            ImmutableList<Class<?>> immutableList = TypeCollector.FOR_RAW_TYPE.collectTypes(TypeToken.this.getRawTypes());
            return FluentIterable.from(immutableList).filter(Class::isInterface).toSet();
        }

        @Override
        public TypeSet classes() {
            throw new UnsupportedOperationException("interfaces().classes() not supported.");
        }

        private Object readResolve() {
            return TypeToken.this.getTypes().interfaces();
        }
    }

    public class TypeSet
    extends ForwardingSet<TypeToken<? super T>>
    implements Serializable {
        @CheckForNull
        private transient ImmutableSet<TypeToken<? super T>> types;
        private static final long serialVersionUID = 0L;

        TypeSet() {
        }

        public TypeSet interfaces() {
            return new InterfaceSet(this);
        }

        public TypeSet classes() {
            return new ClassSet();
        }

        @Override
        protected Set<TypeToken<? super T>> delegate() {
            ImmutableSet immutableSet = this.types;
            if (immutableSet == null) {
                ImmutableList<TypeToken> immutableList = TypeCollector.FOR_GENERIC_TYPE.collectTypes(TypeToken.this);
                this.types = FluentIterable.from(immutableList).filter(TypeFilter.IGNORE_TYPE_VARIABLE_OR_WILDCARD).toSet();
                return this.types;
            }
            return immutableSet;
        }

        public Set<Class<? super T>> rawTypes() {
            ImmutableList<Class<?>> immutableList = TypeCollector.FOR_RAW_TYPE.collectTypes(TypeToken.this.getRawTypes());
            return ImmutableSet.copyOf(immutableList);
        }
    }
}

