/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.ElementTypesAreNonnullByDefault;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
public final class Parameter
implements AnnotatedElement {
    private final Invokable<?, ?> declaration;
    private final int position;
    private final TypeToken<?> type;
    private final ImmutableList<Annotation> annotations;
    private final @Nullable Object annotatedType;

    Parameter(Invokable<?, ?> invokable, int n, TypeToken<?> typeToken, Annotation[] annotationArray, @Nullable Object object) {
        this.declaration = invokable;
        this.position = n;
        this.type = typeToken;
        this.annotations = ImmutableList.copyOf(annotationArray);
        this.annotatedType = object;
    }

    public TypeToken<?> getType() {
        return this.type;
    }

    public Invokable<?, ?> getDeclaringInvokable() {
        return this.declaration;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> clazz) {
        return this.getAnnotation((Class)clazz) != null;
    }

    @CheckForNull
    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        Preconditions.checkNotNull(clazz);
        for (Annotation annotation : this.annotations) {
            if (!clazz.isInstance(annotation)) continue;
            return (A)((Annotation)clazz.cast(annotation));
        }
        return null;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    public <A extends Annotation> A[] getAnnotationsByType(Class<A> clazz) {
        return this.getDeclaredAnnotationsByType(clazz);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.annotations.toArray(new Annotation[0]);
    }

    @CheckForNull
    public <A extends Annotation> A getDeclaredAnnotation(Class<A> clazz) {
        Preconditions.checkNotNull(clazz);
        return (A)((Annotation)FluentIterable.from(this.annotations).filter(clazz).first().orNull());
    }

    public <A extends Annotation> A[] getDeclaredAnnotationsByType(Class<A> clazz) {
        Annotation[] annotationArray;
        Annotation[] annotationArray2 = annotationArray = (Annotation[])FluentIterable.from(this.annotations).filter(clazz).toArray(clazz);
        return annotationArray2;
    }

    public AnnotatedType getAnnotatedType() {
        return Objects.requireNonNull((AnnotatedType)this.annotatedType);
    }

    public boolean equals(@CheckForNull Object object) {
        if (object instanceof Parameter) {
            Parameter parameter = (Parameter)object;
            return this.position == parameter.position && this.declaration.equals(parameter.declaration);
        }
        return false;
    }

    public int hashCode() {
        return this.position;
    }

    public String toString() {
        return this.type + " arg" + this.position;
    }
}

