/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.ElementTypesAreNonnullByDefault;
import com.google.common.reflect.IgnoreJRERequirement;
import com.google.common.reflect.Parameter;
import com.google.common.reflect.TypeToken;
import com.google.common.reflect.Types;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
public abstract class Invokable<T, R>
implements AnnotatedElement,
Member {
    private final AccessibleObject accessibleObject;
    private final Member member;
    private static final boolean ANNOTATED_TYPE_EXISTS = Invokable.initAnnotatedTypeExists();

    <M extends AccessibleObject> Invokable(M m4) {
        Preconditions.checkNotNull(m4);
        this.accessibleObject = m4;
        this.member = (Member)((Object)m4);
    }

    public static Invokable<?, Object> from(Method method) {
        return new MethodInvokable(method);
    }

    public static <T> Invokable<T, T> from(Constructor<T> constructor) {
        return new ConstructorInvokable(constructor);
    }

    @Override
    public final boolean isAnnotationPresent(Class<? extends Annotation> clazz) {
        return this.accessibleObject.isAnnotationPresent(clazz);
    }

    @CheckForNull
    public final <A extends Annotation> A getAnnotation(Class<A> clazz) {
        return this.accessibleObject.getAnnotation(clazz);
    }

    @Override
    public final Annotation[] getAnnotations() {
        return this.accessibleObject.getAnnotations();
    }

    @Override
    public final Annotation[] getDeclaredAnnotations() {
        return this.accessibleObject.getDeclaredAnnotations();
    }

    public abstract TypeVariable<?>[] getTypeParameters();

    public final void setAccessible(boolean bl) {
        this.accessibleObject.setAccessible(bl);
    }

    public final boolean trySetAccessible() {
        try {
            this.accessibleObject.setAccessible(true);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public final boolean isAccessible() {
        return this.accessibleObject.isAccessible();
    }

    @Override
    public final String getName() {
        return this.member.getName();
    }

    @Override
    public final int getModifiers() {
        return this.member.getModifiers();
    }

    @Override
    public final boolean isSynthetic() {
        return this.member.isSynthetic();
    }

    public final boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public final boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    public final boolean isPackagePrivate() {
        return !this.isPrivate() && !this.isPublic() && !this.isProtected();
    }

    public final boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    public final boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public final boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    public final boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public final boolean isNative() {
        return Modifier.isNative(this.getModifiers());
    }

    public final boolean isSynchronized() {
        return Modifier.isSynchronized(this.getModifiers());
    }

    final boolean isVolatile() {
        return Modifier.isVolatile(this.getModifiers());
    }

    final boolean isTransient() {
        return Modifier.isTransient(this.getModifiers());
    }

    public boolean equals(@CheckForNull Object object) {
        if (object instanceof Invokable) {
            Invokable invokable = (Invokable)object;
            return this.getOwnerType().equals(invokable.getOwnerType()) && this.member.equals(invokable.member);
        }
        return false;
    }

    public int hashCode() {
        return this.member.hashCode();
    }

    public String toString() {
        return this.member.toString();
    }

    public abstract boolean isOverridable();

    public abstract boolean isVarArgs();

    @CheckForNull
    @CanIgnoreReturnValue
    public final R invoke(@CheckForNull T t2, Object ... objectArray) throws InvocationTargetException, IllegalAccessException {
        return (R)this.invokeInternal(t2, Preconditions.checkNotNull(objectArray));
    }

    public final TypeToken<? extends R> getReturnType() {
        return TypeToken.of(this.getGenericReturnType());
    }

    @IgnoreJRERequirement
    public final ImmutableList<Parameter> getParameters() {
        Type[] typeArray = this.getGenericParameterTypes();
        Annotation[][] annotationArray = this.getParameterAnnotations();
        @Nullable Object[] objectArray = ANNOTATED_TYPE_EXISTS ? this.getAnnotatedParameterTypes() : new Object[typeArray.length];
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < typeArray.length; ++i) {
            builder.add(new Parameter(this, i, TypeToken.of(typeArray[i]), annotationArray[i], objectArray[i]));
        }
        return builder.build();
    }

    public final ImmutableList<TypeToken<? extends Throwable>> getExceptionTypes() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Type type : this.getGenericExceptionTypes()) {
            TypeToken<?> typeToken = TypeToken.of(type);
            builder.add(typeToken);
        }
        return builder.build();
    }

    public final <R1 extends R> Invokable<T, R1> returning(Class<R1> clazz) {
        return this.returning(TypeToken.of(clazz));
    }

    public final <R1 extends R> Invokable<T, R1> returning(TypeToken<R1> typeToken) {
        if (!typeToken.isSupertypeOf(this.getReturnType())) {
            throw new IllegalArgumentException("Invokable is known to return " + this.getReturnType() + ", not " + typeToken);
        }
        Invokable invokable = this;
        return invokable;
    }

    public final Class<? super T> getDeclaringClass() {
        return this.member.getDeclaringClass();
    }

    public TypeToken<T> getOwnerType() {
        return TypeToken.of(this.getDeclaringClass());
    }

    @CheckForNull
    abstract Object invokeInternal(@CheckForNull Object var1, @Nullable Object[] var2) throws InvocationTargetException, IllegalAccessException;

    abstract Type[] getGenericParameterTypes();

    abstract AnnotatedType[] getAnnotatedParameterTypes();

    abstract Type[] getGenericExceptionTypes();

    abstract Annotation[][] getParameterAnnotations();

    abstract Type getGenericReturnType();

    public abstract AnnotatedType getAnnotatedReturnType();

    private static boolean initAnnotatedTypeExists() {
        try {
            Class.forName("java.lang.reflect.AnnotatedType");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    static class ConstructorInvokable<T>
    extends Invokable<T, T> {
        final Constructor<?> constructor;

        ConstructorInvokable(Constructor<?> constructor) {
            super(constructor);
            this.constructor = constructor;
        }

        @Override
        final Object invokeInternal(@CheckForNull Object object, @Nullable Object[] objectArray) throws InvocationTargetException, IllegalAccessException {
            try {
                return this.constructor.newInstance(objectArray);
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException(this.constructor + " failed.", instantiationException);
            }
        }

        @Override
        Type getGenericReturnType() {
            Class clazz = this.getDeclaringClass();
            Type[] typeArray = clazz.getTypeParameters();
            if (typeArray.length > 0) {
                return Types.newParameterizedType(clazz, typeArray);
            }
            return clazz;
        }

        @Override
        Type[] getGenericParameterTypes() {
            Class<?>[] classArray;
            Type[] typeArray = this.constructor.getGenericParameterTypes();
            if (typeArray.length > 0 && this.mayNeedHiddenThis() && typeArray.length == (classArray = this.constructor.getParameterTypes()).length && classArray[0] == this.getDeclaringClass().getEnclosingClass()) {
                return Arrays.copyOfRange(typeArray, 1, typeArray.length);
            }
            return typeArray;
        }

        @Override
        AnnotatedType[] getAnnotatedParameterTypes() {
            return this.constructor.getAnnotatedParameterTypes();
        }

        @Override
        public AnnotatedType getAnnotatedReturnType() {
            return this.constructor.getAnnotatedReturnType();
        }

        @Override
        Type[] getGenericExceptionTypes() {
            return this.constructor.getGenericExceptionTypes();
        }

        @Override
        final Annotation[][] getParameterAnnotations() {
            return this.constructor.getParameterAnnotations();
        }

        @Override
        public final TypeVariable<?>[] getTypeParameters() {
            TypeVariable<Class<T>>[] typeVariableArray = this.getDeclaringClass().getTypeParameters();
            TypeVariable<Constructor<?>>[] typeVariableArray2 = this.constructor.getTypeParameters();
            TypeVariable[] typeVariableArray3 = new TypeVariable[typeVariableArray.length + typeVariableArray2.length];
            System.arraycopy(typeVariableArray, 0, typeVariableArray3, 0, typeVariableArray.length);
            System.arraycopy(typeVariableArray2, 0, typeVariableArray3, typeVariableArray.length, typeVariableArray2.length);
            return typeVariableArray3;
        }

        @Override
        public final boolean isOverridable() {
            return false;
        }

        @Override
        public final boolean isVarArgs() {
            return this.constructor.isVarArgs();
        }

        private boolean mayNeedHiddenThis() {
            Class<?> clazz = this.constructor.getDeclaringClass();
            if (clazz.getEnclosingConstructor() != null) {
                return true;
            }
            Method method = clazz.getEnclosingMethod();
            if (method != null) {
                return !Modifier.isStatic(method.getModifiers());
            }
            return clazz.getEnclosingClass() != null && !Modifier.isStatic(clazz.getModifiers());
        }
    }

    static class MethodInvokable<T>
    extends Invokable<T, Object> {
        final Method method;

        MethodInvokable(Method method) {
            super(method);
            this.method = method;
        }

        @Override
        @CheckForNull
        final Object invokeInternal(@CheckForNull Object object, @Nullable Object[] objectArray) throws InvocationTargetException, IllegalAccessException {
            return this.method.invoke(object, objectArray);
        }

        @Override
        Type getGenericReturnType() {
            return this.method.getGenericReturnType();
        }

        @Override
        Type[] getGenericParameterTypes() {
            return this.method.getGenericParameterTypes();
        }

        @Override
        AnnotatedType[] getAnnotatedParameterTypes() {
            return this.method.getAnnotatedParameterTypes();
        }

        @Override
        public AnnotatedType getAnnotatedReturnType() {
            return this.method.getAnnotatedReturnType();
        }

        @Override
        Type[] getGenericExceptionTypes() {
            return this.method.getGenericExceptionTypes();
        }

        @Override
        final Annotation[][] getParameterAnnotations() {
            return this.method.getParameterAnnotations();
        }

        @Override
        public final TypeVariable<?>[] getTypeParameters() {
            return this.method.getTypeParameters();
        }

        @Override
        public final boolean isOverridable() {
            return !this.isFinal() && !this.isPrivate() && !this.isStatic() && !Modifier.isFinal(this.getDeclaringClass().getModifiers());
        }

        @Override
        public final boolean isVarArgs() {
            return this.method.isVarArgs();
        }
    }
}

