/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractByteHasher;
import com.google.common.hash.AbstractHashFunction;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.IgnoreJRERequirement;
import com.google.common.hash.ImmutableSupplier;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import java.util.zip.Checksum;
import org.checkerframework.checker.nullness.qual.Nullable;

@Immutable
@ElementTypesAreNonnullByDefault
final class ChecksumHashFunction
extends AbstractHashFunction
implements Serializable {
    private final ImmutableSupplier<? extends Checksum> checksumSupplier;
    private final int bits;
    private final String toString;
    private static final long serialVersionUID = 0L;

    ChecksumHashFunction(ImmutableSupplier<? extends Checksum> immutableSupplier, int n, String string) {
        this.checksumSupplier = Preconditions.checkNotNull(immutableSupplier);
        Preconditions.checkArgument(n == 32 || n == 64, "bits (%s) must be either 32 or 64", n);
        this.bits = n;
        this.toString = Preconditions.checkNotNull(string);
    }

    @Override
    public int bits() {
        return this.bits;
    }

    @Override
    public Hasher newHasher() {
        return new ChecksumHasher((Checksum)this.checksumSupplier.get());
    }

    public String toString() {
        return this.toString;
    }

    private static final class ChecksumMethodHandles {
        private static final @Nullable MethodHandle UPDATE_BB = ChecksumMethodHandles.updateByteBuffer();

        private ChecksumMethodHandles() {
        }

        @IgnoreJRERequirement
        static boolean updateByteBuffer(Checksum checksum, ByteBuffer byteBuffer) {
            if (UPDATE_BB != null) {
                try {
                    UPDATE_BB.invokeExact(checksum, byteBuffer);
                }
                catch (Error error) {
                    throw error;
                }
                catch (Throwable throwable) {
                    throw new AssertionError((Object)throwable);
                }
                return true;
            }
            return false;
        }

        private static @Nullable MethodHandle updateByteBuffer() {
            try {
                Class<?> clazz = Class.forName("java.util.zip.Checksum");
                return MethodHandles.lookup().findVirtual(clazz, "update", MethodType.methodType(Void.TYPE, ByteBuffer.class));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AssertionError((Object)classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw ChecksumMethodHandles.newLinkageError(illegalAccessException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }

        private static LinkageError newLinkageError(Throwable throwable) {
            return new LinkageError(throwable.toString(), throwable);
        }
    }

    private final class ChecksumHasher
    extends AbstractByteHasher {
        private final Checksum checksum;

        private ChecksumHasher(Checksum checksum) {
            this.checksum = Preconditions.checkNotNull(checksum);
        }

        @Override
        protected void update(byte by) {
            this.checksum.update(by);
        }

        @Override
        protected void update(byte[] byArray, int n, int n2) {
            this.checksum.update(byArray, n, n2);
        }

        @Override
        protected void update(ByteBuffer byteBuffer) {
            if (!ChecksumMethodHandles.updateByteBuffer(this.checksum, byteBuffer)) {
                super.update(byteBuffer);
            }
        }

        @Override
        public HashCode hash() {
            long l = this.checksum.getValue();
            if (ChecksumHashFunction.this.bits == 32) {
                return HashCode.fromInt((int)l);
            }
            return HashCode.fromLong(l);
        }
    }
}

