/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractHasher;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.Hasher;
import com.google.common.hash.Java8Compatibility;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@ElementTypesAreNonnullByDefault
abstract class AbstractByteHasher
extends AbstractHasher {
    private final ByteBuffer scratch = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);

    AbstractByteHasher() {
    }

    protected abstract void update(byte var1);

    protected void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    protected void update(byte[] byArray, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            this.update(byArray[i]);
        }
    }

    protected void update(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            this.update(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            Java8Compatibility.position(byteBuffer, byteBuffer.limit());
        } else {
            for (int i = byteBuffer.remaining(); i > 0; --i) {
                this.update(byteBuffer.get());
            }
        }
    }

    @CanIgnoreReturnValue
    private Hasher update(int n) {
        try {
            this.update(this.scratch.array(), 0, n);
        }
        finally {
            Java8Compatibility.clear(this.scratch);
        }
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putByte(byte by) {
        this.update(by);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putBytes(byte[] byArray) {
        Preconditions.checkNotNull(byArray);
        this.update(byArray);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putBytes(byte[] byArray, int n, int n2) {
        Preconditions.checkPositionIndexes(n, n + n2, byArray.length);
        this.update(byArray, n, n2);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putBytes(ByteBuffer byteBuffer) {
        this.update(byteBuffer);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putShort(short s2) {
        this.scratch.putShort(s2);
        return this.update(2);
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putInt(int n) {
        this.scratch.putInt(n);
        return this.update(4);
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putLong(long l) {
        this.scratch.putLong(l);
        return this.update(8);
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putChar(char c) {
        this.scratch.putChar(c);
        return this.update(2);
    }
}

