/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.BaseGraph;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.Network;
import com.google.common.graph.SuccessorsFunction;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.CheckForNull;

@DoNotMock(value="Call forGraph or forTree, passing a lambda or a Graph with the desired edges (built with GraphBuilder)")
@ElementTypesAreNonnullByDefault
@Beta
public abstract class Traverser<N> {
    private final SuccessorsFunction<N> successorFunction;

    private Traverser(SuccessorsFunction<N> successorsFunction) {
        this.successorFunction = Preconditions.checkNotNull(successorsFunction);
    }

    public static <N> Traverser<N> forGraph(final SuccessorsFunction<N> successorsFunction) {
        return new Traverser<N>(successorsFunction){

            @Override
            Traversal<N> newTraversal() {
                return Traversal.inGraph(successorsFunction);
            }
        };
    }

    public static <N> Traverser<N> forTree(final SuccessorsFunction<N> successorsFunction) {
        if (successorsFunction instanceof BaseGraph) {
            Preconditions.checkArgument(((BaseGraph)successorsFunction).isDirected(), "Undirected graphs can never be trees.");
        }
        if (successorsFunction instanceof Network) {
            Preconditions.checkArgument(((Network)successorsFunction).isDirected(), "Undirected networks can never be trees.");
        }
        return new Traverser<N>(successorsFunction){

            @Override
            Traversal<N> newTraversal() {
                return Traversal.inTree(successorsFunction);
            }
        };
    }

    public final Iterable<N> breadthFirst(N n) {
        return this.breadthFirst((Iterable<? extends N>)ImmutableSet.of(n));
    }

    public final Iterable<N> breadthFirst(Iterable<? extends N> iterable) {
        final ImmutableSet<? extends N> immutableSet = this.validate(iterable);
        return new Iterable<N>(){

            @Override
            public Iterator<N> iterator() {
                return Traverser.this.newTraversal().breadthFirst(immutableSet.iterator());
            }
        };
    }

    public final Iterable<N> depthFirstPreOrder(N n) {
        return this.depthFirstPreOrder((Iterable<? extends N>)ImmutableSet.of(n));
    }

    public final Iterable<N> depthFirstPreOrder(Iterable<? extends N> iterable) {
        final ImmutableSet<? extends N> immutableSet = this.validate(iterable);
        return new Iterable<N>(){

            @Override
            public Iterator<N> iterator() {
                return Traverser.this.newTraversal().preOrder(immutableSet.iterator());
            }
        };
    }

    public final Iterable<N> depthFirstPostOrder(N n) {
        return this.depthFirstPostOrder((Iterable<? extends N>)ImmutableSet.of(n));
    }

    public final Iterable<N> depthFirstPostOrder(Iterable<? extends N> iterable) {
        final ImmutableSet<? extends N> immutableSet = this.validate(iterable);
        return new Iterable<N>(){

            @Override
            public Iterator<N> iterator() {
                return Traverser.this.newTraversal().postOrder(immutableSet.iterator());
            }
        };
    }

    abstract Traversal<N> newTraversal();

    private ImmutableSet<N> validate(Iterable<? extends N> iterable) {
        ImmutableSet immutableSet = ImmutableSet.copyOf(iterable);
        for (Object e : immutableSet) {
            this.successorFunction.successors(e);
        }
        return immutableSet;
    }

    private static enum InsertionOrder {
        FRONT{

            @Override
            <T> void insertInto(Deque<T> deque, T t2) {
                deque.addFirst(t2);
            }
        }
        ,
        BACK{

            @Override
            <T> void insertInto(Deque<T> deque, T t2) {
                deque.addLast(t2);
            }
        };


        abstract <T> void insertInto(Deque<T> var1, T var2);
    }

    private static abstract class Traversal<N> {
        final SuccessorsFunction<N> successorFunction;

        Traversal(SuccessorsFunction<N> successorsFunction) {
            this.successorFunction = successorsFunction;
        }

        static <N> Traversal<N> inGraph(SuccessorsFunction<N> successorsFunction) {
            final HashSet hashSet = new HashSet();
            return new Traversal<N>(successorsFunction){

                @Override
                @CheckForNull
                N visitNext(Deque<Iterator<? extends N>> deque) {
                    Iterator iterator2 = deque.getFirst();
                    while (iterator2.hasNext()) {
                        Object n = iterator2.next();
                        Objects.requireNonNull(n);
                        if (!hashSet.add(n)) continue;
                        return n;
                    }
                    deque.removeFirst();
                    return null;
                }
            };
        }

        static <N> Traversal<N> inTree(SuccessorsFunction<N> successorsFunction) {
            return new Traversal<N>((SuccessorsFunction)successorsFunction){

                @Override
                @CheckForNull
                N visitNext(Deque<Iterator<? extends N>> deque) {
                    Iterator iterator2 = deque.getFirst();
                    if (iterator2.hasNext()) {
                        return Preconditions.checkNotNull(iterator2.next());
                    }
                    deque.removeFirst();
                    return null;
                }
            };
        }

        final Iterator<N> breadthFirst(Iterator<? extends N> iterator2) {
            return this.topDown(iterator2, InsertionOrder.BACK);
        }

        final Iterator<N> preOrder(Iterator<? extends N> iterator2) {
            return this.topDown(iterator2, InsertionOrder.FRONT);
        }

        private Iterator<N> topDown(Iterator<? extends N> iterator2, final InsertionOrder insertionOrder) {
            final ArrayDeque<Iterator<? extends N>> arrayDeque = new ArrayDeque<Iterator<? extends N>>();
            arrayDeque.add(iterator2);
            return new AbstractIterator<N>(){

                @Override
                @CheckForNull
                protected N computeNext() {
                    do {
                        Object n;
                        if ((n = this.visitNext(arrayDeque)) == null) continue;
                        Iterator iterator2 = successorFunction.successors(n).iterator();
                        if (iterator2.hasNext()) {
                            insertionOrder.insertInto(arrayDeque, iterator2);
                        }
                        return n;
                    } while (!arrayDeque.isEmpty());
                    return this.endOfData();
                }
            };
        }

        final Iterator<N> postOrder(Iterator<? extends N> iterator2) {
            final ArrayDeque arrayDeque = new ArrayDeque();
            final ArrayDeque<Iterator<? extends N>> arrayDeque2 = new ArrayDeque<Iterator<? extends N>>();
            arrayDeque2.add(iterator2);
            return new AbstractIterator<N>(){

                @Override
                @CheckForNull
                protected N computeNext() {
                    Object n = this.visitNext(arrayDeque2);
                    while (n != null) {
                        Iterator iterator2 = successorFunction.successors(n).iterator();
                        if (!iterator2.hasNext()) {
                            return n;
                        }
                        arrayDeque2.addFirst(iterator2);
                        arrayDeque.push(n);
                        n = this.visitNext(arrayDeque2);
                    }
                    if (!arrayDeque.isEmpty()) {
                        return arrayDeque.pop();
                    }
                    return this.endOfData();
                }
            };
        }

        @CheckForNull
        abstract N visitNext(Deque<Iterator<? extends N>> var1);
    }
}

