/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.AbstractNetwork;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.MapIteratorCache;
import com.google.common.graph.MapRetrievalCache;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.NetworkConnections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

@ElementTypesAreNonnullByDefault
class StandardNetwork<N, E>
extends AbstractNetwork<N, E> {
    private final boolean isDirected;
    private final boolean allowsParallelEdges;
    private final boolean allowsSelfLoops;
    private final ElementOrder<N> nodeOrder;
    private final ElementOrder<E> edgeOrder;
    final MapIteratorCache<N, NetworkConnections<N, E>> nodeConnections;
    final MapIteratorCache<E, N> edgeToReferenceNode;

    StandardNetwork(NetworkBuilder<? super N, ? super E> networkBuilder) {
        this(networkBuilder, networkBuilder.nodeOrder.createMap(networkBuilder.expectedNodeCount.or(10)), networkBuilder.edgeOrder.createMap(networkBuilder.expectedEdgeCount.or(20)));
    }

    StandardNetwork(NetworkBuilder<? super N, ? super E> networkBuilder, Map<N, NetworkConnections<N, E>> map, Map<E, N> map2) {
        this.isDirected = networkBuilder.directed;
        this.allowsParallelEdges = networkBuilder.allowsParallelEdges;
        this.allowsSelfLoops = networkBuilder.allowsSelfLoops;
        this.nodeOrder = networkBuilder.nodeOrder.cast();
        this.edgeOrder = networkBuilder.edgeOrder.cast();
        this.nodeConnections = map instanceof TreeMap ? new MapRetrievalCache<N, NetworkConnections<N, E>>(map) : new MapIteratorCache<N, NetworkConnections<N, E>>(map);
        this.edgeToReferenceNode = new MapIteratorCache<E, N>(map2);
    }

    @Override
    public Set<N> nodes() {
        return this.nodeConnections.unmodifiableKeySet();
    }

    @Override
    public Set<E> edges() {
        return this.edgeToReferenceNode.unmodifiableKeySet();
    }

    @Override
    public boolean isDirected() {
        return this.isDirected;
    }

    @Override
    public boolean allowsParallelEdges() {
        return this.allowsParallelEdges;
    }

    @Override
    public boolean allowsSelfLoops() {
        return this.allowsSelfLoops;
    }

    @Override
    public ElementOrder<N> nodeOrder() {
        return this.nodeOrder;
    }

    @Override
    public ElementOrder<E> edgeOrder() {
        return this.edgeOrder;
    }

    @Override
    public Set<E> incidentEdges(N n) {
        return this.nodeInvalidatableSet(this.checkedConnections(n).incidentEdges(), n);
    }

    @Override
    public EndpointPair<N> incidentNodes(E e) {
        N n = this.checkedReferenceNode(e);
        N n2 = Objects.requireNonNull(this.nodeConnections.get(n)).adjacentNode(e);
        return EndpointPair.of(this, n, n2);
    }

    @Override
    public Set<N> adjacentNodes(N n) {
        return this.nodeInvalidatableSet(this.checkedConnections(n).adjacentNodes(), n);
    }

    @Override
    public Set<E> edgesConnecting(N n, N n2) {
        NetworkConnections<N, E> networkConnections = this.checkedConnections(n);
        if (!this.allowsSelfLoops && n == n2) {
            return ImmutableSet.of();
        }
        Preconditions.checkArgument(this.containsNode(n2), "Node %s is not an element of this graph.", n2);
        return this.nodePairInvalidatableSet(networkConnections.edgesConnecting(n2), n, n2);
    }

    @Override
    public Set<E> inEdges(N n) {
        return this.nodeInvalidatableSet(this.checkedConnections(n).inEdges(), n);
    }

    @Override
    public Set<E> outEdges(N n) {
        return this.nodeInvalidatableSet(this.checkedConnections(n).outEdges(), n);
    }

    @Override
    public Set<N> predecessors(N n) {
        return this.nodeInvalidatableSet(this.checkedConnections(n).predecessors(), n);
    }

    @Override
    public Set<N> successors(N n) {
        return this.nodeInvalidatableSet(this.checkedConnections(n).successors(), n);
    }

    final NetworkConnections<N, E> checkedConnections(N n) {
        NetworkConnections<N, E> networkConnections = this.nodeConnections.get(n);
        if (networkConnections == null) {
            Preconditions.checkNotNull(n);
            throw new IllegalArgumentException(String.format("Node %s is not an element of this graph.", n));
        }
        return networkConnections;
    }

    final N checkedReferenceNode(E e) {
        N n = this.edgeToReferenceNode.get(e);
        if (n == null) {
            Preconditions.checkNotNull(e);
            throw new IllegalArgumentException(String.format("Edge %s is not an element of this graph.", e));
        }
        return n;
    }

    final boolean containsNode(N n) {
        return this.nodeConnections.containsKey(n);
    }

    final boolean containsEdge(E e) {
        return this.edgeToReferenceNode.containsKey(e);
    }
}

