/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.MapIteratorCache;
import java.util.Map;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
final class MapRetrievalCache<K, V>
extends MapIteratorCache<K, V> {
    @CheckForNull
    private volatile transient CacheEntry<K, V> cacheEntry1;
    @CheckForNull
    private volatile transient CacheEntry<K, V> cacheEntry2;

    MapRetrievalCache(Map<K, V> map) {
        super(map);
    }

    @Override
    @CheckForNull
    V get(Object object) {
        Preconditions.checkNotNull(object);
        V v = this.getIfCached(object);
        if (v != null) {
            return v;
        }
        v = this.getWithoutCaching(object);
        if (v != null) {
            this.addToCache(object, v);
        }
        return v;
    }

    @Override
    @CheckForNull
    V getIfCached(@CheckForNull Object object) {
        Object v = super.getIfCached(object);
        if (v != null) {
            return v;
        }
        CacheEntry<K, V> cacheEntry = this.cacheEntry1;
        if (cacheEntry != null && cacheEntry.key == object) {
            return cacheEntry.value;
        }
        cacheEntry = this.cacheEntry2;
        if (cacheEntry != null && cacheEntry.key == object) {
            this.addToCache(cacheEntry);
            return cacheEntry.value;
        }
        return null;
    }

    @Override
    void clearCache() {
        super.clearCache();
        this.cacheEntry1 = null;
        this.cacheEntry2 = null;
    }

    private void addToCache(K k, V v) {
        this.addToCache(new CacheEntry<K, V>(k, v));
    }

    private void addToCache(CacheEntry<K, V> cacheEntry) {
        this.cacheEntry2 = this.cacheEntry1;
        this.cacheEntry1 = cacheEntry;
    }

    private static final class CacheEntry<K, V> {
        final K key;
        final V value;

        CacheEntry(K k, V v) {
            this.key = k;
            this.value = v;
        }
    }
}

