/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
class MapIteratorCache<K, V> {
    private final Map<K, V> backingMap;
    @CheckForNull
    private volatile transient Map.Entry<K, V> cacheEntry;

    MapIteratorCache(Map<K, V> map) {
        this.backingMap = Preconditions.checkNotNull(map);
    }

    @CheckForNull
    @CanIgnoreReturnValue
    final V put(K k, V v) {
        Preconditions.checkNotNull(k);
        Preconditions.checkNotNull(v);
        this.clearCache();
        return this.backingMap.put(k, v);
    }

    @CheckForNull
    @CanIgnoreReturnValue
    final V remove(Object object) {
        Preconditions.checkNotNull(object);
        this.clearCache();
        return this.backingMap.remove(object);
    }

    final void clear() {
        this.clearCache();
        this.backingMap.clear();
    }

    @CheckForNull
    V get(Object object) {
        Preconditions.checkNotNull(object);
        V v = this.getIfCached(object);
        if (v == null) {
            return this.getWithoutCaching(object);
        }
        return v;
    }

    @CheckForNull
    final V getWithoutCaching(Object object) {
        Preconditions.checkNotNull(object);
        return this.backingMap.get(object);
    }

    final boolean containsKey(@CheckForNull Object object) {
        return this.getIfCached(object) != null || this.backingMap.containsKey(object);
    }

    final Set<K> unmodifiableKeySet() {
        return new AbstractSet<K>(){

            @Override
            public UnmodifiableIterator<K> iterator() {
                final Iterator iterator2 = MapIteratorCache.this.backingMap.entrySet().iterator();
                return new UnmodifiableIterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return iterator2.hasNext();
                    }

                    @Override
                    public K next() {
                        Map.Entry entry = (Map.Entry)iterator2.next();
                        MapIteratorCache.this.cacheEntry = entry;
                        return entry.getKey();
                    }
                };
            }

            @Override
            public int size() {
                return MapIteratorCache.this.backingMap.size();
            }

            @Override
            public boolean contains(@CheckForNull Object object) {
                return MapIteratorCache.this.containsKey(object);
            }
        };
    }

    @CheckForNull
    V getIfCached(@CheckForNull Object object) {
        Map.Entry<K, V> entry = this.cacheEntry;
        if (entry != null && entry.getKey() == object) {
            return entry.getValue();
        }
        return null;
    }

    void clearCache() {
        this.cacheEntry = null;
    }
}

