/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ForwardingSet;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import java.util.Set;

@ElementTypesAreNonnullByDefault
final class InvalidatableSet<E>
extends ForwardingSet<E> {
    private final Supplier<Boolean> validator;
    private final Set<E> delegate;
    private final Supplier<String> errorMessage;

    public static final <E> InvalidatableSet<E> of(Set<E> set, Supplier<Boolean> supplier, Supplier<String> supplier2) {
        return new InvalidatableSet<E>(Preconditions.checkNotNull(set), Preconditions.checkNotNull(supplier), Preconditions.checkNotNull(supplier2));
    }

    @Override
    protected Set<E> delegate() {
        this.validate();
        return this.delegate;
    }

    private InvalidatableSet(Set<E> set, Supplier<Boolean> supplier, Supplier<String> supplier2) {
        this.delegate = set;
        this.validator = supplier;
        this.errorMessage = supplier2;
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    private void validate() {
        if (!this.validator.get().booleanValue()) {
            throw new IllegalStateException(this.errorMessage.get());
        }
    }
}

