/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.ForwardingGraph;
import com.google.common.graph.ForwardingNetwork;
import com.google.common.graph.ForwardingValueGraph;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.GraphsBridgeMethods;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.IncidentEdgeSet;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.Traverser;
import com.google.common.graph.ValueGraph;
import com.google.common.graph.ValueGraphBuilder;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@Beta
public final class Graphs
extends GraphsBridgeMethods {
    private Graphs() {
    }

    public static <N> boolean hasCycle(Graph<N> graph) {
        int n = graph.edges().size();
        if (n == 0) {
            return false;
        }
        if (!graph.isDirected() && n >= graph.nodes().size()) {
            return true;
        }
        HashMap<Object, NodeVisitState> hashMap = Maps.newHashMapWithExpectedSize(graph.nodes().size());
        for (N n2 : graph.nodes()) {
            if (!Graphs.subgraphHasCycle(graph, hashMap, n2, null)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasCycle(Network<?, ?> network) {
        if (!network.isDirected() && network.allowsParallelEdges() && network.edges().size() > network.asGraph().edges().size()) {
            return true;
        }
        return Graphs.hasCycle(network.asGraph());
    }

    private static <N> boolean subgraphHasCycle(Graph<N> graph, Map<Object, NodeVisitState> map, N n, @CheckForNull N n2) {
        NodeVisitState nodeVisitState = map.get(n);
        if (nodeVisitState == NodeVisitState.COMPLETE) {
            return false;
        }
        if (nodeVisitState == NodeVisitState.PENDING) {
            return true;
        }
        map.put(n, NodeVisitState.PENDING);
        for (Object e : graph.successors((Object)n)) {
            if (!Graphs.canTraverseWithoutReusingEdge(graph, e, n2) || !Graphs.subgraphHasCycle(graph, map, e, n)) continue;
            return true;
        }
        map.put(n, NodeVisitState.COMPLETE);
        return false;
    }

    private static boolean canTraverseWithoutReusingEdge(Graph<?> graph, Object object, @CheckForNull Object object2) {
        return graph.isDirected() || !com.google.common.base.Objects.equal(object2, object);
    }

    public static <N> ImmutableGraph<N> transitiveClosure(Graph<N> graph) {
        ImmutableGraph.Builder builder = GraphBuilder.from(graph).allowsSelfLoops(true).immutable();
        if (graph.isDirected()) {
            for (N n : graph.nodes()) {
                for (Object e : Graphs.reachableNodes(graph, n)) {
                    builder.putEdge(n, e);
                }
            }
        } else {
            HashSet hashSet = new HashSet();
            for (N n : graph.nodes()) {
                if (hashSet.contains(n)) continue;
                ImmutableSet immutableSet = Graphs.reachableNodes(graph, n);
                hashSet.addAll(immutableSet);
                int n2 = 1;
                for (Object e : immutableSet) {
                    for (Object n3 : Iterables.limit(immutableSet, n2++)) {
                        builder.putEdge(e, n3);
                    }
                }
            }
        }
        return builder.build();
    }

    public static <N> ImmutableSet<N> reachableNodes(Graph<N> graph, N n) {
        Preconditions.checkArgument(graph.nodes().contains(n), "Node %s is not an element of this graph.", n);
        return ImmutableSet.copyOf(Traverser.forGraph(graph).breadthFirst(n));
    }

    public static <N> Graph<N> transpose(Graph<N> graph) {
        if (!graph.isDirected()) {
            return graph;
        }
        if (graph instanceof TransposedGraph) {
            return ((TransposedGraph)graph).graph;
        }
        return new TransposedGraph<N>(graph);
    }

    public static <N, V> ValueGraph<N, V> transpose(ValueGraph<N, V> valueGraph) {
        if (!valueGraph.isDirected()) {
            return valueGraph;
        }
        if (valueGraph instanceof TransposedValueGraph) {
            return ((TransposedValueGraph)valueGraph).graph;
        }
        return new TransposedValueGraph<N, V>(valueGraph);
    }

    public static <N, E> Network<N, E> transpose(Network<N, E> network) {
        if (!network.isDirected()) {
            return network;
        }
        if (network instanceof TransposedNetwork) {
            return ((TransposedNetwork)network).network;
        }
        return new TransposedNetwork<N, E>(network);
    }

    static <N> EndpointPair<N> transpose(EndpointPair<N> endpointPair) {
        if (endpointPair.isOrdered()) {
            return EndpointPair.ordered(endpointPair.target(), endpointPair.source());
        }
        return endpointPair;
    }

    public static <N> MutableGraph<N> inducedSubgraph(Graph<N> graph, Iterable<? extends N> iterable) {
        MutableGraph mutableGraph = iterable instanceof Collection ? GraphBuilder.from(graph).expectedNodeCount(((Collection)iterable).size()).build() : GraphBuilder.from(graph).build();
        for (Object object : iterable) {
            mutableGraph.addNode(object);
        }
        for (Object object : mutableGraph.nodes()) {
            for (Object e : graph.successors(object)) {
                if (!mutableGraph.nodes().contains(e)) continue;
                mutableGraph.putEdge(object, e);
            }
        }
        return mutableGraph;
    }

    public static <N, V> MutableValueGraph<N, V> inducedSubgraph(ValueGraph<N, V> valueGraph, Iterable<? extends N> iterable) {
        MutableValueGraph mutableValueGraph = iterable instanceof Collection ? ValueGraphBuilder.from(valueGraph).expectedNodeCount(((Collection)iterable).size()).build() : ValueGraphBuilder.from(valueGraph).build();
        for (Object object : iterable) {
            mutableValueGraph.addNode(object);
        }
        for (Object object : mutableValueGraph.nodes()) {
            for (Object e : valueGraph.successors(object)) {
                if (!mutableValueGraph.nodes().contains(e)) continue;
                mutableValueGraph.putEdgeValue(object, e, Objects.requireNonNull(valueGraph.edgeValueOrDefault(object, e, null)));
            }
        }
        return mutableValueGraph;
    }

    public static <N, E> MutableNetwork<N, E> inducedSubgraph(Network<N, E> network, Iterable<? extends N> iterable) {
        MutableNetwork mutableNetwork = iterable instanceof Collection ? NetworkBuilder.from(network).expectedNodeCount(((Collection)iterable).size()).build() : NetworkBuilder.from(network).build();
        for (Object object : iterable) {
            mutableNetwork.addNode(object);
        }
        for (Object object : mutableNetwork.nodes()) {
            for (E e : network.outEdges(object)) {
                N n = network.incidentNodes(e).adjacentNode(object);
                if (!mutableNetwork.nodes().contains(n)) continue;
                mutableNetwork.addEdge(object, n, e);
            }
        }
        return mutableNetwork;
    }

    public static <N> MutableGraph<N> copyOf(Graph<N> graph) {
        MutableGraph mutableGraph = GraphBuilder.from(graph).expectedNodeCount(graph.nodes().size()).build();
        for (N object : graph.nodes()) {
            mutableGraph.addNode(object);
        }
        for (EndpointPair endpointPair : graph.edges()) {
            mutableGraph.putEdge(endpointPair.nodeU(), endpointPair.nodeV());
        }
        return mutableGraph;
    }

    public static <N, V> MutableValueGraph<N, V> copyOf(ValueGraph<N, V> valueGraph) {
        MutableValueGraph mutableValueGraph = ValueGraphBuilder.from(valueGraph).expectedNodeCount(valueGraph.nodes().size()).build();
        for (Object object : valueGraph.nodes()) {
            mutableValueGraph.addNode(object);
        }
        for (EndpointPair endpointPair : valueGraph.edges()) {
            mutableValueGraph.putEdgeValue(endpointPair.nodeU(), endpointPair.nodeV(), Objects.requireNonNull(valueGraph.edgeValueOrDefault(endpointPair.nodeU(), endpointPair.nodeV(), null)));
        }
        return mutableValueGraph;
    }

    public static <N, E> MutableNetwork<N, E> copyOf(Network<N, E> network) {
        MutableNetwork mutableNetwork = NetworkBuilder.from(network).expectedNodeCount(network.nodes().size()).expectedEdgeCount(network.edges().size()).build();
        for (Object object : network.nodes()) {
            mutableNetwork.addNode(object);
        }
        for (Object object : network.edges()) {
            EndpointPair<N> endpointPair = network.incidentNodes(object);
            mutableNetwork.addEdge(endpointPair.nodeU(), endpointPair.nodeV(), object);
        }
        return mutableNetwork;
    }

    @CanIgnoreReturnValue
    static int checkNonNegative(int n) {
        Preconditions.checkArgument(n >= 0, "Not true that %s is non-negative.", n);
        return n;
    }

    @CanIgnoreReturnValue
    static long checkNonNegative(long l) {
        Preconditions.checkArgument(l >= 0L, "Not true that %s is non-negative.", l);
        return l;
    }

    @CanIgnoreReturnValue
    static int checkPositive(int n) {
        Preconditions.checkArgument(n > 0, "Not true that %s is positive.", n);
        return n;
    }

    @CanIgnoreReturnValue
    static long checkPositive(long l) {
        Preconditions.checkArgument(l > 0L, "Not true that %s is positive.", l);
        return l;
    }

    private static enum NodeVisitState {
        PENDING,
        COMPLETE;

    }

    private static class TransposedNetwork<N, E>
    extends ForwardingNetwork<N, E> {
        private final Network<N, E> network;

        TransposedNetwork(Network<N, E> network) {
            this.network = network;
        }

        @Override
        Network<N, E> delegate() {
            return this.network;
        }

        @Override
        public Set<N> predecessors(N n) {
            return this.delegate().successors((Object)n);
        }

        @Override
        public Set<N> successors(N n) {
            return this.delegate().predecessors((Object)n);
        }

        @Override
        public int inDegree(N n) {
            return this.delegate().outDegree(n);
        }

        @Override
        public int outDegree(N n) {
            return this.delegate().inDegree(n);
        }

        @Override
        public Set<E> inEdges(N n) {
            return this.delegate().outEdges(n);
        }

        @Override
        public Set<E> outEdges(N n) {
            return this.delegate().inEdges(n);
        }

        @Override
        public EndpointPair<N> incidentNodes(E e) {
            EndpointPair<N> endpointPair = this.delegate().incidentNodes(e);
            return EndpointPair.of(this.network, endpointPair.nodeV(), endpointPair.nodeU());
        }

        @Override
        public Set<E> edgesConnecting(N n, N n2) {
            return this.delegate().edgesConnecting(n2, n);
        }

        @Override
        public Set<E> edgesConnecting(EndpointPair<N> endpointPair) {
            return this.delegate().edgesConnecting(Graphs.transpose(endpointPair));
        }

        @Override
        public Optional<E> edgeConnecting(N n, N n2) {
            return this.delegate().edgeConnecting(n2, n);
        }

        @Override
        public Optional<E> edgeConnecting(EndpointPair<N> endpointPair) {
            return this.delegate().edgeConnecting(Graphs.transpose(endpointPair));
        }

        @Override
        @CheckForNull
        public E edgeConnectingOrNull(N n, N n2) {
            return this.delegate().edgeConnectingOrNull(n2, n);
        }

        @Override
        @CheckForNull
        public E edgeConnectingOrNull(EndpointPair<N> endpointPair) {
            return this.delegate().edgeConnectingOrNull(Graphs.transpose(endpointPair));
        }

        @Override
        public boolean hasEdgeConnecting(N n, N n2) {
            return this.delegate().hasEdgeConnecting(n2, n);
        }

        @Override
        public boolean hasEdgeConnecting(EndpointPair<N> endpointPair) {
            return this.delegate().hasEdgeConnecting(Graphs.transpose(endpointPair));
        }
    }

    private static class TransposedValueGraph<N, V>
    extends ForwardingValueGraph<N, V> {
        private final ValueGraph<N, V> graph;

        TransposedValueGraph(ValueGraph<N, V> valueGraph) {
            this.graph = valueGraph;
        }

        @Override
        ValueGraph<N, V> delegate() {
            return this.graph;
        }

        @Override
        public Set<N> predecessors(N n) {
            return this.delegate().successors((Object)n);
        }

        @Override
        public Set<N> successors(N n) {
            return this.delegate().predecessors((Object)n);
        }

        @Override
        public int inDegree(N n) {
            return this.delegate().outDegree(n);
        }

        @Override
        public int outDegree(N n) {
            return this.delegate().inDegree(n);
        }

        @Override
        public boolean hasEdgeConnecting(N n, N n2) {
            return this.delegate().hasEdgeConnecting(n2, n);
        }

        @Override
        public boolean hasEdgeConnecting(EndpointPair<N> endpointPair) {
            return this.delegate().hasEdgeConnecting(Graphs.transpose(endpointPair));
        }

        @Override
        public Optional<V> edgeValue(N n, N n2) {
            return this.delegate().edgeValue(n2, n);
        }

        @Override
        public Optional<V> edgeValue(EndpointPair<N> endpointPair) {
            return this.delegate().edgeValue(Graphs.transpose(endpointPair));
        }

        @Override
        @CheckForNull
        public V edgeValueOrDefault(N n, N n2, @CheckForNull V v) {
            return this.delegate().edgeValueOrDefault(n2, n, v);
        }

        @Override
        @CheckForNull
        public V edgeValueOrDefault(EndpointPair<N> endpointPair, @CheckForNull V v) {
            return this.delegate().edgeValueOrDefault(Graphs.transpose(endpointPair), v);
        }
    }

    private static class TransposedGraph<N>
    extends ForwardingGraph<N> {
        private final Graph<N> graph;

        TransposedGraph(Graph<N> graph) {
            this.graph = graph;
        }

        @Override
        Graph<N> delegate() {
            return this.graph;
        }

        @Override
        public Set<N> predecessors(N n) {
            return this.delegate().successors((Object)n);
        }

        @Override
        public Set<N> successors(N n) {
            return this.delegate().predecessors((Object)n);
        }

        @Override
        public Set<EndpointPair<N>> incidentEdges(N n) {
            return new IncidentEdgeSet<N>(this, n){

                @Override
                public Iterator<EndpointPair<N>> iterator() {
                    return Iterators.transform(this.delegate().incidentEdges(this.node).iterator(), endpointPair -> EndpointPair.of(this.delegate(), endpointPair.nodeV(), endpointPair.nodeU()));
                }
            };
        }

        @Override
        public int inDegree(N n) {
            return this.delegate().outDegree(n);
        }

        @Override
        public int outDegree(N n) {
            return this.delegate().inDegree(n);
        }

        @Override
        public boolean hasEdgeConnecting(N n, N n2) {
            return this.delegate().hasEdgeConnecting(n2, n);
        }

        @Override
        public boolean hasEdgeConnecting(EndpointPair<N> endpointPair) {
            return this.delegate().hasEdgeConnecting(Graphs.transpose(endpointPair));
        }
    }
}

