/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.BoundType;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.SortedMultiset;
import com.google.j2objc.annotations.Weak;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class SortedMultisets {
    private SortedMultisets() {
    }

    private static <E> E getElementOrThrow(@CheckForNull Multiset.Entry<E> entry) {
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return entry.getElement();
    }

    @CheckForNull
    private static <E> E getElementOrNull(@CheckForNull Multiset.Entry<E> entry) {
        return entry == null ? null : (E)entry.getElement();
    }

    @GwtIncompatible
    static class NavigableElementSet<E>
    extends ElementSet<E>
    implements NavigableSet<E> {
        NavigableElementSet(SortedMultiset<E> sortedMultiset) {
            super(sortedMultiset);
        }

        @Override
        @CheckForNull
        public E lower(@ParametricNullness E e) {
            return (E)SortedMultisets.getElementOrNull(this.multiset().headMultiset(e, BoundType.OPEN).lastEntry());
        }

        @Override
        @CheckForNull
        public E floor(@ParametricNullness E e) {
            return (E)SortedMultisets.getElementOrNull(this.multiset().headMultiset(e, BoundType.CLOSED).lastEntry());
        }

        @Override
        @CheckForNull
        public E ceiling(@ParametricNullness E e) {
            return (E)SortedMultisets.getElementOrNull(this.multiset().tailMultiset(e, BoundType.CLOSED).firstEntry());
        }

        @Override
        @CheckForNull
        public E higher(@ParametricNullness E e) {
            return (E)SortedMultisets.getElementOrNull(this.multiset().tailMultiset(e, BoundType.OPEN).firstEntry());
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return new NavigableElementSet(this.multiset().descendingMultiset());
        }

        @Override
        public Iterator<E> descendingIterator() {
            return this.descendingSet().iterator();
        }

        @Override
        @CheckForNull
        public E pollFirst() {
            return (E)SortedMultisets.getElementOrNull(this.multiset().pollFirstEntry());
        }

        @Override
        @CheckForNull
        public E pollLast() {
            return (E)SortedMultisets.getElementOrNull(this.multiset().pollLastEntry());
        }

        @Override
        public NavigableSet<E> subSet(@ParametricNullness E e, boolean bl, @ParametricNullness E e2, boolean bl2) {
            return new NavigableElementSet<E>(this.multiset().subMultiset(e, BoundType.forBoolean(bl), e2, BoundType.forBoolean(bl2)));
        }

        @Override
        public NavigableSet<E> headSet(@ParametricNullness E e, boolean bl) {
            return new NavigableElementSet<E>(this.multiset().headMultiset(e, BoundType.forBoolean(bl)));
        }

        @Override
        public NavigableSet<E> tailSet(@ParametricNullness E e, boolean bl) {
            return new NavigableElementSet<E>(this.multiset().tailMultiset(e, BoundType.forBoolean(bl)));
        }
    }

    static class ElementSet<E>
    extends Multisets.ElementSet<E>
    implements SortedSet<E> {
        @Weak
        private final SortedMultiset<E> multiset;

        ElementSet(SortedMultiset<E> sortedMultiset) {
            this.multiset = sortedMultiset;
        }

        @Override
        final SortedMultiset<E> multiset() {
            return this.multiset;
        }

        @Override
        public Iterator<E> iterator() {
            return Multisets.elementIterator(this.multiset().entrySet().iterator());
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.multiset().comparator();
        }

        @Override
        public SortedSet<E> subSet(@ParametricNullness E e, @ParametricNullness E e2) {
            return this.multiset().subMultiset(e, BoundType.CLOSED, e2, BoundType.OPEN).elementSet();
        }

        @Override
        public SortedSet<E> headSet(@ParametricNullness E e) {
            return this.multiset().headMultiset(e, BoundType.OPEN).elementSet();
        }

        @Override
        public SortedSet<E> tailSet(@ParametricNullness E e) {
            return this.multiset().tailMultiset(e, BoundType.CLOSED).elementSet();
        }

        @Override
        @ParametricNullness
        public E first() {
            return (E)SortedMultisets.getElementOrThrow(this.multiset().firstEntry());
        }

        @Override
        @ParametricNullness
        public E last() {
            return (E)SortedMultisets.getElementOrThrow(this.multiset().lastEntry());
        }
    }
}

