/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.DenseImmutableTable;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.IndexedImmutableSet;
import com.google.common.collect.SparseImmutableTable;
import com.google.common.collect.Table;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
abstract class RegularImmutableTable<R, C, V>
extends ImmutableTable<R, C, V> {
    RegularImmutableTable() {
    }

    abstract Table.Cell<R, C, V> getCell(int var1);

    @Override
    final ImmutableSet<Table.Cell<R, C, V>> createCellSet() {
        return this.isEmpty() ? ImmutableSet.of() : new CellSet();
    }

    abstract V getValue(int var1);

    @Override
    final ImmutableCollection<V> createValues() {
        return this.isEmpty() ? ImmutableList.of() : new Values();
    }

    static <R, C, V> RegularImmutableTable<R, C, V> forCells(List<Table.Cell<R, C, V>> list, @CheckForNull Comparator<? super R> comparator, @CheckForNull Comparator<? super C> comparator2) {
        Preconditions.checkNotNull(list);
        if (comparator != null || comparator2 != null) {
            Comparator comparator3 = (cell, cell2) -> {
                int n;
                int n2 = n = comparator == null ? 0 : comparator.compare((Object)cell.getRowKey(), (Object)cell2.getRowKey());
                if (n != 0) {
                    return n;
                }
                return comparator2 == null ? 0 : comparator2.compare((Object)cell.getColumnKey(), (Object)cell2.getColumnKey());
            };
            Collections.sort(list, comparator3);
        }
        return RegularImmutableTable.forCellsInternal(list, comparator, comparator2);
    }

    static <R, C, V> RegularImmutableTable<R, C, V> forCells(Iterable<Table.Cell<R, C, V>> iterable) {
        return RegularImmutableTable.forCellsInternal(iterable, null, null);
    }

    private static <R, C, V> RegularImmutableTable<R, C, V> forCellsInternal(Iterable<Table.Cell<R, C, V>> iterable, @CheckForNull Comparator<? super R> comparator, @CheckForNull Comparator<? super C> comparator2) {
        LinkedHashSet<R> linkedHashSet = new LinkedHashSet<R>();
        LinkedHashSet<C> linkedHashSet2 = new LinkedHashSet<C>();
        ImmutableList<Table.Cell<R, C, V>> immutableList = ImmutableList.copyOf(iterable);
        for (Table.Cell<R, C, V> object2 : iterable) {
            linkedHashSet.add(object2.getRowKey());
            linkedHashSet2.add(object2.getColumnKey());
        }
        ImmutableSet<Object> immutableSet = comparator == null ? ImmutableSet.copyOf(linkedHashSet) : ImmutableSet.copyOf(ImmutableList.sortedCopyOf(comparator, linkedHashSet));
        ImmutableSet immutableSet2 = comparator2 == null ? ImmutableSet.copyOf(linkedHashSet2) : ImmutableSet.copyOf(ImmutableList.sortedCopyOf(comparator2, linkedHashSet2));
        return RegularImmutableTable.forOrderedComponents(immutableList, immutableSet, immutableSet2);
    }

    static <R, C, V> RegularImmutableTable<R, C, V> forOrderedComponents(ImmutableList<Table.Cell<R, C, V>> immutableList, ImmutableSet<R> immutableSet, ImmutableSet<C> immutableSet2) {
        return (long)immutableList.size() > (long)immutableSet.size() * (long)immutableSet2.size() / 2L ? new DenseImmutableTable<R, C, V>(immutableList, immutableSet, immutableSet2) : new SparseImmutableTable<R, C, V>(immutableList, immutableSet, immutableSet2);
    }

    final void checkNoDuplicate(R r, C c, @CheckForNull V v, V v2) {
        Preconditions.checkArgument(v == null, "Duplicate key: (row=%s, column=%s), values: [%s, %s].", r, c, v2, v);
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    abstract Object writeReplace();

    private final class Values
    extends ImmutableList<V> {
        private Values() {
        }

        @Override
        public int size() {
            return RegularImmutableTable.this.size();
        }

        @Override
        public V get(int n) {
            return RegularImmutableTable.this.getValue(n);
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        @J2ktIncompatible
        @GwtIncompatible
        Object writeReplace() {
            return super.writeReplace();
        }
    }

    private final class CellSet
    extends IndexedImmutableSet<Table.Cell<R, C, V>> {
        private CellSet() {
        }

        @Override
        public int size() {
            return RegularImmutableTable.this.size();
        }

        @Override
        Table.Cell<R, C, V> get(int n) {
            return RegularImmutableTable.this.getCell(n);
        }

        @Override
        public boolean contains(@CheckForNull Object object) {
            if (object instanceof Table.Cell) {
                Table.Cell cell = (Table.Cell)object;
                Object object2 = RegularImmutableTable.this.get(cell.getRowKey(), cell.getColumnKey());
                return object2 != null && object2.equals(cell.getValue());
            }
            return false;
        }

        @Override
        boolean isPartialView() {
            return false;
        }

        @Override
        @J2ktIncompatible
        @GwtIncompatible
        Object writeReplace() {
            return super.writeReplace();
        }
    }
}

