/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.JdkBackedImmutableMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true, serializable=true)
class RegularImmutableMultiset<E>
extends ImmutableMultiset<E> {
    private static final Multisets.ImmutableEntry<?>[] EMPTY_ARRAY = new Multisets.ImmutableEntry[0];
    static final ImmutableMultiset<Object> EMPTY = RegularImmutableMultiset.create(ImmutableList.of());
    @VisibleForTesting
    static final double MAX_LOAD_FACTOR = 1.0;
    @VisibleForTesting
    static final double HASH_FLOODING_FPP = 0.001;
    @VisibleForTesting
    static final int MAX_HASH_BUCKET_LENGTH = 9;
    private final transient Multisets.ImmutableEntry<E>[] entries;
    private final transient @Nullable Multisets.ImmutableEntry<?>[] hashTable;
    private final transient int size;
    private final transient int hashCode;
    @LazyInit
    @CheckForNull
    private transient ImmutableSet<E> elementSet;

    static <E> ImmutableMultiset<E> create(Collection<? extends Multiset.Entry<? extends E>> collection) {
        int n = collection.size();
        Object[] objectArray = new Multisets.ImmutableEntry[n];
        if (n == 0) {
            return new RegularImmutableMultiset((Multisets.ImmutableEntry<E>[])objectArray, EMPTY_ARRAY, 0, 0, ImmutableSet.of());
        }
        int n2 = Hashing.closedTableSize(n, 1.0);
        int n3 = n2 - 1;
        @Nullable Multisets.ImmutableEntry[] immutableEntryArray = new Multisets.ImmutableEntry[n2];
        int n4 = 0;
        int n5 = 0;
        long l = 0L;
        Iterator<Multiset.Entry<E>> iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            Multisets.ImmutableEntry immutableEntry;
            Multiset.Entry<E> entry;
            Multiset.Entry<E> entry2 = entry = iterator2.next();
            E e = Preconditions.checkNotNull(entry2.getElement());
            int n6 = entry2.getCount();
            int n7 = e.hashCode();
            int n8 = Hashing.smear(n7) & n3;
            Multisets.ImmutableEntry immutableEntry2 = immutableEntryArray[n8];
            if (immutableEntry2 == null) {
                boolean bl = entry2 instanceof Multisets.ImmutableEntry && !(entry2 instanceof NonTerminalEntry);
                immutableEntry = bl ? (Multisets.ImmutableEntry)entry2 : new Multisets.ImmutableEntry<E>(e, n6);
            } else {
                immutableEntry = new NonTerminalEntry<E>(e, n6, immutableEntry2);
            }
            n5 += n7 ^ n6;
            objectArray[n4++] = immutableEntry;
            immutableEntryArray[n8] = immutableEntry;
            l += (long)n6;
        }
        return RegularImmutableMultiset.hashFloodingDetected(immutableEntryArray) ? JdkBackedImmutableMultiset.create(ImmutableList.asImmutableList(objectArray)) : new RegularImmutableMultiset<E>((Multisets.ImmutableEntry<E>[])objectArray, immutableEntryArray, Ints.saturatedCast(l), n5, null);
    }

    private static boolean hashFloodingDetected(@Nullable Multisets.ImmutableEntry<?>[] immutableEntryArray) {
        for (int i = 0; i < immutableEntryArray.length; ++i) {
            int n = 0;
            for (Multisets.ImmutableEntry<?> immutableEntry = immutableEntryArray[i]; immutableEntry != null; immutableEntry = immutableEntry.nextInBucket()) {
                if (++n <= 9) continue;
                return true;
            }
        }
        return false;
    }

    private RegularImmutableMultiset(Multisets.ImmutableEntry<E>[] immutableEntryArray, @Nullable Multisets.ImmutableEntry<?>[] immutableEntryArray2, int n, int n2, @CheckForNull ImmutableSet<E> immutableSet) {
        this.entries = immutableEntryArray;
        this.hashTable = immutableEntryArray2;
        this.size = n;
        this.hashCode = n2;
        this.elementSet = immutableSet;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int count(@CheckForNull Object object) {
        @Nullable Multisets.ImmutableEntry<?>[] immutableEntryArray = this.hashTable;
        if (object == null || immutableEntryArray.length == 0) {
            return 0;
        }
        int n = Hashing.smearedHash(object);
        int n2 = immutableEntryArray.length - 1;
        for (Multisets.ImmutableEntry<?> immutableEntry = immutableEntryArray[n & n2]; immutableEntry != null; immutableEntry = immutableEntry.nextInBucket()) {
            if (!Objects.equal(object, immutableEntry.getElement())) continue;
            return immutableEntry.getCount();
        }
        return 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ImmutableSet<E> elementSet() {
        ImmutableSet<E> immutableSet = this.elementSet;
        return immutableSet == null ? (this.elementSet = new ImmutableMultiset.ElementSet(Arrays.asList(this.entries), this)) : immutableSet;
    }

    @Override
    Multiset.Entry<E> getEntry(int n) {
        return this.entries[n];
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }

    private static final class NonTerminalEntry<E>
    extends Multisets.ImmutableEntry<E> {
        private final Multisets.ImmutableEntry<E> nextInBucket;

        NonTerminalEntry(E e, int n, Multisets.ImmutableEntry<E> immutableEntry) {
            super(e, n);
            this.nextInBucket = immutableEntry;
        }

        @Override
        public Multisets.ImmutableEntry<E> nextInBucket() {
            return this.nextInBucket;
        }
    }
}

