/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableAsList;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMapEntry;
import com.google.common.collect.ImmutableMapEntrySet;
import com.google.common.collect.ImmutableMapKeySet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.JdkBackedImmutableBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.RegularImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.j2objc.annotations.RetainedWith;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
class RegularImmutableBiMap<K, V>
extends ImmutableBiMap<K, V> {
    static final RegularImmutableBiMap<Object, Object> EMPTY = new RegularImmutableBiMap(null, null, ImmutableMap.EMPTY_ENTRY_ARRAY, 0, 0);
    static final double MAX_LOAD_FACTOR = 1.2;
    @CheckForNull
    private final transient @Nullable ImmutableMapEntry<K, V>[] keyTable;
    @CheckForNull
    private final transient @Nullable ImmutableMapEntry<K, V>[] valueTable;
    @VisibleForTesting
    final transient Map.Entry<K, V>[] entries;
    private final transient int mask;
    private final transient int hashCode;
    @LazyInit
    @CheckForNull
    @RetainedWith
    private transient ImmutableBiMap<V, K> inverse;

    static <K, V> ImmutableBiMap<K, V> fromEntries(Map.Entry<K, V> ... entryArray) {
        return RegularImmutableBiMap.fromEntryArray(entryArray.length, entryArray);
    }

    static <K, V> ImmutableBiMap<K, V> fromEntryArray(int n,  @Nullable Map.Entry<K, V>[] entryArray) {
        Preconditions.checkPositionIndex(n, entryArray.length);
        int n2 = Hashing.closedTableSize(n, 1.2);
        int n3 = n2 - 1;
        @Nullable ImmutableMapEntry<K, V>[] immutableMapEntryArray = ImmutableMapEntry.createEntryArray(n2);
        @Nullable ImmutableMapEntry<K, V>[] immutableMapEntryArray2 = ImmutableMapEntry.createEntryArray(n2);
        Map.Entry<K, V>[] entryArray2 = n == entryArray.length ? entryArray : ImmutableMapEntry.createEntryArray(n);
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            Map.Entry<K, V> entry = Objects.requireNonNull(entryArray[i]);
            K k = entry.getKey();
            V v = entry.getValue();
            CollectPreconditions.checkEntryNotNull(k, v);
            int n5 = k.hashCode();
            int n6 = v.hashCode();
            int n7 = Hashing.smear(n5) & n3;
            int n8 = Hashing.smear(n6) & n3;
            ImmutableMapEntry immutableMapEntry = immutableMapEntryArray[n7];
            ImmutableMapEntry immutableMapEntry2 = immutableMapEntryArray2[n8];
            try {
                RegularImmutableMap.checkNoConflictInKeyBucket(k, v, immutableMapEntry, true);
                RegularImmutableBiMap.checkNoConflictInValueBucket(v, entry, immutableMapEntry2);
            }
            catch (RegularImmutableMap.BucketOverflowException bucketOverflowException) {
                return JdkBackedImmutableBiMap.create(n, entryArray);
            }
            ImmutableMapEntry immutableMapEntry3 = immutableMapEntry2 == null && immutableMapEntry == null ? RegularImmutableMap.makeImmutable(entry, k, v) : new ImmutableMapEntry.NonTerminalImmutableBiMapEntry<K, V>(k, v, immutableMapEntry, immutableMapEntry2);
            immutableMapEntryArray[n7] = immutableMapEntry3;
            immutableMapEntryArray2[n8] = immutableMapEntry3;
            entryArray2[i] = immutableMapEntry3;
            n4 += n5 ^ n6;
        }
        return new RegularImmutableBiMap(immutableMapEntryArray, immutableMapEntryArray2, entryArray2, n3, n4);
    }

    private RegularImmutableBiMap(@CheckForNull @Nullable ImmutableMapEntry<K, V>[] immutableMapEntryArray, @CheckForNull @Nullable ImmutableMapEntry<K, V>[] immutableMapEntryArray2, Map.Entry<K, V>[] entryArray, int n, int n2) {
        this.keyTable = immutableMapEntryArray;
        this.valueTable = immutableMapEntryArray2;
        this.entries = entryArray;
        this.mask = n;
        this.hashCode = n2;
    }

    private static void checkNoConflictInValueBucket(Object object, Map.Entry<?, ?> entry, @CheckForNull ImmutableMapEntry<?, ?> immutableMapEntry) throws RegularImmutableMap.BucketOverflowException {
        int n = 0;
        while (immutableMapEntry != null) {
            RegularImmutableBiMap.checkNoConflict(!object.equals(immutableMapEntry.getValue()), "value", entry, immutableMapEntry);
            if (++n > 8) {
                throw new RegularImmutableMap.BucketOverflowException();
            }
            immutableMapEntry = immutableMapEntry.getNextInValueBucket();
        }
    }

    @Override
    @CheckForNull
    public V get(@CheckForNull Object object) {
        return RegularImmutableMap.get(object, this.keyTable, this.mask);
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return this.isEmpty() ? ImmutableSet.of() : new ImmutableMapEntrySet.RegularEntrySet<K, V>(this, this.entries);
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return new ImmutableMapKeySet(this);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        Preconditions.checkNotNull(biConsumer);
        for (Map.Entry<K, V> entry : this.entries) {
            biConsumer.accept(entry.getKey(), entry.getValue());
        }
    }

    @Override
    boolean isHashCodeFast() {
        return true;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    public ImmutableBiMap<V, K> inverse() {
        if (this.isEmpty()) {
            return ImmutableBiMap.of();
        }
        Inverse inverse = this.inverse;
        return inverse == null ? (this.inverse = new Inverse()) : inverse;
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }

    @J2ktIncompatible
    private static class InverseSerializedForm<K, V>
    implements Serializable {
        private final ImmutableBiMap<K, V> forward;
        private static final long serialVersionUID = 1L;

        InverseSerializedForm(ImmutableBiMap<K, V> immutableBiMap) {
            this.forward = immutableBiMap;
        }

        Object readResolve() {
            return this.forward.inverse();
        }
    }

    private final class Inverse
    extends ImmutableBiMap<V, K> {
        private Inverse() {
        }

        @Override
        public int size() {
            return this.inverse().size();
        }

        @Override
        public ImmutableBiMap<K, V> inverse() {
            return RegularImmutableBiMap.this;
        }

        @Override
        public void forEach(BiConsumer<? super V, ? super K> biConsumer) {
            Preconditions.checkNotNull(biConsumer);
            RegularImmutableBiMap.this.forEach((? super K object, ? super V object2) -> biConsumer.accept((Object)object2, (Object)object));
        }

        @Override
        @CheckForNull
        public K get(@CheckForNull Object object) {
            if (object == null || RegularImmutableBiMap.this.valueTable == null) {
                return null;
            }
            int n = Hashing.smear(object.hashCode()) & RegularImmutableBiMap.this.mask;
            for (ImmutableMapEntry immutableMapEntry = RegularImmutableBiMap.this.valueTable[n]; immutableMapEntry != null; immutableMapEntry = immutableMapEntry.getNextInValueBucket()) {
                if (!object.equals(immutableMapEntry.getValue())) continue;
                return immutableMapEntry.getKey();
            }
            return null;
        }

        @Override
        ImmutableSet<V> createKeySet() {
            return new ImmutableMapKeySet(this);
        }

        @Override
        ImmutableSet<Map.Entry<V, K>> createEntrySet() {
            return new InverseEntrySet();
        }

        @Override
        boolean isPartialView() {
            return false;
        }

        @Override
        @J2ktIncompatible
        @GwtIncompatible
        Object writeReplace() {
            return new InverseSerializedForm(RegularImmutableBiMap.this);
        }

        @J2ktIncompatible
        private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
            throw new InvalidObjectException("Use InverseSerializedForm");
        }

        final class InverseEntrySet
        extends ImmutableMapEntrySet<V, K> {
            InverseEntrySet() {
            }

            @Override
            ImmutableMap<V, K> map() {
                return Inverse.this;
            }

            @Override
            boolean isHashCodeFast() {
                return true;
            }

            @Override
            public int hashCode() {
                return RegularImmutableBiMap.this.hashCode;
            }

            @Override
            public UnmodifiableIterator<Map.Entry<V, K>> iterator() {
                return this.asList().iterator();
            }

            @Override
            public void forEach(Consumer<? super Map.Entry<V, K>> consumer) {
                this.asList().forEach(consumer);
            }

            @Override
            ImmutableList<Map.Entry<V, K>> createAsList() {
                return new ImmutableAsList<Map.Entry<V, K>>(){

                    @Override
                    public Map.Entry<V, K> get(int n) {
                        Map.Entry entry = RegularImmutableBiMap.this.entries[n];
                        return Maps.immutableEntry(entry.getValue(), entry.getKey());
                    }

                    @Override
                    ImmutableCollection<Map.Entry<V, K>> delegateCollection() {
                        return InverseEntrySet.this;
                    }

                    @Override
                    @J2ktIncompatible
                    @GwtIncompatible
                    Object writeReplace() {
                        return super.writeReplace();
                    }
                };
            }

            @Override
            @J2ktIncompatible
            @GwtIncompatible
            Object writeReplace() {
                return super.writeReplace();
            }
        }
    }
}

