/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.BoundType;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Cut;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.RangeGwtSerializationDependencies;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.util.SortedSet;
import javax.annotation.CheckForNull;

@Immutable(containerOf={"C"})
@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Range<C extends Comparable>
extends RangeGwtSerializationDependencies
implements Predicate<C>,
Serializable {
    private static final Range<Comparable> ALL = new Range(Cut.belowAll(), Cut.aboveAll());
    final Cut<C> lowerBound;
    final Cut<C> upperBound;
    private static final long serialVersionUID = 0L;

    static <C extends Comparable<?>> Ordering<Range<C>> rangeLexOrdering() {
        return RangeLexOrdering.INSTANCE;
    }

    static <C extends Comparable<?>> Range<C> create(Cut<C> cut, Cut<C> cut2) {
        return new Range<C>(cut, cut2);
    }

    public static <C extends Comparable<?>> Range<C> open(C c, C c2) {
        return Range.create(Cut.aboveValue(c), Cut.belowValue(c2));
    }

    public static <C extends Comparable<?>> Range<C> closed(C c, C c2) {
        return Range.create(Cut.belowValue(c), Cut.aboveValue(c2));
    }

    public static <C extends Comparable<?>> Range<C> closedOpen(C c, C c2) {
        return Range.create(Cut.belowValue(c), Cut.belowValue(c2));
    }

    public static <C extends Comparable<?>> Range<C> openClosed(C c, C c2) {
        return Range.create(Cut.aboveValue(c), Cut.aboveValue(c2));
    }

    public static <C extends Comparable<?>> Range<C> range(C c, BoundType boundType, C c2, BoundType boundType2) {
        Preconditions.checkNotNull(boundType);
        Preconditions.checkNotNull(boundType2);
        Cut<C> cut = boundType == BoundType.OPEN ? Cut.aboveValue(c) : Cut.belowValue(c);
        Cut<C> cut2 = boundType2 == BoundType.OPEN ? Cut.belowValue(c2) : Cut.aboveValue(c2);
        return Range.create(cut, cut2);
    }

    public static <C extends Comparable<?>> Range<C> lessThan(C c) {
        return Range.create(Cut.belowAll(), Cut.belowValue(c));
    }

    public static <C extends Comparable<?>> Range<C> atMost(C c) {
        return Range.create(Cut.belowAll(), Cut.aboveValue(c));
    }

    public static <C extends Comparable<?>> Range<C> upTo(C c, BoundType boundType) {
        switch (boundType) {
            case OPEN: {
                return Range.lessThan(c);
            }
            case CLOSED: {
                return Range.atMost(c);
            }
        }
        throw new AssertionError();
    }

    public static <C extends Comparable<?>> Range<C> greaterThan(C c) {
        return Range.create(Cut.aboveValue(c), Cut.aboveAll());
    }

    public static <C extends Comparable<?>> Range<C> atLeast(C c) {
        return Range.create(Cut.belowValue(c), Cut.aboveAll());
    }

    public static <C extends Comparable<?>> Range<C> downTo(C c, BoundType boundType) {
        switch (boundType) {
            case OPEN: {
                return Range.greaterThan(c);
            }
            case CLOSED: {
                return Range.atLeast(c);
            }
        }
        throw new AssertionError();
    }

    public static <C extends Comparable<?>> Range<C> all() {
        return ALL;
    }

    public static <C extends Comparable<?>> Range<C> singleton(C c) {
        return Range.closed(c, c);
    }

    public static <C extends Comparable<?>> Range<C> encloseAll(Iterable<C> iterable) {
        Object object;
        Object object2;
        Preconditions.checkNotNull(iterable);
        if (iterable instanceof SortedSet) {
            object2 = (SortedSet)iterable;
            object = object2.comparator();
            if (Ordering.natural().equals(object) || object == null) {
                return Range.closed((Comparable)object2.first(), (Comparable)object2.last());
            }
        }
        object2 = iterable.iterator();
        Object object3 = object = Preconditions.checkNotNull((Comparable)object2.next());
        while (object2.hasNext()) {
            Comparable comparable = Preconditions.checkNotNull((Comparable)object2.next());
            object = Ordering.natural().min(object, comparable);
            object3 = Ordering.natural().max(object3, comparable);
        }
        return Range.closed(object, object3);
    }

    private Range(Cut<C> cut, Cut<C> cut2) {
        this.lowerBound = Preconditions.checkNotNull(cut);
        this.upperBound = Preconditions.checkNotNull(cut2);
        if (cut.compareTo(cut2) > 0 || cut == Cut.aboveAll() || cut2 == Cut.belowAll()) {
            throw new IllegalArgumentException("Invalid range: " + Range.toString(cut, cut2));
        }
    }

    public boolean hasLowerBound() {
        return this.lowerBound != Cut.belowAll();
    }

    public C lowerEndpoint() {
        return this.lowerBound.endpoint();
    }

    public BoundType lowerBoundType() {
        return this.lowerBound.typeAsLowerBound();
    }

    public boolean hasUpperBound() {
        return this.upperBound != Cut.aboveAll();
    }

    public C upperEndpoint() {
        return this.upperBound.endpoint();
    }

    public BoundType upperBoundType() {
        return this.upperBound.typeAsUpperBound();
    }

    public boolean isEmpty() {
        return this.lowerBound.equals(this.upperBound);
    }

    public boolean contains(C c) {
        Preconditions.checkNotNull(c);
        return this.lowerBound.isLessThan(c) && !this.upperBound.isLessThan(c);
    }

    @Override
    @Deprecated
    public boolean apply(C c) {
        return this.contains(c);
    }

    public boolean containsAll(Iterable<? extends C> iterable) {
        if (Iterables.isEmpty(iterable)) {
            return true;
        }
        if (iterable instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)iterable;
            Object object = sortedSet.comparator();
            if (Ordering.natural().equals(object) || object == null) {
                return this.contains((Comparable)sortedSet.first()) && this.contains((Comparable)sortedSet.last());
            }
        }
        for (Object object : iterable) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    public boolean encloses(Range<C> range) {
        return this.lowerBound.compareTo(range.lowerBound) <= 0 && this.upperBound.compareTo(range.upperBound) >= 0;
    }

    public boolean isConnected(Range<C> range) {
        return this.lowerBound.compareTo(range.upperBound) <= 0 && range.lowerBound.compareTo(this.upperBound) <= 0;
    }

    public Range<C> intersection(Range<C> range) {
        int n = this.lowerBound.compareTo(range.lowerBound);
        int n2 = this.upperBound.compareTo(range.upperBound);
        if (n >= 0 && n2 <= 0) {
            return this;
        }
        if (n <= 0 && n2 >= 0) {
            return range;
        }
        Cut<C> cut = n >= 0 ? this.lowerBound : range.lowerBound;
        Cut<C> cut2 = n2 <= 0 ? this.upperBound : range.upperBound;
        Preconditions.checkArgument(cut.compareTo(cut2) <= 0, "intersection is undefined for disconnected ranges %s and %s", (Object)this, range);
        return Range.create(cut, cut2);
    }

    public Range<C> gap(Range<C> range) {
        if (this.lowerBound.compareTo(range.upperBound) < 0 && range.lowerBound.compareTo(this.upperBound) < 0) {
            throw new IllegalArgumentException("Ranges have a nonempty intersection: " + this + ", " + range);
        }
        boolean bl = this.lowerBound.compareTo(range.lowerBound) < 0;
        Range<C> range2 = bl ? this : range;
        Range<C> range3 = bl ? range : this;
        return Range.create(range2.upperBound, range3.lowerBound);
    }

    public Range<C> span(Range<C> range) {
        int n = this.lowerBound.compareTo(range.lowerBound);
        int n2 = this.upperBound.compareTo(range.upperBound);
        if (n <= 0 && n2 >= 0) {
            return this;
        }
        if (n >= 0 && n2 <= 0) {
            return range;
        }
        Cut<C> cut = n <= 0 ? this.lowerBound : range.lowerBound;
        Cut<C> cut2 = n2 >= 0 ? this.upperBound : range.upperBound;
        return Range.create(cut, cut2);
    }

    public Range<C> canonical(DiscreteDomain<C> discreteDomain) {
        Preconditions.checkNotNull(discreteDomain);
        Cut<C> cut = this.lowerBound.canonical(discreteDomain);
        Cut<C> cut2 = this.upperBound.canonical(discreteDomain);
        return cut == this.lowerBound && cut2 == this.upperBound ? this : Range.create(cut, cut2);
    }

    @Override
    public boolean equals(@CheckForNull Object object) {
        if (object instanceof Range) {
            Range range = (Range)object;
            return this.lowerBound.equals(range.lowerBound) && this.upperBound.equals(range.upperBound);
        }
        return false;
    }

    public int hashCode() {
        return this.lowerBound.hashCode() * 31 + this.upperBound.hashCode();
    }

    public String toString() {
        return Range.toString(this.lowerBound, this.upperBound);
    }

    Cut<C> lowerBound() {
        return this.lowerBound;
    }

    Cut<C> upperBound() {
        return this.upperBound;
    }

    private static String toString(Cut<?> cut, Cut<?> cut2) {
        StringBuilder stringBuilder = new StringBuilder(16);
        cut.describeAsLowerBound(stringBuilder);
        stringBuilder.append("..");
        cut2.describeAsUpperBound(stringBuilder);
        return stringBuilder.toString();
    }

    Object readResolve() {
        if (this.equals(ALL)) {
            return Range.all();
        }
        return this;
    }

    static int compareOrThrow(Comparable comparable, Comparable comparable2) {
        return comparable.compareTo(comparable2);
    }

    private static class RangeLexOrdering
    extends Ordering<Range<?>>
    implements Serializable {
        static final Ordering<?> INSTANCE = new RangeLexOrdering();
        private static final long serialVersionUID = 0L;

        private RangeLexOrdering() {
        }

        @Override
        public int compare(Range<?> range, Range<?> range2) {
            return ComparisonChain.start().compare(range.lowerBound, range2.lowerBound).compare(range.upperBound, range2.upperBound).result();
        }
    }
}

