/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collector;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class MoreCollectors {
    private static final Collector<Object, ?, Optional<Object>> TO_OPTIONAL = Collector.of(ToOptionalState::new, ToOptionalState::add, ToOptionalState::combine, ToOptionalState::getOptional, Collector.Characteristics.UNORDERED);
    private static final Object NULL_PLACEHOLDER = new Object();
    private static final Collector<@Nullable Object, ?, @Nullable Object> ONLY_ELEMENT = Collector.of(ToOptionalState::new, (toOptionalState, object) -> toOptionalState.add(object == null ? NULL_PLACEHOLDER : object), ToOptionalState::combine, toOptionalState -> {
        Object object = toOptionalState.getElement();
        return object == NULL_PLACEHOLDER ? null : object;
    }, Collector.Characteristics.UNORDERED);

    public static <T> Collector<T, ?, Optional<T>> toOptional() {
        return TO_OPTIONAL;
    }

    public static <T> Collector<T, ?, T> onlyElement() {
        return ONLY_ELEMENT;
    }

    private MoreCollectors() {
    }

    private static final class ToOptionalState {
        static final int MAX_EXTRAS = 4;
        @CheckForNull
        Object element = null;
        List<Object> extras = Collections.emptyList();

        ToOptionalState() {
        }

        IllegalArgumentException multiples(boolean bl) {
            StringBuilder stringBuilder = new StringBuilder().append("expected one element but was: <").append(this.element);
            for (Object object : this.extras) {
                stringBuilder.append(", ").append(object);
            }
            if (bl) {
                stringBuilder.append(", ...");
            }
            stringBuilder.append('>');
            throw new IllegalArgumentException(stringBuilder.toString());
        }

        void add(Object object) {
            Preconditions.checkNotNull(object);
            if (this.element == null) {
                this.element = object;
            } else if (this.extras.isEmpty()) {
                this.extras = new ArrayList<Object>(4);
                this.extras.add(object);
            } else if (this.extras.size() < 4) {
                this.extras.add(object);
            } else {
                throw this.multiples(true);
            }
        }

        ToOptionalState combine(ToOptionalState toOptionalState) {
            if (this.element == null) {
                return toOptionalState;
            }
            if (toOptionalState.element == null) {
                return this;
            }
            if (this.extras.isEmpty()) {
                this.extras = new ArrayList<Object>();
            }
            this.extras.add(toOptionalState.element);
            this.extras.addAll(toOptionalState.extras);
            if (this.extras.size() > 4) {
                this.extras.subList(4, this.extras.size()).clear();
                throw this.multiples(true);
            }
            return this;
        }

        Optional<Object> getOptional() {
            if (this.extras.isEmpty()) {
                return Optional.ofNullable(this.element);
            }
            throw this.multiples(false);
        }

        Object getElement() {
            if (this.element == null) {
                throw new NoSuchElementException();
            }
            if (this.extras.isEmpty()) {
                return this.element;
            }
            throw this.multiples(false);
        }
    }
}

