/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ForwardingSortedMap;
import com.google.common.collect.ParametricNullness;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ForwardingSortedSet<E>
extends ForwardingSet<E>
implements SortedSet<E> {
    protected ForwardingSortedSet() {
    }

    @Override
    protected abstract SortedSet<E> delegate();

    @Override
    @CheckForNull
    public Comparator<? super E> comparator() {
        return this.delegate().comparator();
    }

    @Override
    @ParametricNullness
    public E first() {
        return this.delegate().first();
    }

    @Override
    public SortedSet<E> headSet(@ParametricNullness E e) {
        return this.delegate().headSet(e);
    }

    @Override
    @ParametricNullness
    public E last() {
        return this.delegate().last();
    }

    @Override
    public SortedSet<E> subSet(@ParametricNullness E e, @ParametricNullness E e2) {
        return this.delegate().subSet(e, e2);
    }

    @Override
    public SortedSet<E> tailSet(@ParametricNullness E e) {
        return this.delegate().tailSet(e);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected boolean standardContains(@CheckForNull Object object) {
        try {
            @Nullable ForwardingSortedSet forwardingSortedSet = this;
            Object object2 = forwardingSortedSet.tailSet(object).first();
            return ForwardingSortedMap.unsafeCompare(this.comparator(), object2, object) == 0;
        }
        catch (ClassCastException | NullPointerException | NoSuchElementException runtimeException) {
            return false;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected boolean standardRemove(@CheckForNull Object object) {
        try {
            @Nullable ForwardingSortedSet forwardingSortedSet = this;
            Iterator iterator2 = forwardingSortedSet.tailSet(object).iterator();
            if (iterator2.hasNext()) {
                Object e = iterator2.next();
                if (ForwardingSortedMap.unsafeCompare(this.comparator(), e, object) == 0) {
                    iterator2.remove();
                    return true;
                }
            }
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return false;
        }
        return false;
    }

    protected SortedSet<E> standardSubSet(@ParametricNullness E e, @ParametricNullness E e2) {
        return this.tailSet(e).headSet(e2);
    }
}

