/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMultiset;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Serialization;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.ObjIntConsumer;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
@J2ktIncompatible
public final class EnumMultiset<E extends Enum<E>>
extends AbstractMultiset<E>
implements Serializable {
    private transient Class<E> type;
    private transient E[] enumConstants;
    private transient int[] counts;
    private transient int distinctElements;
    private transient long size;
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    public static <E extends Enum<E>> EnumMultiset<E> create(Class<E> clazz) {
        return new EnumMultiset<E>(clazz);
    }

    public static <E extends Enum<E>> EnumMultiset<E> create(Iterable<E> iterable) {
        Iterator<E> iterator2 = iterable.iterator();
        Preconditions.checkArgument(iterator2.hasNext(), "EnumMultiset constructor passed empty Iterable");
        EnumMultiset enumMultiset = new EnumMultiset(((Enum)iterator2.next()).getDeclaringClass());
        Iterables.addAll(enumMultiset, iterable);
        return enumMultiset;
    }

    public static <E extends Enum<E>> EnumMultiset<E> create(Iterable<E> iterable, Class<E> clazz) {
        EnumMultiset<E> enumMultiset = EnumMultiset.create(clazz);
        Iterables.addAll(enumMultiset, iterable);
        return enumMultiset;
    }

    private EnumMultiset(Class<E> clazz) {
        this.type = clazz;
        Preconditions.checkArgument(clazz.isEnum());
        this.enumConstants = (Enum[])clazz.getEnumConstants();
        this.counts = new int[this.enumConstants.length];
    }

    private boolean isActuallyE(@CheckForNull Object object) {
        if (object instanceof Enum) {
            Enum enum_ = (Enum)object;
            int n = enum_.ordinal();
            return n < this.enumConstants.length && this.enumConstants[n] == enum_;
        }
        return false;
    }

    private void checkIsE(Object object) {
        Preconditions.checkNotNull(object);
        if (!this.isActuallyE(object)) {
            throw new ClassCastException("Expected an " + this.type + " but got " + object);
        }
    }

    @Override
    int distinctElements() {
        return this.distinctElements;
    }

    @Override
    public int size() {
        return Ints.saturatedCast(this.size);
    }

    @Override
    public int count(@CheckForNull Object object) {
        if (object == null || !this.isActuallyE(object)) {
            return 0;
        }
        Enum enum_ = (Enum)object;
        return this.counts[enum_.ordinal()];
    }

    @Override
    @CanIgnoreReturnValue
    public int add(E e, int n) {
        this.checkIsE(e);
        CollectPreconditions.checkNonnegative(n, "occurrences");
        if (n == 0) {
            return this.count(e);
        }
        int n2 = ((Enum)e).ordinal();
        int n3 = this.counts[n2];
        long l = (long)n3 + (long)n;
        Preconditions.checkArgument(l <= Integer.MAX_VALUE, "too many occurrences: %s", l);
        this.counts[n2] = (int)l;
        if (n3 == 0) {
            ++this.distinctElements;
        }
        this.size += (long)n;
        return n3;
    }

    @Override
    @CanIgnoreReturnValue
    public int remove(@CheckForNull Object object, int n) {
        if (object == null || !this.isActuallyE(object)) {
            return 0;
        }
        Enum enum_ = (Enum)object;
        CollectPreconditions.checkNonnegative(n, "occurrences");
        if (n == 0) {
            return this.count(object);
        }
        int n2 = enum_.ordinal();
        int n3 = this.counts[n2];
        if (n3 == 0) {
            return 0;
        }
        if (n3 <= n) {
            this.counts[n2] = 0;
            --this.distinctElements;
            this.size -= (long)n3;
        } else {
            this.counts[n2] = n3 - n;
            this.size -= (long)n;
        }
        return n3;
    }

    @Override
    @CanIgnoreReturnValue
    public int setCount(E e, int n) {
        this.checkIsE(e);
        CollectPreconditions.checkNonnegative(n, "count");
        int n2 = ((Enum)e).ordinal();
        int n3 = this.counts[n2];
        this.counts[n2] = n;
        this.size += (long)(n - n3);
        if (n3 == 0 && n > 0) {
            ++this.distinctElements;
        } else if (n3 > 0 && n == 0) {
            --this.distinctElements;
        }
        return n3;
    }

    @Override
    public void clear() {
        Arrays.fill(this.counts, 0);
        this.size = 0L;
        this.distinctElements = 0;
    }

    @Override
    Iterator<E> elementIterator() {
        return new Itr<E>(){

            @Override
            E output(int n) {
                return EnumMultiset.this.enumConstants[n];
            }
        };
    }

    @Override
    Iterator<Multiset.Entry<E>> entryIterator() {
        return new Itr<Multiset.Entry<E>>(){

            @Override
            Multiset.Entry<E> output(final int n) {
                return new Multisets.AbstractEntry<E>(){

                    @Override
                    public E getElement() {
                        return EnumMultiset.this.enumConstants[n];
                    }

                    @Override
                    public int getCount() {
                        return EnumMultiset.this.counts[n];
                    }
                };
            }
        };
    }

    @Override
    public void forEachEntry(ObjIntConsumer<? super E> objIntConsumer) {
        Preconditions.checkNotNull(objIntConsumer);
        for (int i = 0; i < this.enumConstants.length; ++i) {
            if (this.counts[i] <= 0) continue;
            objIntConsumer.accept(this.enumConstants[i], this.counts[i]);
        }
    }

    @Override
    public Iterator<E> iterator() {
        return Multisets.iteratorImpl(this);
    }

    @GwtIncompatible
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.type);
        Serialization.writeMultiset(this, objectOutputStream);
    }

    @GwtIncompatible
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Class clazz;
        objectInputStream.defaultReadObject();
        this.type = clazz = (Class)Objects.requireNonNull(objectInputStream.readObject());
        this.enumConstants = (Enum[])this.type.getEnumConstants();
        this.counts = new int[this.enumConstants.length];
        Serialization.populateMultiset(this, objectInputStream);
    }

    abstract class Itr<T>
    implements Iterator<T> {
        int index = 0;
        int toRemove = -1;

        Itr() {
        }

        abstract T output(int var1);

        @Override
        public boolean hasNext() {
            while (this.index < EnumMultiset.this.enumConstants.length) {
                if (EnumMultiset.this.counts[this.index] > 0) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T t2 = this.output(this.index);
            this.toRemove = this.index++;
            return t2;
        }

        @Override
        public void remove() {
            CollectPreconditions.checkRemove(this.toRemove >= 0);
            if (EnumMultiset.this.counts[this.toRemove] > 0) {
                EnumMultiset.this.distinctElements--;
                EnumMultiset.this.size -= EnumMultiset.this.counts[this.toRemove];
                ((EnumMultiset)EnumMultiset.this).counts[this.toRemove] = 0;
            }
            this.toRemove = -1;
        }
    }
}

