/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.LexicographicalOrdering;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.TopKSelector;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collector;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Comparators {
    private Comparators() {
    }

    public static <T, S extends T> Comparator<Iterable<S>> lexicographical(Comparator<T> comparator) {
        return new LexicographicalOrdering<T>(Preconditions.checkNotNull(comparator));
    }

    public static <T> boolean isInOrder(Iterable<? extends T> iterable, Comparator<T> comparator) {
        Preconditions.checkNotNull(comparator);
        Iterator<T> iterator2 = iterable.iterator();
        if (iterator2.hasNext()) {
            T t2 = iterator2.next();
            while (iterator2.hasNext()) {
                T t3 = iterator2.next();
                if (comparator.compare(t2, t3) > 0) {
                    return false;
                }
                t2 = t3;
            }
        }
        return true;
    }

    public static <T> boolean isInStrictOrder(Iterable<? extends T> iterable, Comparator<T> comparator) {
        Preconditions.checkNotNull(comparator);
        Iterator<T> iterator2 = iterable.iterator();
        if (iterator2.hasNext()) {
            T t2 = iterator2.next();
            while (iterator2.hasNext()) {
                T t3 = iterator2.next();
                if (comparator.compare(t2, t3) >= 0) {
                    return false;
                }
                t2 = t3;
            }
        }
        return true;
    }

    public static <T> Collector<T, ?, List<T>> least(int n, Comparator<? super T> comparator) {
        CollectPreconditions.checkNonnegative(n, "k");
        Preconditions.checkNotNull(comparator);
        return Collector.of(() -> TopKSelector.least(n, comparator), TopKSelector::offer, TopKSelector::combine, TopKSelector::topK, Collector.Characteristics.UNORDERED);
    }

    public static <T> Collector<T, ?, List<T>> greatest(int n, Comparator<? super T> comparator) {
        return Comparators.least(n, comparator.reversed());
    }

    public static <T> Comparator<Optional<T>> emptiesFirst(Comparator<? super T> comparator) {
        Preconditions.checkNotNull(comparator);
        return Comparator.comparing(optional -> optional.orElse(null), Comparator.nullsFirst(comparator));
    }

    public static <T> Comparator<Optional<T>> emptiesLast(Comparator<? super T> comparator) {
        Preconditions.checkNotNull(comparator);
        return Comparator.comparing(optional -> optional.orElse(null), Comparator.nullsLast(comparator));
    }

    public static <T extends Comparable<? super T>> T min(T t2, T t3) {
        return t2.compareTo(t3) <= 0 ? t2 : t3;
    }

    @ParametricNullness
    public static <T> T min(@ParametricNullness T t2, @ParametricNullness T t3, Comparator<? super T> comparator) {
        return comparator.compare(t2, t3) <= 0 ? t2 : t3;
    }

    public static <T extends Comparable<? super T>> T max(T t2, T t3) {
        return t2.compareTo(t3) >= 0 ? t2 : t3;
    }

    @ParametricNullness
    public static <T> T max(@ParametricNullness T t2, @ParametricNullness T t3, Comparator<? super T> comparator) {
        return comparator.compare(t2, t3) >= 0 ? t2 : t3;
    }
}

