/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.ParametricNullness;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
abstract class AbstractNavigableMap<K, V>
extends Maps.IteratorBasedAbstractMap<K, V>
implements NavigableMap<K, V> {
    AbstractNavigableMap() {
    }

    @Override
    @CheckForNull
    public abstract V get(@CheckForNull Object var1);

    @Override
    @CheckForNull
    public Map.Entry<K, V> firstEntry() {
        return Iterators.getNext(this.entryIterator(), null);
    }

    @Override
    @CheckForNull
    public Map.Entry<K, V> lastEntry() {
        return Iterators.getNext(this.descendingEntryIterator(), null);
    }

    @Override
    @CheckForNull
    public Map.Entry<K, V> pollFirstEntry() {
        return Iterators.pollNext(this.entryIterator());
    }

    @Override
    @CheckForNull
    public Map.Entry<K, V> pollLastEntry() {
        return Iterators.pollNext(this.descendingEntryIterator());
    }

    @Override
    @ParametricNullness
    public K firstKey() {
        Map.Entry<K, V> entry = this.firstEntry();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return entry.getKey();
    }

    @Override
    @ParametricNullness
    public K lastKey() {
        Map.Entry<K, V> entry = this.lastEntry();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return entry.getKey();
    }

    @Override
    @CheckForNull
    public Map.Entry<K, V> lowerEntry(@ParametricNullness K k) {
        return this.headMap(k, false).lastEntry();
    }

    @Override
    @CheckForNull
    public Map.Entry<K, V> floorEntry(@ParametricNullness K k) {
        return this.headMap(k, true).lastEntry();
    }

    @Override
    @CheckForNull
    public Map.Entry<K, V> ceilingEntry(@ParametricNullness K k) {
        return this.tailMap(k, true).firstEntry();
    }

    @Override
    @CheckForNull
    public Map.Entry<K, V> higherEntry(@ParametricNullness K k) {
        return this.tailMap(k, false).firstEntry();
    }

    @Override
    @CheckForNull
    public K lowerKey(@ParametricNullness K k) {
        return Maps.keyOrNull(this.lowerEntry(k));
    }

    @Override
    @CheckForNull
    public K floorKey(@ParametricNullness K k) {
        return Maps.keyOrNull(this.floorEntry(k));
    }

    @Override
    @CheckForNull
    public K ceilingKey(@ParametricNullness K k) {
        return Maps.keyOrNull(this.ceilingEntry(k));
    }

    @Override
    @CheckForNull
    public K higherKey(@ParametricNullness K k) {
        return Maps.keyOrNull(this.higherEntry(k));
    }

    abstract Iterator<Map.Entry<K, V>> descendingEntryIterator();

    @Override
    public SortedMap<K, V> subMap(@ParametricNullness K k, @ParametricNullness K k2) {
        return this.subMap(k, true, k2, false);
    }

    @Override
    public SortedMap<K, V> headMap(@ParametricNullness K k) {
        return this.headMap(k, false);
    }

    @Override
    public SortedMap<K, V> tailMap(@ParametricNullness K k) {
        return this.tailMap(k, true);
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return new Maps.NavigableKeySet(this);
    }

    @Override
    public Set<K> keySet() {
        return this.navigableKeySet();
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        return new DescendingMap();
    }

    private final class DescendingMap
    extends Maps.DescendingMap<K, V> {
        private DescendingMap() {
        }

        @Override
        NavigableMap<K, V> forward() {
            return AbstractNavigableMap.this;
        }

        @Override
        Iterator<Map.Entry<K, V>> entryIterator() {
            return AbstractNavigableMap.this.descendingEntryIterator();
        }
    }
}

