/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.cbor;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.format.InputAccessor;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import com.fasterxml.jackson.dataformat.cbor.CBORConstants;
import com.fasterxml.jackson.dataformat.cbor.CBORParser;
import java.io.IOException;
import java.io.InputStream;

public class CBORParserBootstrapper {
    protected final IOContext _context;
    protected final InputStream _in;
    protected final byte[] _inputBuffer;
    protected int _inputPtr;
    protected int _inputEnd;
    protected final boolean _bufferRecyclable;
    protected int _inputProcessed;

    public CBORParserBootstrapper(IOContext iOContext, InputStream inputStream2) {
        this._context = iOContext;
        this._in = inputStream2;
        this._inputBuffer = iOContext.allocReadIOBuffer();
        this._inputPtr = 0;
        this._inputEnd = 0;
        this._inputProcessed = 0;
        this._bufferRecyclable = true;
    }

    public CBORParserBootstrapper(IOContext iOContext, byte[] byArray, int n, int n2) {
        this._context = iOContext;
        this._in = null;
        this._inputBuffer = byArray;
        this._inputPtr = n;
        this._inputEnd = n + n2;
        this._inputProcessed = -n;
        this._bufferRecyclable = false;
    }

    public CBORParser constructParser(int n, int n2, int n3, ObjectCodec objectCodec, ByteQuadsCanonicalizer byteQuadsCanonicalizer) throws IOException, JsonParseException {
        ByteQuadsCanonicalizer byteQuadsCanonicalizer2 = byteQuadsCanonicalizer.makeChild(n);
        this.ensureLoaded(1);
        CBORParser cBORParser = new CBORParser(this._context, n2, n3, objectCodec, byteQuadsCanonicalizer2, this._in, this._inputBuffer, this._inputPtr, this._inputEnd, this._bufferRecyclable);
        if (this._inputPtr < this._inputEnd) {
            // empty if block
        }
        return cBORParser;
    }

    public static MatchStrength hasCBORFormat(InputAccessor inputAccessor) throws IOException {
        if (!inputAccessor.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        byte by = inputAccessor.nextByte();
        if (by == -65) {
            if (inputAccessor.hasMoreBytes()) {
                by = inputAccessor.nextByte();
                if (by == -1) {
                    return MatchStrength.SOLID_MATCH;
                }
                if (CBORConstants.hasMajorType(3, by)) {
                    return MatchStrength.SOLID_MATCH;
                }
                return MatchStrength.INCONCLUSIVE;
            }
        } else if (by == -97) {
            if (inputAccessor.hasMoreBytes()) {
                by = inputAccessor.nextByte();
                if (by == -1) {
                    return MatchStrength.SOLID_MATCH;
                }
                return MatchStrength.WEAK_MATCH;
            }
        } else {
            if (CBORConstants.hasMajorType(6, by)) {
                if (by == -39 && inputAccessor.hasMoreBytes() && (by = inputAccessor.nextByte()) == -39 && inputAccessor.hasMoreBytes() && (by = inputAccessor.nextByte()) == -9) {
                    return MatchStrength.FULL_MATCH;
                }
                return MatchStrength.WEAK_MATCH;
            }
            if (CBORConstants.hasMajorType(7, by)) {
                if (by == -12 || by == -11 || by == -10) {
                    return MatchStrength.SOLID_MATCH;
                }
                return MatchStrength.NO_MATCH;
            }
        }
        return MatchStrength.INCONCLUSIVE;
    }

    protected boolean ensureLoaded(int n) throws IOException {
        int n2;
        if (this._in == null) {
            return false;
        }
        for (int i = this._inputEnd - this._inputPtr; i < n; i += n2) {
            n2 = this._in.read(this._inputBuffer, this._inputEnd, this._inputBuffer.length - this._inputEnd);
            if (n2 < 1) {
                return false;
            }
            this._inputEnd += n2;
        }
        return true;
    }
}

