/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.cbor;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.core.json.DupDetector;
import com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.fasterxml.jackson.core.util.TextBuffer;
import com.fasterxml.jackson.dataformat.cbor.CBORConstants;
import com.fasterxml.jackson.dataformat.cbor.CBORReadContext;
import com.fasterxml.jackson.dataformat.cbor.PackageVersion;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Arrays;

public class CBORParser
extends ParserMinimalBase {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final int[] UTF8_UNIT_CODES = CBORConstants.sUtf8UnitLengths;
    private static final double MATH_POW_2_10 = Math.pow(2.0, 10.0);
    private static final double MATH_POW_2_NEG14 = Math.pow(2.0, -14.0);
    protected static final int LONGEST_NON_CHUNKED_BINARY = 250000;
    protected ObjectCodec _objectCodec;
    protected final IOContext _ioContext;
    protected boolean _closed;
    protected int _inputPtr = 0;
    protected int _inputEnd = 0;
    protected long _currInputProcessed = 0L;
    protected int _currInputRow = 1;
    protected int _currInputRowStart = 0;
    protected long _tokenInputTotal = 0L;
    protected int _tokenInputRow = 1;
    protected int _tokenInputCol = 0;
    protected CBORReadContext _parsingContext;
    protected final TextBuffer _textBuffer;
    protected char[] _nameCopyBuffer = null;
    protected boolean _nameCopied = false;
    protected ByteArrayBuilder _byteArrayBuilder = null;
    protected byte[] _binaryValue;
    private int _chunkLeft;
    private int _chunkEnd;
    protected int _tagValue = -1;
    protected boolean _tokenIncomplete = false;
    protected int _typeByte;
    protected InputStream _inputStream;
    protected byte[] _inputBuffer;
    protected boolean _bufferRecyclable;
    protected final ByteQuadsCanonicalizer _symbols;
    protected int[] _quadBuffer = NO_INTS;
    protected int _quad1;
    protected int _quad2;
    protected int _quad3;
    static final BigInteger BI_MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);
    static final BigInteger BI_MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    static final BigInteger BI_MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    static final BigInteger BI_MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    static final BigDecimal BD_MIN_LONG = new BigDecimal(BI_MIN_LONG);
    static final BigDecimal BD_MAX_LONG = new BigDecimal(BI_MAX_LONG);
    static final BigDecimal BD_MIN_INT = new BigDecimal(BI_MIN_INT);
    static final BigDecimal BD_MAX_INT = new BigDecimal(BI_MAX_INT);
    protected int _numTypesValid = 0;
    protected int _numberInt;
    protected long _numberLong;
    protected float _numberFloat;
    protected double _numberDouble;
    protected BigInteger _numberBigInt;
    protected BigDecimal _numberBigDecimal;
    private static final BigInteger BIT_63 = BigInteger.ONE.shiftLeft(63);

    public CBORParser(IOContext iOContext, int n, int n2, ObjectCodec objectCodec, ByteQuadsCanonicalizer byteQuadsCanonicalizer, InputStream inputStream2, byte[] byArray, int n3, int n4, boolean bl) {
        super(n);
        this._ioContext = iOContext;
        this._objectCodec = objectCodec;
        this._symbols = byteQuadsCanonicalizer;
        this._inputStream = inputStream2;
        this._inputBuffer = byArray;
        this._inputPtr = n3;
        this._inputEnd = n4;
        this._bufferRecyclable = bl;
        this._textBuffer = iOContext.constructTextBuffer();
        DupDetector dupDetector = JsonParser.Feature.STRICT_DUPLICATE_DETECTION.enabledIn(n) ? DupDetector.rootDetector(this) : null;
        this._parsingContext = CBORReadContext.createRootContext(dupDetector);
        this._tokenInputRow = -1;
        this._tokenInputCol = -1;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public int getFormatFeatures() {
        return 0;
    }

    @Override
    public JacksonFeatureSet<StreamReadCapability> getReadCapabilities() {
        return DEFAULT_READ_CAPABILITIES;
    }

    public int getCurrentTag() {
        return this._tagValue;
    }

    @Override
    public int releaseBuffered(OutputStream outputStream2) throws IOException {
        int n = this._inputEnd - this._inputPtr;
        if (n < 1) {
            return 0;
        }
        int n2 = this._inputPtr;
        outputStream2.write(this._inputBuffer, n2, n);
        return n;
    }

    @Override
    public Object getInputSource() {
        return this._inputStream;
    }

    @Override
    public JsonLocation getTokenLocation() {
        return new JsonLocation(this._ioContext.getSourceReference(), this._tokenInputTotal, -1L, -1, (int)this._tokenInputTotal);
    }

    @Override
    public JsonLocation getCurrentLocation() {
        long l = this._currInputProcessed + (long)this._inputPtr;
        return new JsonLocation(this._ioContext.getSourceReference(), l, -1L, -1, (int)l);
    }

    @Override
    public String getCurrentName() throws IOException {
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            CBORReadContext cBORReadContext = this._parsingContext.getParent();
            return cBORReadContext.getCurrentName();
        }
        return this._parsingContext.getCurrentName();
    }

    @Override
    public void overrideCurrentName(String string) {
        CBORReadContext cBORReadContext = this._parsingContext;
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            cBORReadContext = cBORReadContext.getParent();
        }
        try {
            cBORReadContext.setCurrentName(string);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
            this._symbols.release();
            try {
                this._closeInput();
            }
            finally {
                this._releaseBuffers();
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public CBORReadContext getParsingContext() {
        return this._parsingContext;
    }

    @Override
    public boolean hasTextCharacters() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.hasTextAsCharacters();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nameCopied;
        }
        return false;
    }

    protected void _releaseBuffers() throws IOException {
        Object[] objectArray;
        if (this._bufferRecyclable && (objectArray = this._inputBuffer) != null) {
            this._inputBuffer = null;
            this._ioContext.releaseReadIOBuffer((byte[])objectArray);
        }
        this._textBuffer.releaseBuffers();
        objectArray = this._nameCopyBuffer;
        if (objectArray != null) {
            this._nameCopyBuffer = null;
            this._ioContext.releaseNameCopyBuffer((char[])objectArray);
        }
    }

    @Override
    public JsonToken nextToken() throws IOException {
        this._numTypesValid = 0;
        if (this._tokenIncomplete) {
            this._skipIncomplete();
        }
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr;
        this._binaryValue = null;
        if (this._parsingContext.inObject()) {
            if (this._currToken != JsonToken.FIELD_NAME) {
                this._tagValue = -1;
                if (!this._parsingContext.expectMoreValues()) {
                    this._parsingContext = this._parsingContext.getParent();
                    this._currToken = JsonToken.END_OBJECT;
                    return this._currToken;
                }
                this._currToken = this._decodeFieldName();
                return this._currToken;
            }
        } else if (!this._parsingContext.expectMoreValues()) {
            this._tagValue = -1;
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_ARRAY;
            return this._currToken;
        }
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            return this._handleCBOREOF();
        }
        int n = this._inputBuffer[this._inputPtr++] & 0xFF;
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        if (n2 == 6) {
            this._tagValue = this._decodeTag(n3);
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                return this._handleCBOREOF();
            }
            n = this._inputBuffer[this._inputPtr++] & 0xFF;
            n2 = n >> 5;
            n3 = n & 0x1F;
        } else {
            this._tagValue = -1;
        }
        switch (n2) {
            case 0: {
                this._numTypesValid = 1;
                if (n3 <= 23) {
                    this._numberInt = n3;
                } else {
                    switch (n3 - 24) {
                        case 0: {
                            this._numberInt = this._decode8Bits();
                            break;
                        }
                        case 1: {
                            this._numberInt = this._decode16Bits();
                            break;
                        }
                        case 2: {
                            int n4 = this._decode32Bits();
                            if (n4 >= 0) {
                                this._numberInt = n4;
                                break;
                            }
                            long l = n4;
                            this._numberLong = l & 0xFFFFFFFFL;
                            this._numTypesValid = 2;
                            break;
                        }
                        case 3: {
                            long l = this._decode64Bits();
                            if (l >= 0L) {
                                this._numberLong = l;
                                this._numTypesValid = 2;
                                break;
                            }
                            this._numberBigInt = this._bigPositive(l);
                            this._numTypesValid = 4;
                            break;
                        }
                        default: {
                            this._invalidToken(n);
                        }
                    }
                }
                this._currToken = JsonToken.VALUE_NUMBER_INT;
                return this._currToken;
            }
            case 1: {
                this._numTypesValid = 1;
                if (n3 <= 23) {
                    this._numberInt = -n3 - 1;
                } else {
                    switch (n3 - 24) {
                        case 0: {
                            this._numberInt = -this._decode8Bits() - 1;
                            break;
                        }
                        case 1: {
                            this._numberInt = -this._decode16Bits() - 1;
                            break;
                        }
                        case 2: {
                            int n5 = this._decode32Bits();
                            if (n5 < 0) {
                                long l = (long)n5 & 0xFFFFFFFFL;
                                this._numberLong = -l - 1L;
                                this._numTypesValid = 2;
                                break;
                            }
                            this._numberInt = -n5 - 1;
                            break;
                        }
                        case 3: {
                            long l = this._decode64Bits();
                            if (l >= 0L) {
                                this._numberLong = -l - 1L;
                                this._numTypesValid = 2;
                                break;
                            }
                            this._numberBigInt = this._bigNegative(l);
                            this._numTypesValid = 4;
                            break;
                        }
                        default: {
                            this._invalidToken(n);
                        }
                    }
                }
                this._currToken = JsonToken.VALUE_NUMBER_INT;
                return this._currToken;
            }
            case 2: {
                this._typeByte = n;
                this._tokenIncomplete = true;
                if (this._tagValue >= 0) {
                    return this._handleTaggedBinary(this._tagValue);
                }
                this._currToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                return this._currToken;
            }
            case 3: {
                this._typeByte = n;
                this._tokenIncomplete = true;
                this._currToken = JsonToken.VALUE_STRING;
                return this._currToken;
            }
            case 4: {
                int n6 = this._decodeExplicitLength(n3);
                if (this._tagValue >= 0) {
                    return this._handleTaggedArray(this._tagValue, n6);
                }
                this._parsingContext = this._parsingContext.createChildArrayContext(n6);
                this._currToken = JsonToken.START_ARRAY;
                return this._currToken;
            }
            case 5: {
                this._currToken = JsonToken.START_OBJECT;
                int n7 = this._decodeExplicitLength(n3);
                this._parsingContext = this._parsingContext.createChildObjectContext(n7);
                return this._currToken;
            }
            case 6: {
                this._reportError("Multiple tags not allowed per value (first tag: " + this._tagValue + ")");
            }
        }
        switch (n3) {
            case 20: {
                this._currToken = JsonToken.VALUE_FALSE;
                return this._currToken;
            }
            case 21: {
                this._currToken = JsonToken.VALUE_TRUE;
                return this._currToken;
            }
            case 22: {
                this._currToken = JsonToken.VALUE_NULL;
                return this._currToken;
            }
            case 23: {
                this._currToken = this._decodeUndefinedValue();
                return this._currToken;
            }
            case 25: {
                this._numberFloat = this._decodeHalfSizeFloat();
                this._numTypesValid = 32;
                this._currToken = JsonToken.VALUE_NUMBER_FLOAT;
                return this._currToken;
            }
            case 26: {
                this._numberFloat = Float.intBitsToFloat(this._decode32Bits());
                this._numTypesValid = 32;
                this._currToken = JsonToken.VALUE_NUMBER_FLOAT;
                return this._currToken;
            }
            case 27: {
                this._numberDouble = Double.longBitsToDouble(this._decode64Bits());
                this._numTypesValid = 8;
                this._currToken = JsonToken.VALUE_NUMBER_FLOAT;
                return this._currToken;
            }
            case 31: {
                if (this._parsingContext.inArray() && !this._parsingContext.hasExpectedLength()) {
                    this._parsingContext = this._parsingContext.getParent();
                    this._currToken = JsonToken.END_ARRAY;
                    return this._currToken;
                }
                this._reportUnexpectedBreak();
            }
        }
        this._currToken = this._decodeSimpleValue(n3, n);
        return this._currToken;
    }

    protected String _numberToName(int n, boolean bl) throws IOException {
        int n2;
        int n3 = n & 0x1F;
        if (n3 <= 23) {
            n2 = n3;
        } else {
            switch (n3) {
                case 24: {
                    n2 = this._decode8Bits();
                    break;
                }
                case 25: {
                    n2 = this._decode16Bits();
                    break;
                }
                case 26: {
                    long l;
                    n2 = this._decode32Bits();
                    if (n2 >= 0) break;
                    if (bl) {
                        long l2 = (long)n2 & 0xFFFFFFFFL;
                        l = -l2 - 1L;
                    } else {
                        l = n2;
                        l &= 0xFFFFFFFFL;
                    }
                    return String.valueOf(l);
                }
                case 27: {
                    long l = this._decode64Bits();
                    if (bl) {
                        l = -l - 1L;
                    }
                    return String.valueOf(l);
                }
                default: {
                    throw this._constructError("Invalid length indicator for ints (" + n3 + "), token 0x" + Integer.toHexString(n));
                }
            }
        }
        if (bl) {
            n2 = -n2 - 1;
        }
        return String.valueOf(n2);
    }

    protected JsonToken _handleTaggedBinary(int n) throws IOException {
        boolean bl;
        if (n == 2) {
            bl = false;
        } else if (n == 3) {
            bl = true;
        } else {
            this._currToken = JsonToken.VALUE_EMBEDDED_OBJECT;
            return this._currToken;
        }
        this._finishToken();
        if (this._binaryValue.length == 0) {
            this._numberBigInt = BigInteger.ZERO;
        } else {
            BigInteger bigInteger = new BigInteger(this._binaryValue);
            if (bl) {
                bigInteger = bigInteger.negate();
            }
            this._numberBigInt = bigInteger;
        }
        this._numTypesValid = 4;
        this._tagValue = -1;
        this._currToken = JsonToken.VALUE_NUMBER_INT;
        return this._currToken;
    }

    protected JsonToken _handleTaggedArray(int n, int n2) throws IOException {
        JsonParser.NumberType numberType;
        this._parsingContext = this._parsingContext.createChildArrayContext(n2);
        if (n != 4) {
            this._currToken = JsonToken.START_ARRAY;
            return this._currToken;
        }
        this._currToken = JsonToken.START_ARRAY;
        if (n2 != 2) {
            this._reportError("Unexpected array size (" + n2 + ") for tagged 'bigfloat' value; should have exactly 2 number elements");
        }
        if (!this._checkNextIsIntInArray("bigfloat")) {
            this._reportError("Unexpected token (" + (Object)((Object)this.currentToken()) + ") as the first part of 'bigfloat' value: should get VALUE_NUMBER_INT");
        }
        int n3 = -this.getIntValue();
        if (!this._checkNextIsIntInArray("bigfloat")) {
            this._reportError("Unexpected token (" + (Object)((Object)this.currentToken()) + ") as the second part of 'bigfloat' value: should get VALUE_NUMBER_INT");
        }
        BigDecimal bigDecimal = (numberType = this.getNumberType()) == JsonParser.NumberType.BIG_INTEGER ? new BigDecimal(this.getBigIntegerValue(), n3) : BigDecimal.valueOf(this.getLongValue(), n3);
        if (!this._checkNextIsEndArray()) {
            this._reportError("Unexpected token (" + (Object)((Object)this.currentToken()) + ") after 2 elements of 'bigfloat' value");
        }
        this._numberBigDecimal = bigDecimal;
        this._numTypesValid = 16;
        this._currToken = JsonToken.VALUE_NUMBER_FLOAT;
        return this._currToken;
    }

    protected final boolean _checkNextIsIntInArray(String string) throws IOException {
        if (!this._parsingContext.expectMoreValues()) {
            this._tagValue = -1;
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_ARRAY;
            return false;
        }
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._handleCBOREOF();
            return false;
        }
        int n = this._inputBuffer[this._inputPtr++] & 0xFF;
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        int n4 = -1;
        if (n2 == 6) {
            n4 = this._decodeTag(n3);
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._handleCBOREOF();
                return false;
            }
            n = this._inputBuffer[this._inputPtr++] & 0xFF;
            n2 = n >> 5;
            n3 = n & 0x1F;
        }
        switch (n2) {
            case 0: {
                this._numTypesValid = 1;
                if (n3 <= 23) {
                    this._numberInt = n3;
                } else {
                    switch (n3 - 24) {
                        case 0: {
                            this._numberInt = this._decode8Bits();
                            break;
                        }
                        case 1: {
                            this._numberInt = this._decode16Bits();
                            break;
                        }
                        case 2: {
                            int n5 = this._decode32Bits();
                            if (n5 >= 0) {
                                this._numberInt = n5;
                                break;
                            }
                            long l = n5;
                            this._numberLong = l & 0xFFFFFFFFL;
                            this._numTypesValid = 2;
                            break;
                        }
                        case 3: {
                            long l = this._decode64Bits();
                            if (l >= 0L) {
                                this._numberLong = l;
                                this._numTypesValid = 2;
                                break;
                            }
                            this._numberBigInt = this._bigPositive(l);
                            this._numTypesValid = 4;
                            break;
                        }
                        default: {
                            this._invalidToken(n);
                        }
                    }
                }
                this._currToken = JsonToken.VALUE_NUMBER_INT;
                return true;
            }
            case 1: {
                this._numTypesValid = 1;
                if (n3 <= 23) {
                    this._numberInt = -n3 - 1;
                } else {
                    switch (n3 - 24) {
                        case 0: {
                            this._numberInt = -this._decode8Bits() - 1;
                            break;
                        }
                        case 1: {
                            this._numberInt = -this._decode16Bits() - 1;
                            break;
                        }
                        case 2: {
                            int n6 = this._decode32Bits();
                            if (n6 < 0) {
                                long l = (long)n6 & 0xFFFFFFFFL;
                                this._numberLong = -l - 1L;
                                this._numTypesValid = 2;
                                break;
                            }
                            this._numberInt = -n6 - 1;
                            break;
                        }
                        case 3: {
                            long l = this._decode64Bits();
                            if (l >= 0L) {
                                this._numberLong = -l - 1L;
                                this._numTypesValid = 2;
                                break;
                            }
                            this._numberBigInt = this._bigNegative(l);
                            this._numTypesValid = 4;
                            break;
                        }
                        default: {
                            this._invalidToken(n);
                        }
                    }
                }
                this._currToken = JsonToken.VALUE_NUMBER_INT;
                return true;
            }
            case 2: {
                if (n4 < 0) break;
                this._typeByte = n;
                this._tokenIncomplete = true;
                this._currToken = this._handleTaggedBinary(n4);
                return this._currToken == JsonToken.VALUE_NUMBER_INT;
            }
            case 6: {
                this._reportError("Multiple tags not allowed per value (first tag: " + n4 + ")");
            }
        }
        --this._inputPtr;
        this.nextToken();
        return false;
    }

    protected final boolean _checkNextIsEndArray() throws IOException {
        if (!this._parsingContext.expectMoreValues()) {
            this._tagValue = -1;
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_ARRAY;
            return true;
        }
        byte by = this._inputBuffer[this._inputPtr++];
        int n = by >> 5 & 7;
        int n2 = -1;
        if (n == 6) {
            n2 = this._decodeTag(by & 0x1F);
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._handleCBOREOF();
                return false;
            }
            if ((n = (by = this._inputBuffer[this._inputPtr++]) >> 5 & 7) == 6) {
                this._reportError("Multiple tags not allowed per value (first tag: " + n2 + ")");
            }
        }
        --this._inputPtr;
        return this.nextToken() == JsonToken.END_ARRAY;
    }

    @Override
    public void finishToken() throws IOException {
        if (this._tokenIncomplete) {
            this._finishToken();
        }
    }

    @Override
    public boolean nextFieldName(SerializableString serializableString) throws IOException {
        if (this._parsingContext.inObject() && this._currToken != JsonToken.FIELD_NAME) {
            int n;
            byte by;
            this._numTypesValid = 0;
            if (this._tokenIncomplete) {
                this._skipIncomplete();
            }
            this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr;
            this._binaryValue = null;
            this._tagValue = -1;
            if (!this._parsingContext.expectMoreValues()) {
                this._parsingContext = this._parsingContext.getParent();
                this._currToken = JsonToken.END_OBJECT;
                return false;
            }
            int n2 = this._inputPtr;
            byte[] byArray = serializableString.asQuotedUTF8();
            int n3 = byArray.length;
            if (n2 + n3 + 1 < this._inputEnd && ((by = this._inputBuffer[n2++]) >> 5 & 7) == 3 && (n = by & 0x1F) <= 24) {
                if (n == 23) {
                    n = this._inputBuffer[n2++] & 0xFF;
                }
                if (n == n3) {
                    int n4 = 0;
                    while (true) {
                        if (n4 == n) {
                            this._inputPtr = n2 + n4;
                            this._parsingContext.setCurrentName(serializableString.getValue());
                            this._currToken = JsonToken.FIELD_NAME;
                            return true;
                        }
                        if (byArray[n4] != this._inputBuffer[n2 + n4]) break;
                        ++n4;
                    }
                }
            }
        }
        return this.nextToken() == JsonToken.FIELD_NAME && serializableString.getValue().equals(this.getCurrentName());
    }

    @Override
    public String nextFieldName() throws IOException {
        if (this._parsingContext.inObject() && this._currToken != JsonToken.FIELD_NAME) {
            String string;
            byte by;
            int n;
            this._numTypesValid = 0;
            if (this._tokenIncomplete) {
                this._skipIncomplete();
            }
            this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr;
            this._binaryValue = null;
            this._tagValue = -1;
            if (!this._parsingContext.expectMoreValues()) {
                this._parsingContext = this._parsingContext.getParent();
                this._currToken = JsonToken.END_OBJECT;
                return null;
            }
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n = (by = this._inputBuffer[this._inputPtr++]) >> 5 & 7) != 3) {
                if (by == -1) {
                    if (!this._parsingContext.hasExpectedLength()) {
                        this._parsingContext = this._parsingContext.getParent();
                        this._currToken = JsonToken.END_OBJECT;
                        return null;
                    }
                    this._reportUnexpectedBreak();
                }
                this._decodeNonStringName(by);
                this._currToken = JsonToken.FIELD_NAME;
                return this.getText();
            }
            int n2 = by & 0x1F;
            if (n2 <= 23) {
                if (n2 == 0) {
                    string = "";
                } else {
                    string = this._findDecodedFromSymbols(n2);
                    if (string != null) {
                        this._inputPtr += n2;
                    } else {
                        string = this._decodeShortName(n2);
                        string = this._addDecodedToSymbols(n2, string);
                    }
                }
            } else {
                int n3 = this._decodeExplicitLength(n2);
                string = n3 < 0 ? this._decodeChunkedName() : this._decodeLongerName(n3);
            }
            this._parsingContext.setCurrentName(string);
            this._currToken = JsonToken.FIELD_NAME;
            return string;
        }
        return this.nextToken() == JsonToken.FIELD_NAME ? this.getCurrentName() : null;
    }

    @Override
    public String nextTextValue() throws IOException {
        this._numTypesValid = 0;
        if (this._tokenIncomplete) {
            this._skipIncomplete();
        }
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr;
        this._binaryValue = null;
        this._tagValue = -1;
        if (this._parsingContext.inObject()) {
            if (this._currToken != JsonToken.FIELD_NAME) {
                this._tagValue = -1;
                if (!this._parsingContext.expectMoreValues()) {
                    this._parsingContext = this._parsingContext.getParent();
                    this._currToken = JsonToken.END_OBJECT;
                    return null;
                }
                this._currToken = this._decodeFieldName();
                return null;
            }
        } else if (!this._parsingContext.expectMoreValues()) {
            this._tagValue = -1;
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_ARRAY;
            return null;
        }
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._handleCBOREOF();
            return null;
        }
        int n = this._inputBuffer[this._inputPtr++] & 0xFF;
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        if (n2 == 6) {
            this._tagValue = this._decodeTag(n3);
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._handleCBOREOF();
                return null;
            }
            n = this._inputBuffer[this._inputPtr++] & 0xFF;
            n2 = n >> 5;
            n3 = n & 0x1F;
        } else {
            this._tagValue = -1;
        }
        switch (n2) {
            case 0: {
                this._numTypesValid = 1;
                if (n3 <= 23) {
                    this._numberInt = n3;
                } else {
                    switch (n3 - 24) {
                        case 0: {
                            this._numberInt = this._decode8Bits();
                            break;
                        }
                        case 1: {
                            this._numberInt = this._decode16Bits();
                            break;
                        }
                        case 2: {
                            int n4 = this._decode32Bits();
                            if (n4 < 0) {
                                long l = n4;
                                this._numberLong = l & 0xFFFFFFFFL;
                                this._numTypesValid = 2;
                                break;
                            }
                            this._numberInt = n4;
                            break;
                        }
                        case 3: {
                            long l = this._decode64Bits();
                            if (l >= 0L) {
                                this._numberLong = l;
                                this._numTypesValid = 2;
                                break;
                            }
                            this._numberBigInt = this._bigPositive(l);
                            this._numTypesValid = 4;
                            break;
                        }
                        default: {
                            this._invalidToken(n);
                        }
                    }
                }
                this._currToken = JsonToken.VALUE_NUMBER_INT;
                return null;
            }
            case 1: {
                this._numTypesValid = 1;
                if (n3 <= 23) {
                    this._numberInt = -n3 - 1;
                } else {
                    switch (n3 - 24) {
                        case 0: {
                            this._numberInt = -this._decode8Bits() - 1;
                            break;
                        }
                        case 1: {
                            this._numberInt = -this._decode16Bits() - 1;
                            break;
                        }
                        case 2: {
                            int n5 = this._decode32Bits();
                            if (n5 < 0) {
                                long l = (long)n5 & 0xFFFFFFFFL;
                                this._numberLong = -l - 1L;
                                this._numTypesValid = 2;
                                break;
                            }
                            this._numberInt = -n5 - 1;
                            break;
                        }
                        case 3: {
                            long l = this._decode64Bits();
                            if (l >= 0L) {
                                this._numberLong = l;
                                this._numTypesValid = 2;
                                break;
                            }
                            this._numberBigInt = this._bigNegative(l);
                            this._numTypesValid = 4;
                            break;
                        }
                        default: {
                            this._invalidToken(n);
                        }
                    }
                }
                this._currToken = JsonToken.VALUE_NUMBER_INT;
                return null;
            }
            case 2: {
                this._typeByte = n;
                this._tokenIncomplete = true;
                this._currToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                return null;
            }
            case 3: {
                this._typeByte = n;
                this._tokenIncomplete = true;
                this._currToken = JsonToken.VALUE_STRING;
                return this._finishTextToken(n);
            }
            case 4: {
                this._currToken = JsonToken.START_ARRAY;
                int n6 = this._decodeExplicitLength(n3);
                this._parsingContext = this._parsingContext.createChildArrayContext(n6);
                return null;
            }
            case 5: {
                this._currToken = JsonToken.START_OBJECT;
                int n7 = this._decodeExplicitLength(n3);
                this._parsingContext = this._parsingContext.createChildObjectContext(n7);
                return null;
            }
            case 6: {
                this._reportError("Multiple tags not allowed per value (first tag: " + this._tagValue + ")");
            }
        }
        switch (n3) {
            case 20: {
                this._currToken = JsonToken.VALUE_FALSE;
                return null;
            }
            case 21: {
                this._currToken = JsonToken.VALUE_TRUE;
                return null;
            }
            case 22: {
                this._currToken = JsonToken.VALUE_NULL;
                return null;
            }
            case 23: {
                this._currToken = this._decodeUndefinedValue();
                return null;
            }
            case 25: {
                this._numberFloat = this._decodeHalfSizeFloat();
                this._numTypesValid = 32;
                this._currToken = JsonToken.VALUE_NUMBER_FLOAT;
                return null;
            }
            case 26: {
                this._numberFloat = Float.intBitsToFloat(this._decode32Bits());
                this._numTypesValid = 32;
                this._currToken = JsonToken.VALUE_NUMBER_FLOAT;
                return null;
            }
            case 27: {
                this._numberDouble = Double.longBitsToDouble(this._decode64Bits());
                this._numTypesValid = 8;
                this._currToken = JsonToken.VALUE_NUMBER_FLOAT;
                return null;
            }
            case 31: {
                if (this._parsingContext.inArray() && !this._parsingContext.hasExpectedLength()) {
                    this._parsingContext = this._parsingContext.getParent();
                    this._currToken = JsonToken.END_ARRAY;
                    return null;
                }
                this._reportUnexpectedBreak();
            }
        }
        this._currToken = this._decodeSimpleValue(n3, n);
        return null;
    }

    @Override
    public int nextIntValue(int n) throws IOException {
        if (this.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            return this.getIntValue();
        }
        return n;
    }

    @Override
    public long nextLongValue(long l) throws IOException {
        if (this.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            return this.getLongValue();
        }
        return l;
    }

    @Override
    public Boolean nextBooleanValue() throws IOException {
        JsonToken jsonToken = this.nextToken();
        if (jsonToken == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (jsonToken == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public String getText() throws IOException {
        JsonToken jsonToken = this._currToken;
        if (this._tokenIncomplete && jsonToken == JsonToken.VALUE_STRING) {
            return this._finishTextToken(this._typeByte);
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.contentsAsString();
        }
        if (jsonToken == null) {
            return null;
        }
        if (jsonToken == JsonToken.FIELD_NAME) {
            return this._parsingContext.getCurrentName();
        }
        if (jsonToken.isNumeric()) {
            return this.getNumberValue().toString();
        }
        return this._currToken.asString();
    }

    @Override
    public char[] getTextCharacters() throws IOException {
        if (this._currToken != null) {
            if (this._tokenIncomplete) {
                this._finishToken();
            }
            if (this._currToken == JsonToken.VALUE_STRING) {
                return this._textBuffer.getTextBuffer();
            }
            if (this._currToken == JsonToken.FIELD_NAME) {
                return this._parsingContext.getCurrentName().toCharArray();
            }
            if (this._currToken == JsonToken.VALUE_NUMBER_INT || this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
                return this.getNumberValue().toString().toCharArray();
            }
            return this._currToken.asCharArray();
        }
        return null;
    }

    @Override
    public int getTextLength() throws IOException {
        if (this._currToken != null) {
            if (this._tokenIncomplete) {
                this._finishToken();
            }
            if (this._currToken == JsonToken.VALUE_STRING) {
                return this._textBuffer.size();
            }
            if (this._currToken == JsonToken.FIELD_NAME) {
                return this._parsingContext.getCurrentName().length();
            }
            if (this._currToken == JsonToken.VALUE_NUMBER_INT || this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
                return this.getNumberValue().toString().length();
            }
            return this._currToken.asCharArray().length;
        }
        return 0;
    }

    @Override
    public int getTextOffset() throws IOException {
        return 0;
    }

    @Override
    public String getValueAsString() throws IOException {
        if (this._tokenIncomplete && this._currToken == JsonToken.VALUE_STRING) {
            return this._finishTextToken(this._typeByte);
        }
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == null || this._currToken == JsonToken.VALUE_NULL || !this._currToken.isScalarValue()) {
            return null;
        }
        return this.getText();
    }

    @Override
    public String getValueAsString(String string) throws IOException {
        if (!(this._currToken == JsonToken.VALUE_STRING || this._currToken != null && this._currToken != JsonToken.VALUE_NULL && this._currToken.isScalarValue())) {
            return string;
        }
        return this.getText();
    }

    @Override
    public int getText(Writer writer) throws IOException {
        JsonToken jsonToken;
        if (this._tokenIncomplete) {
            this._finishToken();
        }
        if ((jsonToken = this._currToken) == JsonToken.VALUE_STRING) {
            return this._textBuffer.contentsToWriter(writer);
        }
        if (jsonToken == JsonToken.FIELD_NAME) {
            String string = this._parsingContext.getCurrentName();
            writer.write(string);
            return string.length();
        }
        if (jsonToken != null) {
            if (jsonToken.isNumeric()) {
                return this._textBuffer.contentsToWriter(writer);
            }
            char[] cArray = jsonToken.asCharArray();
            writer.write(cArray);
            return cArray.length;
        }
        return 0;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException {
        if (this._tokenIncomplete) {
            this._finishToken();
        }
        if (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT) {
            this._reportError("Current token (" + (Object)((Object)this.currentToken()) + ") not VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        return this._binaryValue;
    }

    @Override
    public Object getEmbeddedObject() throws IOException {
        if (this._tokenIncomplete) {
            this._finishToken();
        }
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return this._binaryValue;
        }
        return null;
    }

    @Override
    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream2) throws IOException {
        if (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT) {
            this._reportError("Current token (" + (Object)((Object)this.currentToken()) + ") not VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (!this._tokenIncomplete) {
            if (this._binaryValue == null) {
                return 0;
            }
            int n = this._binaryValue.length;
            outputStream2.write(this._binaryValue, 0, n);
            return n;
        }
        this._tokenIncomplete = false;
        int n = this._decodeExplicitLength(this._typeByte & 0x1F);
        if (n >= 0) {
            return this._readAndWriteBytes(outputStream2, n);
        }
        int n2 = 0;
        while ((n = this._decodeChunkLength(2)) >= 0) {
            n2 += this._readAndWriteBytes(outputStream2, n);
        }
        return n2;
    }

    private int _readAndWriteBytes(OutputStream outputStream2, int n) throws IOException {
        int n2;
        for (int i = n; i > 0; i -= n2) {
            int n3 = this._inputEnd - this._inputPtr;
            if (this._inputPtr >= this._inputEnd) {
                if (!this.loadMore()) {
                    this._reportIncompleteBinaryRead(n, n - i);
                }
                n3 = this._inputEnd - this._inputPtr;
            }
            n2 = Math.min(n3, i);
            outputStream2.write(this._inputBuffer, this._inputPtr, n2);
            this._inputPtr += n2;
        }
        this._tokenIncomplete = false;
        return n;
    }

    @Override
    public boolean isNaN() {
        if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
            if ((this._numTypesValid & 8) != 0) {
                double d = this._numberDouble;
                return Double.isNaN(d) || Double.isInfinite(d);
            }
            if ((this._numTypesValid & 0x20) != 0) {
                float f = this._numberFloat;
                return Float.isNaN(f) || Float.isInfinite(f);
            }
        }
        return false;
    }

    @Override
    public Number getNumberValue() throws IOException {
        if (this._numTypesValid == 0) {
            this._checkNumericValue(0);
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            if ((this._numTypesValid & 1) != 0) {
                return this._numberInt;
            }
            if ((this._numTypesValid & 2) != 0) {
                return this._numberLong;
            }
            if ((this._numTypesValid & 4) != 0) {
                return this._numberBigInt;
            }
            return this._numberBigDecimal;
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return this._numberBigDecimal;
        }
        if ((this._numTypesValid & 8) != 0) {
            return this._numberDouble;
        }
        if ((this._numTypesValid & 0x20) == 0) {
            this._throwInternal();
        }
        return Float.valueOf(this._numberFloat);
    }

    @Override
    public final Number getNumberValueExact() throws IOException {
        return this.getNumberValue();
    }

    @Override
    public JsonParser.NumberType getNumberType() throws IOException {
        if (this._numTypesValid == 0) {
            this._checkNumericValue(0);
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            if ((this._numTypesValid & 1) != 0) {
                return JsonParser.NumberType.INT;
            }
            if ((this._numTypesValid & 2) != 0) {
                return JsonParser.NumberType.LONG;
            }
            return JsonParser.NumberType.BIG_INTEGER;
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return JsonParser.NumberType.BIG_DECIMAL;
        }
        if ((this._numTypesValid & 8) != 0) {
            return JsonParser.NumberType.DOUBLE;
        }
        return JsonParser.NumberType.FLOAT;
    }

    @Override
    public int getIntValue() throws IOException {
        if ((this._numTypesValid & 1) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(1);
            }
            if ((this._numTypesValid & 1) == 0) {
                this.convertNumberToInt();
            }
        }
        return this._numberInt;
    }

    @Override
    public long getLongValue() throws IOException {
        if ((this._numTypesValid & 2) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(2);
            }
            if ((this._numTypesValid & 2) == 0) {
                this.convertNumberToLong();
            }
        }
        return this._numberLong;
    }

    @Override
    public BigInteger getBigIntegerValue() throws IOException {
        if ((this._numTypesValid & 4) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(4);
            }
            if ((this._numTypesValid & 4) == 0) {
                this.convertNumberToBigInteger();
            }
        }
        return this._numberBigInt;
    }

    @Override
    public float getFloatValue() throws IOException {
        if ((this._numTypesValid & 0x20) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(32);
            }
            if ((this._numTypesValid & 0x20) == 0) {
                this.convertNumberToFloat();
            }
        }
        return this._numberFloat;
    }

    @Override
    public double getDoubleValue() throws IOException {
        if ((this._numTypesValid & 8) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(8);
            }
            if ((this._numTypesValid & 8) == 0) {
                this.convertNumberToDouble();
            }
        }
        return this._numberDouble;
    }

    @Override
    public BigDecimal getDecimalValue() throws IOException {
        if ((this._numTypesValid & 0x10) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(16);
            }
            if ((this._numTypesValid & 0x10) == 0) {
                this.convertNumberToBigDecimal();
            }
        }
        return this._numberBigDecimal;
    }

    protected void _checkNumericValue(int n) throws IOException {
        if (this._currToken == JsonToken.VALUE_NUMBER_INT || this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return;
        }
        this._reportError("Current token (" + (Object)((Object)this.currentToken()) + ") not numeric, can not use numeric value accessors");
    }

    protected void convertNumberToInt() throws IOException {
        if ((this._numTypesValid & 2) != 0) {
            int n = (int)this._numberLong;
            if ((long)n != this._numberLong) {
                this._reportError("Numeric value (" + this.getText() + ") out of range of int");
            }
            this._numberInt = n;
        } else if ((this._numTypesValid & 4) != 0) {
            if (BI_MIN_INT.compareTo(this._numberBigInt) > 0 || BI_MAX_INT.compareTo(this._numberBigInt) < 0) {
                this.reportOverflowInt();
            }
            this._numberInt = this._numberBigInt.intValue();
        } else if ((this._numTypesValid & 8) != 0) {
            if (this._numberDouble < -2.147483648E9 || this._numberDouble > 2.147483647E9) {
                this.reportOverflowInt();
            }
            this._numberInt = (int)this._numberDouble;
        } else if ((this._numTypesValid & 0x20) != 0) {
            if ((double)this._numberFloat < -2.147483648E9 || (double)this._numberFloat > 2.147483647E9) {
                this.reportOverflowInt();
            }
            this._numberInt = (int)this._numberFloat;
        } else if ((this._numTypesValid & 0x10) != 0) {
            if (BD_MIN_INT.compareTo(this._numberBigDecimal) > 0 || BD_MAX_INT.compareTo(this._numberBigDecimal) < 0) {
                this.reportOverflowInt();
            }
            this._numberInt = this._numberBigDecimal.intValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 1;
    }

    protected void convertNumberToLong() throws IOException {
        if ((this._numTypesValid & 1) != 0) {
            this._numberLong = this._numberInt;
        } else if ((this._numTypesValid & 4) != 0) {
            if (BI_MIN_LONG.compareTo(this._numberBigInt) > 0 || BI_MAX_LONG.compareTo(this._numberBigInt) < 0) {
                this.reportOverflowLong();
            }
            this._numberLong = this._numberBigInt.longValue();
        } else if ((this._numTypesValid & 8) != 0) {
            if (this._numberDouble < -9.223372036854776E18 || this._numberDouble > 9.223372036854776E18) {
                this.reportOverflowLong();
            }
            this._numberLong = (long)this._numberDouble;
        } else if ((this._numTypesValid & 0x20) != 0) {
            if ((double)this._numberFloat < -9.223372036854776E18 || (double)this._numberFloat > 9.223372036854776E18) {
                this.reportOverflowInt();
            }
            this._numberLong = (long)this._numberFloat;
        } else if ((this._numTypesValid & 0x10) != 0) {
            if (BD_MIN_LONG.compareTo(this._numberBigDecimal) > 0 || BD_MAX_LONG.compareTo(this._numberBigDecimal) < 0) {
                this.reportOverflowLong();
            }
            this._numberLong = this._numberBigDecimal.longValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 2;
    }

    protected void convertNumberToBigInteger() throws IOException {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberBigInt = this._numberBigDecimal.toBigInteger();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberInt);
        } else if ((this._numTypesValid & 8) != 0) {
            this._numberBigInt = BigDecimal.valueOf(this._numberDouble).toBigInteger();
        } else if ((this._numTypesValid & 0x20) != 0) {
            this._numberBigInt = BigDecimal.valueOf(this._numberFloat).toBigInteger();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 4;
    }

    protected void convertNumberToFloat() throws IOException {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberFloat = this._numberBigDecimal.floatValue();
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberFloat = this._numberBigInt.floatValue();
        } else if ((this._numTypesValid & 8) != 0) {
            this._numberFloat = (float)this._numberDouble;
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberFloat = this._numberLong;
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberFloat = this._numberInt;
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 0x20;
    }

    protected void convertNumberToDouble() throws IOException {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberDouble = this._numberBigDecimal.doubleValue();
        } else if ((this._numTypesValid & 0x20) != 0) {
            this._numberDouble = this._numberFloat;
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberDouble = this._numberBigInt.doubleValue();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberDouble = this._numberLong;
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberDouble = this._numberInt;
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 8;
    }

    protected void convertNumberToBigDecimal() throws IOException {
        if ((this._numTypesValid & 0x28) != 0) {
            this._numberBigDecimal = NumberInput.parseBigDecimal(this.getText());
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberBigDecimal = new BigDecimal(this._numberBigInt);
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberInt);
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 0x10;
    }

    protected void _finishToken() throws IOException {
        int n;
        this._tokenIncomplete = false;
        int n2 = this._typeByte;
        int n3 = n2 >> 5 & 7;
        n2 &= 0x1F;
        if (n3 != 3) {
            if (n3 == 2) {
                this._binaryValue = this._finishBytes(this._decodeExplicitLength(n2));
                return;
            }
            this._throwInternal();
        }
        if ((n = this._decodeExplicitLength(n2)) <= 0) {
            if (n < 0) {
                this._finishChunkedText();
            } else {
                this._textBuffer.resetWithEmpty();
            }
            return;
        }
        if (n > this._inputEnd - this._inputPtr) {
            if (n >= this._inputBuffer.length) {
                this._finishLongText(n);
                return;
            }
            this._loadToHaveAtLeast(n);
        }
        this._finishShortText(n);
    }

    protected String _finishTextToken(int n) throws IOException {
        int n2;
        this._tokenIncomplete = false;
        int n3 = n >> 5 & 7;
        n &= 0x1F;
        if (n3 != 3) {
            this._throwInternal();
        }
        if ((n2 = this._decodeExplicitLength(n)) <= 0) {
            if (n2 == 0) {
                this._textBuffer.resetWithEmpty();
                return "";
            }
            this._finishChunkedText();
            return this._textBuffer.contentsAsString();
        }
        int n4 = this._inputEnd - this._inputPtr;
        int n5 = Math.max(n2 + 3, n2);
        if (n4 >= n5 || this._inputBuffer.length >= n5 && this._tryToLoadToHaveAtLeast(n5)) {
            return this._finishShortText(n2);
        }
        this._finishLongText(n2);
        return this._textBuffer.contentsAsString();
    }

    private final String _finishShortText(int n) throws IOException {
        int n2;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        if (cArray.length < n) {
            cArray = this._textBuffer.expandCurrentSegment(n);
        }
        int n3 = 0;
        int n4 = this._inputPtr;
        this._inputPtr += n;
        byte[] byArray = this._inputBuffer;
        int n5 = n4 + n;
        while ((n2 = byArray[n4]) >= 0) {
            cArray[n3++] = (char)n2;
            if (++n4 != n5) continue;
            return this._textBuffer.setCurrentAndReturn(n3);
        }
        int[] nArray = UTF8_UNIT_CODES;
        do {
            n2 = byArray[n4++] & 0xFF;
            switch (nArray[n2]) {
                case 0: {
                    break;
                }
                case 1: {
                    n2 = (n2 & 0x1F) << 6 | byArray[n4++] & 0x3F;
                    break;
                }
                case 2: {
                    n2 = (n2 & 0xF) << 12 | (byArray[n4++] & 0x3F) << 6 | byArray[n4++] & 0x3F;
                    break;
                }
                case 3: {
                    n2 = (n2 & 7) << 18 | (byArray[n4++] & 0x3F) << 12 | (byArray[n4++] & 0x3F) << 6 | byArray[n4++] & 0x3F;
                    cArray[n3++] = (char)(0xD800 | (n2 -= 65536) >> 10);
                    n2 = 0xDC00 | n2 & 0x3FF;
                    break;
                }
                default: {
                    this._reportError("Invalid byte " + Integer.toHexString(n2) + " in Unicode text block");
                }
            }
            cArray[n3++] = (char)n2;
        } while (n4 < n5);
        return this._textBuffer.setCurrentAndReturn(n3);
    }

    private final void _finishLongText(int n) throws IOException {
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n2 = 0;
        int[] nArray = UTF8_UNIT_CODES;
        int n3 = cArray.length;
        while (--n >= 0) {
            int n4 = this._nextByte() & 0xFF;
            int n5 = nArray[n4];
            if (n5 == 0 && n2 < n3) {
                cArray[n2++] = (char)n4;
                continue;
            }
            if ((n -= n5) < 0) {
                throw this._constructError("Malformed UTF-8 character at the end of a (non-chunked) text segment");
            }
            switch (n5) {
                case 0: {
                    break;
                }
                case 1: {
                    int n6 = this._nextByte();
                    if ((n6 & 0xC0) != 128) {
                        this._reportInvalidOther(n6 & 0xFF, this._inputPtr);
                    }
                    n4 = (n4 & 0x1F) << 6 | n6 & 0x3F;
                    break;
                }
                case 2: {
                    n4 = this._decodeUTF8_3(n4);
                    break;
                }
                case 3: {
                    n4 = this._decodeUTF8_4(n4);
                    if (n2 >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n2 = 0;
                        n3 = cArray.length;
                    }
                    cArray[n2++] = (char)(0xD800 | n4 >> 10);
                    n4 = 0xDC00 | n4 & 0x3FF;
                    break;
                }
                default: {
                    this._reportInvalidChar(n4);
                }
            }
            if (n2 >= n3) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
                n3 = cArray.length;
            }
            cArray[n2++] = (char)n4;
        }
        this._textBuffer.setCurrentLength(n2);
    }

    private final void _finishChunkedText() throws IOException {
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n = 0;
        int[] nArray = UTF8_UNIT_CODES;
        int n2 = cArray.length;
        byte[] byArray = this._inputBuffer;
        this._chunkEnd = this._inputPtr;
        this._chunkLeft = 0;
        while (true) {
            int n3;
            int n4;
            if (this._inputPtr >= this._chunkEnd) {
                if (this._chunkLeft == 0) {
                    n4 = this._decodeChunkLength(3);
                    if (n4 < 0) break;
                    this._chunkLeft = n4;
                    n3 = this._inputPtr + n4;
                    if (n3 <= this._inputEnd) {
                        this._chunkLeft = 0;
                        this._chunkEnd = n3;
                    } else {
                        this._chunkLeft = n3 - this._inputEnd;
                        this._chunkEnd = this._inputEnd;
                    }
                }
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    n4 = this._inputPtr + this._chunkLeft;
                    if (n4 <= this._inputEnd) {
                        this._chunkLeft = 0;
                        this._chunkEnd = n4;
                    } else {
                        this._chunkLeft = n4 - this._inputEnd;
                        this._chunkEnd = this._inputEnd;
                    }
                }
            }
            if ((n3 = nArray[n4 = byArray[this._inputPtr++] & 0xFF]) == 0 && n < n2) {
                cArray[n++] = (char)n4;
                continue;
            }
            switch (n3) {
                case 0: {
                    break;
                }
                case 1: {
                    int n5 = this._nextChunkedByte();
                    if ((n5 & 0xC0) != 128) {
                        this._reportInvalidOther(n5 & 0xFF, this._inputPtr);
                    }
                    n4 = (n4 & 0x1F) << 6 | n5 & 0x3F;
                    break;
                }
                case 2: {
                    n4 = this._decodeChunkedUTF8_3(n4);
                    break;
                }
                case 3: {
                    n4 = this._decodeChunkedUTF8_4(n4);
                    if (n >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n = 0;
                        n2 = cArray.length;
                    }
                    cArray[n++] = (char)(0xD800 | n4 >> 10);
                    n4 = 0xDC00 | n4 & 0x3FF;
                    break;
                }
                default: {
                    this._reportInvalidChar(n4);
                }
            }
            if (n >= n2) {
                cArray = this._textBuffer.finishCurrentSegment();
                n = 0;
                n2 = cArray.length;
            }
            cArray[n++] = (char)n4;
        }
        this._textBuffer.setCurrentLength(n);
    }

    private final int _nextByte() throws IOException {
        int n = this._inputPtr;
        if (n < this._inputEnd) {
            byte by = this._inputBuffer[n];
            this._inputPtr = n + 1;
            return by;
        }
        this.loadMoreGuaranteed();
        return this._inputBuffer[this._inputPtr++];
    }

    private final int _nextChunkedByte() throws IOException {
        int n = this._inputPtr;
        if (n >= this._chunkEnd) {
            return this._nextChunkedByte2();
        }
        byte by = this._inputBuffer[n];
        this._inputPtr = n + 1;
        return by;
    }

    private final int _nextChunkedByte2() throws IOException {
        int n;
        int n2;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
            if (this._chunkLeft > 0) {
                int n3 = this._inputPtr + this._chunkLeft;
                if (n3 <= this._inputEnd) {
                    this._chunkLeft = 0;
                    this._chunkEnd = n3;
                } else {
                    this._chunkLeft = n3 - this._inputEnd;
                    this._chunkEnd = this._inputEnd;
                }
                return this._inputBuffer[this._inputPtr++];
            }
        }
        if ((n2 = this._decodeChunkLength(3)) <= 0) {
            this._reportInvalidEOF(": chunked Text ends with partial UTF-8 character", JsonToken.VALUE_STRING);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((n = this._inputPtr + n2) <= this._inputEnd) {
            this._chunkLeft = 0;
            this._chunkEnd = n;
        } else {
            this._chunkLeft = n - this._inputEnd;
            this._chunkEnd = this._inputEnd;
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected byte[] _finishBytes(int n) throws IOException {
        if (n <= 0) {
            if (n == 0) {
                return NO_BYTES;
            }
            return this._finishChunkedBytes();
        }
        if (n > 250000) {
            return this._finishLongContiguousBytes(n);
        }
        byte[] byArray = new byte[n];
        int n2 = n;
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportIncompleteBinaryRead(n2, 0);
        }
        int n3 = 0;
        while (true) {
            int n4 = Math.min(n, this._inputEnd - this._inputPtr);
            System.arraycopy(this._inputBuffer, this._inputPtr, byArray, n3, n4);
            this._inputPtr += n4;
            n3 += n4;
            if ((n -= n4) <= 0) {
                return byArray;
            }
            if (this.loadMore()) continue;
            this._reportIncompleteBinaryRead(n2, n3);
        }
    }

    protected byte[] _finishChunkedBytes() throws IOException {
        ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
        block0: while (true) {
            int n;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) == 255) break;
            int n2 = n >> 5;
            if (n2 != 2) {
                throw this._constructError("Mismatched chunk in chunked content: expected 2 but encountered " + n2);
            }
            int n3 = this._decodeExplicitLength(n & 0x1F);
            if (n3 < 0) {
                throw this._constructError("Illegal chunked-length indicator within chunked-length value (type 2)");
            }
            int n4 = n3;
            while (true) {
                if (n3 <= 0) continue block0;
                int n5 = this._inputEnd - this._inputPtr;
                if (this._inputPtr >= this._inputEnd) {
                    if (!this.loadMore()) {
                        this._reportIncompleteBinaryRead(n4, n4 - n3);
                    }
                    n5 = this._inputEnd - this._inputPtr;
                }
                int n6 = Math.min(n5, n3);
                byteArrayBuilder.write(this._inputBuffer, this._inputPtr, n6);
                this._inputPtr += n6;
                n3 -= n6;
            }
            break;
        }
        return byteArrayBuilder.toByteArray();
    }

    protected byte[] _finishLongContiguousBytes(int n) throws IOException {
        try (ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder(125000);){
            int n2;
            for (int i = n; i > 0; i -= n2) {
                int n3 = this._inputEnd - this._inputPtr;
                if (n3 <= 0) {
                    if (!this.loadMore()) {
                        this._reportIncompleteBinaryRead(n, n - i);
                    }
                    n3 = this._inputEnd - this._inputPtr;
                }
                n2 = Math.min(n3, i);
                byteArrayBuilder.write(this._inputBuffer, this._inputPtr, n2);
                this._inputPtr += n2;
            }
            byte[] byArray = byteArrayBuilder.toByteArray();
            return byArray;
        }
    }

    protected final JsonToken _decodeFieldName() throws IOException {
        String string;
        byte by;
        int n;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((n = (by = this._inputBuffer[this._inputPtr++]) >> 5 & 7) != 3) {
            if (by == -1) {
                if (!this._parsingContext.hasExpectedLength()) {
                    this._parsingContext = this._parsingContext.getParent();
                    return JsonToken.END_OBJECT;
                }
                this._reportUnexpectedBreak();
            }
            this._decodeNonStringName(by);
            return JsonToken.FIELD_NAME;
        }
        int n2 = by & 0x1F;
        if (n2 <= 23) {
            if (n2 == 0) {
                string = "";
            } else {
                string = this._findDecodedFromSymbols(n2);
                if (string != null) {
                    this._inputPtr += n2;
                } else {
                    string = this._decodeShortName(n2);
                    string = this._addDecodedToSymbols(n2, string);
                }
            }
        } else {
            int n3 = this._decodeExplicitLength(n2);
            string = n3 < 0 ? this._decodeChunkedName() : this._decodeLongerName(n3);
        }
        this._parsingContext.setCurrentName(string);
        return JsonToken.FIELD_NAME;
    }

    private final String _decodeShortName(int n) throws IOException {
        int n2;
        int n3;
        int n4 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        if (cArray.length < n) {
            cArray = this._textBuffer.expandCurrentSegment(n);
        }
        int n5 = this._inputPtr;
        this._inputPtr += n;
        int[] nArray = UTF8_UNIT_CODES;
        byte[] byArray = this._inputBuffer;
        int n6 = n5 + n;
        while ((n3 = nArray[n2 = byArray[n5] & 0xFF]) == 0) {
            cArray[n4++] = (char)n2;
            if (++n5 != n6) continue;
            return this._textBuffer.setCurrentAndReturn(n4);
        }
        while (n5 < n6) {
            if ((n3 = nArray[n2 = byArray[n5++] & 0xFF]) != 0) {
                switch (n3) {
                    case 1: {
                        n2 = (n2 & 0x1F) << 6 | byArray[n5++] & 0x3F;
                        break;
                    }
                    case 2: {
                        n2 = (n2 & 0xF) << 12 | (byArray[n5++] & 0x3F) << 6 | byArray[n5++] & 0x3F;
                        break;
                    }
                    case 3: {
                        n2 = (n2 & 7) << 18 | (byArray[n5++] & 0x3F) << 12 | (byArray[n5++] & 0x3F) << 6 | byArray[n5++] & 0x3F;
                        cArray[n4++] = (char)(0xD800 | (n2 -= 65536) >> 10);
                        n2 = 0xDC00 | n2 & 0x3FF;
                        break;
                    }
                    default: {
                        this._reportError("Invalid byte " + Integer.toHexString(n2) + " in Object name");
                    }
                }
            }
            cArray[n4++] = (char)n2;
        }
        return this._textBuffer.setCurrentAndReturn(n4);
    }

    private final String _decodeLongerName(int n) throws IOException {
        String string;
        if (n == 0) {
            return "";
        }
        if (this._inputEnd - this._inputPtr < n) {
            if (n >= this._inputBuffer.length) {
                this._finishLongText(n);
                return this._textBuffer.contentsAsString();
            }
            this._loadToHaveAtLeast(n);
        }
        if ((string = this._findDecodedFromSymbols(n)) != null) {
            this._inputPtr += n;
            return string;
        }
        string = this._decodeShortName(n);
        return this._addDecodedToSymbols(n, string);
    }

    private final String _decodeChunkedName() throws IOException {
        this._finishChunkedText();
        return this._textBuffer.contentsAsString();
    }

    protected final void _decodeNonStringName(int n) throws IOException {
        String string;
        int n2 = n >> 5 & 7;
        if (n2 == 0) {
            string = this._numberToName(n, false);
        } else if (n2 == 1) {
            string = this._numberToName(n, true);
        } else if (n2 == 2) {
            int n3 = this._decodeExplicitLength(n & 0x1F);
            byte[] byArray = this._finishBytes(n3);
            string = new String(byArray, UTF8);
        } else {
            if ((n & 0xFF) == 255) {
                this._reportUnexpectedBreak();
            }
            throw this._constructError("Unsupported major type (" + n2 + ") for CBOR Objects, not (yet?) supported, only Strings");
        }
        this._parsingContext.setCurrentName(string);
    }

    private final String _findDecodedFromSymbols(int n) throws IOException {
        if (this._inputEnd - this._inputPtr < n) {
            this._loadToHaveAtLeast(n);
        }
        if (n < 5) {
            int n2 = this._inputPtr;
            byte[] byArray = this._inputBuffer;
            int n3 = byArray[n2] & 0xFF;
            if (n > 1) {
                n3 = (n3 << 8) + (byArray[++n2] & 0xFF);
                if (n > 2) {
                    n3 = (n3 << 8) + (byArray[++n2] & 0xFF);
                    if (n > 3) {
                        n3 = (n3 << 8) + (byArray[++n2] & 0xFF);
                    }
                }
            }
            this._quad1 = n3;
            return this._symbols.findName(n3);
        }
        byte[] byArray = this._inputBuffer;
        int n4 = this._inputPtr;
        int n5 = byArray[n4++] & 0xFF;
        n5 = n5 << 8 | byArray[n4++] & 0xFF;
        n5 = n5 << 8 | byArray[n4++] & 0xFF;
        n5 = n5 << 8 | byArray[n4++] & 0xFF;
        if (n < 9) {
            int n6 = byArray[n4++] & 0xFF;
            int n7 = n - 5;
            if (n7 > 0) {
                n6 = (n6 << 8) + (byArray[n4++] & 0xFF);
                if (n7 > 1) {
                    n6 = (n6 << 8) + (byArray[n4++] & 0xFF);
                    if (n7 > 2) {
                        n6 = (n6 << 8) + (byArray[n4++] & 0xFF);
                    }
                }
            }
            this._quad1 = n5;
            this._quad2 = n6;
            return this._symbols.findName(n5, n6);
        }
        int n8 = byArray[n4++] & 0xFF;
        n8 = n8 << 8 | byArray[n4++] & 0xFF;
        n8 = n8 << 8 | byArray[n4++] & 0xFF;
        n8 = n8 << 8 | byArray[n4++] & 0xFF;
        if (n < 13) {
            int n9 = byArray[n4++] & 0xFF;
            int n10 = n - 9;
            if (n10 > 0) {
                n9 = (n9 << 8) + (byArray[n4++] & 0xFF);
                if (n10 > 1) {
                    n9 = (n9 << 8) + (byArray[n4++] & 0xFF);
                    if (n10 > 2) {
                        n9 = (n9 << 8) + (byArray[n4++] & 0xFF);
                    }
                }
            }
            this._quad1 = n5;
            this._quad2 = n8;
            this._quad3 = n9;
            return this._symbols.findName(n5, n8, n9);
        }
        return this._findDecodedLong(n, n5, n8);
    }

    private final String _findDecodedLong(int n, int n2, int n3) throws IOException {
        int n4;
        int n5 = n + 3 >> 2;
        if (n5 > this._quadBuffer.length) {
            this._quadBuffer = CBORParser._growArrayTo(this._quadBuffer, n5);
        }
        this._quadBuffer[0] = n2;
        this._quadBuffer[1] = n3;
        n5 = 2;
        int n6 = this._inputPtr + 8;
        n -= 8;
        byte[] byArray = this._inputBuffer;
        do {
            n4 = byArray[n6++] & 0xFF;
            n4 = n4 << 8 | byArray[n6++] & 0xFF;
            n4 = n4 << 8 | byArray[n6++] & 0xFF;
            n4 = n4 << 8 | byArray[n6++] & 0xFF;
            this._quadBuffer[n5++] = n4;
        } while ((n -= 4) > 3);
        if (n > 0) {
            n4 = byArray[n6] & 0xFF;
            if (n > 1) {
                n4 = (n4 << 8) + (byArray[++n6] & 0xFF);
                if (n > 2) {
                    n4 = (n4 << 8) + (byArray[++n6] & 0xFF);
                }
            }
            this._quadBuffer[n5++] = n4;
        }
        return this._symbols.findName(this._quadBuffer, n5);
    }

    private final String _addDecodedToSymbols(int n, String string) {
        if (n < 5) {
            return this._symbols.addName(string, this._quad1);
        }
        if (n < 9) {
            return this._symbols.addName(string, this._quad1, this._quad2);
        }
        if (n < 13) {
            return this._symbols.addName(string, this._quad1, this._quad2, this._quad3);
        }
        int n2 = n + 3 >> 2;
        return this._symbols.addName(string, this._quadBuffer, n2);
    }

    private static int[] _growArrayTo(int[] nArray, int n) {
        return Arrays.copyOf(nArray, n + 4);
    }

    protected void _skipIncomplete() throws IOException {
        int n;
        this._tokenIncomplete = false;
        int n2 = this._typeByte >> 5 & 7;
        if (n2 != 3 && n2 != 2) {
            this._throwInternal();
        }
        if ((n = this._typeByte & 0x1F) <= 23) {
            if (n > 0) {
                this._skipBytes(n);
            }
            return;
        }
        switch (n) {
            case 24: {
                this._skipBytes(this._decode8Bits());
                break;
            }
            case 25: {
                this._skipBytes(this._decode16Bits());
                break;
            }
            case 26: {
                this._skipBytes(this._decode32Bits());
                break;
            }
            case 27: {
                this._skipBytesL(this._decode64Bits());
                break;
            }
            case 31: {
                this._skipChunked(n2);
                break;
            }
            default: {
                this._invalidToken(this._typeByte);
            }
        }
    }

    protected void _skipChunked(int n) throws IOException {
        block7: while (true) {
            int n2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) == 255) {
                return;
            }
            int n3 = n2 >> 5;
            if (n3 != n) {
                throw this._constructError("Mismatched chunk in chunked content: expected " + n + " but encountered " + n3);
            }
            int n4 = n2 & 0x1F;
            if (n4 <= 23) {
                if (n4 <= 0) continue;
                this._skipBytes(n4);
                continue;
            }
            switch (n4) {
                case 24: {
                    this._skipBytes(this._decode8Bits());
                    continue block7;
                }
                case 25: {
                    this._skipBytes(this._decode16Bits());
                    continue block7;
                }
                case 26: {
                    this._skipBytes(this._decode32Bits());
                    continue block7;
                }
                case 27: {
                    this._skipBytesL(this._decode64Bits());
                    continue block7;
                }
                case 31: {
                    throw this._constructError("Illegal chunked-length indicator within chunked-length value (type " + n + ")");
                }
            }
            this._invalidToken(this._typeByte);
        }
    }

    protected void _skipBytesL(long l) throws IOException {
        while (l > Integer.MAX_VALUE) {
            this._skipBytes(Integer.MAX_VALUE);
            l -= Integer.MAX_VALUE;
        }
        this._skipBytes((int)l);
    }

    protected void _skipBytes(int n) throws IOException {
        while (true) {
            int n2 = Math.min(n, this._inputEnd - this._inputPtr);
            this._inputPtr += n2;
            if ((n -= n2) <= 0) {
                return;
            }
            this.loadMoreGuaranteed();
        }
    }

    private final int _decodeTag(int n) throws IOException {
        if (n <= 23) {
            return n;
        }
        switch (n - 24) {
            case 0: {
                return this._decode8Bits();
            }
            case 1: {
                return this._decode16Bits();
            }
            case 2: {
                return this._decode32Bits();
            }
            case 3: {
                long l = this._decode64Bits();
                if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                    this._reportError("Illegal Tag value: " + l);
                }
                return (int)l;
            }
        }
        throw this._constructError("Invalid low bits for Tag token: 0x" + Integer.toHexString(n));
    }

    private final int _decodeExplicitLength(int n) throws IOException {
        if (n == 31) {
            return -1;
        }
        if (n <= 23) {
            return n;
        }
        switch (n - 24) {
            case 0: {
                return this._decode8Bits();
            }
            case 1: {
                return this._decode16Bits();
            }
            case 2: {
                return this._decode32Bits();
            }
            case 3: {
                long l = this._decode64Bits();
                if (l < 0L || l > Integer.MAX_VALUE) {
                    throw this._constructError("Illegal length for " + (Object)((Object)this.currentToken()) + ": " + l);
                }
                return (int)l;
            }
        }
        throw this._constructError("Invalid length for " + (Object)((Object)this.currentToken()) + ": 0x" + Integer.toHexString(n));
    }

    private int _decodeChunkLength(int n) throws IOException {
        int n2;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) == 255) {
            return -1;
        }
        int n3 = n2 >> 5;
        if (n3 != n) {
            throw this._constructError("Mismatched chunk in chunked content: expected " + n + " but encountered " + n3 + " (byte 0x" + Integer.toHexString(n2) + ")");
        }
        int n4 = this._decodeExplicitLength(n2 & 0x1F);
        if (n4 < 0) {
            throw this._constructError("Illegal chunked-length indicator within chunked-length value (type " + n + ")");
        }
        return n4;
    }

    private float _decodeHalfSizeFloat() throws IOException {
        int n = this._decode16Bits() & 0xFFFF;
        boolean bl = n >> 15 != 0;
        int n2 = n >> 10 & 0x1F;
        int n3 = n & 0x3FF;
        if (n2 == 0) {
            float f = (float)(MATH_POW_2_NEG14 * ((double)n3 / MATH_POW_2_10));
            return bl ? -f : f;
        }
        if (n2 == 31) {
            if (n3 != 0) {
                return Float.NaN;
            }
            return bl ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        float f = (float)(Math.pow(2.0, n2 - 15) * (1.0 + (double)n3 / MATH_POW_2_10));
        return bl ? -f : f;
    }

    private final int _decode8Bits() throws IOException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        return this._inputBuffer[this._inputPtr++] & 0xFF;
    }

    private final int _decode16Bits() throws IOException {
        int n = this._inputPtr;
        if (n + 1 >= this._inputEnd) {
            return this._slow16();
        }
        byte[] byArray = this._inputBuffer;
        int n2 = ((byArray[n] & 0xFF) << 8) + (byArray[n + 1] & 0xFF);
        this._inputPtr = n + 2;
        return n2;
    }

    private final int _slow16() throws IOException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        int n = this._inputBuffer[this._inputPtr++] & 0xFF;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        return (n << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF);
    }

    private final int _decode32Bits() throws IOException {
        int n = this._inputPtr;
        if (n + 3 >= this._inputEnd) {
            return this._slow32();
        }
        byte[] byArray = this._inputBuffer;
        int n2 = (byArray[n++] << 24) + ((byArray[n++] & 0xFF) << 16) + ((byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF);
        this._inputPtr = n;
        return n2;
    }

    private final int _slow32() throws IOException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        int n = this._inputBuffer[this._inputPtr++];
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        n = (n << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF);
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        n = (n << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF);
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        return (n << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF);
    }

    private final long _decode64Bits() throws IOException {
        int n = this._inputPtr;
        if (n + 7 >= this._inputEnd) {
            return this._slow64();
        }
        byte[] byArray = this._inputBuffer;
        int n2 = (byArray[n++] << 24) + ((byArray[n++] & 0xFF) << 16) + ((byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF);
        int n3 = (byArray[n++] << 24) + ((byArray[n++] & 0xFF) << 16) + ((byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF);
        this._inputPtr = n;
        return CBORParser._long(n2, n3);
    }

    private final long _slow64() throws IOException {
        return CBORParser._long(this._decode32Bits(), this._decode32Bits());
    }

    private static final long _long(int n, int n2) {
        long l = n;
        long l2 = n2;
        l2 = l2 << 32 >>> 32;
        return (l << 32) + l2;
    }

    protected JsonToken _decodeUndefinedValue() throws IOException {
        return JsonToken.VALUE_NULL;
    }

    public JsonToken _decodeSimpleValue(int n, int n2) throws IOException {
        if (n > 24) {
            this._invalidToken(n2);
        }
        if (n < 24) {
            this._numberInt = n;
        } else {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            this._numberInt = this._inputBuffer[this._inputPtr++] & 0xFF;
            if (this._numberInt < 32) {
                throw this._constructError("Invalid second byte for simple value: 0x" + Integer.toHexString(this._numberInt) + " (only values 0x20 - 0xFF allowed)");
            }
        }
        this._numTypesValid = 1;
        return JsonToken.VALUE_NUMBER_INT;
    }

    private final int _decodeUTF8_3(int n) throws IOException {
        n &= 0xF;
        int n2 = this._nextByte();
        if ((n2 & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF, this._inputPtr);
        }
        int n3 = n << 6 | n2 & 0x3F;
        n2 = this._nextByte();
        if ((n2 & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF, this._inputPtr);
        }
        n3 = n3 << 6 | n2 & 0x3F;
        return n3;
    }

    private final int _decodeChunkedUTF8_3(int n) throws IOException {
        n &= 0xF;
        int n2 = this._nextChunkedByte();
        if ((n2 & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF, this._inputPtr);
        }
        int n3 = n << 6 | n2 & 0x3F;
        n2 = this._nextChunkedByte();
        if ((n2 & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF, this._inputPtr);
        }
        n3 = n3 << 6 | n2 & 0x3F;
        return n3;
    }

    private final int _decodeUTF8_4(int n) throws IOException {
        int n2 = this._nextByte();
        if ((n2 & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF, this._inputPtr);
        }
        n = (n & 7) << 6 | n2 & 0x3F;
        n2 = this._nextByte();
        if ((n2 & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF, this._inputPtr);
        }
        n = n << 6 | n2 & 0x3F;
        n2 = this._nextByte();
        if ((n2 & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF, this._inputPtr);
        }
        return (n << 6 | n2 & 0x3F) - 65536;
    }

    private final int _decodeChunkedUTF8_4(int n) throws IOException {
        int n2 = this._nextChunkedByte();
        if ((n2 & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF, this._inputPtr);
        }
        n = (n & 7) << 6 | n2 & 0x3F;
        n2 = this._nextChunkedByte();
        if ((n2 & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF, this._inputPtr);
        }
        n = n << 6 | n2 & 0x3F;
        n2 = this._nextChunkedByte();
        if ((n2 & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF, this._inputPtr);
        }
        return (n << 6 | n2 & 0x3F) - 65536;
    }

    protected boolean loadMore() throws IOException {
        if (this._inputStream != null) {
            this._currInputProcessed += (long)this._inputEnd;
            int n = this._inputStream.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (n > 0) {
                this._inputPtr = 0;
                this._inputEnd = n;
                return true;
            }
            this._closeInput();
            if (n == 0) {
                throw new IOException("InputStream.read() returned 0 characters when trying to read " + this._inputBuffer.length + " bytes");
            }
        }
        return false;
    }

    protected void loadMoreGuaranteed() throws IOException {
        if (!this.loadMore()) {
            this._reportInvalidEOF();
        }
    }

    protected final void _loadToHaveAtLeast(int n) throws IOException {
        if (this._inputStream == null) {
            throw this._constructError("Needed to read " + n + " bytes, reached end-of-input");
        }
        int n2 = this._inputEnd - this._inputPtr;
        if (n2 > 0 && this._inputPtr > 0) {
            System.arraycopy(this._inputBuffer, this._inputPtr, this._inputBuffer, 0, n2);
            this._inputEnd = n2;
        } else {
            this._inputEnd = 0;
        }
        this._currInputProcessed += (long)this._inputPtr;
        this._inputPtr = 0;
        while (this._inputEnd < n) {
            int n3 = this._inputStream.read(this._inputBuffer, this._inputEnd, this._inputBuffer.length - this._inputEnd);
            if (n3 < 1) {
                this._closeInput();
                if (n3 == 0) {
                    throw new IOException("InputStream.read() returned 0 characters when trying to read " + n2 + " bytes");
                }
                throw this._constructError("Needed to read " + n + " bytes, missed " + n + " before end-of-input");
            }
            this._inputEnd += n3;
        }
    }

    protected final boolean _tryToLoadToHaveAtLeast(int n) throws IOException {
        if (this._inputStream == null) {
            return false;
        }
        int n2 = this._inputEnd - this._inputPtr;
        if (n2 > 0 && this._inputPtr > 0) {
            System.arraycopy(this._inputBuffer, this._inputPtr, this._inputBuffer, 0, n2);
            this._inputEnd = n2;
        } else {
            this._inputEnd = 0;
        }
        this._currInputProcessed += (long)this._inputPtr;
        this._inputPtr = 0;
        while (this._inputEnd < n) {
            int n3 = this._inputStream.read(this._inputBuffer, this._inputEnd, this._inputBuffer.length - this._inputEnd);
            if (n3 < 1) {
                this._closeInput();
                return false;
            }
            this._inputEnd += n3;
        }
        return true;
    }

    protected ByteArrayBuilder _getByteArrayBuilder() {
        if (this._byteArrayBuilder == null) {
            this._byteArrayBuilder = new ByteArrayBuilder();
        } else {
            this._byteArrayBuilder.reset();
        }
        return this._byteArrayBuilder;
    }

    protected void _closeInput() throws IOException {
        if (this._inputStream != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                this._inputStream.close();
            }
            this._inputStream = null;
        }
    }

    @Override
    protected void _handleEOF() throws JsonParseException {
        if (this._parsingContext.inRoot()) {
            return;
        }
        String string = this._parsingContext.inArray() ? "Array" : "Object";
        this._reportInvalidEOF(String.format(": expected close marker for %s (start marker at %s)", string, this._parsingContext.getStartLocation(this._ioContext.getSourceReference())), null);
    }

    protected JsonToken _handleCBOREOF() throws IOException {
        this._tagValue = -1;
        this.close();
        this._handleEOF();
        this._currToken = null;
        return null;
    }

    protected void _invalidToken(int n) throws JsonParseException {
        if ((n &= 0xFF) == 255) {
            throw this._constructError("Mismatched BREAK byte (0xFF): encountered where value expected");
        }
        throw this._constructError("Invalid CBOR value token (first byte): 0x" + Integer.toHexString(n));
    }

    protected void _reportUnexpectedBreak() throws IOException {
        if (this._parsingContext.inRoot()) {
            throw this._constructError("Unexpected Break (0xFF) token in Root context");
        }
        throw this._constructError("Unexpected Break (0xFF) token in definite length (" + this._parsingContext.getExpectedLength() + ") " + (this._parsingContext.inObject() ? "Object" : "Array"));
    }

    protected void _reportInvalidChar(int n) throws JsonParseException {
        if (n < 32) {
            this._throwInvalidSpace(n);
        }
        this._reportInvalidInitial(n);
    }

    protected void _reportInvalidInitial(int n) throws JsonParseException {
        this._reportError("Invalid UTF-8 start byte 0x" + Integer.toHexString(n));
    }

    protected void _reportInvalidOther(int n) throws JsonParseException {
        this._reportError("Invalid UTF-8 middle byte 0x" + Integer.toHexString(n));
    }

    protected void _reportInvalidOther(int n, int n2) throws JsonParseException {
        this._inputPtr = n2;
        this._reportInvalidOther(n);
    }

    protected void _reportIncompleteBinaryRead(int n, int n2) throws IOException {
        this._reportInvalidEOF(String.format(" for Binary value: expected %d bytes, only found %d", n, n2), this._currToken);
    }

    private final BigInteger _bigPositive(long l) {
        BigInteger bigInteger = BigInteger.valueOf(l << 1 >>> 1);
        return bigInteger.or(BIT_63);
    }

    private final BigInteger _bigNegative(long l) {
        BigInteger bigInteger = this._bigPositive(l);
        return bigInteger.negate().subtract(BigInteger.ONE);
    }

    public static enum Feature implements FormatFeature
    {

        final boolean _defaultState;
        final int _mask;

        public static int collectDefaults() {
            int n = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n |= feature.getMask();
            }
            return n;
        }

        private Feature(boolean bl) {
            this._defaultState = bl;
            this._mask = 1 << this.ordinal();
        }

        @Override
        public boolean enabledByDefault() {
            return this._defaultState;
        }

        @Override
        public int getMask() {
            return this._mask;
        }

        @Override
        public boolean enabledIn(int n) {
            return (n & this._mask) != 0;
        }
    }
}

