/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.util.LinkedNode;
import java.lang.reflect.Array;
import java.util.List;

public final class ObjectBuffer {
    private static final int SMALL_CHUNK = 16384;
    private static final int MAX_CHUNK = 262144;
    private LinkedNode<Object[]> _head;
    private LinkedNode<Object[]> _tail;
    private int _size;
    private Object[] _freeBuffer;

    public Object[] resetAndStart() {
        this._reset();
        if (this._freeBuffer == null) {
            this._freeBuffer = new Object[12];
            return this._freeBuffer;
        }
        return this._freeBuffer;
    }

    public Object[] resetAndStart(Object[] objectArray, int n) {
        this._reset();
        if (this._freeBuffer == null || this._freeBuffer.length < n) {
            this._freeBuffer = new Object[Math.max(12, n)];
        }
        System.arraycopy(objectArray, 0, this._freeBuffer, 0, n);
        return this._freeBuffer;
    }

    public Object[] appendCompletedChunk(Object[] objectArray) {
        LinkedNode<Object[]> linkedNode = new LinkedNode<Object[]>(objectArray, null);
        if (this._head == null) {
            this._tail = linkedNode;
            this._head = this._tail;
        } else {
            this._tail.linkNext(linkedNode);
            this._tail = linkedNode;
        }
        int n = objectArray.length;
        this._size += n;
        if (n < 16384) {
            n += n;
        } else if (n < 262144) {
            n += n >> 2;
        }
        return new Object[n];
    }

    public Object[] completeAndClearBuffer(Object[] objectArray, int n) {
        int n2 = n + this._size;
        Object[] objectArray2 = new Object[n2];
        this._copyTo(objectArray2, n2, objectArray, n);
        this._reset();
        return objectArray2;
    }

    public <T> T[] completeAndClearBuffer(Object[] objectArray, int n, Class<T> clazz) {
        int n2 = n + this._size;
        Object[] objectArray2 = (Object[])Array.newInstance(clazz, n2);
        this._copyTo(objectArray2, n2, objectArray, n);
        this._reset();
        return objectArray2;
    }

    public void completeAndClearBuffer(Object[] objectArray, int n, List<Object> list) {
        for (LinkedNode<Object[]> linkedNode = this._head; linkedNode != null; linkedNode = linkedNode.next()) {
            Object[] objectArray2 = linkedNode.value();
            int n2 = objectArray2.length;
            for (int i = 0; i < n2; ++i) {
                list.add(objectArray2[i]);
            }
        }
        for (int i = 0; i < n; ++i) {
            list.add(objectArray[i]);
        }
        this._reset();
    }

    public int initialCapacity() {
        return this._freeBuffer == null ? 0 : this._freeBuffer.length;
    }

    public int bufferedSize() {
        return this._size;
    }

    protected void _reset() {
        if (this._tail != null) {
            this._freeBuffer = this._tail.value();
        }
        this._tail = null;
        this._head = null;
        this._size = 0;
    }

    protected final void _copyTo(Object object, int n, Object[] objectArray, int n2) {
        int n3 = 0;
        for (LinkedNode<Object[]> linkedNode = this._head; linkedNode != null; linkedNode = linkedNode.next()) {
            Object[] objectArray2 = linkedNode.value();
            int n4 = objectArray2.length;
            System.arraycopy(objectArray2, 0, object, n3, n4);
            n3 += n4;
        }
        System.arraycopy(objectArray, 0, object, n3, n2);
        if ((n3 += n2) != n) {
            throw new IllegalStateException("Should have gotten " + n + " entries, got " + n3);
        }
    }
}

