/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.PrimitiveArrayBuilder;
import java.lang.reflect.Array;
import java.util.HashSet;

public final class ArrayBuilders {
    private BooleanBuilder _booleanBuilder = null;
    private ByteBuilder _byteBuilder = null;
    private ShortBuilder _shortBuilder = null;
    private IntBuilder _intBuilder = null;
    private LongBuilder _longBuilder = null;
    private FloatBuilder _floatBuilder = null;
    private DoubleBuilder _doubleBuilder = null;

    public BooleanBuilder getBooleanBuilder() {
        if (this._booleanBuilder == null) {
            this._booleanBuilder = new BooleanBuilder();
        }
        return this._booleanBuilder;
    }

    public ByteBuilder getByteBuilder() {
        if (this._byteBuilder == null) {
            this._byteBuilder = new ByteBuilder();
        }
        return this._byteBuilder;
    }

    public ShortBuilder getShortBuilder() {
        if (this._shortBuilder == null) {
            this._shortBuilder = new ShortBuilder();
        }
        return this._shortBuilder;
    }

    public IntBuilder getIntBuilder() {
        if (this._intBuilder == null) {
            this._intBuilder = new IntBuilder();
        }
        return this._intBuilder;
    }

    public LongBuilder getLongBuilder() {
        if (this._longBuilder == null) {
            this._longBuilder = new LongBuilder();
        }
        return this._longBuilder;
    }

    public FloatBuilder getFloatBuilder() {
        if (this._floatBuilder == null) {
            this._floatBuilder = new FloatBuilder();
        }
        return this._floatBuilder;
    }

    public DoubleBuilder getDoubleBuilder() {
        if (this._doubleBuilder == null) {
            this._doubleBuilder = new DoubleBuilder();
        }
        return this._doubleBuilder;
    }

    public static Object getArrayComparator(final Object object) {
        final int n = Array.getLength(object);
        final Class<?> clazz = object.getClass();
        return new Object(){

            public boolean equals(Object object4) {
                if (object4 == this) {
                    return true;
                }
                if (!ClassUtil.hasClass(object4, clazz)) {
                    return false;
                }
                if (Array.getLength(object4) != n) {
                    return false;
                }
                for (int i = 0; i < n; ++i) {
                    Object object2;
                    Object object3 = Array.get(object, i);
                    if (object3 == (object2 = Array.get(object4, i)) || object3 == null || object3.equals(object2)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <T> HashSet<T> arrayToSet(T[] TArray) {
        if (TArray != null) {
            int n = TArray.length;
            HashSet<T> hashSet = new HashSet<T>(n);
            for (int i = 0; i < n; ++i) {
                hashSet.add(TArray[i]);
            }
            return hashSet;
        }
        return new HashSet();
    }

    public static <T> T[] insertInListNoDup(T[] TArray, T t2) {
        int n = TArray.length;
        for (int i = 0; i < n; ++i) {
            if (TArray[i] != t2) continue;
            if (i == 0) {
                return TArray;
            }
            Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n);
            System.arraycopy(TArray, 0, objectArray, 1, i);
            objectArray[0] = t2;
            int n2 = n - ++i;
            if (n2 > 0) {
                System.arraycopy(TArray, i, objectArray, i, n2);
            }
            return objectArray;
        }
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n + 1);
        if (n > 0) {
            System.arraycopy(TArray, 0, objectArray, 1, n);
        }
        objectArray[0] = t2;
        return objectArray;
    }

    public static final class DoubleBuilder
    extends PrimitiveArrayBuilder<double[]> {
        @Override
        public final double[] _constructArray(int n) {
            return new double[n];
        }
    }

    public static final class FloatBuilder
    extends PrimitiveArrayBuilder<float[]> {
        @Override
        public final float[] _constructArray(int n) {
            return new float[n];
        }
    }

    public static final class LongBuilder
    extends PrimitiveArrayBuilder<long[]> {
        @Override
        public final long[] _constructArray(int n) {
            return new long[n];
        }
    }

    public static final class IntBuilder
    extends PrimitiveArrayBuilder<int[]> {
        @Override
        public final int[] _constructArray(int n) {
            return new int[n];
        }
    }

    public static final class ShortBuilder
    extends PrimitiveArrayBuilder<short[]> {
        @Override
        public final short[] _constructArray(int n) {
            return new short[n];
        }
    }

    public static final class ByteBuilder
    extends PrimitiveArrayBuilder<byte[]> {
        @Override
        public final byte[] _constructArray(int n) {
            return new byte[n];
        }
    }

    public static final class BooleanBuilder
    extends PrimitiveArrayBuilder<boolean[]> {
        @Override
        public final boolean[] _constructArray(int n) {
            return new boolean[n];
        }
    }
}

