/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeCreator;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.fasterxml.jackson.databind.util.RawValue;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;

public class JsonNodeFactory
implements JsonNodeCreator,
Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean _cfgBigDecimalExact;
    private static final JsonNodeFactory decimalsNormalized = new JsonNodeFactory(false);
    private static final JsonNodeFactory decimalsAsIs = new JsonNodeFactory(true);
    public static final JsonNodeFactory instance = decimalsNormalized;

    public JsonNodeFactory(boolean bl) {
        this._cfgBigDecimalExact = bl;
    }

    protected JsonNodeFactory() {
        this(false);
    }

    public static JsonNodeFactory withExactBigDecimals(boolean bl) {
        return bl ? decimalsAsIs : decimalsNormalized;
    }

    @Override
    public BooleanNode booleanNode(boolean bl) {
        return bl ? BooleanNode.getTrue() : BooleanNode.getFalse();
    }

    @Override
    public NullNode nullNode() {
        return NullNode.getInstance();
    }

    public JsonNode missingNode() {
        return MissingNode.getInstance();
    }

    @Override
    public NumericNode numberNode(byte by) {
        return IntNode.valueOf(by);
    }

    @Override
    public ValueNode numberNode(Byte by) {
        return by == null ? this.nullNode() : IntNode.valueOf(by.intValue());
    }

    @Override
    public NumericNode numberNode(short s2) {
        return ShortNode.valueOf(s2);
    }

    @Override
    public ValueNode numberNode(Short s2) {
        return s2 == null ? this.nullNode() : ShortNode.valueOf(s2);
    }

    @Override
    public NumericNode numberNode(int n) {
        return IntNode.valueOf(n);
    }

    @Override
    public ValueNode numberNode(Integer n) {
        return n == null ? this.nullNode() : IntNode.valueOf(n);
    }

    @Override
    public NumericNode numberNode(long l) {
        return LongNode.valueOf(l);
    }

    @Override
    public ValueNode numberNode(Long l) {
        if (l == null) {
            return this.nullNode();
        }
        return LongNode.valueOf(l);
    }

    @Override
    public ValueNode numberNode(BigInteger bigInteger) {
        if (bigInteger == null) {
            return this.nullNode();
        }
        return BigIntegerNode.valueOf(bigInteger);
    }

    @Override
    public NumericNode numberNode(float f) {
        return FloatNode.valueOf(f);
    }

    @Override
    public ValueNode numberNode(Float f) {
        return f == null ? this.nullNode() : FloatNode.valueOf(f.floatValue());
    }

    @Override
    public NumericNode numberNode(double d) {
        return DoubleNode.valueOf(d);
    }

    @Override
    public ValueNode numberNode(Double d) {
        return d == null ? this.nullNode() : DoubleNode.valueOf(d);
    }

    @Override
    public ValueNode numberNode(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return this.nullNode();
        }
        if (this._cfgBigDecimalExact) {
            return DecimalNode.valueOf(bigDecimal);
        }
        if (bigDecimal.signum() == 0) {
            return DecimalNode.ZERO;
        }
        try {
            bigDecimal = bigDecimal.stripTrailingZeros();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return DecimalNode.valueOf(bigDecimal);
    }

    @Override
    public TextNode textNode(String string) {
        return TextNode.valueOf(string);
    }

    @Override
    public BinaryNode binaryNode(byte[] byArray) {
        return BinaryNode.valueOf(byArray);
    }

    @Override
    public BinaryNode binaryNode(byte[] byArray, int n, int n2) {
        return BinaryNode.valueOf(byArray, n, n2);
    }

    @Override
    public ArrayNode arrayNode() {
        return new ArrayNode(this);
    }

    @Override
    public ArrayNode arrayNode(int n) {
        return new ArrayNode(this, n);
    }

    @Override
    public ObjectNode objectNode() {
        return new ObjectNode(this);
    }

    @Override
    public ValueNode pojoNode(Object object) {
        return new POJONode(object);
    }

    @Override
    public ValueNode rawValueNode(RawValue rawValue) {
        return new POJONode(rawValue);
    }

    protected boolean _inIntRange(long l) {
        int n = (int)l;
        long l2 = n;
        return l2 == l;
    }
}

