/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jdk14;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;

public class JDK14Util {
    public static String[] getRecordFieldNames(Class<?> clazz) {
        return RecordAccessor.instance().getRecordFieldNames(clazz);
    }

    public static AnnotatedConstructor findRecordConstructor(DeserializationContext deserializationContext, BeanDescription beanDescription, List<String> list) {
        return new CreatorLocator(deserializationContext, beanDescription).locate(list);
    }

    static class CreatorLocator {
        protected final BeanDescription _beanDesc;
        protected final DeserializationConfig _config;
        protected final AnnotationIntrospector _intr;
        protected final List<AnnotatedConstructor> _constructors;
        protected final AnnotatedConstructor _primaryConstructor;
        protected final RawTypeName[] _recordFields;

        CreatorLocator(DeserializationContext deserializationContext, BeanDescription beanDescription) {
            this._beanDesc = beanDescription;
            this._intr = deserializationContext.getAnnotationIntrospector();
            this._config = deserializationContext.getConfig();
            this._recordFields = RecordAccessor.instance().getRecordFields(beanDescription.getBeanClass());
            int n = this._recordFields.length;
            AnnotatedConstructor annotatedConstructor = null;
            if (n == 0) {
                annotatedConstructor = beanDescription.findDefaultConstructor();
                this._constructors = Collections.singletonList(annotatedConstructor);
            } else {
                this._constructors = beanDescription.getConstructors();
                block0: for (AnnotatedConstructor annotatedConstructor2 : this._constructors) {
                    if (annotatedConstructor2.getParameterCount() != n) continue;
                    for (int i = 0; i < n; ++i) {
                        if (!annotatedConstructor2.getRawParameterType(i).equals(this._recordFields[i].rawType)) continue block0;
                    }
                    annotatedConstructor = annotatedConstructor2;
                    break;
                }
            }
            if (annotatedConstructor == null) {
                throw new IllegalArgumentException("Failed to find the canonical Record constructor of type " + ClassUtil.getTypeDescription(this._beanDesc.getType()));
            }
            this._primaryConstructor = annotatedConstructor;
        }

        public AnnotatedConstructor locate(List<String> list) {
            for (AnnotatedConstructor annotatedConstructor : this._constructors) {
                JsonCreator.Mode mode = this._intr.findCreatorAnnotation(this._config, annotatedConstructor);
                if (null == mode || JsonCreator.Mode.DISABLED == mode) continue;
                if (JsonCreator.Mode.DELEGATING == mode) {
                    return null;
                }
                if (annotatedConstructor == this._primaryConstructor) continue;
                return null;
            }
            for (RawTypeName rawTypeName : this._recordFields) {
                list.add(rawTypeName.name);
            }
            return this._primaryConstructor;
        }
    }

    static class RawTypeName {
        public final Class<?> rawType;
        public final String name;

        public RawTypeName(Class<?> clazz, String string) {
            this.rawType = clazz;
            this.name = string;
        }
    }

    static class RecordAccessor {
        private final Method RECORD_GET_RECORD_COMPONENTS;
        private final Method RECORD_COMPONENT_GET_NAME;
        private final Method RECORD_COMPONENT_GET_TYPE;
        private static final RecordAccessor INSTANCE;
        private static final RuntimeException PROBLEM;

        private RecordAccessor() throws RuntimeException {
            try {
                this.RECORD_GET_RECORD_COMPONENTS = Class.class.getMethod("getRecordComponents", new Class[0]);
                Class<?> clazz = Class.forName("java.lang.reflect.RecordComponent");
                this.RECORD_COMPONENT_GET_NAME = clazz.getMethod("getName", new Class[0]);
                this.RECORD_COMPONENT_GET_TYPE = clazz.getMethod("getType", new Class[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(String.format("Failed to access Methods needed to support `java.lang.Record`: (%s) %s", exception.getClass().getName(), exception.getMessage()), exception);
            }
        }

        public static RecordAccessor instance() {
            if (PROBLEM != null) {
                throw PROBLEM;
            }
            return INSTANCE;
        }

        public String[] getRecordFieldNames(Class<?> clazz) throws IllegalArgumentException {
            Object[] objectArray = this.recordComponents(clazz);
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                try {
                    stringArray[i] = (String)this.RECORD_COMPONENT_GET_NAME.invoke(objectArray[i], new Object[0]);
                    continue;
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(String.format("Failed to access name of field #%d (of %d) of Record type %s", i, objectArray.length, ClassUtil.nameOf(clazz)), exception);
                }
            }
            return stringArray;
        }

        public RawTypeName[] getRecordFields(Class<?> clazz) throws IllegalArgumentException {
            Object[] objectArray = this.recordComponents(clazz);
            RawTypeName[] rawTypeNameArray = new RawTypeName[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                Class clazz2;
                String string;
                try {
                    string = (String)this.RECORD_COMPONENT_GET_NAME.invoke(objectArray[i], new Object[0]);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(String.format("Failed to access name of field #%d (of %d) of Record type %s", i, objectArray.length, ClassUtil.nameOf(clazz)), exception);
                }
                try {
                    clazz2 = (Class)this.RECORD_COMPONENT_GET_TYPE.invoke(objectArray[i], new Object[0]);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(String.format("Failed to access type of field #%d (of %d) of Record type %s", i, objectArray.length, ClassUtil.nameOf(clazz)), exception);
                }
                rawTypeNameArray[i] = new RawTypeName(clazz2, string);
            }
            return rawTypeNameArray;
        }

        protected Object[] recordComponents(Class<?> clazz) throws IllegalArgumentException {
            try {
                return (Object[])this.RECORD_GET_RECORD_COMPONENTS.invoke(clazz, new Object[0]);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to access RecordComponents of type " + ClassUtil.nameOf(clazz));
            }
        }

        static {
            RuntimeException runtimeException = null;
            RecordAccessor recordAccessor = null;
            try {
                recordAccessor = new RecordAccessor();
            }
            catch (RuntimeException runtimeException2) {
                runtimeException = runtimeException2;
            }
            INSTANCE = recordAccessor;
            PROBLEM = runtimeException;
        }
    }
}

