/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AnnotationIntrospectorPair
extends AnnotationIntrospector
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final AnnotationIntrospector _primary;
    protected final AnnotationIntrospector _secondary;

    public AnnotationIntrospectorPair(AnnotationIntrospector annotationIntrospector, AnnotationIntrospector annotationIntrospector2) {
        this._primary = annotationIntrospector;
        this._secondary = annotationIntrospector2;
    }

    @Override
    public Version version() {
        return this._primary.version();
    }

    public static AnnotationIntrospector create(AnnotationIntrospector annotationIntrospector, AnnotationIntrospector annotationIntrospector2) {
        if (annotationIntrospector == null) {
            return annotationIntrospector2;
        }
        if (annotationIntrospector2 == null) {
            return annotationIntrospector;
        }
        return new AnnotationIntrospectorPair(annotationIntrospector, annotationIntrospector2);
    }

    @Override
    public Collection<AnnotationIntrospector> allIntrospectors() {
        return this.allIntrospectors(new ArrayList<AnnotationIntrospector>());
    }

    @Override
    public Collection<AnnotationIntrospector> allIntrospectors(Collection<AnnotationIntrospector> collection) {
        this._primary.allIntrospectors(collection);
        this._secondary.allIntrospectors(collection);
        return collection;
    }

    @Override
    public boolean isAnnotationBundle(Annotation annotation) {
        return this._primary.isAnnotationBundle(annotation) || this._secondary.isAnnotationBundle(annotation);
    }

    @Override
    public PropertyName findRootName(AnnotatedClass annotatedClass) {
        PropertyName propertyName = this._primary.findRootName(annotatedClass);
        if (propertyName == null) {
            return this._secondary.findRootName(annotatedClass);
        }
        if (propertyName.hasSimpleName()) {
            return propertyName;
        }
        PropertyName propertyName2 = this._secondary.findRootName(annotatedClass);
        return propertyName2 == null ? propertyName : propertyName2;
    }

    @Override
    public JsonIgnoreProperties.Value findPropertyIgnoralByName(MapperConfig<?> mapperConfig, Annotated annotated) {
        JsonIgnoreProperties.Value value = this._secondary.findPropertyIgnoralByName(mapperConfig, annotated);
        JsonIgnoreProperties.Value value2 = this._primary.findPropertyIgnoralByName(mapperConfig, annotated);
        return value == null ? value2 : value.withOverrides(value2);
    }

    @Override
    public JsonIncludeProperties.Value findPropertyInclusionByName(MapperConfig<?> mapperConfig, Annotated annotated) {
        JsonIncludeProperties.Value value = this._secondary.findPropertyInclusionByName(mapperConfig, annotated);
        JsonIncludeProperties.Value value2 = this._primary.findPropertyInclusionByName(mapperConfig, annotated);
        return value == null ? value2 : value.withOverrides(value2);
    }

    @Override
    public Boolean isIgnorableType(AnnotatedClass annotatedClass) {
        Boolean bl = this._primary.isIgnorableType(annotatedClass);
        if (bl == null) {
            bl = this._secondary.isIgnorableType(annotatedClass);
        }
        return bl;
    }

    @Override
    public Object findFilterId(Annotated annotated) {
        Object object = this._primary.findFilterId(annotated);
        if (object == null) {
            object = this._secondary.findFilterId(annotated);
        }
        return object;
    }

    @Override
    public Object findNamingStrategy(AnnotatedClass annotatedClass) {
        Object object = this._primary.findNamingStrategy(annotatedClass);
        if (object == null) {
            object = this._secondary.findNamingStrategy(annotatedClass);
        }
        return object;
    }

    @Override
    public String findClassDescription(AnnotatedClass annotatedClass) {
        String string = this._primary.findClassDescription(annotatedClass);
        if (string == null || string.isEmpty()) {
            string = this._secondary.findClassDescription(annotatedClass);
        }
        return string;
    }

    @Override
    @Deprecated
    public String[] findPropertiesToIgnore(Annotated annotated, boolean bl) {
        String[] stringArray = this._primary.findPropertiesToIgnore(annotated, bl);
        if (stringArray == null) {
            stringArray = this._secondary.findPropertiesToIgnore(annotated, bl);
        }
        return stringArray;
    }

    @Override
    @Deprecated
    public Boolean findIgnoreUnknownProperties(AnnotatedClass annotatedClass) {
        Boolean bl = this._primary.findIgnoreUnknownProperties(annotatedClass);
        if (bl == null) {
            bl = this._secondary.findIgnoreUnknownProperties(annotatedClass);
        }
        return bl;
    }

    @Override
    @Deprecated
    public JsonIgnoreProperties.Value findPropertyIgnorals(Annotated annotated) {
        JsonIgnoreProperties.Value value = this._secondary.findPropertyIgnorals(annotated);
        JsonIgnoreProperties.Value value2 = this._primary.findPropertyIgnorals(annotated);
        return value == null ? value2 : value.withOverrides(value2);
    }

    @Override
    public VisibilityChecker<?> findAutoDetectVisibility(AnnotatedClass annotatedClass, VisibilityChecker<?> visibilityChecker) {
        visibilityChecker = this._secondary.findAutoDetectVisibility(annotatedClass, visibilityChecker);
        return this._primary.findAutoDetectVisibility(annotatedClass, visibilityChecker);
    }

    @Override
    public TypeResolverBuilder<?> findTypeResolver(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, JavaType javaType) {
        TypeResolverBuilder<?> typeResolverBuilder = this._primary.findTypeResolver(mapperConfig, annotatedClass, javaType);
        if (typeResolverBuilder == null) {
            typeResolverBuilder = this._secondary.findTypeResolver(mapperConfig, annotatedClass, javaType);
        }
        return typeResolverBuilder;
    }

    @Override
    public TypeResolverBuilder<?> findPropertyTypeResolver(MapperConfig<?> mapperConfig, AnnotatedMember annotatedMember, JavaType javaType) {
        TypeResolverBuilder<?> typeResolverBuilder = this._primary.findPropertyTypeResolver(mapperConfig, annotatedMember, javaType);
        if (typeResolverBuilder == null) {
            typeResolverBuilder = this._secondary.findPropertyTypeResolver(mapperConfig, annotatedMember, javaType);
        }
        return typeResolverBuilder;
    }

    @Override
    public TypeResolverBuilder<?> findPropertyContentTypeResolver(MapperConfig<?> mapperConfig, AnnotatedMember annotatedMember, JavaType javaType) {
        TypeResolverBuilder<?> typeResolverBuilder = this._primary.findPropertyContentTypeResolver(mapperConfig, annotatedMember, javaType);
        if (typeResolverBuilder == null) {
            typeResolverBuilder = this._secondary.findPropertyContentTypeResolver(mapperConfig, annotatedMember, javaType);
        }
        return typeResolverBuilder;
    }

    @Override
    public List<NamedType> findSubtypes(Annotated annotated) {
        List<NamedType> list = this._primary.findSubtypes(annotated);
        List<NamedType> list2 = this._secondary.findSubtypes(annotated);
        if (list == null || list.isEmpty()) {
            return list2;
        }
        if (list2 == null || list2.isEmpty()) {
            return list;
        }
        ArrayList<NamedType> arrayList = new ArrayList<NamedType>(list.size() + list2.size());
        arrayList.addAll(list);
        arrayList.addAll(list2);
        return arrayList;
    }

    @Override
    public String findTypeName(AnnotatedClass annotatedClass) {
        String string = this._primary.findTypeName(annotatedClass);
        if (string == null || string.isEmpty()) {
            string = this._secondary.findTypeName(annotatedClass);
        }
        return string;
    }

    @Override
    public AnnotationIntrospector.ReferenceProperty findReferenceType(AnnotatedMember annotatedMember) {
        AnnotationIntrospector.ReferenceProperty referenceProperty = this._primary.findReferenceType(annotatedMember);
        return referenceProperty == null ? this._secondary.findReferenceType(annotatedMember) : referenceProperty;
    }

    @Override
    public NameTransformer findUnwrappingNameTransformer(AnnotatedMember annotatedMember) {
        NameTransformer nameTransformer = this._primary.findUnwrappingNameTransformer(annotatedMember);
        return nameTransformer == null ? this._secondary.findUnwrappingNameTransformer(annotatedMember) : nameTransformer;
    }

    @Override
    public JacksonInject.Value findInjectableValue(AnnotatedMember annotatedMember) {
        JacksonInject.Value value;
        JacksonInject.Value value2 = this._primary.findInjectableValue(annotatedMember);
        if ((value2 == null || value2.getUseInput() == null) && (value = this._secondary.findInjectableValue(annotatedMember)) != null) {
            value2 = value2 == null ? value : value2.withUseInput(value.getUseInput());
        }
        return value2;
    }

    @Override
    public boolean hasIgnoreMarker(AnnotatedMember annotatedMember) {
        return this._primary.hasIgnoreMarker(annotatedMember) || this._secondary.hasIgnoreMarker(annotatedMember);
    }

    @Override
    public Boolean hasRequiredMarker(AnnotatedMember annotatedMember) {
        Boolean bl = this._primary.hasRequiredMarker(annotatedMember);
        return bl == null ? this._secondary.hasRequiredMarker(annotatedMember) : bl;
    }

    @Override
    @Deprecated
    public Object findInjectableValueId(AnnotatedMember annotatedMember) {
        Object object = this._primary.findInjectableValueId(annotatedMember);
        return object == null ? this._secondary.findInjectableValueId(annotatedMember) : object;
    }

    @Override
    public Object findSerializer(Annotated annotated) {
        Object object = this._primary.findSerializer(annotated);
        if (this._isExplicitClassOrOb(object, JsonSerializer.None.class)) {
            return object;
        }
        return this._explicitClassOrOb(this._secondary.findSerializer(annotated), JsonSerializer.None.class);
    }

    @Override
    public Object findKeySerializer(Annotated annotated) {
        Object object = this._primary.findKeySerializer(annotated);
        if (this._isExplicitClassOrOb(object, JsonSerializer.None.class)) {
            return object;
        }
        return this._explicitClassOrOb(this._secondary.findKeySerializer(annotated), JsonSerializer.None.class);
    }

    @Override
    public Object findContentSerializer(Annotated annotated) {
        Object object = this._primary.findContentSerializer(annotated);
        if (this._isExplicitClassOrOb(object, JsonSerializer.None.class)) {
            return object;
        }
        return this._explicitClassOrOb(this._secondary.findContentSerializer(annotated), JsonSerializer.None.class);
    }

    @Override
    public Object findNullSerializer(Annotated annotated) {
        Object object = this._primary.findNullSerializer(annotated);
        if (this._isExplicitClassOrOb(object, JsonSerializer.None.class)) {
            return object;
        }
        return this._explicitClassOrOb(this._secondary.findNullSerializer(annotated), JsonSerializer.None.class);
    }

    @Override
    @Deprecated
    public JsonInclude.Include findSerializationInclusion(Annotated annotated, JsonInclude.Include include) {
        include = this._secondary.findSerializationInclusion(annotated, include);
        include = this._primary.findSerializationInclusion(annotated, include);
        return include;
    }

    @Override
    @Deprecated
    public JsonInclude.Include findSerializationInclusionForContent(Annotated annotated, JsonInclude.Include include) {
        include = this._secondary.findSerializationInclusionForContent(annotated, include);
        include = this._primary.findSerializationInclusionForContent(annotated, include);
        return include;
    }

    @Override
    public JsonInclude.Value findPropertyInclusion(Annotated annotated) {
        JsonInclude.Value value = this._secondary.findPropertyInclusion(annotated);
        JsonInclude.Value value2 = this._primary.findPropertyInclusion(annotated);
        if (value == null) {
            return value2;
        }
        return value.withOverrides(value2);
    }

    @Override
    public JsonSerialize.Typing findSerializationTyping(Annotated annotated) {
        JsonSerialize.Typing typing = this._primary.findSerializationTyping(annotated);
        return typing == null ? this._secondary.findSerializationTyping(annotated) : typing;
    }

    @Override
    public Object findSerializationConverter(Annotated annotated) {
        Object object = this._primary.findSerializationConverter(annotated);
        return object == null ? this._secondary.findSerializationConverter(annotated) : object;
    }

    @Override
    public Object findSerializationContentConverter(AnnotatedMember annotatedMember) {
        Object object = this._primary.findSerializationContentConverter(annotatedMember);
        return object == null ? this._secondary.findSerializationContentConverter(annotatedMember) : object;
    }

    @Override
    public Class<?>[] findViews(Annotated annotated) {
        Class<?>[] classArray = this._primary.findViews(annotated);
        if (classArray == null) {
            classArray = this._secondary.findViews(annotated);
        }
        return classArray;
    }

    @Override
    public Boolean isTypeId(AnnotatedMember annotatedMember) {
        Boolean bl = this._primary.isTypeId(annotatedMember);
        return bl == null ? this._secondary.isTypeId(annotatedMember) : bl;
    }

    @Override
    public ObjectIdInfo findObjectIdInfo(Annotated annotated) {
        ObjectIdInfo objectIdInfo = this._primary.findObjectIdInfo(annotated);
        return objectIdInfo == null ? this._secondary.findObjectIdInfo(annotated) : objectIdInfo;
    }

    @Override
    public ObjectIdInfo findObjectReferenceInfo(Annotated annotated, ObjectIdInfo objectIdInfo) {
        objectIdInfo = this._secondary.findObjectReferenceInfo(annotated, objectIdInfo);
        objectIdInfo = this._primary.findObjectReferenceInfo(annotated, objectIdInfo);
        return objectIdInfo;
    }

    @Override
    public JsonFormat.Value findFormat(Annotated annotated) {
        JsonFormat.Value value = this._primary.findFormat(annotated);
        JsonFormat.Value value2 = this._secondary.findFormat(annotated);
        if (value2 == null) {
            return value;
        }
        return value2.withOverrides(value);
    }

    @Override
    public PropertyName findWrapperName(Annotated annotated) {
        PropertyName propertyName;
        PropertyName propertyName2 = this._primary.findWrapperName(annotated);
        if (propertyName2 == null) {
            propertyName2 = this._secondary.findWrapperName(annotated);
        } else if (propertyName2 == PropertyName.USE_DEFAULT && (propertyName = this._secondary.findWrapperName(annotated)) != null) {
            propertyName2 = propertyName;
        }
        return propertyName2;
    }

    @Override
    public String findPropertyDefaultValue(Annotated annotated) {
        String string = this._primary.findPropertyDefaultValue(annotated);
        return string == null || string.isEmpty() ? this._secondary.findPropertyDefaultValue(annotated) : string;
    }

    @Override
    public String findPropertyDescription(Annotated annotated) {
        String string = this._primary.findPropertyDescription(annotated);
        return string == null ? this._secondary.findPropertyDescription(annotated) : string;
    }

    @Override
    public Integer findPropertyIndex(Annotated annotated) {
        Integer n = this._primary.findPropertyIndex(annotated);
        return n == null ? this._secondary.findPropertyIndex(annotated) : n;
    }

    @Override
    public String findImplicitPropertyName(AnnotatedMember annotatedMember) {
        String string = this._primary.findImplicitPropertyName(annotatedMember);
        return string == null ? this._secondary.findImplicitPropertyName(annotatedMember) : string;
    }

    @Override
    public List<PropertyName> findPropertyAliases(Annotated annotated) {
        List<PropertyName> list = this._primary.findPropertyAliases(annotated);
        return list == null ? this._secondary.findPropertyAliases(annotated) : list;
    }

    @Override
    public JsonProperty.Access findPropertyAccess(Annotated annotated) {
        JsonProperty.Access access = this._primary.findPropertyAccess(annotated);
        if (access != null && access != JsonProperty.Access.AUTO) {
            return access;
        }
        access = this._secondary.findPropertyAccess(annotated);
        if (access != null) {
            return access;
        }
        return JsonProperty.Access.AUTO;
    }

    @Override
    public AnnotatedMethod resolveSetterConflict(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, AnnotatedMethod annotatedMethod2) {
        AnnotatedMethod annotatedMethod3 = this._primary.resolveSetterConflict(mapperConfig, annotatedMethod, annotatedMethod2);
        if (annotatedMethod3 == null) {
            annotatedMethod3 = this._secondary.resolveSetterConflict(mapperConfig, annotatedMethod, annotatedMethod2);
        }
        return annotatedMethod3;
    }

    @Override
    public PropertyName findRenameByField(MapperConfig<?> mapperConfig, AnnotatedField annotatedField, PropertyName propertyName) {
        PropertyName propertyName2 = this._secondary.findRenameByField(mapperConfig, annotatedField, propertyName);
        if (propertyName2 == null) {
            propertyName2 = this._primary.findRenameByField(mapperConfig, annotatedField, propertyName);
        }
        return propertyName2;
    }

    @Override
    public JavaType refineSerializationType(MapperConfig<?> mapperConfig, Annotated annotated, JavaType javaType) throws JsonMappingException {
        JavaType javaType2 = this._secondary.refineSerializationType(mapperConfig, annotated, javaType);
        return this._primary.refineSerializationType(mapperConfig, annotated, javaType2);
    }

    @Override
    @Deprecated
    public Class<?> findSerializationType(Annotated annotated) {
        Class<?> clazz = this._primary.findSerializationType(annotated);
        return clazz == null ? this._secondary.findSerializationType(annotated) : clazz;
    }

    @Override
    @Deprecated
    public Class<?> findSerializationKeyType(Annotated annotated, JavaType javaType) {
        Class<?> clazz = this._primary.findSerializationKeyType(annotated, javaType);
        return clazz == null ? this._secondary.findSerializationKeyType(annotated, javaType) : clazz;
    }

    @Override
    @Deprecated
    public Class<?> findSerializationContentType(Annotated annotated, JavaType javaType) {
        Class<?> clazz = this._primary.findSerializationContentType(annotated, javaType);
        return clazz == null ? this._secondary.findSerializationContentType(annotated, javaType) : clazz;
    }

    @Override
    public String[] findSerializationPropertyOrder(AnnotatedClass annotatedClass) {
        String[] stringArray = this._primary.findSerializationPropertyOrder(annotatedClass);
        return stringArray == null ? this._secondary.findSerializationPropertyOrder(annotatedClass) : stringArray;
    }

    @Override
    public Boolean findSerializationSortAlphabetically(Annotated annotated) {
        Boolean bl = this._primary.findSerializationSortAlphabetically(annotated);
        return bl == null ? this._secondary.findSerializationSortAlphabetically(annotated) : bl;
    }

    @Override
    public void findAndAddVirtualProperties(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, List<BeanPropertyWriter> list) {
        this._primary.findAndAddVirtualProperties(mapperConfig, annotatedClass, list);
        this._secondary.findAndAddVirtualProperties(mapperConfig, annotatedClass, list);
    }

    @Override
    public PropertyName findNameForSerialization(Annotated annotated) {
        PropertyName propertyName;
        PropertyName propertyName2 = this._primary.findNameForSerialization(annotated);
        if (propertyName2 == null) {
            propertyName2 = this._secondary.findNameForSerialization(annotated);
        } else if (propertyName2 == PropertyName.USE_DEFAULT && (propertyName = this._secondary.findNameForSerialization(annotated)) != null) {
            propertyName2 = propertyName;
        }
        return propertyName2;
    }

    @Override
    public Boolean hasAsKey(MapperConfig<?> mapperConfig, Annotated annotated) {
        Boolean bl = this._primary.hasAsKey(mapperConfig, annotated);
        if (bl == null) {
            bl = this._secondary.hasAsKey(mapperConfig, annotated);
        }
        return bl;
    }

    @Override
    public Boolean hasAsValue(Annotated annotated) {
        Boolean bl = this._primary.hasAsValue(annotated);
        if (bl == null) {
            bl = this._secondary.hasAsValue(annotated);
        }
        return bl;
    }

    @Override
    public Boolean hasAnyGetter(Annotated annotated) {
        Boolean bl = this._primary.hasAnyGetter(annotated);
        if (bl == null) {
            bl = this._secondary.hasAnyGetter(annotated);
        }
        return bl;
    }

    @Override
    public String[] findEnumValues(Class<?> clazz, Enum<?>[] enumArray, String[] stringArray) {
        stringArray = this._secondary.findEnumValues(clazz, enumArray, stringArray);
        stringArray = this._primary.findEnumValues(clazz, enumArray, stringArray);
        return stringArray;
    }

    @Override
    public void findEnumAliases(Class<?> clazz, Enum<?>[] enumArray, String[][] stringArray) {
        this._secondary.findEnumAliases(clazz, enumArray, stringArray);
        this._primary.findEnumAliases(clazz, enumArray, stringArray);
    }

    @Override
    public Enum<?> findDefaultEnumValue(Class<Enum<?>> clazz) {
        Enum<?> enum_ = this._primary.findDefaultEnumValue(clazz);
        return enum_ == null ? this._secondary.findDefaultEnumValue(clazz) : enum_;
    }

    @Override
    @Deprecated
    public String findEnumValue(Enum<?> enum_) {
        String string = this._primary.findEnumValue(enum_);
        return string == null ? this._secondary.findEnumValue(enum_) : string;
    }

    @Override
    @Deprecated
    public boolean hasAsValueAnnotation(AnnotatedMethod annotatedMethod) {
        return this._primary.hasAsValueAnnotation(annotatedMethod) || this._secondary.hasAsValueAnnotation(annotatedMethod);
    }

    @Override
    @Deprecated
    public boolean hasAnyGetterAnnotation(AnnotatedMethod annotatedMethod) {
        return this._primary.hasAnyGetterAnnotation(annotatedMethod) || this._secondary.hasAnyGetterAnnotation(annotatedMethod);
    }

    @Override
    public Object findDeserializer(Annotated annotated) {
        Object object = this._primary.findDeserializer(annotated);
        if (this._isExplicitClassOrOb(object, JsonDeserializer.None.class)) {
            return object;
        }
        return this._explicitClassOrOb(this._secondary.findDeserializer(annotated), JsonDeserializer.None.class);
    }

    @Override
    public Object findKeyDeserializer(Annotated annotated) {
        Object object = this._primary.findKeyDeserializer(annotated);
        if (this._isExplicitClassOrOb(object, KeyDeserializer.None.class)) {
            return object;
        }
        return this._explicitClassOrOb(this._secondary.findKeyDeserializer(annotated), KeyDeserializer.None.class);
    }

    @Override
    public Object findContentDeserializer(Annotated annotated) {
        Object object = this._primary.findContentDeserializer(annotated);
        if (this._isExplicitClassOrOb(object, JsonDeserializer.None.class)) {
            return object;
        }
        return this._explicitClassOrOb(this._secondary.findContentDeserializer(annotated), JsonDeserializer.None.class);
    }

    @Override
    public Object findDeserializationConverter(Annotated annotated) {
        Object object = this._primary.findDeserializationConverter(annotated);
        return object == null ? this._secondary.findDeserializationConverter(annotated) : object;
    }

    @Override
    public Object findDeserializationContentConverter(AnnotatedMember annotatedMember) {
        Object object = this._primary.findDeserializationContentConverter(annotatedMember);
        return object == null ? this._secondary.findDeserializationContentConverter(annotatedMember) : object;
    }

    @Override
    public JavaType refineDeserializationType(MapperConfig<?> mapperConfig, Annotated annotated, JavaType javaType) throws JsonMappingException {
        JavaType javaType2 = this._secondary.refineDeserializationType(mapperConfig, annotated, javaType);
        return this._primary.refineDeserializationType(mapperConfig, annotated, javaType2);
    }

    @Override
    @Deprecated
    public Class<?> findDeserializationType(Annotated annotated, JavaType javaType) {
        Class<?> clazz = this._primary.findDeserializationType(annotated, javaType);
        return clazz != null ? clazz : this._secondary.findDeserializationType(annotated, javaType);
    }

    @Override
    @Deprecated
    public Class<?> findDeserializationKeyType(Annotated annotated, JavaType javaType) {
        Class<?> clazz = this._primary.findDeserializationKeyType(annotated, javaType);
        return clazz == null ? this._secondary.findDeserializationKeyType(annotated, javaType) : clazz;
    }

    @Override
    @Deprecated
    public Class<?> findDeserializationContentType(Annotated annotated, JavaType javaType) {
        Class<?> clazz = this._primary.findDeserializationContentType(annotated, javaType);
        return clazz == null ? this._secondary.findDeserializationContentType(annotated, javaType) : clazz;
    }

    @Override
    public Object findValueInstantiator(AnnotatedClass annotatedClass) {
        Object object = this._primary.findValueInstantiator(annotatedClass);
        return object == null ? this._secondary.findValueInstantiator(annotatedClass) : object;
    }

    @Override
    public Class<?> findPOJOBuilder(AnnotatedClass annotatedClass) {
        Class<?> clazz = this._primary.findPOJOBuilder(annotatedClass);
        return clazz == null ? this._secondary.findPOJOBuilder(annotatedClass) : clazz;
    }

    @Override
    public JsonPOJOBuilder.Value findPOJOBuilderConfig(AnnotatedClass annotatedClass) {
        JsonPOJOBuilder.Value value = this._primary.findPOJOBuilderConfig(annotatedClass);
        return value == null ? this._secondary.findPOJOBuilderConfig(annotatedClass) : value;
    }

    @Override
    public PropertyName findNameForDeserialization(Annotated annotated) {
        PropertyName propertyName;
        PropertyName propertyName2 = this._primary.findNameForDeserialization(annotated);
        if (propertyName2 == null) {
            propertyName2 = this._secondary.findNameForDeserialization(annotated);
        } else if (propertyName2 == PropertyName.USE_DEFAULT && (propertyName = this._secondary.findNameForDeserialization(annotated)) != null) {
            propertyName2 = propertyName;
        }
        return propertyName2;
    }

    @Override
    public Boolean hasAnySetter(Annotated annotated) {
        Boolean bl = this._primary.hasAnySetter(annotated);
        if (bl == null) {
            bl = this._secondary.hasAnySetter(annotated);
        }
        return bl;
    }

    @Override
    public JsonSetter.Value findSetterInfo(Annotated annotated) {
        JsonSetter.Value value = this._secondary.findSetterInfo(annotated);
        JsonSetter.Value value2 = this._primary.findSetterInfo(annotated);
        return value == null ? value2 : value.withOverrides(value2);
    }

    @Override
    public Boolean findMergeInfo(Annotated annotated) {
        Boolean bl = this._primary.findMergeInfo(annotated);
        if (bl == null) {
            bl = this._secondary.findMergeInfo(annotated);
        }
        return bl;
    }

    @Override
    @Deprecated
    public boolean hasCreatorAnnotation(Annotated annotated) {
        return this._primary.hasCreatorAnnotation(annotated) || this._secondary.hasCreatorAnnotation(annotated);
    }

    @Override
    @Deprecated
    public JsonCreator.Mode findCreatorBinding(Annotated annotated) {
        JsonCreator.Mode mode = this._primary.findCreatorBinding(annotated);
        if (mode != null) {
            return mode;
        }
        return this._secondary.findCreatorBinding(annotated);
    }

    @Override
    public JsonCreator.Mode findCreatorAnnotation(MapperConfig<?> mapperConfig, Annotated annotated) {
        JsonCreator.Mode mode = this._primary.findCreatorAnnotation(mapperConfig, annotated);
        return mode == null ? this._secondary.findCreatorAnnotation(mapperConfig, annotated) : mode;
    }

    @Override
    @Deprecated
    public boolean hasAnySetterAnnotation(AnnotatedMethod annotatedMethod) {
        return this._primary.hasAnySetterAnnotation(annotatedMethod) || this._secondary.hasAnySetterAnnotation(annotatedMethod);
    }

    protected boolean _isExplicitClassOrOb(Object object, Class<?> clazz) {
        if (object == null || object == clazz) {
            return false;
        }
        if (object instanceof Class) {
            return !ClassUtil.isBogusClass((Class)object);
        }
        return true;
    }

    protected Object _explicitClassOrOb(Object object, Class<?> clazz) {
        if (object == null || object == clazz) {
            return null;
        }
        if (object instanceof Class && ClassUtil.isBogusClass((Class)object)) {
            return null;
        }
        return object;
    }
}

