/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotationCollector;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.fasterxml.jackson.databind.introspect.CollectorBase;
import com.fasterxml.jackson.databind.introspect.MemberKey;
import com.fasterxml.jackson.databind.introspect.MethodGenericTypeResolver;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class AnnotatedCreatorCollector
extends CollectorBase {
    private final TypeResolutionContext _typeContext;
    private final boolean _collectAnnotations;
    private AnnotatedConstructor _defaultConstructor;

    AnnotatedCreatorCollector(AnnotationIntrospector annotationIntrospector, TypeResolutionContext typeResolutionContext, boolean bl) {
        super(annotationIntrospector);
        this._typeContext = typeResolutionContext;
        this._collectAnnotations = bl;
    }

    public static AnnotatedClass.Creators collectCreators(AnnotationIntrospector annotationIntrospector, TypeFactory typeFactory, TypeResolutionContext typeResolutionContext, JavaType javaType, Class<?> clazz, boolean bl) {
        return new AnnotatedCreatorCollector(annotationIntrospector, typeResolutionContext, bl |= clazz != null).collect(typeFactory, javaType, clazz);
    }

    AnnotatedClass.Creators collect(TypeFactory typeFactory, JavaType javaType, Class<?> clazz) {
        List<AnnotatedConstructor> list = this._findPotentialConstructors(javaType, clazz);
        List<AnnotatedMethod> list2 = this._findPotentialFactories(typeFactory, javaType, clazz);
        if (this._collectAnnotations) {
            if (this._defaultConstructor != null && this._intr.hasIgnoreMarker(this._defaultConstructor)) {
                this._defaultConstructor = null;
            }
            int n = list.size();
            while (--n >= 0) {
                if (!this._intr.hasIgnoreMarker(list.get(n))) continue;
                list.remove(n);
            }
            n = list2.size();
            while (--n >= 0) {
                if (!this._intr.hasIgnoreMarker(list2.get(n))) continue;
                list2.remove(n);
            }
        }
        return new AnnotatedClass.Creators(this._defaultConstructor, list, list2);
    }

    private List<AnnotatedConstructor> _findPotentialConstructors(JavaType javaType, Class<?> clazz) {
        int n;
        int n2;
        Object object;
        ClassUtil.Ctor ctor = null;
        ArrayList<ClassUtil.Ctor> arrayList = null;
        if (!javaType.isEnumType()) {
            object = ClassUtil.getConstructors(javaType.getRawClass());
            Object object2 = object;
            n2 = ((ClassUtil.Ctor[])object2).length;
            for (int i = 0; i < n2; ++i) {
                ClassUtil.Ctor ctor2 = object2[i];
                if (!AnnotatedCreatorCollector.isIncludableConstructor(ctor2.getConstructor())) continue;
                if (ctor2.getParamCount() == 0) {
                    ctor = ctor2;
                    continue;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<ClassUtil.Ctor>();
                }
                arrayList.add(ctor2);
            }
        }
        if (arrayList == null) {
            object = Collections.emptyList();
            if (ctor == null) {
                return object;
            }
            n = 0;
        } else {
            n = arrayList.size();
            object = new ArrayList(n);
            for (n2 = 0; n2 < n; ++n2) {
                object.add(null);
            }
        }
        if (clazz != null) {
            MemberKey[] memberKeyArray = null;
            block2: for (ClassUtil.Ctor ctor3 : ClassUtil.getConstructors(clazz)) {
                if (ctor3.getParamCount() == 0) {
                    if (ctor == null) continue;
                    this._defaultConstructor = this.constructDefaultConstructor(ctor, ctor3);
                    ctor = null;
                    continue;
                }
                if (arrayList == null) continue;
                if (memberKeyArray == null) {
                    memberKeyArray = new MemberKey[n];
                    for (int i = 0; i < n; ++i) {
                        memberKeyArray[i] = new MemberKey(((ClassUtil.Ctor)arrayList.get(i)).getConstructor());
                    }
                }
                MemberKey memberKey = new MemberKey(ctor3.getConstructor());
                for (int i = 0; i < n; ++i) {
                    if (!memberKey.equals(memberKeyArray[i])) continue;
                    object.set(i, this.constructNonDefaultConstructor((ClassUtil.Ctor)arrayList.get(i), ctor3));
                    continue block2;
                }
            }
        }
        if (ctor != null) {
            this._defaultConstructor = this.constructDefaultConstructor(ctor, null);
        }
        for (int i = 0; i < n; ++i) {
            AnnotatedConstructor annotatedConstructor = (AnnotatedConstructor)object.get(i);
            if (annotatedConstructor != null) continue;
            object.set(i, this.constructNonDefaultConstructor((ClassUtil.Ctor)arrayList.get(i), null));
        }
        return object;
    }

    private List<AnnotatedMethod> _findPotentialFactories(TypeFactory typeFactory, JavaType javaType, Class<?> clazz) {
        ArrayList<Method> arrayList = null;
        for (Method i : ClassUtil.getClassMethods(javaType.getRawClass())) {
            if (!AnnotatedCreatorCollector._isIncludableFactoryMethod(i)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Method>();
            }
            arrayList.add(i);
        }
        if (arrayList == null) {
            return Collections.emptyList();
        }
        TypeResolutionContext typeResolutionContext = this._typeContext;
        int n = arrayList.size();
        ArrayList<AnnotatedMethod> arrayList2 = new ArrayList<AnnotatedMethod>(n);
        for (int memberKeyArray = 0; memberKeyArray < n; ++memberKeyArray) {
            arrayList2.add(null);
        }
        if (clazz != null) {
            MemberKey[] i = null;
            block2: for (Method method : clazz.getDeclaredMethods()) {
                if (!AnnotatedCreatorCollector._isIncludableFactoryMethod(method)) continue;
                if (i == null) {
                    i = new MemberKey[n];
                    for (int j = 0; j < n; ++j) {
                        i[j] = new MemberKey((Method)arrayList.get(j));
                    }
                }
                MemberKey memberKey = new MemberKey(method);
                for (int j = 0; j < n; ++j) {
                    if (!memberKey.equals(i[j])) continue;
                    arrayList2.set(j, this.constructFactoryCreator((Method)arrayList.get(j), typeResolutionContext, method));
                    continue block2;
                }
            }
        }
        for (int i = 0; i < n; ++i) {
            AnnotatedMethod annotatedMethod = (AnnotatedMethod)arrayList2.get(i);
            if (annotatedMethod != null) continue;
            Method method = (Method)arrayList.get(i);
            TypeResolutionContext typeResolutionContext2 = MethodGenericTypeResolver.narrowMethodTypeParameters(method, javaType, typeFactory, typeResolutionContext);
            arrayList2.set(i, this.constructFactoryCreator(method, typeResolutionContext2, null));
        }
        return arrayList2;
    }

    private static boolean _isIncludableFactoryMethod(Method method) {
        return Modifier.isStatic(method.getModifiers()) && !method.isSynthetic();
    }

    protected AnnotatedConstructor constructDefaultConstructor(ClassUtil.Ctor ctor, ClassUtil.Ctor ctor2) {
        return new AnnotatedConstructor(this._typeContext, ctor.getConstructor(), this.collectAnnotations(ctor, ctor2), NO_ANNOTATION_MAPS);
    }

    protected AnnotatedConstructor constructNonDefaultConstructor(ClassUtil.Ctor ctor, ClassUtil.Ctor ctor2) {
        AnnotationMap[] annotationMapArray;
        int n = ctor.getParamCount();
        if (this._intr == null) {
            return new AnnotatedConstructor(this._typeContext, ctor.getConstructor(), AnnotatedCreatorCollector._emptyAnnotationMap(), AnnotatedCreatorCollector._emptyAnnotationMaps(n));
        }
        if (n == 0) {
            return new AnnotatedConstructor(this._typeContext, ctor.getConstructor(), this.collectAnnotations(ctor, ctor2), NO_ANNOTATION_MAPS);
        }
        Annotation[][] annotationArray = ctor.getParameterAnnotations();
        if (n != annotationArray.length) {
            annotationMapArray = null;
            Class<?> clazz = ctor.getDeclaringClass();
            if (ClassUtil.isEnumType(clazz) && n == annotationArray.length + 2) {
                Annotation[][] annotationArray2 = annotationArray;
                annotationArray = new Annotation[annotationArray2.length + 2][];
                System.arraycopy(annotationArray2, 0, annotationArray, 2, annotationArray2.length);
                annotationMapArray = this.collectAnnotations(annotationArray, (Annotation[][])null);
            } else if (clazz.isMemberClass() && n == annotationArray.length + 1) {
                Annotation[][] annotationArray3 = annotationArray;
                annotationArray = new Annotation[annotationArray3.length + 1][];
                System.arraycopy(annotationArray3, 0, annotationArray, 1, annotationArray3.length);
                annotationArray[0] = NO_ANNOTATIONS;
                annotationMapArray = this.collectAnnotations(annotationArray, (Annotation[][])null);
            }
            if (annotationMapArray == null) {
                throw new IllegalStateException(String.format("Internal error: constructor for %s has mismatch: %d parameters; %d sets of annotations", ctor.getDeclaringClass().getName(), n, annotationArray.length));
            }
        } else {
            annotationMapArray = this.collectAnnotations(annotationArray, ctor2 == null ? (Annotation[][])null : ctor2.getParameterAnnotations());
        }
        return new AnnotatedConstructor(this._typeContext, ctor.getConstructor(), this.collectAnnotations(ctor, ctor2), annotationMapArray);
    }

    protected AnnotatedMethod constructFactoryCreator(Method method, TypeResolutionContext typeResolutionContext, Method method2) {
        int n = method.getParameterTypes().length;
        if (this._intr == null) {
            return new AnnotatedMethod(typeResolutionContext, method, AnnotatedCreatorCollector._emptyAnnotationMap(), AnnotatedCreatorCollector._emptyAnnotationMaps(n));
        }
        if (n == 0) {
            return new AnnotatedMethod(typeResolutionContext, method, this.collectAnnotations(method, method2), NO_ANNOTATION_MAPS);
        }
        return new AnnotatedMethod(typeResolutionContext, method, this.collectAnnotations(method, method2), this.collectAnnotations(method.getParameterAnnotations(), method2 == null ? (Annotation[][])null : method2.getParameterAnnotations()));
    }

    private AnnotationMap[] collectAnnotations(Annotation[][] annotationArray, Annotation[][] annotationArray2) {
        if (this._collectAnnotations) {
            int n = annotationArray.length;
            AnnotationMap[] annotationMapArray = new AnnotationMap[n];
            for (int i = 0; i < n; ++i) {
                AnnotationCollector annotationCollector = this.collectAnnotations(AnnotationCollector.emptyCollector(), annotationArray[i]);
                if (annotationArray2 != null) {
                    annotationCollector = this.collectAnnotations(annotationCollector, annotationArray2[i]);
                }
                annotationMapArray[i] = annotationCollector.asAnnotationMap();
            }
            return annotationMapArray;
        }
        return NO_ANNOTATION_MAPS;
    }

    private AnnotationMap collectAnnotations(ClassUtil.Ctor ctor, ClassUtil.Ctor ctor2) {
        if (this._collectAnnotations) {
            AnnotationCollector annotationCollector = this.collectAnnotations(ctor.getDeclaredAnnotations());
            if (ctor2 != null) {
                annotationCollector = this.collectAnnotations(annotationCollector, ctor2.getDeclaredAnnotations());
            }
            return annotationCollector.asAnnotationMap();
        }
        return AnnotatedCreatorCollector._emptyAnnotationMap();
    }

    private final AnnotationMap collectAnnotations(AnnotatedElement annotatedElement, AnnotatedElement annotatedElement2) {
        AnnotationCollector annotationCollector = this.collectAnnotations(annotatedElement.getDeclaredAnnotations());
        if (annotatedElement2 != null) {
            annotationCollector = this.collectAnnotations(annotationCollector, annotatedElement2.getDeclaredAnnotations());
        }
        return annotationCollector.asAnnotationMap();
    }

    private static boolean isIncludableConstructor(Constructor<?> constructor) {
        return !constructor.isSynthetic();
    }
}

