/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.StdValueInstantiator;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.reflect.Member;
import java.util.HashMap;

public class CreatorCollector {
    protected static final int C_DEFAULT = 0;
    protected static final int C_STRING = 1;
    protected static final int C_INT = 2;
    protected static final int C_LONG = 3;
    protected static final int C_BIG_INTEGER = 4;
    protected static final int C_DOUBLE = 5;
    protected static final int C_BIG_DECIMAL = 6;
    protected static final int C_BOOLEAN = 7;
    protected static final int C_DELEGATE = 8;
    protected static final int C_PROPS = 9;
    protected static final int C_ARRAY_DELEGATE = 10;
    protected static final String[] TYPE_DESCS = new String[]{"default", "from-String", "from-int", "from-long", "from-big-integer", "from-double", "from-big-decimal", "from-boolean", "delegate", "property-based", "array-delegate"};
    protected final BeanDescription _beanDesc;
    protected final boolean _canFixAccess;
    protected final boolean _forceAccess;
    protected final AnnotatedWithParams[] _creators = new AnnotatedWithParams[11];
    protected int _explicitCreators = 0;
    protected boolean _hasNonDefaultCreator = false;
    protected SettableBeanProperty[] _delegateArgs;
    protected SettableBeanProperty[] _arrayDelegateArgs;
    protected SettableBeanProperty[] _propertyBasedArgs;

    public CreatorCollector(BeanDescription beanDescription, MapperConfig<?> mapperConfig) {
        this._beanDesc = beanDescription;
        this._canFixAccess = mapperConfig.canOverrideAccessModifiers();
        this._forceAccess = mapperConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS);
    }

    public ValueInstantiator constructValueInstantiator(DeserializationContext deserializationContext) throws JsonMappingException {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        JavaType javaType = this._computeDelegateType(deserializationContext, this._creators[8], this._delegateArgs);
        JavaType javaType2 = this._computeDelegateType(deserializationContext, this._creators[10], this._arrayDelegateArgs);
        JavaType javaType3 = this._beanDesc.getType();
        StdValueInstantiator stdValueInstantiator = new StdValueInstantiator(deserializationConfig, javaType3);
        stdValueInstantiator.configureFromObjectSettings(this._creators[0], this._creators[8], javaType, this._delegateArgs, this._creators[9], this._propertyBasedArgs);
        stdValueInstantiator.configureFromArraySettings(this._creators[10], javaType2, this._arrayDelegateArgs);
        stdValueInstantiator.configureFromStringCreator(this._creators[1]);
        stdValueInstantiator.configureFromIntCreator(this._creators[2]);
        stdValueInstantiator.configureFromLongCreator(this._creators[3]);
        stdValueInstantiator.configureFromBigIntegerCreator(this._creators[4]);
        stdValueInstantiator.configureFromDoubleCreator(this._creators[5]);
        stdValueInstantiator.configureFromBigDecimalCreator(this._creators[6]);
        stdValueInstantiator.configureFromBooleanCreator(this._creators[7]);
        return stdValueInstantiator;
    }

    public void setDefaultCreator(AnnotatedWithParams annotatedWithParams) {
        this._creators[0] = this._fixAccess(annotatedWithParams);
    }

    public void addStringCreator(AnnotatedWithParams annotatedWithParams, boolean bl) {
        this.verifyNonDup(annotatedWithParams, 1, bl);
    }

    public void addIntCreator(AnnotatedWithParams annotatedWithParams, boolean bl) {
        this.verifyNonDup(annotatedWithParams, 2, bl);
    }

    public void addLongCreator(AnnotatedWithParams annotatedWithParams, boolean bl) {
        this.verifyNonDup(annotatedWithParams, 3, bl);
    }

    public void addBigIntegerCreator(AnnotatedWithParams annotatedWithParams, boolean bl) {
        this.verifyNonDup(annotatedWithParams, 4, bl);
    }

    public void addDoubleCreator(AnnotatedWithParams annotatedWithParams, boolean bl) {
        this.verifyNonDup(annotatedWithParams, 5, bl);
    }

    public void addBigDecimalCreator(AnnotatedWithParams annotatedWithParams, boolean bl) {
        this.verifyNonDup(annotatedWithParams, 6, bl);
    }

    public void addBooleanCreator(AnnotatedWithParams annotatedWithParams, boolean bl) {
        this.verifyNonDup(annotatedWithParams, 7, bl);
    }

    public void addDelegatingCreator(AnnotatedWithParams annotatedWithParams, boolean bl, SettableBeanProperty[] settableBeanPropertyArray, int n) {
        if (annotatedWithParams.getParameterType(n).isCollectionLikeType()) {
            if (this.verifyNonDup(annotatedWithParams, 10, bl)) {
                this._arrayDelegateArgs = settableBeanPropertyArray;
            }
        } else if (this.verifyNonDup(annotatedWithParams, 8, bl)) {
            this._delegateArgs = settableBeanPropertyArray;
        }
    }

    public void addPropertyCreator(AnnotatedWithParams annotatedWithParams, boolean bl, SettableBeanProperty[] settableBeanPropertyArray) {
        if (this.verifyNonDup(annotatedWithParams, 9, bl)) {
            if (settableBeanPropertyArray.length > 1) {
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                int n = settableBeanPropertyArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer n2;
                    String string = settableBeanPropertyArray[i].getName();
                    if (string.isEmpty() && settableBeanPropertyArray[i].getInjectableValueId() != null || (n2 = hashMap.put(string, i)) == null) continue;
                    throw new IllegalArgumentException(String.format("Duplicate creator property \"%s\" (index %s vs %d) for type %s ", string, n2, i, ClassUtil.nameOf(this._beanDesc.getBeanClass())));
                }
            }
            this._propertyBasedArgs = settableBeanPropertyArray;
        }
    }

    public boolean hasDefaultCreator() {
        return this._creators[0] != null;
    }

    public boolean hasDelegatingCreator() {
        return this._creators[8] != null;
    }

    public boolean hasPropertyBasedCreator() {
        return this._creators[9] != null;
    }

    private JavaType _computeDelegateType(DeserializationContext deserializationContext, AnnotatedWithParams annotatedWithParams, SettableBeanProperty[] settableBeanPropertyArray) throws JsonMappingException {
        if (!this._hasNonDefaultCreator || annotatedWithParams == null) {
            return null;
        }
        int n = 0;
        if (settableBeanPropertyArray != null) {
            int n2 = settableBeanPropertyArray.length;
            for (int i = 0; i < n2; ++i) {
                if (settableBeanPropertyArray[i] != null) continue;
                n = i;
                break;
            }
        }
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        JavaType javaType = annotatedWithParams.getParameterType(n);
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        if (annotationIntrospector != null) {
            AnnotatedParameter annotatedParameter = annotatedWithParams.getParameter(n);
            Object object = annotationIntrospector.findDeserializer(annotatedParameter);
            if (object != null) {
                JsonDeserializer<Object> jsonDeserializer = deserializationContext.deserializerInstance(annotatedParameter, object);
                javaType = javaType.withValueHandler(jsonDeserializer);
            } else {
                javaType = annotationIntrospector.refineDeserializationType(deserializationConfig, annotatedParameter, javaType);
            }
        }
        return javaType;
    }

    private <T extends AnnotatedMember> T _fixAccess(T t2) {
        if (t2 != null && this._canFixAccess) {
            ClassUtil.checkAndFixAccess((Member)((Object)t2.getAnnotated()), this._forceAccess);
        }
        return t2;
    }

    protected boolean verifyNonDup(AnnotatedWithParams annotatedWithParams, int n, boolean bl) {
        int n2 = 1 << n;
        this._hasNonDefaultCreator = true;
        AnnotatedWithParams annotatedWithParams2 = this._creators[n];
        if (annotatedWithParams2 != null) {
            boolean bl2;
            if ((this._explicitCreators & n2) != 0) {
                if (!bl) {
                    return false;
                }
                bl2 = true;
            } else {
                boolean bl3 = bl2 = !bl;
            }
            if (bl2 && annotatedWithParams2.getClass() == annotatedWithParams.getClass()) {
                Class<?> clazz;
                Class<?> clazz2 = annotatedWithParams2.getRawParameterType(0);
                if (clazz2 == (clazz = annotatedWithParams.getRawParameterType(0))) {
                    if (this._isEnumValueOf(annotatedWithParams)) {
                        return false;
                    }
                    if (!this._isEnumValueOf(annotatedWithParams2)) {
                        this._reportDuplicateCreator(n, bl, annotatedWithParams2, annotatedWithParams);
                    }
                } else {
                    if (clazz.isAssignableFrom(clazz2)) {
                        return false;
                    }
                    if (!clazz2.isAssignableFrom(clazz)) {
                        if (clazz2.isPrimitive() != clazz.isPrimitive()) {
                            if (clazz2.isPrimitive()) {
                                return false;
                            }
                        } else {
                            this._reportDuplicateCreator(n, bl, annotatedWithParams2, annotatedWithParams);
                        }
                    }
                }
            }
        }
        if (bl) {
            this._explicitCreators |= n2;
        }
        this._creators[n] = this._fixAccess(annotatedWithParams);
        return true;
    }

    protected void _reportDuplicateCreator(int n, boolean bl, AnnotatedWithParams annotatedWithParams, AnnotatedWithParams annotatedWithParams2) {
        throw new IllegalArgumentException(String.format("Conflicting %s creators: already had %s creator %s, encountered another: %s", TYPE_DESCS[n], bl ? "explicitly marked" : "implicitly discovered", annotatedWithParams, annotatedWithParams2));
    }

    protected boolean _isEnumValueOf(AnnotatedWithParams annotatedWithParams) {
        return ClassUtil.isEnumType(annotatedWithParams.getDeclaringClass()) && "valueOf".equals(annotatedWithParams.getName());
    }
}

