/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

import com.fasterxml.jackson.core.util.BufferRecycler;
import java.io.OutputStream;
import java.util.LinkedList;

public final class ByteArrayBuilder
extends OutputStream {
    public static final byte[] NO_BYTES = new byte[0];
    private static final int INITIAL_BLOCK_SIZE = 500;
    private static final int MAX_BLOCK_SIZE = 131072;
    static final int DEFAULT_BLOCK_ARRAY_SIZE = 40;
    private final BufferRecycler _bufferRecycler;
    private final LinkedList<byte[]> _pastBlocks = new LinkedList();
    private int _pastLen;
    private byte[] _currBlock;
    private int _currBlockPtr;

    public ByteArrayBuilder() {
        this(null);
    }

    public ByteArrayBuilder(BufferRecycler bufferRecycler) {
        this(bufferRecycler, 500);
    }

    public ByteArrayBuilder(int n) {
        this(null, n);
    }

    public ByteArrayBuilder(BufferRecycler bufferRecycler, int n) {
        this._bufferRecycler = bufferRecycler;
        if (n > 131072) {
            n = 131072;
        }
        this._currBlock = bufferRecycler == null ? new byte[n] : bufferRecycler.allocByteBuffer(2);
    }

    private ByteArrayBuilder(BufferRecycler bufferRecycler, byte[] byArray, int n) {
        this._bufferRecycler = null;
        this._currBlock = byArray;
        this._currBlockPtr = n;
    }

    public static ByteArrayBuilder fromInitial(byte[] byArray, int n) {
        return new ByteArrayBuilder(null, byArray, n);
    }

    public void reset() {
        this._pastLen = 0;
        this._currBlockPtr = 0;
        if (!this._pastBlocks.isEmpty()) {
            this._pastBlocks.clear();
        }
    }

    public int size() {
        return this._pastLen + this._currBlockPtr;
    }

    public void release() {
        this.reset();
        if (this._bufferRecycler != null && this._currBlock != null) {
            this._bufferRecycler.releaseByteBuffer(2, this._currBlock);
            this._currBlock = null;
        }
    }

    public void append(int n) {
        if (this._currBlockPtr >= this._currBlock.length) {
            this._allocMore();
        }
        this._currBlock[this._currBlockPtr++] = (byte)n;
    }

    public void appendTwoBytes(int n) {
        if (this._currBlockPtr + 1 < this._currBlock.length) {
            this._currBlock[this._currBlockPtr++] = (byte)(n >> 8);
            this._currBlock[this._currBlockPtr++] = (byte)n;
        } else {
            this.append(n >> 8);
            this.append(n);
        }
    }

    public void appendThreeBytes(int n) {
        if (this._currBlockPtr + 2 < this._currBlock.length) {
            this._currBlock[this._currBlockPtr++] = (byte)(n >> 16);
            this._currBlock[this._currBlockPtr++] = (byte)(n >> 8);
            this._currBlock[this._currBlockPtr++] = (byte)n;
        } else {
            this.append(n >> 16);
            this.append(n >> 8);
            this.append(n);
        }
    }

    public void appendFourBytes(int n) {
        if (this._currBlockPtr + 3 < this._currBlock.length) {
            this._currBlock[this._currBlockPtr++] = (byte)(n >> 24);
            this._currBlock[this._currBlockPtr++] = (byte)(n >> 16);
            this._currBlock[this._currBlockPtr++] = (byte)(n >> 8);
            this._currBlock[this._currBlockPtr++] = (byte)n;
        } else {
            this.append(n >> 24);
            this.append(n >> 16);
            this.append(n >> 8);
            this.append(n);
        }
    }

    public byte[] toByteArray() {
        int n = this._pastLen + this._currBlockPtr;
        if (n == 0) {
            return NO_BYTES;
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (byte[] byArray2 : this._pastBlocks) {
            int n3 = byArray2.length;
            System.arraycopy(byArray2, 0, byArray, n2, n3);
            n2 += n3;
        }
        System.arraycopy(this._currBlock, 0, byArray, n2, this._currBlockPtr);
        if ((n2 += this._currBlockPtr) != n) {
            throw new RuntimeException("Internal error: total len assumed to be " + n + ", copied " + n2 + " bytes");
        }
        if (!this._pastBlocks.isEmpty()) {
            this.reset();
        }
        return byArray;
    }

    public byte[] resetAndGetFirstSegment() {
        this.reset();
        return this._currBlock;
    }

    public byte[] finishCurrentSegment() {
        this._allocMore();
        return this._currBlock;
    }

    public byte[] completeAndCoalesce(int n) {
        this._currBlockPtr = n;
        return this.toByteArray();
    }

    public byte[] getCurrentSegment() {
        return this._currBlock;
    }

    public void setCurrentSegmentLength(int n) {
        this._currBlockPtr = n;
    }

    public int getCurrentSegmentLength() {
        return this._currBlockPtr;
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        while (true) {
            int n3;
            int n4;
            if ((n4 = Math.min(n3 = this._currBlock.length - this._currBlockPtr, n2)) > 0) {
                System.arraycopy(byArray, n, this._currBlock, this._currBlockPtr, n4);
                n += n4;
                this._currBlockPtr += n4;
                n2 -= n4;
            }
            if (n2 <= 0) break;
            this._allocMore();
        }
    }

    @Override
    public void write(int n) {
        this.append(n);
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    private void _allocMore() {
        int n = this._pastLen + this._currBlock.length;
        if (n < 0) {
            throw new IllegalStateException("Maximum Java array size (2GB) exceeded by `ByteArrayBuilder`");
        }
        this._pastLen = n;
        int n2 = Math.max(this._pastLen >> 1, 1000);
        if (n2 > 131072) {
            n2 = 131072;
        }
        this._pastBlocks.add(this._currBlock);
        this._currBlock = new byte[n2];
        this._currBlockPtr = 0;
    }
}

