/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.sym;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.util.InternCache;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;

public final class ByteQuadsCanonicalizer {
    private static final int DEFAULT_T_SIZE = 64;
    private static final int MAX_T_SIZE = 65536;
    private static final int MIN_HASH_SIZE = 16;
    protected static final int MAX_ENTRIES_FOR_REUSE = 6000;
    protected final ByteQuadsCanonicalizer _parent;
    protected final AtomicReference<TableInfo> _tableInfo;
    protected final int _seed;
    protected final boolean _intern;
    protected final boolean _failOnDoS;
    protected int[] _hashArea;
    protected int _hashSize;
    protected int _secondaryStart;
    protected int _tertiaryStart;
    protected int _tertiaryShift;
    protected int _count;
    protected String[] _names;
    protected int _spilloverEnd;
    protected int _longNameOffset;
    protected boolean _hashShared;
    private static final int MULT = 33;
    private static final int MULT2 = 65599;
    private static final int MULT3 = 31;

    private ByteQuadsCanonicalizer(int n, int n2) {
        this._parent = null;
        this._count = 0;
        this._hashShared = true;
        this._seed = n2;
        this._intern = false;
        this._failOnDoS = true;
        if (n < 16) {
            n = 16;
        } else if ((n & n - 1) != 0) {
            int n3;
            for (n3 = 16; n3 < n; n3 += n3) {
            }
            n = n3;
        }
        this._tableInfo = new AtomicReference<TableInfo>(TableInfo.createInitial(n));
    }

    private ByteQuadsCanonicalizer(ByteQuadsCanonicalizer byteQuadsCanonicalizer, int n, TableInfo tableInfo, boolean bl, boolean bl2) {
        this._parent = byteQuadsCanonicalizer;
        this._seed = n;
        this._intern = bl;
        this._failOnDoS = bl2;
        this._tableInfo = null;
        this._count = tableInfo.count;
        this._hashSize = tableInfo.size;
        this._secondaryStart = this._hashSize << 2;
        this._tertiaryStart = this._secondaryStart + (this._secondaryStart >> 1);
        this._tertiaryShift = tableInfo.tertiaryShift;
        this._hashArea = tableInfo.mainHash;
        this._names = tableInfo.names;
        this._spilloverEnd = tableInfo.spilloverEnd;
        this._longNameOffset = tableInfo.longNameOffset;
        this._hashShared = true;
    }

    private ByteQuadsCanonicalizer(TableInfo tableInfo) {
        int n;
        this._parent = null;
        this._seed = 0;
        this._intern = false;
        this._failOnDoS = true;
        this._tableInfo = null;
        this._count = -1;
        this._hashArea = tableInfo.mainHash;
        this._names = tableInfo.names;
        this._hashSize = tableInfo.size;
        this._secondaryStart = n = this._hashArea.length;
        this._tertiaryStart = n;
        this._tertiaryShift = 1;
        this._spilloverEnd = n;
        this._longNameOffset = n;
        this._hashShared = true;
    }

    public static ByteQuadsCanonicalizer createRoot() {
        long l = System.currentTimeMillis();
        int n = (int)l + (int)(l >>> 32) | 1;
        return ByteQuadsCanonicalizer.createRoot(n);
    }

    protected static ByteQuadsCanonicalizer createRoot(int n) {
        return new ByteQuadsCanonicalizer(64, n);
    }

    public ByteQuadsCanonicalizer makeChild(int n) {
        return new ByteQuadsCanonicalizer(this, this._seed, this._tableInfo.get(), JsonFactory.Feature.INTERN_FIELD_NAMES.enabledIn(n), JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW.enabledIn(n));
    }

    public ByteQuadsCanonicalizer makeChildOrPlaceholder(int n) {
        if (JsonFactory.Feature.CANONICALIZE_FIELD_NAMES.enabledIn(n)) {
            return new ByteQuadsCanonicalizer(this, this._seed, this._tableInfo.get(), JsonFactory.Feature.INTERN_FIELD_NAMES.enabledIn(n), JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW.enabledIn(n));
        }
        return new ByteQuadsCanonicalizer(this._tableInfo.get());
    }

    public void release() {
        if (this._parent != null && this.maybeDirty()) {
            this._parent.mergeChild(new TableInfo(this));
            this._hashShared = true;
        }
    }

    private void mergeChild(TableInfo tableInfo) {
        int n = tableInfo.count;
        TableInfo tableInfo2 = this._tableInfo.get();
        if (n == tableInfo2.count) {
            return;
        }
        if (n > 6000) {
            tableInfo = TableInfo.createInitial(64);
        }
        this._tableInfo.compareAndSet(tableInfo2, tableInfo);
    }

    public int size() {
        if (this._tableInfo != null) {
            return this._tableInfo.get().count;
        }
        return this._count;
    }

    public int bucketCount() {
        return this._hashSize;
    }

    public boolean maybeDirty() {
        return !this._hashShared;
    }

    public int hashSeed() {
        return this._seed;
    }

    public boolean isCanonicalizing() {
        return this._parent != null;
    }

    public int primaryCount() {
        int n = 0;
        int n2 = this._secondaryStart;
        for (int i = 3; i < n2; i += 4) {
            if (this._hashArea[i] == 0) continue;
            ++n;
        }
        return n;
    }

    public int secondaryCount() {
        int n = 0;
        int n2 = this._tertiaryStart;
        for (int i = this._secondaryStart + 3; i < n2; i += 4) {
            if (this._hashArea[i] == 0) continue;
            ++n;
        }
        return n;
    }

    public int tertiaryCount() {
        int n;
        int n2 = 0;
        int n3 = n + this._hashSize;
        for (n = this._tertiaryStart + 3; n < n3; n += 4) {
            if (this._hashArea[n] == 0) continue;
            ++n2;
        }
        return n2;
    }

    public int spilloverCount() {
        return this._spilloverEnd - this._spilloverStart() >> 2;
    }

    public int totalCount() {
        int n = 0;
        int n2 = this._hashSize << 3;
        for (int i = 3; i < n2; i += 4) {
            if (this._hashArea[i] == 0) continue;
            ++n;
        }
        return n;
    }

    public String toString() {
        int n = this.primaryCount();
        int n2 = this.secondaryCount();
        int n3 = this.tertiaryCount();
        int n4 = this.spilloverCount();
        int n5 = this.totalCount();
        return String.format("[%s: size=%d, hashSize=%d, %d/%d/%d/%d pri/sec/ter/spill (=%s), total:%d]", this.getClass().getName(), this._count, this._hashSize, n, n2, n3, n4, n + n2 + n3 + n4, n5);
    }

    public String findName(int n) {
        int n2;
        int[] nArray = this._hashArea;
        int n3 = this._calcOffset(this.calcHash(n));
        int n4 = nArray[n3 + 3];
        if (n4 == 1) {
            if (nArray[n3] == n) {
                return this._names[n3 >> 2];
            }
        } else if (n4 == 0) {
            return null;
        }
        if ((n4 = nArray[(n2 = this._secondaryStart + (n3 >> 3 << 2)) + 3]) == 1) {
            if (nArray[n2] == n) {
                return this._names[n2 >> 2];
            }
        } else if (n4 == 0) {
            return null;
        }
        return this._findSecondary(n3, n);
    }

    public String findName(int n, int n2) {
        int n3;
        int[] nArray = this._hashArea;
        int n4 = this._calcOffset(this.calcHash(n, n2));
        int n5 = nArray[n4 + 3];
        if (n5 == 2) {
            if (n == nArray[n4] && n2 == nArray[n4 + 1]) {
                return this._names[n4 >> 2];
            }
        } else if (n5 == 0) {
            return null;
        }
        if ((n5 = nArray[(n3 = this._secondaryStart + (n4 >> 3 << 2)) + 3]) == 2) {
            if (n == nArray[n3] && n2 == nArray[n3 + 1]) {
                return this._names[n3 >> 2];
            }
        } else if (n5 == 0) {
            return null;
        }
        return this._findSecondary(n4, n, n2);
    }

    public String findName(int n, int n2, int n3) {
        int n4;
        int[] nArray = this._hashArea;
        int n5 = this._calcOffset(this.calcHash(n, n2, n3));
        int n6 = nArray[n5 + 3];
        if (n6 == 3) {
            if (n == nArray[n5] && nArray[n5 + 1] == n2 && nArray[n5 + 2] == n3) {
                return this._names[n5 >> 2];
            }
        } else if (n6 == 0) {
            return null;
        }
        if ((n6 = nArray[(n4 = this._secondaryStart + (n5 >> 3 << 2)) + 3]) == 3) {
            if (n == nArray[n4] && nArray[n4 + 1] == n2 && nArray[n4 + 2] == n3) {
                return this._names[n4 >> 2];
            }
        } else if (n6 == 0) {
            return null;
        }
        return this._findSecondary(n5, n, n2, n3);
    }

    public String findName(int[] nArray, int n) {
        if (n < 4) {
            switch (n) {
                case 3: {
                    return this.findName(nArray[0], nArray[1], nArray[2]);
                }
                case 2: {
                    return this.findName(nArray[0], nArray[1]);
                }
                case 1: {
                    return this.findName(nArray[0]);
                }
            }
            return "";
        }
        int n2 = this.calcHash(nArray, n);
        int n3 = this._calcOffset(n2);
        int[] nArray2 = this._hashArea;
        int n4 = nArray2[n3 + 3];
        if (n2 == nArray2[n3] && n4 == n && this._verifyLongName(nArray, n, nArray2[n3 + 1])) {
            return this._names[n3 >> 2];
        }
        if (n4 == 0) {
            return null;
        }
        int n5 = this._secondaryStart + (n3 >> 3 << 2);
        int n6 = nArray2[n5 + 3];
        if (n2 == nArray2[n5] && n6 == n && this._verifyLongName(nArray, n, nArray2[n5 + 1])) {
            return this._names[n5 >> 2];
        }
        return this._findSecondary(n3, n2, nArray, n);
    }

    private final int _calcOffset(int n) {
        int n2 = n & this._hashSize - 1;
        return n2 << 2;
    }

    private String _findSecondary(int n, int n2) {
        int n3;
        int[] nArray = this._hashArea;
        int n4 = 1 << this._tertiaryShift;
        int n5 = n3 + n4;
        for (n3 = this._tertiaryStart + (n >> this._tertiaryShift + 2 << this._tertiaryShift); n3 < n5; n3 += 4) {
            int n6 = nArray[n3 + 3];
            if (n2 == nArray[n3] && 1 == n6) {
                return this._names[n3 >> 2];
            }
            if (n6 != 0) continue;
            return null;
        }
        for (n3 = this._spilloverStart(); n3 < this._spilloverEnd; n3 += 4) {
            if (n2 != nArray[n3] || 1 != nArray[n3 + 3]) continue;
            return this._names[n3 >> 2];
        }
        return null;
    }

    private String _findSecondary(int n, int n2, int n3) {
        int n4;
        int[] nArray = this._hashArea;
        int n5 = 1 << this._tertiaryShift;
        int n6 = n4 + n5;
        for (n4 = this._tertiaryStart + (n >> this._tertiaryShift + 2 << this._tertiaryShift); n4 < n6; n4 += 4) {
            int n7 = nArray[n4 + 3];
            if (n2 == nArray[n4] && n3 == nArray[n4 + 1] && 2 == n7) {
                return this._names[n4 >> 2];
            }
            if (n7 != 0) continue;
            return null;
        }
        for (n4 = this._spilloverStart(); n4 < this._spilloverEnd; n4 += 4) {
            if (n2 != nArray[n4] || n3 != nArray[n4 + 1] || 2 != nArray[n4 + 3]) continue;
            return this._names[n4 >> 2];
        }
        return null;
    }

    private String _findSecondary(int n, int n2, int n3, int n4) {
        int n5;
        int[] nArray = this._hashArea;
        int n6 = 1 << this._tertiaryShift;
        int n7 = n5 + n6;
        for (n5 = this._tertiaryStart + (n >> this._tertiaryShift + 2 << this._tertiaryShift); n5 < n7; n5 += 4) {
            int n8 = nArray[n5 + 3];
            if (n2 == nArray[n5] && n3 == nArray[n5 + 1] && n4 == nArray[n5 + 2] && 3 == n8) {
                return this._names[n5 >> 2];
            }
            if (n8 != 0) continue;
            return null;
        }
        for (n5 = this._spilloverStart(); n5 < this._spilloverEnd; n5 += 4) {
            if (n2 != nArray[n5] || n3 != nArray[n5 + 1] || n4 != nArray[n5 + 2] || 3 != nArray[n5 + 3]) continue;
            return this._names[n5 >> 2];
        }
        return null;
    }

    private String _findSecondary(int n, int n2, int[] nArray, int n3) {
        int n4;
        int[] nArray2 = this._hashArea;
        int n5 = 1 << this._tertiaryShift;
        int n6 = n4 + n5;
        for (n4 = this._tertiaryStart + (n >> this._tertiaryShift + 2 << this._tertiaryShift); n4 < n6; n4 += 4) {
            int n7 = nArray2[n4 + 3];
            if (n2 == nArray2[n4] && n3 == n7 && this._verifyLongName(nArray, n3, nArray2[n4 + 1])) {
                return this._names[n4 >> 2];
            }
            if (n7 != 0) continue;
            return null;
        }
        for (n4 = this._spilloverStart(); n4 < this._spilloverEnd; n4 += 4) {
            if (n2 != nArray2[n4] || n3 != nArray2[n4 + 3] || !this._verifyLongName(nArray, n3, nArray2[n4 + 1])) continue;
            return this._names[n4 >> 2];
        }
        return null;
    }

    private boolean _verifyLongName(int[] nArray, int n, int n2) {
        int[] nArray2 = this._hashArea;
        int n3 = 0;
        switch (n) {
            default: {
                return this._verifyLongName2(nArray, n, n2);
            }
            case 8: {
                if (nArray[n3++] != nArray2[n2++]) {
                    return false;
                }
            }
            case 7: {
                if (nArray[n3++] != nArray2[n2++]) {
                    return false;
                }
            }
            case 6: {
                if (nArray[n3++] != nArray2[n2++]) {
                    return false;
                }
            }
            case 5: {
                if (nArray[n3++] == nArray2[n2++]) break;
                return false;
            }
            case 4: 
        }
        if (nArray[n3++] != nArray2[n2++]) {
            return false;
        }
        if (nArray[n3++] != nArray2[n2++]) {
            return false;
        }
        if (nArray[n3++] != nArray2[n2++]) {
            return false;
        }
        return nArray[n3++] == nArray2[n2++];
    }

    private boolean _verifyLongName2(int[] nArray, int n, int n2) {
        int n3 = 0;
        do {
            if (nArray[n3++] == this._hashArea[n2++]) continue;
            return false;
        } while (n3 < n);
        return true;
    }

    public String addName(String string, int n) {
        this._verifySharing();
        if (this._intern) {
            string = InternCache.instance.intern(string);
        }
        int n2 = this._findOffsetForAdd(this.calcHash(n));
        this._hashArea[n2] = n;
        this._hashArea[n2 + 3] = 1;
        this._names[n2 >> 2] = string;
        ++this._count;
        return string;
    }

    public String addName(String string, int n, int n2) {
        this._verifySharing();
        if (this._intern) {
            string = InternCache.instance.intern(string);
        }
        int n3 = this.calcHash(n, n2);
        int n4 = this._findOffsetForAdd(n3);
        this._hashArea[n4] = n;
        this._hashArea[n4 + 1] = n2;
        this._hashArea[n4 + 3] = 2;
        this._names[n4 >> 2] = string;
        ++this._count;
        return string;
    }

    public String addName(String string, int n, int n2, int n3) {
        this._verifySharing();
        if (this._intern) {
            string = InternCache.instance.intern(string);
        }
        int n4 = this._findOffsetForAdd(this.calcHash(n, n2, n3));
        this._hashArea[n4] = n;
        this._hashArea[n4 + 1] = n2;
        this._hashArea[n4 + 2] = n3;
        this._hashArea[n4 + 3] = 3;
        this._names[n4 >> 2] = string;
        ++this._count;
        return string;
    }

    public String addName(String string, int[] nArray, int n) {
        this._verifySharing();
        if (this._intern) {
            string = InternCache.instance.intern(string);
        }
        switch (n) {
            case 1: {
                int n2 = this._findOffsetForAdd(this.calcHash(nArray[0]));
                this._hashArea[n2] = nArray[0];
                this._hashArea[n2 + 3] = 1;
                break;
            }
            case 2: {
                int n2 = this._findOffsetForAdd(this.calcHash(nArray[0], nArray[1]));
                this._hashArea[n2] = nArray[0];
                this._hashArea[n2 + 1] = nArray[1];
                this._hashArea[n2 + 3] = 2;
                break;
            }
            case 3: {
                int n2 = this._findOffsetForAdd(this.calcHash(nArray[0], nArray[1], nArray[2]));
                this._hashArea[n2] = nArray[0];
                this._hashArea[n2 + 1] = nArray[1];
                this._hashArea[n2 + 2] = nArray[2];
                this._hashArea[n2 + 3] = 3;
                break;
            }
            default: {
                int n3;
                int n4 = this.calcHash(nArray, n);
                int n2 = this._findOffsetForAdd(n4);
                this._hashArea[n2] = n4;
                this._hashArea[n2 + 1] = n3 = this._appendLongName(nArray, n);
                this._hashArea[n2 + 3] = n;
            }
        }
        this._names[n2 >> 2] = string;
        ++this._count;
        return string;
    }

    private void _verifySharing() {
        if (this._hashShared) {
            if (this._parent == null) {
                if (this._count == 0) {
                    throw new IllegalStateException("Cannot add names to Root symbol table");
                }
                throw new IllegalStateException("Cannot add names to Placeholder symbol table");
            }
            this._hashArea = Arrays.copyOf(this._hashArea, this._hashArea.length);
            this._names = Arrays.copyOf(this._names, this._names.length);
            this._hashShared = false;
        }
    }

    private int _findOffsetForAdd(int n) {
        int[] nArray = this._hashArea;
        int n2 = this._calcOffset(n);
        if (nArray[n2 + 3] == 0) {
            return n2;
        }
        if (this._checkNeedForRehash()) {
            return this._resizeAndFindOffsetForAdd(n);
        }
        int n3 = this._secondaryStart + (n2 >> 3 << 2);
        if (nArray[n3 + 3] == 0) {
            return n3;
        }
        int n4 = 1 << this._tertiaryShift;
        int n5 = n3 + n4;
        for (n3 = this._tertiaryStart + (n2 >> this._tertiaryShift + 2 << this._tertiaryShift); n3 < n5; n3 += 4) {
            if (nArray[n3 + 3] != 0) continue;
            return n3;
        }
        n2 = this._spilloverEnd;
        this._spilloverEnd += 4;
        n5 = this._hashSize << 3;
        if (this._spilloverEnd >= n5) {
            if (this._failOnDoS) {
                this._reportTooManyCollisions();
            }
            return this._resizeAndFindOffsetForAdd(n);
        }
        return n2;
    }

    private int _resizeAndFindOffsetForAdd(int n) {
        this.rehash();
        int n2 = this._calcOffset(n);
        int[] nArray = this._hashArea;
        if (nArray[n2 + 3] == 0) {
            return n2;
        }
        int n3 = this._secondaryStart + (n2 >> 3 << 2);
        if (nArray[n3 + 3] == 0) {
            return n3;
        }
        int n4 = 1 << this._tertiaryShift;
        int n5 = n3 + n4;
        for (n3 = this._tertiaryStart + (n2 >> this._tertiaryShift + 2 << this._tertiaryShift); n3 < n5; n3 += 4) {
            if (nArray[n3 + 3] != 0) continue;
            return n3;
        }
        n2 = this._spilloverEnd;
        this._spilloverEnd += 4;
        return n2;
    }

    private boolean _checkNeedForRehash() {
        int n;
        return this._count > this._hashSize >> 1 && ((n = this._spilloverEnd - this._spilloverStart() >> 2) > 1 + this._count >> 7 || (double)this._count > (double)this._hashSize * 0.8);
    }

    private int _appendLongName(int[] nArray, int n) {
        int n2 = this._longNameOffset;
        if (n2 + n > this._hashArea.length) {
            int n3 = n2 + n - this._hashArea.length;
            int n4 = Math.min(4096, this._hashSize);
            int n5 = this._hashArea.length + Math.max(n3, n4);
            this._hashArea = Arrays.copyOf(this._hashArea, n5);
        }
        System.arraycopy(nArray, 0, this._hashArea, n2, n);
        this._longNameOffset += n;
        return n2;
    }

    public int calcHash(int n) {
        int n2 = n ^ this._seed;
        n2 += n2 >>> 16;
        n2 ^= n2 << 3;
        n2 += n2 >>> 12;
        return n2;
    }

    public int calcHash(int n, int n2) {
        int n3 = n;
        n3 += n3 >>> 15;
        n3 ^= n3 >>> 9;
        n3 += n2 * 33;
        n3 ^= this._seed;
        n3 += n3 >>> 16;
        n3 ^= n3 >>> 4;
        n3 += n3 << 3;
        return n3;
    }

    public int calcHash(int n, int n2, int n3) {
        int n4 = n ^ this._seed;
        n4 += n4 >>> 9;
        n4 *= 31;
        n4 += n2;
        n4 *= 33;
        n4 += n4 >>> 15;
        n4 ^= n3;
        n4 += n4 >>> 4;
        n4 += n4 >>> 15;
        n4 ^= n4 << 9;
        return n4;
    }

    public int calcHash(int[] nArray, int n) {
        if (n < 4) {
            throw new IllegalArgumentException();
        }
        int n2 = nArray[0] ^ this._seed;
        n2 += n2 >>> 9;
        n2 += nArray[1];
        n2 += n2 >>> 15;
        n2 *= 33;
        n2 ^= nArray[2];
        n2 += n2 >>> 4;
        for (int i = 3; i < n; ++i) {
            int n3 = nArray[i];
            n3 ^= n3 >> 21;
            n2 += n3;
        }
        n2 *= 65599;
        n2 += n2 >>> 19;
        n2 ^= n2 << 5;
        return n2;
    }

    private void rehash() {
        this._hashShared = false;
        int[] nArray = this._hashArea;
        String[] stringArray = this._names;
        int n = this._hashSize;
        int n2 = this._count;
        int n3 = n + n;
        int n4 = this._spilloverEnd;
        if (n3 > 65536) {
            this.nukeSymbols(true);
            return;
        }
        this._hashArea = new int[nArray.length + (n << 3)];
        this._hashSize = n3;
        this._secondaryStart = n3 << 2;
        this._tertiaryStart = this._secondaryStart + (this._secondaryStart >> 1);
        this._tertiaryShift = ByteQuadsCanonicalizer._calcTertiaryShift(n3);
        this._names = new String[stringArray.length << 1];
        this.nukeSymbols(false);
        int n5 = 0;
        int[] nArray2 = new int[16];
        int n6 = n4;
        block5: for (int i = 0; i < n6; i += 4) {
            int n7 = nArray[i + 3];
            if (n7 == 0) continue;
            ++n5;
            String string = stringArray[i >> 2];
            switch (n7) {
                case 1: {
                    nArray2[0] = nArray[i];
                    this.addName(string, nArray2, 1);
                    continue block5;
                }
                case 2: {
                    nArray2[0] = nArray[i];
                    nArray2[1] = nArray[i + 1];
                    this.addName(string, nArray2, 2);
                    continue block5;
                }
                case 3: {
                    nArray2[0] = nArray[i];
                    nArray2[1] = nArray[i + 1];
                    nArray2[2] = nArray[i + 2];
                    this.addName(string, nArray2, 3);
                    continue block5;
                }
                default: {
                    if (n7 > nArray2.length) {
                        nArray2 = new int[n7];
                    }
                    int n8 = nArray[i + 1];
                    System.arraycopy(nArray, n8, nArray2, 0, n7);
                    this.addName(string, nArray2, n7);
                }
            }
        }
        if (n5 != n2) {
            throw new IllegalStateException("Failed rehash(): old count=" + n2 + ", copyCount=" + n5);
        }
    }

    private void nukeSymbols(boolean bl) {
        this._count = 0;
        this._spilloverEnd = this._spilloverStart();
        this._longNameOffset = this._hashSize << 3;
        if (bl) {
            Arrays.fill(this._hashArea, 0);
            Arrays.fill(this._names, null);
        }
    }

    private final int _spilloverStart() {
        int n = this._hashSize;
        return (n << 3) - n;
    }

    protected void _reportTooManyCollisions() {
        if (this._hashSize <= 1024) {
            return;
        }
        throw new IllegalStateException("Spill-over slots in symbol table with " + this._count + " entries, hash area of " + this._hashSize + " slots is now full (all " + (this._hashSize >> 3) + " slots -- suspect a DoS attack based on hash collisions. You can disable the check via `JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW`");
    }

    static int _calcTertiaryShift(int n) {
        int n2 = n >> 2;
        if (n2 < 64) {
            return 4;
        }
        if (n2 <= 256) {
            return 5;
        }
        if (n2 <= 1024) {
            return 6;
        }
        return 7;
    }

    private static final class TableInfo {
        public final int size;
        public final int count;
        public final int tertiaryShift;
        public final int[] mainHash;
        public final String[] names;
        public final int spilloverEnd;
        public final int longNameOffset;

        public TableInfo(int n, int n2, int n3, int[] nArray, String[] stringArray, int n4, int n5) {
            this.size = n;
            this.count = n2;
            this.tertiaryShift = n3;
            this.mainHash = nArray;
            this.names = stringArray;
            this.spilloverEnd = n4;
            this.longNameOffset = n5;
        }

        public TableInfo(ByteQuadsCanonicalizer byteQuadsCanonicalizer) {
            this.size = byteQuadsCanonicalizer._hashSize;
            this.count = byteQuadsCanonicalizer._count;
            this.tertiaryShift = byteQuadsCanonicalizer._tertiaryShift;
            this.mainHash = byteQuadsCanonicalizer._hashArea;
            this.names = byteQuadsCanonicalizer._names;
            this.spilloverEnd = byteQuadsCanonicalizer._spilloverEnd;
            this.longNameOffset = byteQuadsCanonicalizer._longNameOffset;
        }

        public static TableInfo createInitial(int n) {
            int n2 = n << 3;
            int n3 = ByteQuadsCanonicalizer._calcTertiaryShift(n);
            return new TableInfo(n, 0, n3, new int[n2], new String[n << 1], n2 - n, n2);
        }
    }
}

