/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.io.NumberOutput;
import com.fasterxml.jackson.core.json.JsonGeneratorImpl;
import com.fasterxml.jackson.core.json.JsonWriteContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;

public class UTF8JsonGenerator
extends JsonGeneratorImpl {
    private static final byte BYTE_u = 117;
    private static final byte BYTE_0 = 48;
    private static final byte BYTE_LBRACKET = 91;
    private static final byte BYTE_RBRACKET = 93;
    private static final byte BYTE_LCURLY = 123;
    private static final byte BYTE_RCURLY = 125;
    private static final byte BYTE_BACKSLASH = 92;
    private static final byte BYTE_COMMA = 44;
    private static final byte BYTE_COLON = 58;
    private static final int MAX_BYTES_TO_BUFFER = 512;
    private static final byte[] HEX_CHARS = CharTypes.copyHexBytes();
    private static final byte[] NULL_BYTES = new byte[]{110, 117, 108, 108};
    private static final byte[] TRUE_BYTES = new byte[]{116, 114, 117, 101};
    private static final byte[] FALSE_BYTES = new byte[]{102, 97, 108, 115, 101};
    protected final OutputStream _outputStream;
    protected byte _quoteChar;
    protected byte[] _outputBuffer;
    protected int _outputTail;
    protected final int _outputEnd;
    protected final int _outputMaxContiguous;
    protected char[] _charBuffer;
    protected final int _charBufferLength;
    protected byte[] _entityBuffer;
    protected boolean _bufferRecyclable;

    public UTF8JsonGenerator(IOContext iOContext, int n, ObjectCodec objectCodec, OutputStream outputStream2, char c) {
        super(iOContext, n, objectCodec);
        this._outputStream = outputStream2;
        this._quoteChar = (byte)c;
        if (c != '\"') {
            this._outputEscapes = CharTypes.get7BitOutputEscapes(c);
        }
        this._bufferRecyclable = true;
        this._outputBuffer = iOContext.allocWriteEncodingBuffer();
        this._outputEnd = this._outputBuffer.length;
        this._outputMaxContiguous = this._outputEnd >> 3;
        this._charBuffer = iOContext.allocConcatBuffer();
        this._charBufferLength = this._charBuffer.length;
        if (this.isEnabled(JsonGenerator.Feature.ESCAPE_NON_ASCII)) {
            this.setHighestNonEscapedChar(127);
        }
    }

    public UTF8JsonGenerator(IOContext iOContext, int n, ObjectCodec objectCodec, OutputStream outputStream2, char c, byte[] byArray, int n2, boolean bl) {
        super(iOContext, n, objectCodec);
        this._outputStream = outputStream2;
        this._quoteChar = (byte)c;
        if (c != '\"') {
            this._outputEscapes = CharTypes.get7BitOutputEscapes(c);
        }
        this._bufferRecyclable = bl;
        this._outputTail = n2;
        this._outputBuffer = byArray;
        this._outputEnd = this._outputBuffer.length;
        this._outputMaxContiguous = this._outputEnd >> 3;
        this._charBuffer = iOContext.allocConcatBuffer();
        this._charBufferLength = this._charBuffer.length;
    }

    @Deprecated
    public UTF8JsonGenerator(IOContext iOContext, int n, ObjectCodec objectCodec, OutputStream outputStream2) {
        this(iOContext, n, objectCodec, outputStream2, '\"');
    }

    @Deprecated
    public UTF8JsonGenerator(IOContext iOContext, int n, ObjectCodec objectCodec, OutputStream outputStream2, byte[] byArray, int n2, boolean bl) {
        this(iOContext, n, objectCodec, outputStream2, '\"', byArray, n2, bl);
    }

    @Override
    public Object getOutputTarget() {
        return this._outputStream;
    }

    @Override
    public int getOutputBuffered() {
        return this._outputTail;
    }

    @Override
    public void writeFieldName(String string) throws IOException {
        if (this._cfgPrettyPrinter != null) {
            this._writePPFieldName(string);
            return;
        }
        int n = this._writeContext.writeFieldName(string);
        if (n == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        if (n == 1) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 44;
        }
        if (this._cfgUnqNames) {
            this._writeStringSegments(string, false);
            return;
        }
        int n2 = string.length();
        if (n2 > this._charBufferLength) {
            this._writeStringSegments(string, true);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        if (n2 <= this._outputMaxContiguous) {
            if (this._outputTail + n2 > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(string, 0, n2);
        } else {
            this._writeStringSegments(string, 0, n2);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeFieldName(SerializableString serializableString) throws IOException {
        if (this._cfgPrettyPrinter != null) {
            this._writePPFieldName(serializableString);
            return;
        }
        int n = this._writeContext.writeFieldName(serializableString.getValue());
        if (n == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        if (n == 1) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 44;
        }
        if (this._cfgUnqNames) {
            this._writeUnq(serializableString);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        int n2 = serializableString.appendQuotedUTF8(this._outputBuffer, this._outputTail);
        if (n2 < 0) {
            this._writeBytes(serializableString.asQuotedUTF8());
        } else {
            this._outputTail += n2;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    private final void _writeUnq(SerializableString serializableString) throws IOException {
        int n = serializableString.appendQuotedUTF8(this._outputBuffer, this._outputTail);
        if (n < 0) {
            this._writeBytes(serializableString.asQuotedUTF8());
        } else {
            this._outputTail += n;
        }
    }

    @Override
    public final void writeStartArray() throws IOException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartArray(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 91;
        }
    }

    @Override
    public final void writeStartArray(Object object) throws IOException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext(object);
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartArray(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 91;
        }
    }

    @Override
    public void writeStartArray(Object object, int n) throws IOException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext(object);
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartArray(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 91;
        }
    }

    @Override
    public final void writeEndArray() throws IOException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not Array but " + this._writeContext.typeDesc());
        }
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeEndArray(this, this._writeContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 93;
        }
        this._writeContext = this._writeContext.clearAndGetParent();
    }

    @Override
    public final void writeStartObject() throws IOException {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartObject(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 123;
        }
    }

    @Override
    public void writeStartObject(Object object) throws IOException {
        JsonWriteContext jsonWriteContext;
        this._verifyValueWrite("start an object");
        this._writeContext = jsonWriteContext = this._writeContext.createChildObjectContext(object);
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartObject(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 123;
        }
    }

    @Override
    public final void writeEndObject() throws IOException {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not Object but " + this._writeContext.typeDesc());
        }
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeEndObject(this, this._writeContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 125;
        }
        this._writeContext = this._writeContext.clearAndGetParent();
    }

    protected final void _writePPFieldName(String string) throws IOException {
        int n = this._writeContext.writeFieldName(string);
        if (n == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        if (n == 1) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        if (this._cfgUnqNames) {
            this._writeStringSegments(string, false);
            return;
        }
        int n2 = string.length();
        if (n2 > this._charBufferLength) {
            this._writeStringSegments(string, true);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        string.getChars(0, n2, this._charBuffer, 0);
        if (n2 <= this._outputMaxContiguous) {
            if (this._outputTail + n2 > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(this._charBuffer, 0, n2);
        } else {
            this._writeStringSegments(this._charBuffer, 0, n2);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    protected final void _writePPFieldName(SerializableString serializableString) throws IOException {
        int n;
        boolean bl;
        int n2 = this._writeContext.writeFieldName(serializableString.getValue());
        if (n2 == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        if (n2 == 1) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        boolean bl2 = bl = !this._cfgUnqNames;
        if (bl) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
        }
        if ((n = serializableString.appendQuotedUTF8(this._outputBuffer, this._outputTail)) < 0) {
            this._writeBytes(serializableString.asQuotedUTF8());
        } else {
            this._outputTail += n;
        }
        if (bl) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
        }
    }

    @Override
    public void writeString(String string) throws IOException {
        this._verifyValueWrite("write a string");
        if (string == null) {
            this._writeNull();
            return;
        }
        int n = string.length();
        if (n > this._outputMaxContiguous) {
            this._writeStringSegments(string, true);
            return;
        }
        if (this._outputTail + n >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._writeStringSegment(string, 0, n);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeString(Reader reader, int n) throws IOException {
        int n2;
        int n3;
        this._verifyValueWrite("write a string");
        if (reader == null) {
            this._reportError("null reader");
            return;
        }
        int n4 = n >= 0 ? n : Integer.MAX_VALUE;
        char[] cArray = this._charBuffer;
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        while (n4 > 0 && (n3 = reader.read(cArray, 0, n2 = Math.min(n4, cArray.length))) > 0) {
            if (this._outputTail + n >= this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegments(cArray, 0, n3);
            n4 -= n3;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        if (n4 > 0 && n >= 0) {
            this._reportError("Didn't read enough from reader");
        }
    }

    @Override
    public void writeString(char[] cArray, int n, int n2) throws IOException {
        this._verifyValueWrite("write a string");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        if (n2 <= this._outputMaxContiguous) {
            if (this._outputTail + n2 > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(cArray, n, n2);
        } else {
            this._writeStringSegments(cArray, n, n2);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public final void writeString(SerializableString serializableString) throws IOException {
        this._verifyValueWrite("write a string");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        int n = serializableString.appendQuotedUTF8(this._outputBuffer, this._outputTail);
        if (n < 0) {
            this._writeBytes(serializableString.asQuotedUTF8());
        } else {
            this._outputTail += n;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeRawUTF8String(byte[] byArray, int n, int n2) throws IOException {
        this._verifyValueWrite("write a string");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._writeBytes(byArray, n, n2);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeUTF8String(byte[] byArray, int n, int n2) throws IOException {
        this._verifyValueWrite("write a string");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        if (n2 <= this._outputMaxContiguous) {
            this._writeUTF8Segment(byArray, n, n2);
        } else {
            this._writeUTF8Segments(byArray, n, n2);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeRaw(String string) throws IOException {
        char[] cArray;
        int n = string.length();
        if (n <= (cArray = this._charBuffer).length) {
            string.getChars(0, n, cArray, 0);
            this.writeRaw(cArray, 0, n);
        } else {
            this.writeRaw(string, 0, n);
        }
    }

    @Override
    public void writeRaw(String string, int n, int n2) throws IOException {
        char[] cArray = this._charBuffer;
        int n3 = cArray.length;
        if (n2 <= n3) {
            string.getChars(n, n + n2, cArray, 0);
            this.writeRaw(cArray, 0, n2);
            return;
        }
        int n4 = Math.min(n3, (this._outputEnd >> 2) + (this._outputEnd >> 4));
        int n5 = n4 * 3;
        while (n2 > 0) {
            char c;
            int n6 = Math.min(n4, n2);
            string.getChars(n, n + n6, cArray, 0);
            if (this._outputTail + n5 > this._outputEnd) {
                this._flushBuffer();
            }
            if (n6 > 1 && (c = cArray[n6 - 1]) >= '\ud800' && c <= '\udbff') {
                --n6;
            }
            this._writeRawSegment(cArray, 0, n6);
            n += n6;
            n2 -= n6;
        }
    }

    @Override
    public void writeRaw(SerializableString serializableString) throws IOException {
        int n = serializableString.appendUnquotedUTF8(this._outputBuffer, this._outputTail);
        if (n < 0) {
            this._writeBytes(serializableString.asUnquotedUTF8());
        } else {
            this._outputTail += n;
        }
    }

    @Override
    public void writeRawValue(SerializableString serializableString) throws IOException {
        this._verifyValueWrite("write a raw (unencoded) value");
        int n = serializableString.appendUnquotedUTF8(this._outputBuffer, this._outputTail);
        if (n < 0) {
            this._writeBytes(serializableString.asUnquotedUTF8());
        } else {
            this._outputTail += n;
        }
    }

    @Override
    public final void writeRaw(char[] cArray, int n, int n2) throws IOException {
        int n3 = n2 + n2 + n2;
        if (this._outputTail + n3 > this._outputEnd) {
            if (this._outputEnd < n3) {
                this._writeSegmentedRaw(cArray, n, n2);
                return;
            }
            this._flushBuffer();
        }
        n2 += n;
        block0: while (n < n2) {
            while ((n3 = cArray[n]) <= 127) {
                this._outputBuffer[this._outputTail++] = (byte)n3;
                if (++n < n2) continue;
                break block0;
            }
            n3 = cArray[n++];
            if (n3 < 2048) {
                this._outputBuffer[this._outputTail++] = (byte)(0xC0 | n3 >> 6);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | n3 & 0x3F);
                continue;
            }
            n = this._outputRawMultiByteChar(n3, cArray, n, n2);
        }
    }

    @Override
    public void writeRaw(char c) throws IOException {
        if (this._outputTail + 3 >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        if (c <= '\u007f') {
            byArray[this._outputTail++] = (byte)c;
        } else if (c < '\u0800') {
            byArray[this._outputTail++] = (byte)(0xC0 | c >> 6);
            byArray[this._outputTail++] = (byte)(0x80 | c & 0x3F);
        } else {
            this._outputRawMultiByteChar(c, null, 0, 0);
        }
    }

    private final void _writeSegmentedRaw(char[] cArray, int n, int n2) throws IOException {
        int n3 = this._outputEnd;
        byte[] byArray = this._outputBuffer;
        int n4 = n + n2;
        block0: while (n < n4) {
            char c;
            while ((c = cArray[n]) < '\u0080') {
                if (this._outputTail >= n3) {
                    this._flushBuffer();
                }
                byArray[this._outputTail++] = (byte)c;
                if (++n < n4) continue;
                break block0;
            }
            if (this._outputTail + 3 >= this._outputEnd) {
                this._flushBuffer();
            }
            if ((c = cArray[n++]) < '\u0800') {
                byArray[this._outputTail++] = (byte)(0xC0 | c >> 6);
                byArray[this._outputTail++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            n = this._outputRawMultiByteChar(c, cArray, n, n4);
        }
    }

    private void _writeRawSegment(char[] cArray, int n, int n2) throws IOException {
        block0: while (n < n2) {
            char c;
            while ((c = cArray[n]) <= '\u007f') {
                this._outputBuffer[this._outputTail++] = (byte)c;
                if (++n < n2) continue;
                break block0;
            }
            c = cArray[n++];
            if (c < '\u0800') {
                this._outputBuffer[this._outputTail++] = (byte)(0xC0 | c >> 6);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            n = this._outputRawMultiByteChar(c, cArray, n, n2);
        }
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write a binary value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._writeBinary(base64Variant, byArray, n, n + n2);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int writeBinary(Base64Variant base64Variant, InputStream inputStream2, int n) throws IOException, JsonGenerationException {
        int n2;
        this._verifyValueWrite("write a binary value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        byte[] byArray = this._ioContext.allocBase64Buffer();
        try {
            if (n < 0) {
                n2 = this._writeBinary(base64Variant, inputStream2, byArray);
            } else {
                int n3 = this._writeBinary(base64Variant, inputStream2, byArray, n);
                if (n3 > 0) {
                    this._reportError("Too few bytes available: missing " + n3 + " bytes (out of " + n + ")");
                }
                n2 = n;
            }
        }
        finally {
            this._ioContext.releaseBase64Buffer(byArray);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        return n2;
    }

    @Override
    public void writeNumber(short s2) throws IOException {
        this._verifyValueWrite("write a number");
        if (this._outputTail + 6 >= this._outputEnd) {
            this._flushBuffer();
        }
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedShort(s2);
            return;
        }
        this._outputTail = NumberOutput.outputInt((int)s2, this._outputBuffer, this._outputTail);
    }

    private final void _writeQuotedShort(short s2) throws IOException {
        if (this._outputTail + 8 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._outputTail = NumberOutput.outputInt((int)s2, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeNumber(int n) throws IOException {
        this._verifyValueWrite("write a number");
        if (this._outputTail + 11 >= this._outputEnd) {
            this._flushBuffer();
        }
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedInt(n);
            return;
        }
        this._outputTail = NumberOutput.outputInt(n, this._outputBuffer, this._outputTail);
    }

    private final void _writeQuotedInt(int n) throws IOException {
        if (this._outputTail + 13 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._outputTail = NumberOutput.outputInt(n, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeNumber(long l) throws IOException {
        this._verifyValueWrite("write a number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedLong(l);
            return;
        }
        if (this._outputTail + 21 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputTail = NumberOutput.outputLong(l, this._outputBuffer, this._outputTail);
    }

    private final void _writeQuotedLong(long l) throws IOException {
        if (this._outputTail + 23 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._outputTail = NumberOutput.outputLong(l, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeNumber(BigInteger bigInteger) throws IOException {
        this._verifyValueWrite("write a number");
        if (bigInteger == null) {
            this._writeNull();
        } else if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(bigInteger.toString());
        } else {
            this.writeRaw(bigInteger.toString());
        }
    }

    @Override
    public void writeNumber(double d) throws IOException {
        if (this._cfgNumbersAsStrings || NumberOutput.notFinite(d) && JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS.enabledIn(this._features)) {
            this.writeString(String.valueOf(d));
            return;
        }
        this._verifyValueWrite("write a number");
        this.writeRaw(String.valueOf(d));
    }

    @Override
    public void writeNumber(float f) throws IOException {
        if (this._cfgNumbersAsStrings || NumberOutput.notFinite(f) && JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS.enabledIn(this._features)) {
            this.writeString(String.valueOf(f));
            return;
        }
        this._verifyValueWrite("write a number");
        this.writeRaw(String.valueOf(f));
    }

    @Override
    public void writeNumber(BigDecimal bigDecimal) throws IOException {
        this._verifyValueWrite("write a number");
        if (bigDecimal == null) {
            this._writeNull();
        } else if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(this._asString(bigDecimal));
        } else {
            this.writeRaw(this._asString(bigDecimal));
        }
    }

    @Override
    public void writeNumber(String string) throws IOException {
        this._verifyValueWrite("write a number");
        if (string == null) {
            this._writeNull();
        } else if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(string);
        } else {
            this.writeRaw(string);
        }
    }

    @Override
    public void writeNumber(char[] cArray, int n, int n2) throws IOException {
        this._verifyValueWrite("write a number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(cArray, n, n2);
        } else {
            this.writeRaw(cArray, n, n2);
        }
    }

    private final void _writeQuotedRaw(String string) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this.writeRaw(string);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    private void _writeQuotedRaw(char[] cArray, int n, int n2) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this.writeRaw(cArray, n, n2);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException {
        this._verifyValueWrite("write a boolean value");
        if (this._outputTail + 5 >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = bl ? TRUE_BYTES : FALSE_BYTES;
        int n = byArray.length;
        System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n);
        this._outputTail += n;
    }

    @Override
    public void writeNull() throws IOException {
        this._verifyValueWrite("write a null");
        this._writeNull();
    }

    @Override
    protected final void _verifyValueWrite(String string) throws IOException {
        int n;
        int n2 = this._writeContext.writeValue();
        if (this._cfgPrettyPrinter != null) {
            this._verifyPrettyValueWrite(string, n2);
            return;
        }
        switch (n2) {
            default: {
                return;
            }
            case 1: {
                n = 44;
                break;
            }
            case 2: {
                n = 58;
                break;
            }
            case 3: {
                byte[] byArray;
                if (this._rootValueSeparator != null && (byArray = this._rootValueSeparator.asUnquotedUTF8()).length > 0) {
                    this._writeBytes(byArray);
                }
                return;
            }
            case 5: {
                this._reportCantWriteValueExpectName(string);
                return;
            }
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = n;
    }

    @Override
    public void flush() throws IOException {
        this._flushBuffer();
        if (this._outputStream != null && this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
            this._outputStream.flush();
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this._outputBuffer != null && this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT)) {
            while (true) {
                JsonStreamContext jsonStreamContext;
                if ((jsonStreamContext = this.getOutputContext()).inArray()) {
                    this.writeEndArray();
                    continue;
                }
                if (!jsonStreamContext.inObject()) break;
                this.writeEndObject();
            }
        }
        this._flushBuffer();
        this._outputTail = 0;
        if (this._outputStream != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET)) {
                this._outputStream.close();
            } else if (this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
                this._outputStream.flush();
            }
        }
        this._releaseBuffers();
    }

    @Override
    protected void _releaseBuffers() {
        char[] cArray;
        byte[] byArray = this._outputBuffer;
        if (byArray != null && this._bufferRecyclable) {
            this._outputBuffer = null;
            this._ioContext.releaseWriteEncodingBuffer(byArray);
        }
        if ((cArray = this._charBuffer) != null) {
            this._charBuffer = null;
            this._ioContext.releaseConcatBuffer(cArray);
        }
    }

    private final void _writeBytes(byte[] byArray) throws IOException {
        int n = byArray.length;
        if (this._outputTail + n > this._outputEnd) {
            this._flushBuffer();
            if (n > 512) {
                this._outputStream.write(byArray, 0, n);
                return;
            }
        }
        System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n);
        this._outputTail += n;
    }

    private final void _writeBytes(byte[] byArray, int n, int n2) throws IOException {
        if (this._outputTail + n2 > this._outputEnd) {
            this._flushBuffer();
            if (n2 > 512) {
                this._outputStream.write(byArray, n, n2);
                return;
            }
        }
        System.arraycopy(byArray, n, this._outputBuffer, this._outputTail, n2);
        this._outputTail += n2;
    }

    private final void _writeStringSegments(String string, boolean bl) throws IOException {
        int n;
        if (bl) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
        }
        int n2 = 0;
        for (int i = string.length(); i > 0; i -= n) {
            n = Math.min(this._outputMaxContiguous, i);
            if (this._outputTail + n > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(string, n2, n);
            n2 += n;
        }
        if (bl) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
        }
    }

    private final void _writeStringSegments(char[] cArray, int n, int n2) throws IOException {
        int n3;
        do {
            if (this._outputTail + (n3 = Math.min(this._outputMaxContiguous, n2)) > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(cArray, n, n3);
            n += n3;
        } while ((n2 -= n3) > 0);
    }

    private final void _writeStringSegments(String string, int n, int n2) throws IOException {
        int n3;
        do {
            if (this._outputTail + (n3 = Math.min(this._outputMaxContiguous, n2)) > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(string, n, n3);
            n += n3;
        } while ((n2 -= n3) > 0);
    }

    private final void _writeStringSegment(char[] cArray, int n, int n2) throws IOException {
        char c;
        n2 += n;
        int n3 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        while (n < n2 && (c = cArray[n]) <= '\u007f' && nArray[c] == 0) {
            byArray[n3++] = (byte)c;
            ++n;
        }
        this._outputTail = n3;
        if (n < n2) {
            if (this._characterEscapes != null) {
                this._writeCustomStringSegment2(cArray, n, n2);
            } else if (this._maximumNonEscapedChar == 0) {
                this._writeStringSegment2(cArray, n, n2);
            } else {
                this._writeStringSegmentASCII2(cArray, n, n2);
            }
        }
    }

    private final void _writeStringSegment(String string, int n, int n2) throws IOException {
        char c;
        n2 += n;
        int n3 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        while (n < n2 && (c = string.charAt(n)) <= '\u007f' && nArray[c] == 0) {
            byArray[n3++] = (byte)c;
            ++n;
        }
        this._outputTail = n3;
        if (n < n2) {
            if (this._characterEscapes != null) {
                this._writeCustomStringSegment2(string, n, n2);
            } else if (this._maximumNonEscapedChar == 0) {
                this._writeStringSegment2(string, n, n2);
            } else {
                this._writeStringSegmentASCII2(string, n, n2);
            }
        }
    }

    private final void _writeStringSegment2(char[] cArray, int n, int n2) throws IOException {
        if (this._outputTail + 6 * (n2 - n) > this._outputEnd) {
            this._flushBuffer();
        }
        int n3 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        while (n < n2) {
            char c;
            if ((c = cArray[n++]) <= '\u007f') {
                if (nArray[c] == 0) {
                    byArray[n3++] = (byte)c;
                    continue;
                }
                int n4 = nArray[c];
                if (n4 > 0) {
                    byArray[n3++] = 92;
                    byArray[n3++] = (byte)n4;
                    continue;
                }
                n3 = this._writeGenericEscape(c, n3);
                continue;
            }
            if (c <= '\u07ff') {
                byArray[n3++] = (byte)(0xC0 | c >> 6);
                byArray[n3++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            n3 = this._outputMultiByteChar(c, n3);
        }
        this._outputTail = n3;
    }

    private final void _writeStringSegment2(String string, int n, int n2) throws IOException {
        if (this._outputTail + 6 * (n2 - n) > this._outputEnd) {
            this._flushBuffer();
        }
        int n3 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        while (n < n2) {
            char c;
            if ((c = string.charAt(n++)) <= '\u007f') {
                if (nArray[c] == 0) {
                    byArray[n3++] = (byte)c;
                    continue;
                }
                int n4 = nArray[c];
                if (n4 > 0) {
                    byArray[n3++] = 92;
                    byArray[n3++] = (byte)n4;
                    continue;
                }
                n3 = this._writeGenericEscape(c, n3);
                continue;
            }
            if (c <= '\u07ff') {
                byArray[n3++] = (byte)(0xC0 | c >> 6);
                byArray[n3++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            n3 = this._outputMultiByteChar(c, n3);
        }
        this._outputTail = n3;
    }

    private final void _writeStringSegmentASCII2(char[] cArray, int n, int n2) throws IOException {
        if (this._outputTail + 6 * (n2 - n) > this._outputEnd) {
            this._flushBuffer();
        }
        int n3 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        int n4 = this._maximumNonEscapedChar;
        while (n < n2) {
            char c;
            if ((c = cArray[n++]) <= '\u007f') {
                if (nArray[c] == 0) {
                    byArray[n3++] = (byte)c;
                    continue;
                }
                int n5 = nArray[c];
                if (n5 > 0) {
                    byArray[n3++] = 92;
                    byArray[n3++] = (byte)n5;
                    continue;
                }
                n3 = this._writeGenericEscape(c, n3);
                continue;
            }
            if (c > n4) {
                n3 = this._writeGenericEscape(c, n3);
                continue;
            }
            if (c <= '\u07ff') {
                byArray[n3++] = (byte)(0xC0 | c >> 6);
                byArray[n3++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            n3 = this._outputMultiByteChar(c, n3);
        }
        this._outputTail = n3;
    }

    private final void _writeStringSegmentASCII2(String string, int n, int n2) throws IOException {
        if (this._outputTail + 6 * (n2 - n) > this._outputEnd) {
            this._flushBuffer();
        }
        int n3 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        int n4 = this._maximumNonEscapedChar;
        while (n < n2) {
            char c;
            if ((c = string.charAt(n++)) <= '\u007f') {
                if (nArray[c] == 0) {
                    byArray[n3++] = (byte)c;
                    continue;
                }
                int n5 = nArray[c];
                if (n5 > 0) {
                    byArray[n3++] = 92;
                    byArray[n3++] = (byte)n5;
                    continue;
                }
                n3 = this._writeGenericEscape(c, n3);
                continue;
            }
            if (c > n4) {
                n3 = this._writeGenericEscape(c, n3);
                continue;
            }
            if (c <= '\u07ff') {
                byArray[n3++] = (byte)(0xC0 | c >> 6);
                byArray[n3++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            n3 = this._outputMultiByteChar(c, n3);
        }
        this._outputTail = n3;
    }

    private final void _writeCustomStringSegment2(char[] cArray, int n, int n2) throws IOException {
        if (this._outputTail + 6 * (n2 - n) > this._outputEnd) {
            this._flushBuffer();
        }
        int n3 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        int n4 = this._maximumNonEscapedChar <= 0 ? 65535 : this._maximumNonEscapedChar;
        CharacterEscapes characterEscapes = this._characterEscapes;
        while (n < n2) {
            int n5;
            if ((n5 = cArray[n++]) <= 127) {
                if (nArray[n5] == 0) {
                    byArray[n3++] = (byte)n5;
                    continue;
                }
                int n6 = nArray[n5];
                if (n6 > 0) {
                    byArray[n3++] = 92;
                    byArray[n3++] = (byte)n6;
                    continue;
                }
                if (n6 == -2) {
                    SerializableString serializableString = characterEscapes.getEscapeSequence(n5);
                    if (serializableString == null) {
                        this._reportError("Invalid custom escape definitions; custom escape not found for character code 0x" + Integer.toHexString(n5) + ", although was supposed to have one");
                    }
                    n3 = this._writeCustomEscape(byArray, n3, serializableString, n2 - n);
                    continue;
                }
                n3 = this._writeGenericEscape(n5, n3);
                continue;
            }
            if (n5 > n4) {
                n3 = this._writeGenericEscape(n5, n3);
                continue;
            }
            SerializableString serializableString = characterEscapes.getEscapeSequence(n5);
            if (serializableString != null) {
                n3 = this._writeCustomEscape(byArray, n3, serializableString, n2 - n);
                continue;
            }
            if (n5 <= 2047) {
                byArray[n3++] = (byte)(0xC0 | n5 >> 6);
                byArray[n3++] = (byte)(0x80 | n5 & 0x3F);
                continue;
            }
            n3 = this._outputMultiByteChar(n5, n3);
        }
        this._outputTail = n3;
    }

    private final void _writeCustomStringSegment2(String string, int n, int n2) throws IOException {
        if (this._outputTail + 6 * (n2 - n) > this._outputEnd) {
            this._flushBuffer();
        }
        int n3 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        int n4 = this._maximumNonEscapedChar <= 0 ? 65535 : this._maximumNonEscapedChar;
        CharacterEscapes characterEscapes = this._characterEscapes;
        while (n < n2) {
            int n5;
            if ((n5 = string.charAt(n++)) <= 127) {
                if (nArray[n5] == 0) {
                    byArray[n3++] = (byte)n5;
                    continue;
                }
                int n6 = nArray[n5];
                if (n6 > 0) {
                    byArray[n3++] = 92;
                    byArray[n3++] = (byte)n6;
                    continue;
                }
                if (n6 == -2) {
                    SerializableString serializableString = characterEscapes.getEscapeSequence(n5);
                    if (serializableString == null) {
                        this._reportError("Invalid custom escape definitions; custom escape not found for character code 0x" + Integer.toHexString(n5) + ", although was supposed to have one");
                    }
                    n3 = this._writeCustomEscape(byArray, n3, serializableString, n2 - n);
                    continue;
                }
                n3 = this._writeGenericEscape(n5, n3);
                continue;
            }
            if (n5 > n4) {
                n3 = this._writeGenericEscape(n5, n3);
                continue;
            }
            SerializableString serializableString = characterEscapes.getEscapeSequence(n5);
            if (serializableString != null) {
                n3 = this._writeCustomEscape(byArray, n3, serializableString, n2 - n);
                continue;
            }
            if (n5 <= 2047) {
                byArray[n3++] = (byte)(0xC0 | n5 >> 6);
                byArray[n3++] = (byte)(0x80 | n5 & 0x3F);
                continue;
            }
            n3 = this._outputMultiByteChar(n5, n3);
        }
        this._outputTail = n3;
    }

    private final int _writeCustomEscape(byte[] byArray, int n, SerializableString serializableString, int n2) throws IOException, JsonGenerationException {
        byte[] byArray2 = serializableString.asUnquotedUTF8();
        int n3 = byArray2.length;
        if (n3 > 6) {
            return this._handleLongCustomEscape(byArray, n, this._outputEnd, byArray2, n2);
        }
        System.arraycopy(byArray2, 0, byArray, n, n3);
        return n + n3;
    }

    private final int _handleLongCustomEscape(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IOException, JsonGenerationException {
        int n4 = byArray2.length;
        if (n + n4 > n2) {
            this._outputTail = n;
            this._flushBuffer();
            n = this._outputTail;
            if (n4 > byArray.length) {
                this._outputStream.write(byArray2, 0, n4);
                return n;
            }
        }
        System.arraycopy(byArray2, 0, byArray, n, n4);
        if ((n += n4) + 6 * n3 > n2) {
            this._outputTail = n;
            this._flushBuffer();
            return this._outputTail;
        }
        return n;
    }

    private final void _writeUTF8Segments(byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        int n3;
        do {
            n3 = Math.min(this._outputMaxContiguous, n2);
            this._writeUTF8Segment(byArray, n, n3);
            n += n3;
        } while ((n2 -= n3) > 0);
    }

    private final void _writeUTF8Segment(byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        int[] nArray = this._outputEscapes;
        int n3 = n;
        int n4 = n + n2;
        while (n3 < n4) {
            byte by;
            if ((by = byArray[n3++]) < 0 || nArray[by] == 0) continue;
            this._writeUTF8Segment2(byArray, n, n2);
            return;
        }
        if (this._outputTail + n2 > this._outputEnd) {
            this._flushBuffer();
        }
        System.arraycopy(byArray, n, this._outputBuffer, this._outputTail, n2);
        this._outputTail += n2;
    }

    private final void _writeUTF8Segment2(byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        int n3 = this._outputTail;
        if (n3 + n2 * 6 > this._outputEnd) {
            this._flushBuffer();
            n3 = this._outputTail;
        }
        byte[] byArray2 = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        n2 += n;
        while (n < n2) {
            byte by;
            byte by2;
            if ((by2 = (by = byArray[n++])) < 0 || nArray[by2] == 0) {
                byArray2[n3++] = by;
                continue;
            }
            int n4 = nArray[by2];
            if (n4 > 0) {
                byArray2[n3++] = 92;
                byArray2[n3++] = (byte)n4;
                continue;
            }
            n3 = this._writeGenericEscape(by2, n3);
        }
        this._outputTail = n3;
    }

    protected final void _writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        int n3;
        int n4 = n2 - 3;
        int n5 = this._outputEnd - 6;
        int n6 = base64Variant.getMaxLineLength() >> 2;
        while (n <= n4) {
            if (this._outputTail > n5) {
                this._flushBuffer();
            }
            n3 = byArray[n++] << 8;
            n3 |= byArray[n++] & 0xFF;
            n3 = n3 << 8 | byArray[n++] & 0xFF;
            this._outputTail = base64Variant.encodeBase64Chunk(n3, this._outputBuffer, this._outputTail);
            if (--n6 > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            n6 = base64Variant.getMaxLineLength() >> 2;
        }
        n3 = n2 - n;
        if (n3 > 0) {
            if (this._outputTail > n5) {
                this._flushBuffer();
            }
            int n7 = byArray[n++] << 16;
            if (n3 == 2) {
                n7 |= (byArray[n++] & 0xFF) << 8;
            }
            this._outputTail = base64Variant.encodeBase64Partial(n7, n3, this._outputBuffer, this._outputTail);
        }
    }

    protected final int _writeBinary(Base64Variant base64Variant, InputStream inputStream2, byte[] byArray, int n) throws IOException, JsonGenerationException {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = -3;
        int n6 = this._outputEnd - 6;
        int n7 = base64Variant.getMaxLineLength() >> 2;
        while (n > 2) {
            if (n3 > n5) {
                n4 = this._readMore(inputStream2, byArray, n3, n4, n);
                n3 = 0;
                if (n4 < 3) break;
                n5 = n4 - 3;
            }
            if (this._outputTail > n6) {
                this._flushBuffer();
            }
            n2 = byArray[n3++] << 8;
            n2 |= byArray[n3++] & 0xFF;
            n2 = n2 << 8 | byArray[n3++] & 0xFF;
            n -= 3;
            this._outputTail = base64Variant.encodeBase64Chunk(n2, this._outputBuffer, this._outputTail);
            if (--n7 > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            n7 = base64Variant.getMaxLineLength() >> 2;
        }
        if (n > 0) {
            n4 = this._readMore(inputStream2, byArray, n3, n4, n);
            n3 = 0;
            if (n4 > 0) {
                int n8;
                if (this._outputTail > n6) {
                    this._flushBuffer();
                }
                n2 = byArray[n3++] << 16;
                if (n3 < n4) {
                    n2 |= (byArray[n3] & 0xFF) << 8;
                    n8 = 2;
                } else {
                    n8 = 1;
                }
                this._outputTail = base64Variant.encodeBase64Partial(n2, n8, this._outputBuffer, this._outputTail);
                n -= n8;
            }
        }
        return n;
    }

    protected final int _writeBinary(Base64Variant base64Variant, InputStream inputStream2, byte[] byArray) throws IOException, JsonGenerationException {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = -3;
        int n5 = 0;
        int n6 = this._outputEnd - 6;
        int n7 = base64Variant.getMaxLineLength() >> 2;
        while (true) {
            if (n2 > n4) {
                n3 = this._readMore(inputStream2, byArray, n2, n3, byArray.length);
                n2 = 0;
                if (n3 < 3) break;
                n4 = n3 - 3;
            }
            if (this._outputTail > n6) {
                this._flushBuffer();
            }
            n = byArray[n2++] << 8;
            n |= byArray[n2++] & 0xFF;
            n = n << 8 | byArray[n2++] & 0xFF;
            n5 += 3;
            this._outputTail = base64Variant.encodeBase64Chunk(n, this._outputBuffer, this._outputTail);
            if (--n7 > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            n7 = base64Variant.getMaxLineLength() >> 2;
        }
        if (n2 < n3) {
            if (this._outputTail > n6) {
                this._flushBuffer();
            }
            n = byArray[n2++] << 16;
            int n8 = 1;
            if (n2 < n3) {
                n |= (byArray[n2] & 0xFF) << 8;
                n8 = 2;
            }
            n5 += n8;
            this._outputTail = base64Variant.encodeBase64Partial(n, n8, this._outputBuffer, this._outputTail);
        }
        return n5;
    }

    private final int _readMore(InputStream inputStream2, byte[] byArray, int n, int n2, int n3) throws IOException {
        int n4;
        int n5 = 0;
        while (n < n2) {
            byArray[n5++] = byArray[n++];
        }
        n = 0;
        n2 = n5;
        n3 = Math.min(n3, byArray.length);
        while ((n4 = n3 - n2) != 0) {
            int n6 = inputStream2.read(byArray, n2, n4);
            if (n6 < 0) {
                return n2;
            }
            if ((n2 += n6) < 3) continue;
        }
        return n2;
    }

    private final int _outputRawMultiByteChar(int n, char[] cArray, int n2, int n3) throws IOException {
        if (n >= 55296 && n <= 57343) {
            if (n2 >= n3 || cArray == null) {
                this._reportError(String.format("Split surrogate on writeRaw() input (last character): first character 0x%4x", n));
            } else {
                this._outputSurrogates(n, cArray[n2]);
            }
            return n2 + 1;
        }
        byte[] byArray = this._outputBuffer;
        byArray[this._outputTail++] = (byte)(0xE0 | n >> 12);
        byArray[this._outputTail++] = (byte)(0x80 | n >> 6 & 0x3F);
        byArray[this._outputTail++] = (byte)(0x80 | n & 0x3F);
        return n2;
    }

    protected final void _outputSurrogates(int n, int n2) throws IOException {
        int n3 = this._decodeSurrogate(n, n2);
        if (this._outputTail + 4 > this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        byArray[this._outputTail++] = (byte)(0xF0 | n3 >> 18);
        byArray[this._outputTail++] = (byte)(0x80 | n3 >> 12 & 0x3F);
        byArray[this._outputTail++] = (byte)(0x80 | n3 >> 6 & 0x3F);
        byArray[this._outputTail++] = (byte)(0x80 | n3 & 0x3F);
    }

    private final int _outputMultiByteChar(int n, int n2) throws IOException {
        byte[] byArray = this._outputBuffer;
        if (n >= 55296 && n <= 57343) {
            byArray[n2++] = 92;
            byArray[n2++] = 117;
            byArray[n2++] = HEX_CHARS[n >> 12 & 0xF];
            byArray[n2++] = HEX_CHARS[n >> 8 & 0xF];
            byArray[n2++] = HEX_CHARS[n >> 4 & 0xF];
            byArray[n2++] = HEX_CHARS[n & 0xF];
        } else {
            byArray[n2++] = (byte)(0xE0 | n >> 12);
            byArray[n2++] = (byte)(0x80 | n >> 6 & 0x3F);
            byArray[n2++] = (byte)(0x80 | n & 0x3F);
        }
        return n2;
    }

    private final void _writeNull() throws IOException {
        if (this._outputTail + 4 >= this._outputEnd) {
            this._flushBuffer();
        }
        System.arraycopy(NULL_BYTES, 0, this._outputBuffer, this._outputTail, 4);
        this._outputTail += 4;
    }

    private int _writeGenericEscape(int n, int n2) throws IOException {
        byte[] byArray = this._outputBuffer;
        byArray[n2++] = 92;
        byArray[n2++] = 117;
        if (n > 255) {
            int n3 = n >> 8 & 0xFF;
            byArray[n2++] = HEX_CHARS[n3 >> 4];
            byArray[n2++] = HEX_CHARS[n3 & 0xF];
            n &= 0xFF;
        } else {
            byArray[n2++] = 48;
            byArray[n2++] = 48;
        }
        byArray[n2++] = HEX_CHARS[n >> 4];
        byArray[n2++] = HEX_CHARS[n & 0xF];
        return n2;
    }

    protected final void _flushBuffer() throws IOException {
        int n = this._outputTail;
        if (n > 0) {
            this._outputTail = 0;
            this._outputStream.write(this._outputBuffer, 0, n);
        }
    }
}

