/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

import com.fasterxml.jackson.core.io.IOContext;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class UTF32Reader
extends Reader {
    protected static final int LAST_VALID_UNICODE_CHAR = 0x10FFFF;
    protected static final char NC = '\u0000';
    protected final IOContext _context;
    protected InputStream _in;
    protected byte[] _buffer;
    protected int _ptr;
    protected int _length;
    protected final boolean _bigEndian;
    protected char _surrogate = '\u0000';
    protected int _charCount;
    protected int _byteCount;
    protected final boolean _managedBuffers;
    protected char[] _tmpBuf;

    public UTF32Reader(IOContext iOContext, InputStream inputStream2, byte[] byArray, int n, int n2, boolean bl) {
        this._context = iOContext;
        this._in = inputStream2;
        this._buffer = byArray;
        this._ptr = n;
        this._length = n2;
        this._bigEndian = bl;
        this._managedBuffers = inputStream2 != null;
    }

    @Override
    public void close() throws IOException {
        InputStream inputStream2 = this._in;
        if (inputStream2 != null) {
            this._in = null;
            this.freeBuffers();
            inputStream2.close();
        }
    }

    @Override
    public int read() throws IOException {
        if (this._tmpBuf == null) {
            this._tmpBuf = new char[1];
        }
        if (this.read(this._tmpBuf, 0, 1) < 1) {
            return -1;
        }
        return this._tmpBuf[0];
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        if (this._buffer == null) {
            return -1;
        }
        if (n2 < 1) {
            return n2;
        }
        if (n < 0 || n + n2 > cArray.length) {
            this.reportBounds(cArray, n, n2);
        }
        int n5 = n;
        int n6 = n2 + n;
        if (this._surrogate != '\u0000') {
            cArray[n5++] = this._surrogate;
            this._surrogate = '\u0000';
        } else {
            n4 = this._length - this._ptr;
            if (n4 < 4 && !this.loadMore(n4)) {
                if (n4 == 0) {
                    return -1;
                }
                this.reportUnexpectedEOF(this._length - this._ptr, 4);
            }
        }
        n4 = this._length - 4;
        while (n5 < n6 && this._ptr <= n4) {
            int n7;
            int n8;
            n3 = this._ptr;
            if (this._bigEndian) {
                n8 = this._buffer[n3] << 8 | this._buffer[n3 + 1] & 0xFF;
                n7 = (this._buffer[n3 + 2] & 0xFF) << 8 | this._buffer[n3 + 3] & 0xFF;
            } else {
                n7 = this._buffer[n3] & 0xFF | (this._buffer[n3 + 1] & 0xFF) << 8;
                n8 = this._buffer[n3 + 2] & 0xFF | this._buffer[n3 + 3] << 8;
            }
            this._ptr += 4;
            if (n8 != 0) {
                int n9 = (n8 &= 0xFFFF) - 1 << 16 | n7;
                if (n8 > 16) {
                    this.reportInvalid(n9, n5 - n, String.format(" (above 0x%08x)", 0x10FFFF));
                }
                cArray[n5++] = (char)(55296 + (n9 >> 10));
                n7 = 0xDC00 | n9 & 0x3FF;
                if (n5 >= n6) {
                    this._surrogate = (char)n9;
                    break;
                }
            }
            cArray[n5++] = (char)n7;
        }
        n3 = n5 - n;
        this._charCount += n3;
        return n3;
    }

    private void reportUnexpectedEOF(int n, int n2) throws IOException {
        int n3 = this._byteCount + n;
        int n4 = this._charCount;
        throw new CharConversionException("Unexpected EOF in the middle of a 4-byte UTF-32 char: got " + n + ", needed " + n2 + ", at char #" + n4 + ", byte #" + n3 + ")");
    }

    private void reportInvalid(int n, int n2, String string) throws IOException {
        int n3 = this._byteCount + this._ptr - 1;
        int n4 = this._charCount + n2;
        throw new CharConversionException("Invalid UTF-32 character 0x" + Integer.toHexString(n) + string + " at char #" + n4 + ", byte #" + n3 + ")");
    }

    private boolean loadMore(int n) throws IOException {
        int n2;
        if (this._in == null || this._buffer == null) {
            return false;
        }
        this._byteCount += this._length - n;
        if (n > 0) {
            if (this._ptr > 0) {
                System.arraycopy(this._buffer, this._ptr, this._buffer, 0, n);
                this._ptr = 0;
            }
            this._length = n;
        } else {
            this._ptr = 0;
            n2 = this._in.read(this._buffer);
            if (n2 < 1) {
                this._length = 0;
                if (n2 < 0) {
                    if (this._managedBuffers) {
                        this.freeBuffers();
                    }
                    return false;
                }
                this.reportStrangeStream();
            }
            this._length = n2;
        }
        while (this._length < 4) {
            n2 = this._in.read(this._buffer, this._length, this._buffer.length - this._length);
            if (n2 < 1) {
                if (n2 < 0) {
                    if (this._managedBuffers) {
                        this.freeBuffers();
                    }
                    this.reportUnexpectedEOF(this._length, 4);
                }
                this.reportStrangeStream();
            }
            this._length += n2;
        }
        return true;
    }

    private void freeBuffers() {
        byte[] byArray = this._buffer;
        if (byArray != null) {
            this._buffer = null;
            if (this._context != null) {
                this._context.releaseReadIOBuffer(byArray);
            }
        }
    }

    private void reportBounds(char[] cArray, int n, int n2) throws IOException {
        throw new ArrayIndexOutOfBoundsException(String.format("read(buf,%d,%d), cbuf[%d]", n, n2, cArray.length));
    }

    private void reportStrangeStream() throws IOException {
        throw new IOException("Strange I/O stream, returned 0 bytes on read");
    }
}

