/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

import com.fasterxml.jackson.core.io.CharTypes;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Objects;

public class ContentReference
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final ContentReference UNKNOWN_CONTENT = new ContentReference(false, null);
    public static final int DEFAULT_MAX_CONTENT_SNIPPET = 500;
    protected final transient Object _rawContent;
    protected final int _offset;
    protected final int _length;
    protected final boolean _isContentTextual;

    protected ContentReference(boolean bl, Object object) {
        this(bl, object, -1, -1);
    }

    protected ContentReference(boolean bl, Object object, int n, int n2) {
        this._isContentTextual = bl;
        this._rawContent = object;
        this._offset = n;
        this._length = n2;
    }

    public static ContentReference unknown() {
        return UNKNOWN_CONTENT;
    }

    public static ContentReference construct(boolean bl, Object object) {
        return new ContentReference(bl, object);
    }

    public static ContentReference construct(boolean bl, Object object, int n, int n2) {
        return new ContentReference(bl, object, n, n2);
    }

    public static ContentReference rawReference(boolean bl, Object object) {
        if (object instanceof ContentReference) {
            return (ContentReference)object;
        }
        return new ContentReference(bl, object);
    }

    public static ContentReference rawReference(Object object) {
        return ContentReference.rawReference(false, object);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    protected Object readResolve() {
        return UNKNOWN_CONTENT;
    }

    public boolean hasTextualContent() {
        return this._isContentTextual;
    }

    public Object getRawContent() {
        return this._rawContent;
    }

    public int contentOffset() {
        return this._offset;
    }

    public int contentLength() {
        return this._length;
    }

    protected int maxContentSnippetLength() {
        return 500;
    }

    public String buildSourceDescription() {
        return this.appendSourceDescription(new StringBuilder(200)).toString();
    }

    public StringBuilder appendSourceDescription(StringBuilder stringBuilder) {
        Object object = this.getRawContent();
        if (object == null) {
            stringBuilder.append("UNKNOWN");
            return stringBuilder;
        }
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        String string = clazz.getName();
        if (string.startsWith("java.")) {
            string = clazz.getSimpleName();
        } else if (object instanceof byte[]) {
            string = "byte[]";
        } else if (object instanceof char[]) {
            string = "char[]";
        }
        stringBuilder.append('(').append(string).append(')');
        if (this.hasTextualContent()) {
            String string2;
            String string3 = " chars";
            int n = this.maxContentSnippetLength();
            int[] nArray = new int[]{this.contentOffset(), this.contentLength()};
            if (object instanceof CharSequence) {
                string2 = this._truncate((CharSequence)object, nArray, n);
            } else if (object instanceof char[]) {
                string2 = this._truncate((char[])object, nArray, n);
            } else if (object instanceof byte[]) {
                string2 = this._truncate((byte[])object, nArray, n);
                string3 = " bytes";
            } else {
                string2 = null;
            }
            if (string2 != null) {
                this._append(stringBuilder, string2);
                if (nArray[1] > n) {
                    stringBuilder.append("[truncated ").append(nArray[1] - n).append(string3).append(']');
                }
            }
        } else if (object instanceof byte[]) {
            int n = this.contentLength();
            if (n < 0) {
                n = ((byte[])object).length;
            }
            stringBuilder.append('[').append(n).append(" bytes]");
        }
        return stringBuilder;
    }

    protected String _truncate(CharSequence charSequence, int[] nArray, int n) {
        this._truncateOffsets(nArray, charSequence.length());
        int n2 = nArray[0];
        int n3 = Math.min(nArray[1], n);
        return charSequence.subSequence(n2, n2 + n3).toString();
    }

    protected String _truncate(char[] cArray, int[] nArray, int n) {
        this._truncateOffsets(nArray, cArray.length);
        int n2 = nArray[0];
        int n3 = Math.min(nArray[1], n);
        return new String(cArray, n2, n3);
    }

    protected String _truncate(byte[] byArray, int[] nArray, int n) {
        this._truncateOffsets(nArray, byArray.length);
        int n2 = nArray[0];
        int n3 = Math.min(nArray[1], n);
        return new String(byArray, n2, n3, Charset.forName("UTF-8"));
    }

    protected void _truncateOffsets(int[] nArray, int n) {
        int n2 = nArray[0];
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= n) {
            n2 = n;
        }
        nArray[0] = n2;
        int n3 = nArray[1];
        int n4 = n - n2;
        if (n3 < 0 || n3 > n4) {
            nArray[1] = n4;
        }
    }

    protected int _append(StringBuilder stringBuilder, String string) {
        stringBuilder.append('\"');
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isISOControl(c) && this._appendEscaped(stringBuilder, c)) continue;
            stringBuilder.append(c);
        }
        stringBuilder.append('\"');
        return string.length();
    }

    protected boolean _appendEscaped(StringBuilder stringBuilder, int n) {
        if (n == 13 || n == 10) {
            return false;
        }
        stringBuilder.append('\\');
        stringBuilder.append('u');
        stringBuilder.append(CharTypes.hexToChar(n >> 12 & 0xF));
        stringBuilder.append(CharTypes.hexToChar(n >> 8 & 0xF));
        stringBuilder.append(CharTypes.hexToChar(n >> 4 & 0xF));
        stringBuilder.append(CharTypes.hexToChar(n & 0xF));
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ContentReference)) {
            return false;
        }
        ContentReference contentReference = (ContentReference)object;
        if (this._offset != contentReference._offset || this._length != contentReference._length) {
            return false;
        }
        Object object2 = contentReference._rawContent;
        if (this._rawContent == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        if (this._rawContent instanceof File || this._rawContent instanceof URL || this._rawContent instanceof URI) {
            return this._rawContent.equals(object2);
        }
        return this._rawContent == contentReference._rawContent;
    }

    public int hashCode() {
        return Objects.hashCode(this._rawContent);
    }
}

