/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.base;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.fasterxml.jackson.core.io.ContentReference;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.core.json.DupDetector;
import com.fasterxml.jackson.core.json.JsonReadContext;
import com.fasterxml.jackson.core.json.PackageVersion;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.fasterxml.jackson.core.util.TextBuffer;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public abstract class ParserBase
extends ParserMinimalBase {
    protected static final JacksonFeatureSet<StreamReadCapability> JSON_READ_CAPABILITIES = DEFAULT_READ_CAPABILITIES;
    protected final IOContext _ioContext;
    protected boolean _closed;
    protected int _inputPtr;
    protected int _inputEnd;
    protected long _currInputProcessed;
    protected int _currInputRow = 1;
    protected int _currInputRowStart;
    protected long _tokenInputTotal;
    protected int _tokenInputRow = 1;
    protected int _tokenInputCol;
    protected JsonReadContext _parsingContext;
    protected JsonToken _nextToken;
    protected final TextBuffer _textBuffer;
    protected char[] _nameCopyBuffer;
    protected boolean _nameCopied;
    protected ByteArrayBuilder _byteArrayBuilder;
    protected byte[] _binaryValue;
    protected int _numTypesValid = 0;
    protected int _numberInt;
    protected long _numberLong;
    protected double _numberDouble;
    protected BigInteger _numberBigInt;
    protected BigDecimal _numberBigDecimal;
    protected boolean _numberNegative;
    protected int _intLength;
    protected int _fractLength;
    protected int _expLength;

    protected ParserBase(IOContext iOContext, int n) {
        super(n);
        this._ioContext = iOContext;
        this._textBuffer = iOContext.constructTextBuffer();
        DupDetector dupDetector = JsonParser.Feature.STRICT_DUPLICATE_DETECTION.enabledIn(n) ? DupDetector.rootDetector(this) : null;
        this._parsingContext = JsonReadContext.createRootContext(dupDetector);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public Object getCurrentValue() {
        return this._parsingContext.getCurrentValue();
    }

    @Override
    public void setCurrentValue(Object object) {
        this._parsingContext.setCurrentValue(object);
    }

    @Override
    public JsonParser enable(JsonParser.Feature feature) {
        this._features |= feature.getMask();
        if (feature == JsonParser.Feature.STRICT_DUPLICATE_DETECTION && this._parsingContext.getDupDetector() == null) {
            this._parsingContext = this._parsingContext.withDupDetector(DupDetector.rootDetector(this));
        }
        return this;
    }

    @Override
    public JsonParser disable(JsonParser.Feature feature) {
        this._features &= ~feature.getMask();
        if (feature == JsonParser.Feature.STRICT_DUPLICATE_DETECTION) {
            this._parsingContext = this._parsingContext.withDupDetector(null);
        }
        return this;
    }

    @Override
    @Deprecated
    public JsonParser setFeatureMask(int n) {
        int n2 = this._features ^ n;
        if (n2 != 0) {
            this._features = n;
            this._checkStdFeatureChanges(n, n2);
        }
        return this;
    }

    @Override
    public JsonParser overrideStdFeatures(int n, int n2) {
        int n3 = this._features;
        int n4 = n3 & ~n2 | n & n2;
        int n5 = n3 ^ n4;
        if (n5 != 0) {
            this._features = n4;
            this._checkStdFeatureChanges(n4, n5);
        }
        return this;
    }

    protected void _checkStdFeatureChanges(int n, int n2) {
        int n3 = JsonParser.Feature.STRICT_DUPLICATE_DETECTION.getMask();
        if ((n2 & n3) != 0 && (n & n3) != 0) {
            this._parsingContext = this._parsingContext.getDupDetector() == null ? this._parsingContext.withDupDetector(DupDetector.rootDetector(this)) : this._parsingContext.withDupDetector(null);
        }
    }

    @Override
    public String getCurrentName() throws IOException {
        JsonReadContext jsonReadContext;
        if ((this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) && (jsonReadContext = this._parsingContext.getParent()) != null) {
            return jsonReadContext.getCurrentName();
        }
        return this._parsingContext.getCurrentName();
    }

    @Override
    public void overrideCurrentName(String string) {
        JsonReadContext jsonReadContext = this._parsingContext;
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            jsonReadContext = jsonReadContext.getParent();
        }
        try {
            jsonReadContext.setCurrentName(string);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this._closed) {
            this._inputPtr = Math.max(this._inputPtr, this._inputEnd);
            this._closed = true;
            try {
                this._closeInput();
            }
            finally {
                this._releaseBuffers();
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public JsonReadContext getParsingContext() {
        return this._parsingContext;
    }

    @Override
    public JsonLocation getTokenLocation() {
        return new JsonLocation(this._contentReference(), -1L, this.getTokenCharacterOffset(), this.getTokenLineNr(), this.getTokenColumnNr());
    }

    @Override
    public JsonLocation getCurrentLocation() {
        int n = this._inputPtr - this._currInputRowStart + 1;
        return new JsonLocation(this._contentReference(), -1L, this._currInputProcessed + (long)this._inputPtr, this._currInputRow, n);
    }

    @Override
    public boolean hasTextCharacters() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return true;
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nameCopied;
        }
        return false;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException {
        if (this._binaryValue == null) {
            if (this._currToken != JsonToken.VALUE_STRING) {
                this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING, can not access as binary");
            }
            ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
            this._decodeBase64(this.getText(), byteArrayBuilder, base64Variant);
            this._binaryValue = byteArrayBuilder.toByteArray();
        }
        return this._binaryValue;
    }

    public long getTokenCharacterOffset() {
        return this._tokenInputTotal;
    }

    public int getTokenLineNr() {
        return this._tokenInputRow;
    }

    public int getTokenColumnNr() {
        int n = this._tokenInputCol;
        return n < 0 ? n : n + 1;
    }

    protected abstract void _closeInput() throws IOException;

    protected void _releaseBuffers() throws IOException {
        this._textBuffer.releaseBuffers();
        char[] cArray = this._nameCopyBuffer;
        if (cArray != null) {
            this._nameCopyBuffer = null;
            this._ioContext.releaseNameCopyBuffer(cArray);
        }
    }

    @Override
    protected void _handleEOF() throws JsonParseException {
        if (!this._parsingContext.inRoot()) {
            String string = this._parsingContext.inArray() ? "Array" : "Object";
            this._reportInvalidEOF(String.format(": expected close marker for %s (start marker at %s)", string, this._parsingContext.startLocation(this._contentReference())), null);
        }
    }

    protected final int _eofAsNextChar() throws JsonParseException {
        this._handleEOF();
        return -1;
    }

    public ByteArrayBuilder _getByteArrayBuilder() {
        if (this._byteArrayBuilder == null) {
            this._byteArrayBuilder = new ByteArrayBuilder();
        } else {
            this._byteArrayBuilder.reset();
        }
        return this._byteArrayBuilder;
    }

    protected final JsonToken reset(boolean bl, int n, int n2, int n3) {
        if (n2 < 1 && n3 < 1) {
            return this.resetInt(bl, n);
        }
        return this.resetFloat(bl, n, n2, n3);
    }

    protected final JsonToken resetInt(boolean bl, int n) {
        this._numberNegative = bl;
        this._intLength = n;
        this._fractLength = 0;
        this._expLength = 0;
        this._numTypesValid = 0;
        return JsonToken.VALUE_NUMBER_INT;
    }

    protected final JsonToken resetFloat(boolean bl, int n, int n2, int n3) {
        this._numberNegative = bl;
        this._intLength = n;
        this._fractLength = n2;
        this._expLength = n3;
        this._numTypesValid = 0;
        return JsonToken.VALUE_NUMBER_FLOAT;
    }

    protected final JsonToken resetAsNaN(String string, double d) {
        this._textBuffer.resetWithString(string);
        this._numberDouble = d;
        this._numTypesValid = 8;
        return JsonToken.VALUE_NUMBER_FLOAT;
    }

    @Override
    public boolean isNaN() {
        if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT && (this._numTypesValid & 8) != 0) {
            double d = this._numberDouble;
            return Double.isNaN(d) || Double.isInfinite(d);
        }
        return false;
    }

    @Override
    public Number getNumberValue() throws IOException {
        if (this._numTypesValid == 0) {
            this._parseNumericValue(0);
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            if ((this._numTypesValid & 1) != 0) {
                return this._numberInt;
            }
            if ((this._numTypesValid & 2) != 0) {
                return this._numberLong;
            }
            if ((this._numTypesValid & 4) != 0) {
                return this._numberBigInt;
            }
            this._throwInternal();
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return this._numberBigDecimal;
        }
        if ((this._numTypesValid & 8) == 0) {
            this._throwInternal();
        }
        return this._numberDouble;
    }

    @Override
    public Number getNumberValueExact() throws IOException {
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(0);
            }
            if ((this._numTypesValid & 1) != 0) {
                return this._numberInt;
            }
            if ((this._numTypesValid & 2) != 0) {
                return this._numberLong;
            }
            if ((this._numTypesValid & 4) != 0) {
                return this._numberBigInt;
            }
            this._throwInternal();
        }
        if (this._numTypesValid == 0) {
            this._parseNumericValue(16);
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return this._numberBigDecimal;
        }
        if ((this._numTypesValid & 8) == 0) {
            this._throwInternal();
        }
        return this._numberDouble;
    }

    @Override
    public JsonParser.NumberType getNumberType() throws IOException {
        if (this._numTypesValid == 0) {
            this._parseNumericValue(0);
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            if ((this._numTypesValid & 1) != 0) {
                return JsonParser.NumberType.INT;
            }
            if ((this._numTypesValid & 2) != 0) {
                return JsonParser.NumberType.LONG;
            }
            return JsonParser.NumberType.BIG_INTEGER;
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return JsonParser.NumberType.BIG_DECIMAL;
        }
        return JsonParser.NumberType.DOUBLE;
    }

    @Override
    public int getIntValue() throws IOException {
        if ((this._numTypesValid & 1) == 0) {
            if (this._numTypesValid == 0) {
                return this._parseIntValue();
            }
            if ((this._numTypesValid & 1) == 0) {
                this.convertNumberToInt();
            }
        }
        return this._numberInt;
    }

    @Override
    public long getLongValue() throws IOException {
        if ((this._numTypesValid & 2) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(2);
            }
            if ((this._numTypesValid & 2) == 0) {
                this.convertNumberToLong();
            }
        }
        return this._numberLong;
    }

    @Override
    public BigInteger getBigIntegerValue() throws IOException {
        if ((this._numTypesValid & 4) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(4);
            }
            if ((this._numTypesValid & 4) == 0) {
                this.convertNumberToBigInteger();
            }
        }
        return this._numberBigInt;
    }

    @Override
    public float getFloatValue() throws IOException {
        double d = this.getDoubleValue();
        return (float)d;
    }

    @Override
    public double getDoubleValue() throws IOException {
        if ((this._numTypesValid & 8) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(8);
            }
            if ((this._numTypesValid & 8) == 0) {
                this.convertNumberToDouble();
            }
        }
        return this._numberDouble;
    }

    @Override
    public BigDecimal getDecimalValue() throws IOException {
        if ((this._numTypesValid & 0x10) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(16);
            }
            if ((this._numTypesValid & 0x10) == 0) {
                this.convertNumberToBigDecimal();
            }
        }
        return this._numberBigDecimal;
    }

    protected void _parseNumericValue(int n) throws IOException {
        if (this._closed) {
            this._reportError("Internal error: _parseNumericValue called when parser instance closed");
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            int n2 = this._intLength;
            if (n2 <= 9) {
                int n3;
                this._numberInt = n3 = this._textBuffer.contentsAsInt(this._numberNegative);
                this._numTypesValid = 1;
                return;
            }
            if (n2 <= 18) {
                long l = this._textBuffer.contentsAsLong(this._numberNegative);
                if (n2 == 10) {
                    if (this._numberNegative) {
                        if (l >= Integer.MIN_VALUE) {
                            this._numberInt = (int)l;
                            this._numTypesValid = 1;
                            return;
                        }
                    } else if (l <= Integer.MAX_VALUE) {
                        this._numberInt = (int)l;
                        this._numTypesValid = 1;
                        return;
                    }
                }
                this._numberLong = l;
                this._numTypesValid = 2;
                return;
            }
            this._parseSlowInt(n);
            return;
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
            this._parseSlowFloat(n);
            return;
        }
        this._reportError("Current token (%s) not numeric, can not use numeric value accessors", (Object)this._currToken);
    }

    protected int _parseIntValue() throws IOException {
        if (this._closed) {
            this._reportError("Internal error: _parseNumericValue called when parser instance closed");
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_INT && this._intLength <= 9) {
            int n;
            this._numberInt = n = this._textBuffer.contentsAsInt(this._numberNegative);
            this._numTypesValid = 1;
            return n;
        }
        this._parseNumericValue(1);
        if ((this._numTypesValid & 1) == 0) {
            this.convertNumberToInt();
        }
        return this._numberInt;
    }

    private void _parseSlowFloat(int n) throws IOException {
        try {
            if (n == 16) {
                this._numberBigDecimal = this._textBuffer.contentsAsDecimal();
                this._numTypesValid = 16;
            } else {
                this._numberDouble = this._textBuffer.contentsAsDouble();
                this._numTypesValid = 8;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this._wrapError("Malformed numeric value (" + this._longNumberDesc(this._textBuffer.contentsAsString()) + ")", numberFormatException);
        }
    }

    private void _parseSlowInt(int n) throws IOException {
        String string = this._textBuffer.contentsAsString();
        try {
            int n2 = this._intLength;
            char[] cArray = this._textBuffer.getTextBuffer();
            int n3 = this._textBuffer.getTextOffset();
            if (this._numberNegative) {
                ++n3;
            }
            if (NumberInput.inLongRange(cArray, n3, n2, this._numberNegative)) {
                this._numberLong = Long.parseLong(string);
                this._numTypesValid = 2;
            } else {
                if (n == 1 || n == 2) {
                    this._reportTooLongIntegral(n, string);
                }
                if (n == 8 || n == 32) {
                    this._numberDouble = NumberInput.parseDouble(string);
                    this._numTypesValid = 8;
                } else {
                    this._numberBigInt = new BigInteger(string);
                    this._numTypesValid = 4;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this._wrapError("Malformed numeric value (" + this._longNumberDesc(string) + ")", numberFormatException);
        }
    }

    protected void _reportTooLongIntegral(int n, String string) throws IOException {
        if (n == 1) {
            this.reportOverflowInt(string);
        } else {
            this.reportOverflowLong(string);
        }
    }

    protected void convertNumberToInt() throws IOException {
        if ((this._numTypesValid & 2) != 0) {
            int n = (int)this._numberLong;
            if ((long)n != this._numberLong) {
                this.reportOverflowInt(this.getText(), this.currentToken());
            }
            this._numberInt = n;
        } else if ((this._numTypesValid & 4) != 0) {
            if (BI_MIN_INT.compareTo(this._numberBigInt) > 0 || BI_MAX_INT.compareTo(this._numberBigInt) < 0) {
                this.reportOverflowInt();
            }
            this._numberInt = this._numberBigInt.intValue();
        } else if ((this._numTypesValid & 8) != 0) {
            if (this._numberDouble < -2.147483648E9 || this._numberDouble > 2.147483647E9) {
                this.reportOverflowInt();
            }
            this._numberInt = (int)this._numberDouble;
        } else if ((this._numTypesValid & 0x10) != 0) {
            if (BD_MIN_INT.compareTo(this._numberBigDecimal) > 0 || BD_MAX_INT.compareTo(this._numberBigDecimal) < 0) {
                this.reportOverflowInt();
            }
            this._numberInt = this._numberBigDecimal.intValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 1;
    }

    protected void convertNumberToLong() throws IOException {
        if ((this._numTypesValid & 1) != 0) {
            this._numberLong = this._numberInt;
        } else if ((this._numTypesValid & 4) != 0) {
            if (BI_MIN_LONG.compareTo(this._numberBigInt) > 0 || BI_MAX_LONG.compareTo(this._numberBigInt) < 0) {
                this.reportOverflowLong();
            }
            this._numberLong = this._numberBigInt.longValue();
        } else if ((this._numTypesValid & 8) != 0) {
            if (this._numberDouble < -9.223372036854776E18 || this._numberDouble > 9.223372036854776E18) {
                this.reportOverflowLong();
            }
            this._numberLong = (long)this._numberDouble;
        } else if ((this._numTypesValid & 0x10) != 0) {
            if (BD_MIN_LONG.compareTo(this._numberBigDecimal) > 0 || BD_MAX_LONG.compareTo(this._numberBigDecimal) < 0) {
                this.reportOverflowLong();
            }
            this._numberLong = this._numberBigDecimal.longValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 2;
    }

    protected void convertNumberToBigInteger() throws IOException {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberBigInt = this._numberBigDecimal.toBigInteger();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberInt);
        } else if ((this._numTypesValid & 8) != 0) {
            this._numberBigInt = BigDecimal.valueOf(this._numberDouble).toBigInteger();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 4;
    }

    protected void convertNumberToDouble() throws IOException {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberDouble = this._numberBigDecimal.doubleValue();
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberDouble = this._numberBigInt.doubleValue();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberDouble = this._numberLong;
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberDouble = this._numberInt;
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 8;
    }

    protected void convertNumberToBigDecimal() throws IOException {
        if ((this._numTypesValid & 8) != 0) {
            this._numberBigDecimal = NumberInput.parseBigDecimal(this.getText());
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberBigDecimal = new BigDecimal(this._numberBigInt);
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberInt);
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 0x10;
    }

    protected void _reportMismatchedEndMarker(int n, char c) throws JsonParseException {
        JsonReadContext jsonReadContext = this.getParsingContext();
        this._reportError(String.format("Unexpected close marker '%s': expected '%c' (for %s starting at %s)", Character.valueOf((char)n), Character.valueOf(c), jsonReadContext.typeDesc(), jsonReadContext.startLocation(this._contentReference())));
    }

    protected char _handleUnrecognizedCharacterEscape(char c) throws JsonProcessingException {
        if (this.isEnabled(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER)) {
            return c;
        }
        if (c == '\'' && this.isEnabled(JsonParser.Feature.ALLOW_SINGLE_QUOTES)) {
            return c;
        }
        this._reportError("Unrecognized character escape " + ParserBase._getCharDesc(c));
        return c;
    }

    protected void _throwUnquotedSpace(int n, String string) throws JsonParseException {
        if (!this.isEnabled(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS) || n > 32) {
            char c = (char)n;
            String string2 = "Illegal unquoted character (" + ParserBase._getCharDesc(c) + "): has to be escaped using backslash to be included in " + string;
            this._reportError(string2);
        }
    }

    protected String _validJsonTokenList() throws IOException {
        return this._validJsonValueList();
    }

    protected String _validJsonValueList() throws IOException {
        if (this.isEnabled(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
            return "(JSON String, Number (or 'NaN'/'INF'/'+INF'), Array, Object or token 'null', 'true' or 'false')";
        }
        return "(JSON String, Number, Array, Object or token 'null', 'true' or 'false')";
    }

    protected char _decodeEscaped() throws IOException {
        throw new UnsupportedOperationException();
    }

    protected final int _decodeBase64Escape(Base64Variant base64Variant, int n, int n2) throws IOException {
        if (n != 92) {
            throw this.reportInvalidBase64Char(base64Variant, n, n2);
        }
        char c = this._decodeEscaped();
        if (c <= ' ' && n2 == 0) {
            return -1;
        }
        int n3 = base64Variant.decodeBase64Char((int)c);
        if (n3 < 0 && n3 != -2) {
            throw this.reportInvalidBase64Char(base64Variant, c, n2);
        }
        return n3;
    }

    protected final int _decodeBase64Escape(Base64Variant base64Variant, char c, int n) throws IOException {
        if (c != '\\') {
            throw this.reportInvalidBase64Char(base64Variant, c, n);
        }
        char c2 = this._decodeEscaped();
        if (c2 <= ' ' && n == 0) {
            return -1;
        }
        int n2 = base64Variant.decodeBase64Char(c2);
        if (n2 < 0 && (n2 != -2 || n < 2)) {
            throw this.reportInvalidBase64Char(base64Variant, c2, n);
        }
        return n2;
    }

    protected IllegalArgumentException reportInvalidBase64Char(Base64Variant base64Variant, int n, int n2) throws IllegalArgumentException {
        return this.reportInvalidBase64Char(base64Variant, n, n2, null);
    }

    protected IllegalArgumentException reportInvalidBase64Char(Base64Variant base64Variant, int n, int n2, String string) throws IllegalArgumentException {
        String string2 = n <= 32 ? String.format("Illegal white space character (code 0x%s) as character #%d of 4-char base64 unit: can only used between units", Integer.toHexString(n), n2 + 1) : (base64Variant.usesPaddingChar(n) ? "Unexpected padding character ('" + base64Variant.getPaddingChar() + "') as character #" + (n2 + 1) + " of 4-char base64 unit: padding only legal as 3rd or 4th character" : (!Character.isDefined(n) || Character.isISOControl(n) ? "Illegal character (code 0x" + Integer.toHexString(n) + ") in base64 content" : "Illegal character '" + (char)n + "' (code 0x" + Integer.toHexString(n) + ") in base64 content"));
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        return new IllegalArgumentException(string2);
    }

    protected void _handleBase64MissingPadding(Base64Variant base64Variant) throws IOException {
        this._reportError(base64Variant.missingPaddingMessage());
    }

    @Deprecated
    protected Object _getSourceReference() {
        if (JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION.enabledIn(this._features)) {
            return this._ioContext.contentReference().getRawContent();
        }
        return null;
    }

    protected ContentReference _contentReference() {
        if (JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION.enabledIn(this._features)) {
            return this._ioContext.contentReference();
        }
        return ContentReference.unknown();
    }

    protected static int[] growArrayBy(int[] nArray, int n) {
        if (nArray == null) {
            return new int[n];
        }
        return Arrays.copyOf(nArray, nArray.length + n);
    }

    @Deprecated
    protected void loadMoreGuaranteed() throws IOException {
        if (!this.loadMore()) {
            this._reportInvalidEOF();
        }
    }

    @Deprecated
    protected boolean loadMore() throws IOException {
        return false;
    }

    protected void _finishString() throws IOException {
    }
}

