/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import java.io.Serializable;
import java.util.Arrays;

public final class Base64Variant
implements Serializable {
    private static final int INT_SPACE = 32;
    private static final long serialVersionUID = 1L;
    protected static final char PADDING_CHAR_NONE = '\u0000';
    public static final int BASE64_VALUE_INVALID = -1;
    public static final int BASE64_VALUE_PADDING = -2;
    private final transient int[] _asciiToBase64 = new int[128];
    private final transient char[] _base64ToAsciiC = new char[64];
    private final transient byte[] _base64ToAsciiB = new byte[64];
    final String _name;
    private final char _paddingChar;
    private final int _maxLineLength;
    private final boolean _writePadding;
    private final PaddingReadBehaviour _paddingReadBehaviour;

    public Base64Variant(String string, String string2, boolean bl, char c, int n) {
        this._name = string;
        this._writePadding = bl;
        this._paddingChar = c;
        this._maxLineLength = n;
        int n2 = string2.length();
        if (n2 != 64) {
            throw new IllegalArgumentException("Base64Alphabet length must be exactly 64 (was " + n2 + ")");
        }
        string2.getChars(0, n2, this._base64ToAsciiC, 0);
        Arrays.fill(this._asciiToBase64, -1);
        int n3 = 0;
        while (n3 < n2) {
            char c2 = this._base64ToAsciiC[n3];
            this._base64ToAsciiB[n3] = (byte)c2;
            this._asciiToBase64[c2] = n3++;
        }
        if (bl) {
            this._asciiToBase64[c] = -2;
        }
        this._paddingReadBehaviour = bl ? PaddingReadBehaviour.PADDING_REQUIRED : PaddingReadBehaviour.PADDING_FORBIDDEN;
    }

    public Base64Variant(Base64Variant base64Variant, String string, int n) {
        this(base64Variant, string, base64Variant._writePadding, base64Variant._paddingChar, n);
    }

    public Base64Variant(Base64Variant base64Variant, String string, boolean bl, char c, int n) {
        this(base64Variant, string, bl, c, base64Variant._paddingReadBehaviour, n);
    }

    private Base64Variant(Base64Variant base64Variant, String string, boolean bl, char c, PaddingReadBehaviour paddingReadBehaviour, int n) {
        this._name = string;
        byte[] byArray = base64Variant._base64ToAsciiB;
        System.arraycopy(byArray, 0, this._base64ToAsciiB, 0, byArray.length);
        char[] cArray = base64Variant._base64ToAsciiC;
        System.arraycopy(cArray, 0, this._base64ToAsciiC, 0, cArray.length);
        int[] nArray = base64Variant._asciiToBase64;
        System.arraycopy(nArray, 0, this._asciiToBase64, 0, nArray.length);
        this._writePadding = bl;
        this._paddingChar = c;
        this._maxLineLength = n;
        this._paddingReadBehaviour = paddingReadBehaviour;
    }

    private Base64Variant(Base64Variant base64Variant, PaddingReadBehaviour paddingReadBehaviour) {
        this(base64Variant, base64Variant._name, base64Variant._writePadding, base64Variant._paddingChar, paddingReadBehaviour, base64Variant._maxLineLength);
    }

    public Base64Variant withPaddingAllowed() {
        return this.withReadPadding(PaddingReadBehaviour.PADDING_ALLOWED);
    }

    public Base64Variant withPaddingRequired() {
        return this.withReadPadding(PaddingReadBehaviour.PADDING_REQUIRED);
    }

    public Base64Variant withPaddingForbidden() {
        return this.withReadPadding(PaddingReadBehaviour.PADDING_FORBIDDEN);
    }

    public Base64Variant withReadPadding(PaddingReadBehaviour paddingReadBehaviour) {
        return paddingReadBehaviour == this._paddingReadBehaviour ? this : new Base64Variant(this, paddingReadBehaviour);
    }

    public Base64Variant withWritePadding(boolean bl) {
        return bl == this._writePadding ? this : new Base64Variant(this, this._name, bl, this._paddingChar, this._maxLineLength);
    }

    protected Object readResolve() {
        Base64Variant base64Variant = Base64Variants.valueOf(this._name);
        if (this._writePadding != base64Variant._writePadding || this._paddingChar != base64Variant._paddingChar || this._paddingReadBehaviour != base64Variant._paddingReadBehaviour || this._maxLineLength != base64Variant._maxLineLength || this._writePadding != base64Variant._writePadding) {
            return new Base64Variant(base64Variant, this._name, this._writePadding, this._paddingChar, this._paddingReadBehaviour, this._maxLineLength);
        }
        return base64Variant;
    }

    public String getName() {
        return this._name;
    }

    public boolean usesPadding() {
        return this._writePadding;
    }

    public boolean requiresPaddingOnRead() {
        return this._paddingReadBehaviour == PaddingReadBehaviour.PADDING_REQUIRED;
    }

    public boolean acceptsPaddingOnRead() {
        return this._paddingReadBehaviour != PaddingReadBehaviour.PADDING_FORBIDDEN;
    }

    public boolean usesPaddingChar(char c) {
        return c == this._paddingChar;
    }

    public boolean usesPaddingChar(int n) {
        return n == this._paddingChar;
    }

    public PaddingReadBehaviour paddingReadBehaviour() {
        return this._paddingReadBehaviour;
    }

    public char getPaddingChar() {
        return this._paddingChar;
    }

    public byte getPaddingByte() {
        return (byte)this._paddingChar;
    }

    public int getMaxLineLength() {
        return this._maxLineLength;
    }

    public int decodeBase64Char(char c) {
        char c2 = c;
        return c2 <= '\u007f' ? this._asciiToBase64[c2] : -1;
    }

    public int decodeBase64Char(int n) {
        return n <= 127 ? this._asciiToBase64[n] : -1;
    }

    public int decodeBase64Byte(byte by) {
        byte by2 = by;
        if (by2 < 0) {
            return -1;
        }
        return this._asciiToBase64[by2];
    }

    public char encodeBase64BitsAsChar(int n) {
        return this._base64ToAsciiC[n];
    }

    public int encodeBase64Chunk(int n, char[] cArray, int n2) {
        cArray[n2++] = this._base64ToAsciiC[n >> 18 & 0x3F];
        cArray[n2++] = this._base64ToAsciiC[n >> 12 & 0x3F];
        cArray[n2++] = this._base64ToAsciiC[n >> 6 & 0x3F];
        cArray[n2++] = this._base64ToAsciiC[n & 0x3F];
        return n2;
    }

    public void encodeBase64Chunk(StringBuilder stringBuilder, int n) {
        stringBuilder.append(this._base64ToAsciiC[n >> 18 & 0x3F]);
        stringBuilder.append(this._base64ToAsciiC[n >> 12 & 0x3F]);
        stringBuilder.append(this._base64ToAsciiC[n >> 6 & 0x3F]);
        stringBuilder.append(this._base64ToAsciiC[n & 0x3F]);
    }

    public int encodeBase64Partial(int n, int n2, char[] cArray, int n3) {
        cArray[n3++] = this._base64ToAsciiC[n >> 18 & 0x3F];
        cArray[n3++] = this._base64ToAsciiC[n >> 12 & 0x3F];
        if (this.usesPadding()) {
            cArray[n3++] = n2 == 2 ? this._base64ToAsciiC[n >> 6 & 0x3F] : this._paddingChar;
            cArray[n3++] = this._paddingChar;
        } else if (n2 == 2) {
            cArray[n3++] = this._base64ToAsciiC[n >> 6 & 0x3F];
        }
        return n3;
    }

    public void encodeBase64Partial(StringBuilder stringBuilder, int n, int n2) {
        stringBuilder.append(this._base64ToAsciiC[n >> 18 & 0x3F]);
        stringBuilder.append(this._base64ToAsciiC[n >> 12 & 0x3F]);
        if (this.usesPadding()) {
            stringBuilder.append(n2 == 2 ? this._base64ToAsciiC[n >> 6 & 0x3F] : this._paddingChar);
            stringBuilder.append(this._paddingChar);
        } else if (n2 == 2) {
            stringBuilder.append(this._base64ToAsciiC[n >> 6 & 0x3F]);
        }
    }

    public byte encodeBase64BitsAsByte(int n) {
        return this._base64ToAsciiB[n];
    }

    public int encodeBase64Chunk(int n, byte[] byArray, int n2) {
        byArray[n2++] = this._base64ToAsciiB[n >> 18 & 0x3F];
        byArray[n2++] = this._base64ToAsciiB[n >> 12 & 0x3F];
        byArray[n2++] = this._base64ToAsciiB[n >> 6 & 0x3F];
        byArray[n2++] = this._base64ToAsciiB[n & 0x3F];
        return n2;
    }

    public int encodeBase64Partial(int n, int n2, byte[] byArray, int n3) {
        byArray[n3++] = this._base64ToAsciiB[n >> 18 & 0x3F];
        byArray[n3++] = this._base64ToAsciiB[n >> 12 & 0x3F];
        if (this.usesPadding()) {
            byte by = (byte)this._paddingChar;
            byArray[n3++] = n2 == 2 ? this._base64ToAsciiB[n >> 6 & 0x3F] : by;
            byArray[n3++] = by;
        } else if (n2 == 2) {
            byArray[n3++] = this._base64ToAsciiB[n >> 6 & 0x3F];
        }
        return n3;
    }

    public String encode(byte[] byArray) {
        return this.encode(byArray, false);
    }

    public String encode(byte[] byArray, boolean bl) {
        int n;
        int n2 = byArray.length;
        StringBuilder stringBuilder = new StringBuilder(n2 + (n2 >> 2) + (n2 >> 3));
        if (bl) {
            stringBuilder.append('\"');
        }
        int n3 = this.getMaxLineLength() >> 2;
        int n4 = 0;
        int n5 = n2 - 3;
        while (n4 <= n5) {
            n = byArray[n4++] << 8;
            n |= byArray[n4++] & 0xFF;
            n = n << 8 | byArray[n4++] & 0xFF;
            this.encodeBase64Chunk(stringBuilder, n);
            if (--n3 > 0) continue;
            stringBuilder.append('\\');
            stringBuilder.append('n');
            n3 = this.getMaxLineLength() >> 2;
        }
        n = n2 - n4;
        if (n > 0) {
            int n6 = byArray[n4++] << 16;
            if (n == 2) {
                n6 |= (byArray[n4++] & 0xFF) << 8;
            }
            this.encodeBase64Partial(stringBuilder, n6, n);
        }
        if (bl) {
            stringBuilder.append('\"');
        }
        return stringBuilder.toString();
    }

    public String encode(byte[] byArray, boolean bl, String string) {
        int n;
        int n2 = byArray.length;
        StringBuilder stringBuilder = new StringBuilder(n2 + (n2 >> 2) + (n2 >> 3));
        if (bl) {
            stringBuilder.append('\"');
        }
        int n3 = this.getMaxLineLength() >> 2;
        int n4 = 0;
        int n5 = n2 - 3;
        while (n4 <= n5) {
            n = byArray[n4++] << 8;
            n |= byArray[n4++] & 0xFF;
            n = n << 8 | byArray[n4++] & 0xFF;
            this.encodeBase64Chunk(stringBuilder, n);
            if (--n3 > 0) continue;
            stringBuilder.append(string);
            n3 = this.getMaxLineLength() >> 2;
        }
        n = n2 - n4;
        if (n > 0) {
            int n6 = byArray[n4++] << 16;
            if (n == 2) {
                n6 |= (byArray[n4++] & 0xFF) << 8;
            }
            this.encodeBase64Partial(stringBuilder, n6, n);
        }
        if (bl) {
            stringBuilder.append('\"');
        }
        return stringBuilder.toString();
    }

    public byte[] decode(String string) throws IllegalArgumentException {
        ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder();
        this.decode(string, byteArrayBuilder);
        return byteArrayBuilder.toByteArray();
    }

    public void decode(String string, ByteArrayBuilder byteArrayBuilder) throws IllegalArgumentException {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c;
            if ((c = string.charAt(n++)) <= ' ') continue;
            int n3 = this.decodeBase64Char(c);
            if (n3 < 0) {
                this._reportInvalidBase64(c, 0, null);
            }
            int n4 = n3;
            if (n >= n2) {
                this._reportBase64EOF();
            }
            if ((n3 = this.decodeBase64Char(c = string.charAt(n++))) < 0) {
                this._reportInvalidBase64(c, 1, null);
            }
            n4 = n4 << 6 | n3;
            if (n >= n2) {
                if (!this.requiresPaddingOnRead()) {
                    byteArrayBuilder.append(n4 >>= 4);
                    break;
                }
                this._reportBase64EOF();
            }
            if ((n3 = this.decodeBase64Char(c = string.charAt(n++))) < 0) {
                if (n3 != -2) {
                    this._reportInvalidBase64(c, 2, null);
                }
                if (!this.acceptsPaddingOnRead()) {
                    this._reportBase64UnexpectedPadding();
                }
                if (n >= n2) {
                    this._reportBase64EOF();
                }
                if (!this.usesPaddingChar(c = string.charAt(n++))) {
                    this._reportInvalidBase64(c, 3, "expected padding character '" + this.getPaddingChar() + "'");
                }
                byteArrayBuilder.append(n4 >>= 4);
                continue;
            }
            n4 = n4 << 6 | n3;
            if (n >= n2) {
                if (!this.requiresPaddingOnRead()) {
                    byteArrayBuilder.appendTwoBytes(n4 >>= 2);
                    break;
                }
                this._reportBase64EOF();
            }
            if ((n3 = this.decodeBase64Char(c = string.charAt(n++))) < 0) {
                if (n3 != -2) {
                    this._reportInvalidBase64(c, 3, null);
                }
                if (!this.acceptsPaddingOnRead()) {
                    this._reportBase64UnexpectedPadding();
                }
                byteArrayBuilder.appendTwoBytes(n4 >>= 2);
                continue;
            }
            n4 = n4 << 6 | n3;
            byteArrayBuilder.appendThreeBytes(n4);
        }
    }

    public String toString() {
        return this._name;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        Base64Variant base64Variant = (Base64Variant)object;
        return base64Variant._paddingChar == this._paddingChar && base64Variant._maxLineLength == this._maxLineLength && base64Variant._writePadding == this._writePadding && base64Variant._paddingReadBehaviour == this._paddingReadBehaviour && this._name.equals(base64Variant._name);
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    protected void _reportInvalidBase64(char c, int n, String string) throws IllegalArgumentException {
        String string2 = c <= ' ' ? "Illegal white space character (code 0x" + Integer.toHexString(c) + ") as character #" + (n + 1) + " of 4-char base64 unit: can only used between units" : (this.usesPaddingChar(c) ? "Unexpected padding character ('" + this.getPaddingChar() + "') as character #" + (n + 1) + " of 4-char base64 unit: padding only legal as 3rd or 4th character" : (!Character.isDefined(c) || Character.isISOControl(c) ? "Illegal character (code 0x" + Integer.toHexString(c) + ") in base64 content" : "Illegal character '" + c + "' (code 0x" + Integer.toHexString(c) + ") in base64 content"));
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        throw new IllegalArgumentException(string2);
    }

    protected void _reportBase64EOF() throws IllegalArgumentException {
        throw new IllegalArgumentException(this.missingPaddingMessage());
    }

    protected void _reportBase64UnexpectedPadding() throws IllegalArgumentException {
        throw new IllegalArgumentException(this.unexpectedPaddingMessage());
    }

    protected String unexpectedPaddingMessage() {
        return String.format("Unexpected end of base64-encoded String: base64 variant '%s' expects no padding at the end while decoding. This Base64Variant might have been incorrectly configured", this.getName());
    }

    public String missingPaddingMessage() {
        return String.format("Unexpected end of base64-encoded String: base64 variant '%s' expects padding (one or more '%c' characters) at the end. This Base64Variant might have been incorrectly configured", this.getName(), Character.valueOf(this.getPaddingChar()));
    }

    public static enum PaddingReadBehaviour {
        PADDING_FORBIDDEN,
        PADDING_REQUIRED,
        PADDING_ALLOWED;

    }
}

