/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.waiters;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.util.ValidationUtils;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import java.util.ArrayList;
import java.util.List;

@SdkInternalApi
class CompositeAcceptor<Output> {
    private List<WaiterAcceptor<Output>> acceptors = new ArrayList<WaiterAcceptor<Output>>();

    public CompositeAcceptor(List<WaiterAcceptor<Output>> list) {
        this.acceptors = ValidationUtils.assertNotEmpty(list, "acceptors");
    }

    public List<WaiterAcceptor<Output>> getAcceptors() {
        return this.acceptors;
    }

    public WaiterState accepts(Output Output2) {
        for (WaiterAcceptor<Output> waiterAcceptor : this.acceptors) {
            if (!waiterAcceptor.matches(Output2)) continue;
            return waiterAcceptor.getState();
        }
        return WaiterState.RETRY;
    }

    public WaiterState accepts(AmazonServiceException amazonServiceException) throws AmazonServiceException {
        for (WaiterAcceptor<Output> waiterAcceptor : this.acceptors) {
            if (!waiterAcceptor.matches(amazonServiceException)) continue;
            return waiterAcceptor.getState();
        }
        throw amazonServiceException;
    }
}

