/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util.json;

import com.amazonaws.SdkClientException;
import com.amazonaws.log.InternalLogApi;
import com.amazonaws.log.InternalLogFactory;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public enum Jackson {

    private static final InternalLogApi log = InternalLogFactory.getLog(Jackson.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final ObjectWriter writer;
    private static final ObjectWriter prettyWriter;
    private static final TypeReference<HashMap<String, String>> STRING_MAP_TYPEREFERENCE;

    public static String toJsonPrettyString(Object object) {
        try {
            return prettyWriter.writeValueAsString(object);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public static String toJsonString(Object object) {
        try {
            return writer.writeValueAsString(object);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public static <T> T fromJsonString(String string, Class<T> clazz) {
        if (string == null) {
            return null;
        }
        try {
            return objectMapper.readValue(string, clazz);
        }
        catch (Exception exception) {
            throw new SdkClientException("Unable to parse Json String.", exception);
        }
    }

    public static Map<String, String> stringMapFromJsonString(String string) {
        if (string == null) {
            return null;
        }
        try {
            return objectMapper.readValue(string, STRING_MAP_TYPEREFERENCE);
        }
        catch (IOException iOException) {
            throw new SdkClientException("Unable to parse Json String.", iOException);
        }
    }

    public static <T> T fromSensitiveJsonString(String string, Class<T> clazz) {
        if (string == null) {
            return null;
        }
        try {
            return objectMapper.readValue(string, clazz);
        }
        catch (IOException iOException) {
            log.debug("Failed to parse JSON string.", iOException);
            throw new SdkClientException("Unable to parse Json string. See debug-level logs for the exact error details, which may include sensitive information.");
        }
    }

    public static JsonNode jsonNodeOf(String string) {
        return Jackson.fromJsonString(string, JsonNode.class);
    }

    public static JsonGenerator jsonGeneratorOf(Writer writer) throws IOException {
        return new JsonFactory().createGenerator(writer);
    }

    public static <T> T loadFrom(File file, Class<T> clazz) throws IOException {
        try {
            return objectMapper.readValue(file, clazz);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static ObjectWriter getWriter() {
        return writer;
    }

    public static ObjectWriter getPrettywriter() {
        return prettyWriter;
    }

    static {
        objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        writer = objectMapper.writer();
        prettyWriter = objectMapper.writerWithDefaultPrettyPrinter();
        STRING_MAP_TYPEREFERENCE = new TypeReference<HashMap<String, String>>(){};
    }
}

