/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.internal.SdkThreadLocalsRegistry;
import com.amazonaws.util.Base64;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.NamespaceRemovingInputStream;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XpathUtils {
    private static final String DTM_MANAGER_DEFAULT_PROP_NAME = "com.sun.org.apache.xml.internal.dtm.DTMManager";
    private static final String DOCUMENT_BUILDER_FACTORY_PROP_NAME = "javax.xml.parsers.DocumentBuilderFactory";
    private static final String DOCUMENT_BUILDER_FACTORY_IMPL_CLASS_NAME = "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl";
    private static final String XPATH_CONTEXT_CLASS_NAME = "com.sun.org.apache.xpath.internal.XPathContext";
    private static final String DTM_MANAGER_IMPL_CLASS_NAME = "com.sun.org.apache.xml.internal.dtm.ref.DTMManagerDefault";
    private static final Log log = LogFactory.getLog(XpathUtils.class);
    private static final ErrorHandler ERROR_HANDLER = new ErrorHandler(){

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            if (log.isDebugEnabled()) {
                log.debug("xml parse warning: " + sAXParseException.getMessage(), sAXParseException);
            }
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            if (log.isDebugEnabled()) {
                log.debug("xml parse error: " + sAXParseException.getMessage(), sAXParseException);
            }
        }
    };
    private static volatile DocumentBuilderInfo cachedDocumentBuilderInfo = null;
    private static final ThreadLocal<XPathFactory> X_PATH_FACTORY = SdkThreadLocalsRegistry.register(new ThreadLocal<XPathFactory>(){

        @Override
        protected XPathFactory initialValue() {
            return XPathFactory.newInstance();
        }
    });

    private static void speedUpDTMManager() throws Exception {
        Object obj;
        Class<?> clazz;
        Method method;
        Object object;
        if (System.getProperty(DTM_MANAGER_DEFAULT_PROP_NAME) == null && DTM_MANAGER_IMPL_CLASS_NAME.equals((object = (method = (clazz = Class.forName(XPATH_CONTEXT_CLASS_NAME)).getMethod("getDTMManager", new Class[0])).invoke(obj = clazz.newInstance(), new Object[0])).getClass().getName())) {
            System.setProperty(DTM_MANAGER_DEFAULT_PROP_NAME, DTM_MANAGER_IMPL_CLASS_NAME);
        }
    }

    private static void speedUpDcoumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory;
        if (System.getProperty(DOCUMENT_BUILDER_FACTORY_PROP_NAME) == null && DOCUMENT_BUILDER_FACTORY_IMPL_CLASS_NAME.equals((documentBuilderFactory = DocumentBuilderFactory.newInstance()).getClass().getName())) {
            System.setProperty(DOCUMENT_BUILDER_FACTORY_PROP_NAME, DOCUMENT_BUILDER_FACTORY_IMPL_CLASS_NAME);
        }
    }

    public static XPath xpath() {
        return X_PATH_FACTORY.get().newXPath();
    }

    public static Document documentFrom(InputStream inputStream2) throws SAXException, IOException, ParserConfigurationException {
        inputStream2 = new NamespaceRemovingInputStream(inputStream2);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        XpathUtils.configureDocumentBuilderFactory(documentBuilderFactory);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(ERROR_HANDLER);
        Document document = documentBuilder.parse(inputStream2);
        inputStream2.close();
        return document;
    }

    public static Document documentFrom(String string) throws SAXException, IOException, ParserConfigurationException {
        return XpathUtils.documentFrom(new ByteArrayInputStream(string.getBytes(StringUtils.UTF8)));
    }

    public static Document documentFrom(URL uRL) throws SAXException, IOException, ParserConfigurationException {
        return XpathUtils.documentFrom(uRL.openStream());
    }

    public static Double asDouble(String string, Node node) throws XPathExpressionException {
        return XpathUtils.asDouble(string, node, XpathUtils.xpath());
    }

    public static Double asDouble(String string, Node node, XPath xPath) throws XPathExpressionException {
        String string2 = XpathUtils.evaluateAsString(string, node, xPath);
        return XpathUtils.isEmptyString(string2) ? null : Double.valueOf(Double.parseDouble(string2));
    }

    public static String asString(String string, Node node) throws XPathExpressionException {
        return XpathUtils.evaluateAsString(string, node, XpathUtils.xpath());
    }

    public static String asString(String string, Node node, XPath xPath) throws XPathExpressionException {
        return XpathUtils.evaluateAsString(string, node, xPath);
    }

    public static Integer asInteger(String string, Node node) throws XPathExpressionException {
        return XpathUtils.asInteger(string, node, XpathUtils.xpath());
    }

    public static Integer asInteger(String string, Node node, XPath xPath) throws XPathExpressionException {
        String string2 = XpathUtils.evaluateAsString(string, node, xPath);
        return XpathUtils.isEmptyString(string2) ? null : Integer.valueOf(Integer.parseInt(string2));
    }

    public static Boolean asBoolean(String string, Node node) throws XPathExpressionException {
        return XpathUtils.asBoolean(string, node, XpathUtils.xpath());
    }

    public static Boolean asBoolean(String string, Node node, XPath xPath) throws XPathExpressionException {
        String string2 = XpathUtils.evaluateAsString(string, node, xPath);
        return XpathUtils.isEmptyString(string2) ? null : Boolean.valueOf(Boolean.parseBoolean(string2));
    }

    public static Float asFloat(String string, Node node) throws XPathExpressionException {
        return XpathUtils.asFloat(string, node, XpathUtils.xpath());
    }

    public static Float asFloat(String string, Node node, XPath xPath) throws XPathExpressionException {
        String string2 = XpathUtils.evaluateAsString(string, node, xPath);
        return XpathUtils.isEmptyString(string2) ? null : Float.valueOf(string2);
    }

    public static Long asLong(String string, Node node) throws XPathExpressionException {
        return XpathUtils.asLong(string, node, XpathUtils.xpath());
    }

    public static Long asLong(String string, Node node, XPath xPath) throws XPathExpressionException {
        String string2 = XpathUtils.evaluateAsString(string, node, xPath);
        return XpathUtils.isEmptyString(string2) ? null : Long.valueOf(Long.parseLong(string2));
    }

    public static Byte asByte(String string, Node node) throws XPathExpressionException {
        return XpathUtils.asByte(string, node, XpathUtils.xpath());
    }

    public static Byte asByte(String string, Node node, XPath xPath) throws XPathExpressionException {
        String string2 = XpathUtils.evaluateAsString(string, node, xPath);
        return XpathUtils.isEmptyString(string2) ? null : Byte.valueOf(string2);
    }

    public static Date asDate(String string, Node node) throws XPathExpressionException {
        return XpathUtils.asDate(string, node, XpathUtils.xpath());
    }

    public static Date asDate(String string, Node node, XPath xPath) throws XPathExpressionException {
        String string2 = XpathUtils.evaluateAsString(string, node, xPath);
        if (XpathUtils.isEmptyString(string2)) {
            return null;
        }
        try {
            return DateUtils.parseISO8601Date(string2);
        }
        catch (Exception exception) {
            log.warn("Unable to parse date '" + string2 + "':  " + exception.getMessage(), exception);
            return null;
        }
    }

    public static ByteBuffer asByteBuffer(String string, Node node) throws XPathExpressionException {
        return XpathUtils.asByteBuffer(string, node, XpathUtils.xpath());
    }

    public static ByteBuffer asByteBuffer(String string, Node node, XPath xPath) throws XPathExpressionException {
        String string2 = XpathUtils.evaluateAsString(string, node, xPath);
        if (XpathUtils.isEmptyString(string2)) {
            return null;
        }
        if (!XpathUtils.isEmpty(node)) {
            byte[] byArray = Base64.decode(string2);
            return ByteBuffer.wrap(byArray);
        }
        return null;
    }

    public static boolean isEmpty(Node node) {
        return node == null;
    }

    public static Node asNode(String string, Node node) throws XPathExpressionException {
        return XpathUtils.asNode(string, node, XpathUtils.xpath());
    }

    public static Node asNode(String string, Node node, XPath xPath) throws XPathExpressionException {
        if (node == null) {
            return null;
        }
        return (Node)xPath.evaluate(string, node, XPathConstants.NODE);
    }

    public static int nodeLength(NodeList nodeList) {
        return nodeList == null ? 0 : nodeList.getLength();
    }

    private static String evaluateAsString(String string, Node node, XPath xPath) throws XPathExpressionException {
        if (XpathUtils.isEmpty(node)) {
            return null;
        }
        if (!string.equals(".") && XpathUtils.asNode(string, node, xPath) == null) {
            return null;
        }
        String string2 = xPath.evaluate(string, node);
        return string2.trim();
    }

    private static boolean isEmptyString(String string) {
        return string == null || string.trim().length() == 0;
    }

    private static void configureDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        block6: {
            DocumentBuilderInfo documentBuilderInfo = cachedDocumentBuilderInfo;
            if (documentBuilderInfo != null && documentBuilderInfo.clzz.equals(documentBuilderFactory.getClass())) {
                if (documentBuilderInfo.xxeMitigationSuccessful) {
                    try {
                        if (XpathUtils.isXerces(documentBuilderInfo.canonicalName)) {
                            XpathUtils.configureXercesFactory(documentBuilderFactory);
                            break block6;
                        }
                        XpathUtils.configureGenericFactory(documentBuilderFactory);
                    }
                    catch (Throwable throwable) {
                        log.warn("Unable to configure DocumentBuilderFactory to protect against XXE attacks", throwable);
                    }
                }
            } else {
                XpathUtils.initialConfigureDocumentBuilderFactory(documentBuilderFactory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialConfigureDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        Class<XpathUtils> clazz = XpathUtils.class;
        synchronized (XpathUtils.class) {
            boolean bl;
            Class<?> clazz2 = documentBuilderFactory.getClass();
            String string = clazz2.getCanonicalName();
            try {
                if (XpathUtils.isXerces(string)) {
                    XpathUtils.configureXercesFactory(documentBuilderFactory);
                } else {
                    XpathUtils.configureGenericFactory(documentBuilderFactory);
                }
                bl = true;
            }
            catch (Throwable throwable) {
                log.warn("Unable to configure DocumentBuilderFactory to protect against XXE attacks", throwable);
                bl = false;
            }
            cachedDocumentBuilderInfo = new DocumentBuilderInfo(clazz2, string, bl);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static boolean isXerces(String string) {
        return string.startsWith("org.apache.xerces.") || string.startsWith("com.sun.org.apache.xerces.");
    }

    private static void configureXercesFactory(DocumentBuilderFactory documentBuilderFactory) throws ParserConfigurationException {
        XpathUtils.commonConfigureFactory(documentBuilderFactory);
        documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
    }

    private static void configureGenericFactory(DocumentBuilderFactory documentBuilderFactory) throws ParserConfigurationException {
        XpathUtils.commonConfigureFactory(documentBuilderFactory);
        documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
    }

    private static void commonConfigureFactory(DocumentBuilderFactory documentBuilderFactory) throws ParserConfigurationException {
        documentBuilderFactory.setXIncludeAware(false);
        documentBuilderFactory.setExpandEntityReferences(false);
        documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
    }

    static {
        try {
            XpathUtils.speedUpDcoumentBuilderFactory();
        }
        catch (Throwable throwable) {
            log.debug("Ingore failure in speeding up DocumentBuilderFactory", throwable);
        }
        try {
            XpathUtils.speedUpDTMManager();
        }
        catch (Throwable throwable) {
            log.debug("Ingore failure in speeding up DTMManager", throwable);
        }
    }

    private static class DocumentBuilderInfo {
        private final Class<?> clzz;
        private final String canonicalName;
        private final boolean xxeMitigationSuccessful;

        private DocumentBuilderInfo(Class<?> clazz, String string, boolean bl) {
            this.clzz = clazz;
            this.canonicalName = string;
            this.xxeMitigationSuccessful = bl;
        }
    }
}

