/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import java.util.Collection;

public class ValidationUtils {
    public static <T> T assertNotNull(T t2, String string) throws IllegalArgumentException {
        if (t2 == null) {
            throw new IllegalArgumentException(String.format("%s cannot be null", string));
        }
        return t2;
    }

    public static void assertAllAreNull(String string, Object ... objectArray) throws IllegalArgumentException {
        for (Object object : objectArray) {
            if (object == null) continue;
            throw new IllegalArgumentException(string);
        }
    }

    public static int assertIsPositive(int n, String string) {
        if (n <= 0) {
            throw new IllegalArgumentException(String.format("%s must be positive", string));
        }
        return n;
    }

    public static <T extends Collection<?>> T assertNotEmpty(T t2, String string) throws IllegalArgumentException {
        ValidationUtils.assertNotNull(t2, string);
        if (t2.isEmpty()) {
            throw new IllegalArgumentException(String.format("%s cannot be empty", string));
        }
        return t2;
    }

    public static <T> T[] assertNotEmpty(T[] TArray, String string) throws IllegalArgumentException {
        ValidationUtils.assertNotNull(TArray, string);
        if (TArray.length == 0) {
            throw new IllegalArgumentException(String.format("%s cannot be empty", string));
        }
        return TArray;
    }

    public static String assertStringNotEmpty(String string, String string2) throws IllegalArgumentException {
        ValidationUtils.assertNotNull(string, string2);
        if (string.isEmpty()) {
            throw new IllegalArgumentException(String.format("%s cannot be empty", string2));
        }
        return string;
    }
}

