/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.annotation.Immutable;
import com.amazonaws.util.NameValuePair;
import com.amazonaws.util.StringUtils;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.BitSet;
import java.util.List;

@Immutable
class URLEncodedUtils {
    private static final char QP_SEP_A = '&';
    private static final String NAME_VALUE_SEPARATOR = "=";
    private static final BitSet UNRESERVED;
    private static final BitSet PUNCT;
    private static final BitSet USERINFO;
    private static final BitSet PATHSAFE;
    private static final BitSet URIC;
    private static final BitSet RESERVED;
    private static final BitSet URLENCODER;
    private static final int RADIX = 16;

    URLEncodedUtils() {
    }

    public static String format(List<? extends NameValuePair> list, String string) {
        return URLEncodedUtils.format(list, '&', string);
    }

    public static String format(List<? extends NameValuePair> list, char c, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (NameValuePair nameValuePair : list) {
            String string2 = URLEncodedUtils.encodeFormFields(nameValuePair.getName(), string);
            String string3 = URLEncodedUtils.encodeFormFields(nameValuePair.getValue(), string);
            if (stringBuilder.length() > 0) {
                stringBuilder.append(c);
            }
            stringBuilder.append(string2);
            if (string3 == null) continue;
            stringBuilder.append(NAME_VALUE_SEPARATOR);
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    public static String format(Iterable<? extends NameValuePair> iterable, Charset charset) {
        return URLEncodedUtils.format(iterable, '&', charset);
    }

    public static String format(Iterable<? extends NameValuePair> iterable, char c, Charset charset) {
        StringBuilder stringBuilder = new StringBuilder();
        for (NameValuePair nameValuePair : iterable) {
            String string = URLEncodedUtils.encodeFormFields(nameValuePair.getName(), charset);
            String string2 = URLEncodedUtils.encodeFormFields(nameValuePair.getValue(), charset);
            if (stringBuilder.length() > 0) {
                stringBuilder.append(c);
            }
            stringBuilder.append(string);
            if (string2 == null) continue;
            stringBuilder.append(NAME_VALUE_SEPARATOR);
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private static String urlEncode(String string, Charset charset, BitSet bitSet, boolean bl) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        ByteBuffer byteBuffer = charset.encode(string);
        while (byteBuffer.hasRemaining()) {
            int n = byteBuffer.get() & 0xFF;
            if (bitSet.get(n)) {
                stringBuilder.append((char)n);
                continue;
            }
            if (bl && n == 32) {
                stringBuilder.append('+');
                continue;
            }
            stringBuilder.append("%");
            char c = Character.toUpperCase(Character.forDigit(n >> 4 & 0xF, 16));
            char c2 = Character.toUpperCase(Character.forDigit(n & 0xF, 16));
            stringBuilder.append(c);
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    private static String encodeFormFields(String string, String string2) {
        if (string == null) {
            return null;
        }
        return URLEncodedUtils.urlEncode(string, string2 != null ? Charset.forName(string2) : StringUtils.UTF8, URLENCODER, true);
    }

    private static String encodeFormFields(String string, Charset charset) {
        if (string == null) {
            return null;
        }
        return URLEncodedUtils.urlEncode(string, charset != null ? charset : StringUtils.UTF8, URLENCODER, true);
    }

    static String encUserInfo(String string, Charset charset) {
        return URLEncodedUtils.urlEncode(string, charset, USERINFO, false);
    }

    static String encUric(String string, Charset charset) {
        return URLEncodedUtils.urlEncode(string, charset, URIC, false);
    }

    static String encPath(String string, Charset charset) {
        return URLEncodedUtils.urlEncode(string, charset, PATHSAFE, false);
    }

    static {
        int n;
        UNRESERVED = new BitSet(256);
        PUNCT = new BitSet(256);
        USERINFO = new BitSet(256);
        PATHSAFE = new BitSet(256);
        URIC = new BitSet(256);
        RESERVED = new BitSet(256);
        URLENCODER = new BitSet(256);
        for (n = 97; n <= 122; ++n) {
            UNRESERVED.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            UNRESERVED.set(n);
        }
        for (n = 48; n <= 57; ++n) {
            UNRESERVED.set(n);
        }
        UNRESERVED.set(95);
        UNRESERVED.set(45);
        UNRESERVED.set(46);
        UNRESERVED.set(42);
        URLENCODER.or(UNRESERVED);
        UNRESERVED.set(33);
        UNRESERVED.set(126);
        UNRESERVED.set(39);
        UNRESERVED.set(40);
        UNRESERVED.set(41);
        PUNCT.set(44);
        PUNCT.set(59);
        PUNCT.set(58);
        PUNCT.set(36);
        PUNCT.set(38);
        PUNCT.set(43);
        PUNCT.set(61);
        USERINFO.or(UNRESERVED);
        USERINFO.or(PUNCT);
        PATHSAFE.or(UNRESERVED);
        PATHSAFE.set(47);
        PATHSAFE.set(59);
        PATHSAFE.set(58);
        PATHSAFE.set(64);
        PATHSAFE.set(38);
        PATHSAFE.set(61);
        PATHSAFE.set(43);
        PATHSAFE.set(36);
        PATHSAFE.set(44);
        RESERVED.set(59);
        RESERVED.set(47);
        RESERVED.set(63);
        RESERVED.set(58);
        RESERVED.set(64);
        RESERVED.set(38);
        RESERVED.set(61);
        RESERVED.set(43);
        RESERVED.set(36);
        RESERVED.set(44);
        RESERVED.set(91);
        RESERVED.set(93);
        URIC.or(RESERVED);
        URIC.or(UNRESERVED);
    }
}

