/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.SignableRequest;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.util.BasicNameValuePair;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.URLEncodedUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SdkHttpUtils {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final Pattern ENCODED_CHARACTERS_PATTERN;

    public static String urlEncode(String string, boolean bl) {
        if (string == null) {
            return "";
        }
        try {
            String string2 = URLEncoder.encode(string, DEFAULT_ENCODING);
            Matcher matcher = ENCODED_CHARACTERS_PATTERN.matcher(string2);
            StringBuffer stringBuffer = new StringBuffer(string2.length());
            while (matcher.find()) {
                String string3 = matcher.group(0);
                if ("+".equals(string3)) {
                    string3 = "%20";
                } else if ("*".equals(string3)) {
                    string3 = "%2A";
                } else if ("%7E".equals(string3)) {
                    string3 = "~";
                } else if (bl && "%2F".equals(string3)) {
                    string3 = "/";
                }
                matcher.appendReplacement(stringBuffer, string3);
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static String urlDecode(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLDecoder.decode(string, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static boolean isUsingNonDefaultPort(URI uRI) {
        String string = StringUtils.lowerCase(uRI.getScheme());
        int n = uRI.getPort();
        if (n <= 0) {
            return false;
        }
        if (string.equals("http") && n == 80) {
            return false;
        }
        return !string.equals("https") || n != 443;
    }

    public static boolean usePayloadForQueryParameters(SignableRequest<?> signableRequest) {
        boolean bl = HttpMethodName.POST.equals((Object)signableRequest.getHttpMethod());
        boolean bl2 = signableRequest.getContent() == null;
        return bl && bl2;
    }

    public static String encodeParameters(SignableRequest<?> signableRequest) {
        Map<String, List<String>> map = signableRequest.getParameters();
        if (map.isEmpty()) {
            return null;
        }
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String string = entry.getKey();
            for (String string2 : entry.getValue()) {
                arrayList.add(new BasicNameValuePair(string, string2));
            }
        }
        return URLEncodedUtils.format(arrayList, DEFAULT_ENCODING);
    }

    public static String appendUri(String string, String string2) {
        return SdkHttpUtils.appendUri(string, string2, false);
    }

    public static String appendUri(String string, String string2, boolean bl) {
        String string3 = string;
        if (string2 != null && string2.length() > 0) {
            if (string2.startsWith("/")) {
                if (string3.endsWith("/")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
            } else if (!string3.endsWith("/")) {
                string3 = string3 + "/";
            }
            string3 = bl ? string3 + string2.replace("//", "/%2F") : string3 + string2;
        } else if (!string3.endsWith("/")) {
            string3 = string3 + "/";
        }
        return string3;
    }

    static {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Pattern.quote("+")).append("|").append(Pattern.quote("*")).append("|").append(Pattern.quote("%7E")).append("|").append(Pattern.quote("%2F"));
        ENCODED_CHARACTERS_PATTERN = Pattern.compile(stringBuilder.toString());
    }
}

