/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@SdkInternalApi
public class ReflectionMethodInvoker<T, R> {
    private final Class<T> clazz;
    private final String methodName;
    private final Class<R> returnType;
    private final Class<?>[] parameterTypes;
    private Method targetMethod;

    public ReflectionMethodInvoker(Class<T> clazz, Class<R> clazz2, String string, Class<?> ... classArray) {
        this.clazz = clazz;
        this.methodName = string;
        this.returnType = clazz2;
        this.parameterTypes = classArray;
    }

    public R invoke(T t2, Object ... objectArray) throws NoSuchMethodException {
        Method method = this.getTargetMethod();
        try {
            Object object = method.invoke(t2, objectArray);
            return this.returnType.cast(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SdkClientException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SdkClientException(invocationTargetException);
        }
    }

    public void initialize() throws NoSuchMethodException {
        this.getTargetMethod();
    }

    public boolean isInitialized() {
        return this.targetMethod != null;
    }

    private Method getTargetMethod() throws NoSuchMethodException {
        if (this.targetMethod != null) {
            return this.targetMethod;
        }
        try {
            this.targetMethod = this.clazz.getMethod(this.methodName, this.parameterTypes);
            return this.targetMethod;
        }
        catch (NullPointerException nullPointerException) {
            throw new SdkClientException(nullPointerException);
        }
    }
}

