/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.annotation.SdkInternalApi;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

@SdkInternalApi
public class NamedDefaultThreadFactory
implements ThreadFactory {
    private static final Map<String, AtomicInteger> poolNumberMap = new ConcurrentHashMap<String, AtomicInteger>();
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;

    public static NamedDefaultThreadFactory of(String string) {
        return new NamedDefaultThreadFactory(string);
    }

    private NamedDefaultThreadFactory(String string) {
        AtomicInteger atomicInteger = NamedDefaultThreadFactory.getPoolNumberForName(string);
        SecurityManager securityManager = System.getSecurityManager();
        this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = "pool-" + string + "-" + atomicInteger.getAndIncrement() + "-thread-";
    }

    @Override
    public Thread newThread(Runnable runnable2) {
        Thread thread2 = new Thread(this.group, runnable2, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        if (thread2.isDaemon()) {
            thread2.setDaemon(false);
        }
        if (thread2.getPriority() != 5) {
            thread2.setPriority(5);
        }
        return thread2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AtomicInteger getPoolNumberForName(String string) {
        AtomicInteger atomicInteger = poolNumberMap.get(string);
        if (atomicInteger != null) return atomicInteger;
        Class<NamedDefaultThreadFactory> clazz = NamedDefaultThreadFactory.class;
        synchronized (NamedDefaultThreadFactory.class) {
            atomicInteger = poolNumberMap.get(string);
            if (atomicInteger != null) return atomicInteger;
            atomicInteger = new AtomicInteger(1);
            poolNumberMap.put(string, atomicInteger);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return atomicInteger;
        }
    }
}

