/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.log.InternalLogFactory;
import com.amazonaws.util.Classes;
import com.amazonaws.util.DateUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public enum JodaTime {

    private static final boolean expectedBehavior = JodaTime.checkExpectedBehavior();

    public static String getVersion() {
        return LazyHolder.version;
    }

    public static boolean hasExpectedBehavior() {
        return expectedBehavior;
    }

    private static boolean checkExpectedBehavior() {
        try {
            return JodaTime.checkTT0031561767() && JodaTime.checkFormatIso8601Date() && JodaTime.checkFormatRfc822Date() && JodaTime.checkAlternateIso8601DateFormat() && JodaTime.checkInvalidDate() && JodaTime.checkParseCompressedIso8601Date() && JodaTime.checkParseIso8601Date() && JodaTime.checkParseIso8601DateUsingAlternativeFormat() && JodaTime.checkParseRfc822Date();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean checkTT0031561767() throws ParseException {
        String string = "Fri, 16 May 2014 23:56:46 GMT";
        Date date = new Date(DateUtils.rfc822DateFormat.parseMillis(string));
        return string.equals(DateUtils.rfc822DateFormat.print(date.getTime()));
    }

    private static boolean checkFormatIso8601Date() throws ParseException {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        String string = simpleDateFormat.format(date);
        String string2 = DateUtils.iso8601DateFormat.print(date.getTime());
        if (string.equals(string2)) {
            Date date2 = simpleDateFormat.parse(string);
            Date date3 = DateUtils.doParseISO8601Date(string2);
            return date2.equals(date3);
        }
        return false;
    }

    private static boolean checkFormatRfc822Date() throws ParseException {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        String string = simpleDateFormat.format(date);
        String string2 = DateUtils.rfc822DateFormat.print(date.getTime());
        if (string.equals(string2)) {
            Date date2 = simpleDateFormat.parse(string);
            Date date3 = new Date(DateUtils.rfc822DateFormat.parseMillis(string2));
            return date2.equals(date3);
        }
        return false;
    }

    private static boolean checkParseCompressedIso8601Date() throws ParseException {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        String string = simpleDateFormat.format(date);
        Date date2 = simpleDateFormat.parse(string);
        Date date3 = new Date(DateUtils.compressedIso8601DateFormat.parseMillis(string));
        return date2.equals(date3);
    }

    private static boolean checkParseRfc822Date() throws ParseException {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        String string = simpleDateFormat.format(date);
        Date date2 = simpleDateFormat.parse(string);
        Date date3 = new Date(DateUtils.rfc822DateFormat.parseMillis(string));
        return date2.equals(date3);
    }

    private static boolean checkParseIso8601Date() throws ParseException {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        String string = simpleDateFormat.format(date);
        String string2 = DateUtils.iso8601DateFormat.print(date.getTime());
        if (string.equals(string2)) {
            Date date2 = simpleDateFormat.parse(string);
            Date date3 = DateUtils.doParseISO8601Date(string);
            return date2.equals(date3);
        }
        return false;
    }

    private static boolean checkParseIso8601DateUsingAlternativeFormat() throws ParseException {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        String string = simpleDateFormat.format(date);
        String string2 = DateUtils.alternateIso8601DateFormat.print(date.getTime());
        if (string.equals(string2)) {
            Date date2 = simpleDateFormat.parse(string);
            Date date3 = DateUtils.parseISO8601Date(string);
            return date2.equals(date3);
        }
        return false;
    }

    private static boolean checkAlternateIso8601DateFormat() throws ParseException {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        String string = simpleDateFormat.format(date);
        String string2 = DateUtils.alternateIso8601DateFormat.print(date.getTime());
        if (string.equals(string2)) {
            Date date2 = simpleDateFormat.parse(string);
            DateTime dateTime = DateUtils.alternateIso8601DateFormat.parseDateTime(string2);
            return date2.getTime() == dateTime.getMillis();
        }
        return false;
    }

    private static boolean checkInvalidDate() {
        String string = "2014-03-06T14:28:58.000Z.000Z";
        try {
            DateUtils.doParseISO8601Date("2014-03-06T14:28:58.000Z.000Z");
            return false;
        }
        catch (RuntimeException runtimeException) {
            return true;
        }
    }

    private static class LazyHolder {
        static final String version = LazyHolder.getVersion();

        private LazyHolder() {
        }

        private static String getVersion() {
            try {
                JarFile jarFile = Classes.jarFileOf(DateTimeZone.class);
                if (jarFile == null) {
                    return null;
                }
                Manifest manifest = jarFile.getManifest();
                Attributes attributes = manifest.getMainAttributes();
                String string = attributes.getValue("Bundle-Name");
                String string2 = attributes.getValue("Bundle-Version");
                if ("Joda-Time".equals(string) && string2 != null) {
                    return string2;
                }
            }
            catch (Exception exception) {
                InternalLogFactory.getLog(JodaTime.class).debug("FYI", exception);
            }
            return null;
        }
    }
}

