/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.AmazonClientException;
import com.amazonaws.SdkClientException;
import com.amazonaws.internal.InstanceMetadataServiceResourceFetcher;
import com.amazonaws.retry.internal.CredentialsEndpointRetryParameters;
import com.amazonaws.retry.internal.CredentialsEndpointRetryPolicy;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.Jackson;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EC2MetadataUtils {
    private static final String REGION = "region";
    private static final String INSTANCE_IDENTITY_DOCUMENT = "instance-identity/document";
    private static final String INSTANCE_IDENTITY_SIGNATURE = "instance-identity/signature";
    private static final String EC2_METADATA_ROOT = "/latest/meta-data";
    private static final String EC2_USERDATA_ROOT = "/latest/user-data/";
    private static final String EC2_DYNAMICDATA_ROOT = "/latest/dynamic/";
    private static final String EC2_METADATA_SERVICE_URL = "http://169.254.169.254";
    public static final String SECURITY_CREDENTIALS_RESOURCE = "/latest/meta-data/iam/security-credentials/";
    private static final int DEFAULT_QUERY_RETRIES = 3;
    private static final int MINIMUM_RETRY_WAIT_TIME_MILLISECONDS = 250;
    private static Map<String, String> cache = new ConcurrentHashMap<String, String>();
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Log log;

    public static String getAmiId() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/ami-id");
    }

    public static String getAmiLaunchIndex() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/ami-launch-index");
    }

    public static String getAmiManifestPath() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/ami-manifest-path");
    }

    public static List<String> getAncestorAmiIds() {
        return EC2MetadataUtils.getItems("/latest/meta-data/ancestor-ami-ids");
    }

    public static String getInstanceAction() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/instance-action");
    }

    public static String getInstanceId() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/instance-id");
    }

    public static String getInstanceType() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/instance-type");
    }

    public static String getLocalHostName() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/local-hostname");
    }

    public static String getMacAddress() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/mac");
    }

    public static String getPrivateIpAddress() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/local-ipv4");
    }

    public static String getAvailabilityZone() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/placement/availability-zone");
    }

    public static List<String> getProductCodes() {
        return EC2MetadataUtils.getItems("/latest/meta-data/product-codes");
    }

    public static String getPublicKey() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/public-keys/0/openssh-key");
    }

    public static String getRamdiskId() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/ramdisk-id");
    }

    public static String getReservationId() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/reservation-id");
    }

    public static List<String> getSecurityGroups() {
        return EC2MetadataUtils.getItems("/latest/meta-data/security-groups");
    }

    public static IAMInfo getIAMInstanceProfileInfo() {
        String string = EC2MetadataUtils.getData("/latest/meta-data/iam/info");
        if (null == string) {
            return null;
        }
        try {
            return mapper.readValue(string, IAMInfo.class);
        }
        catch (Exception exception) {
            log.warn("Unable to parse IAM Instance profile info (" + string + "): " + exception.getMessage(), exception);
            return null;
        }
    }

    public static InstanceInfo getInstanceInfo() {
        return EC2MetadataUtils.doGetInstanceInfo(EC2MetadataUtils.getData("/latest/dynamic/instance-identity/document"));
    }

    public static String getInstanceSignature() {
        return EC2MetadataUtils.fetchData("/latest/dynamic/instance-identity/signature");
    }

    static InstanceInfo doGetInstanceInfo(String string) {
        if (null != string) {
            try {
                InstanceInfo instanceInfo = Jackson.fromJsonString(string, InstanceInfo.class);
                return instanceInfo;
            }
            catch (Exception exception) {
                log.warn("Unable to parse dynamic EC2 instance info (" + string + ") : " + exception.getMessage(), exception);
            }
        }
        return null;
    }

    public static String getEC2InstanceRegion() {
        return EC2MetadataUtils.doGetEC2InstanceRegion(EC2MetadataUtils.getData("/latest/dynamic/instance-identity/document"));
    }

    static String doGetEC2InstanceRegion(String string) {
        if (null != string) {
            try {
                JsonNode jsonNode = mapper.readTree(string.getBytes(StringUtils.UTF8));
                JsonNode jsonNode2 = jsonNode.findValue(REGION);
                return jsonNode2.asText();
            }
            catch (Exception exception) {
                log.warn("Unable to parse EC2 instance info (" + string + ") : " + exception.getMessage(), exception);
            }
        }
        return null;
    }

    public static Map<String, IAMSecurityCredential> getIAMSecurityCredentials() {
        HashMap<String, IAMSecurityCredential> hashMap = new HashMap<String, IAMSecurityCredential>();
        List<String> list = EC2MetadataUtils.getItems("/latest/meta-data/iam/security-credentials");
        if (list != null) {
            for (String string : list) {
                String string2 = EC2MetadataUtils.getData(SECURITY_CREDENTIALS_RESOURCE + string);
                try {
                    IAMSecurityCredential iAMSecurityCredential = mapper.readValue(string2, IAMSecurityCredential.class);
                    hashMap.put(string, iAMSecurityCredential);
                }
                catch (Exception exception) {
                    log.warn("Unable to process the credential (" + string + "). " + exception.getMessage(), exception);
                }
            }
        }
        return hashMap;
    }

    public static Map<String, String> getBlockDeviceMapping() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        List<String> list = EC2MetadataUtils.getItems("/latest/meta-data/block-device-mapping");
        if (list != null) {
            for (String string : list) {
                hashMap.put(string, EC2MetadataUtils.getData("/latest/meta-data/block-device-mapping/" + string));
            }
        }
        return hashMap;
    }

    public static List<NetworkInterface> getNetworkInterfaces() {
        LinkedList<NetworkInterface> linkedList = new LinkedList<NetworkInterface>();
        List<String> list = EC2MetadataUtils.getItems("/latest/meta-data/network/interfaces/macs/");
        if (list != null) {
            for (String string : list) {
                String string2 = string.trim();
                if (string2.endsWith("/")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                linkedList.add(new NetworkInterface(string2));
            }
        }
        return linkedList;
    }

    public static String getUserData() {
        return EC2MetadataUtils.getData(EC2_USERDATA_ROOT);
    }

    public static String getData(String string) {
        return EC2MetadataUtils.getData(string, 3);
    }

    public static String getData(String string, int n) {
        List<String> list = EC2MetadataUtils.getItems(string, n, true);
        if (null != list && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public static List<String> getItems(String string) {
        return EC2MetadataUtils.getItems(string, 3, false);
    }

    public static List<String> getItems(String string, int n) {
        return EC2MetadataUtils.getItems(string, n, false);
    }

    private static List<String> getItems(String string, int n, boolean bl) {
        if (n == 0) {
            throw new SdkClientException("Unable to contact EC2 metadata service.");
        }
        try {
            String string2 = EC2MetadataUtils.getHostAddressForEC2MetadataService();
            String string3 = InstanceMetadataServiceResourceFetcher.getInstance().readResource(new URI(string2 + string), EC2MetadataUtilsRetryPolicy.INSTANCE);
            List<String> list = bl ? Collections.singletonList(string3) : Arrays.asList(string3.split("\n"));
            return list;
        }
        catch (Exception exception) {
            log.warn("Unable to retrieve the requested metadata (" + string + "). " + exception.getMessage(), exception);
            return null;
        }
    }

    private static String fetchData(String string) {
        return EC2MetadataUtils.fetchData(string, false);
    }

    private static String fetchData(String string, boolean bl) {
        try {
            if (bl || !cache.containsKey(string)) {
                cache.put(string, EC2MetadataUtils.getData(string));
            }
            return cache.get(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getHostAddressForEC2MetadataService() {
        String string = System.getProperty("com.amazonaws.sdk.ec2MetadataServiceEndpointOverride");
        if (string == null) {
            string = System.getenv("AWS_EC2_METADATA_SERVICE_ENDPOINT");
        }
        return string != null ? string : EC2_METADATA_SERVICE_URL;
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            mapper.setPropertyNamingStrategy(PropertyNamingStrategies.UPPER_CAMEL_CASE);
        }
        catch (LinkageError linkageError) {
            mapper.setPropertyNamingStrategy(PropertyNamingStrategy.PASCAL_CASE_TO_CAMEL_CASE);
        }
        log = LogFactory.getLog(EC2MetadataUtils.class);
    }

    private static final class EC2MetadataUtilsRetryPolicy
    implements CredentialsEndpointRetryPolicy {
        private static final EC2MetadataUtilsRetryPolicy INSTANCE = new EC2MetadataUtilsRetryPolicy();

        private EC2MetadataUtilsRetryPolicy() {
        }

        @Override
        public boolean shouldRetry(int n, CredentialsEndpointRetryParameters credentialsEndpointRetryParameters) {
            if (n >= 3) {
                return false;
            }
            if (credentialsEndpointRetryParameters.getException() instanceof AmazonClientException) {
                return false;
            }
            int n2 = (int)(Math.pow(2.0, 3 - n) * 250.0);
            try {
                Thread.sleep(Math.max(n2, 250));
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            return true;
        }
    }

    public static class NetworkInterface {
        private String path;
        private String mac;
        private List<String> availableKeys;
        private Map<String, String> data = new HashMap<String, String>();

        public NetworkInterface(String string) {
            this.mac = string;
            this.path = "/network/interfaces/macs/" + this.mac + "/";
        }

        public String getMacAddress() {
            return this.mac;
        }

        public String getOwnerId() {
            return this.getData("owner-id");
        }

        public String getProfile() {
            return this.getData("profile");
        }

        public String getHostname() {
            return this.getData("local-hostname");
        }

        public List<String> getLocalIPv4s() {
            return this.getItems("local-ipv4s");
        }

        public String getPublicHostname() {
            return this.getData("public-hostname");
        }

        public List<String> getPublicIPv4s() {
            return this.getItems("public-ipv4s");
        }

        public List<String> getSecurityGroups() {
            return this.getItems("security-groups");
        }

        public List<String> getSecurityGroupIds() {
            return this.getItems("security-group-ids");
        }

        public String getSubnetIPv4CidrBlock() {
            return this.getData("subnet-ipv4-cidr-block");
        }

        public String getSubnetId() {
            return this.getData("subnet-id");
        }

        public String getVpcIPv4CidrBlock() {
            return this.getData("vpc-ipv4-cidr-block");
        }

        public String getVpcId() {
            return this.getData("vpc-id");
        }

        public List<String> getIPv4Association(String string) {
            return EC2MetadataUtils.getItems(EC2MetadataUtils.EC2_METADATA_ROOT + this.path + "ipv4-associations/" + string);
        }

        private String getData(String string) {
            if (this.data.containsKey(string)) {
                return this.data.get(string);
            }
            if (null == this.availableKeys) {
                this.availableKeys = EC2MetadataUtils.getItems(EC2MetadataUtils.EC2_METADATA_ROOT + this.path);
            }
            if (this.availableKeys != null && this.availableKeys.contains(string)) {
                this.data.put(string, EC2MetadataUtils.getData(EC2MetadataUtils.EC2_METADATA_ROOT + this.path + string));
                return this.data.get(string);
            }
            return null;
        }

        private List<String> getItems(String string) {
            if (null == this.availableKeys) {
                this.availableKeys = EC2MetadataUtils.getItems(EC2MetadataUtils.EC2_METADATA_ROOT + this.path);
            }
            if (this.availableKeys != null && this.availableKeys.contains(string)) {
                return EC2MetadataUtils.getItems(EC2MetadataUtils.EC2_METADATA_ROOT + this.path + string);
            }
            return new LinkedList<String>();
        }
    }

    public static class InstanceInfo {
        private final String pendingTime;
        private final String instanceType;
        private final String imageId;
        private final String instanceId;
        private final String[] billingProducts;
        private final String architecture;
        private final String accountId;
        private final String kernelId;
        private final String ramdiskId;
        private final String region;
        private final String version;
        private final String availabilityZone;
        private final String privateIp;
        private final String[] devpayProductCodes;

        @JsonCreator
        public InstanceInfo(@JsonProperty(value="pendingTime", required=true) String string, @JsonProperty(value="instanceType", required=true) String string2, @JsonProperty(value="imageId", required=true) String string3, @JsonProperty(value="instanceId", required=true) String string4, @JsonProperty(value="billingProducts", required=false) String[] stringArray, @JsonProperty(value="architecture", required=true) String string5, @JsonProperty(value="accountId", required=true) String string6, @JsonProperty(value="kernelId", required=true) String string7, @JsonProperty(value="ramdiskId", required=false) String string8, @JsonProperty(value="region", required=true) String string9, @JsonProperty(value="version", required=true) String string10, @JsonProperty(value="availabilityZone", required=true) String string11, @JsonProperty(value="privateIp", required=true) String string12, @JsonProperty(value="devpayProductCodes", required=false) String[] stringArray2) {
            this.pendingTime = string;
            this.instanceType = string2;
            this.imageId = string3;
            this.instanceId = string4;
            this.billingProducts = stringArray == null ? null : (String[])stringArray.clone();
            this.architecture = string5;
            this.accountId = string6;
            this.kernelId = string7;
            this.ramdiskId = string8;
            this.region = string9;
            this.version = string10;
            this.availabilityZone = string11;
            this.privateIp = string12;
            this.devpayProductCodes = stringArray2 == null ? null : (String[])stringArray2.clone();
        }

        public String getPendingTime() {
            return this.pendingTime;
        }

        public String getInstanceType() {
            return this.instanceType;
        }

        public String getImageId() {
            return this.imageId;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public String[] getBillingProducts() {
            return this.billingProducts == null ? null : (String[])this.billingProducts.clone();
        }

        public String getArchitecture() {
            return this.architecture;
        }

        public String getAccountId() {
            return this.accountId;
        }

        public String getKernelId() {
            return this.kernelId;
        }

        public String getRamdiskId() {
            return this.ramdiskId;
        }

        public String getRegion() {
            return this.region;
        }

        public String getVersion() {
            return this.version;
        }

        public String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public String getPrivateIp() {
            return this.privateIp;
        }

        public String[] getDevpayProductCodes() {
            return this.devpayProductCodes == null ? null : (String[])this.devpayProductCodes.clone();
        }
    }

    public static class IAMSecurityCredential {
        public String code;
        public String message;
        public String lastUpdated;
        public String type;
        public String accessKeyId;
        public String secretAccessKey;
        public String token;
        public String expiration;
        @Deprecated
        public String secretAcessKey;
    }

    public static class IAMInfo {
        public String code;
        public String message;
        public String lastUpdated;
        public String instanceProfileArn;
        public String instanceProfileId;
    }
}

