/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform;

import com.amazonaws.http.HttpResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public class StaxUnmarshallerContext {
    private XMLEvent currentEvent;
    private final XMLEventReader eventReader;
    public final Stack<String> stack = new Stack();
    private String stackString = "";
    private Map<String, String> metadata = new HashMap<String, String>();
    private List<MetadataExpression> metadataExpressions = new ArrayList<MetadataExpression>();
    private Iterator<?> attributeIterator;
    private final Map<String, String> headers;
    private final HttpResponse httpResponse;
    private String currentHeader;

    public void setCurrentHeader(String string) {
        this.currentHeader = string;
    }

    public boolean isInsideResponseHeader() {
        return this.currentEvent == null;
    }

    public StaxUnmarshallerContext(XMLEventReader xMLEventReader) {
        this(xMLEventReader, null, null);
    }

    public StaxUnmarshallerContext(XMLEventReader xMLEventReader, Map<String, String> map) {
        this(xMLEventReader, map, null);
    }

    public StaxUnmarshallerContext(XMLEventReader xMLEventReader, Map<String, String> map, HttpResponse httpResponse) {
        this.eventReader = xMLEventReader;
        this.headers = map;
        this.httpResponse = httpResponse;
    }

    public String getHeader(String string) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.get(string);
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public String readText() throws XMLStreamException {
        XMLEvent xMLEvent;
        if (this.isInsideResponseHeader()) {
            return this.getHeader(this.currentHeader);
        }
        if (this.currentEvent.isAttribute()) {
            Attribute attribute = (Attribute)this.currentEvent;
            return attribute.getValue();
        }
        StringBuilder stringBuilder = new StringBuilder();
        while ((xMLEvent = this.eventReader.peek()).getEventType() == 4) {
            this.eventReader.nextEvent();
            stringBuilder.append(xMLEvent.asCharacters().getData());
        }
        if (xMLEvent.getEventType() == 2) {
            return stringBuilder.toString();
        }
        throw new RuntimeException("Encountered unexpected event: " + xMLEvent.toString());
    }

    public int getCurrentDepth() {
        return this.stack.size();
    }

    public boolean testExpression(String string) {
        if (string.equals(".")) {
            return true;
        }
        return this.stackString.endsWith(string);
    }

    public boolean testExpression(String string, int n) {
        if (string.equals(".")) {
            return true;
        }
        int n2 = -1;
        while ((n2 = string.indexOf("/", n2 + 1)) > -1) {
            if (string.charAt(n2 + 1) == '@') continue;
            ++n;
        }
        return n == this.getCurrentDepth() && this.stackString.endsWith("/" + string);
    }

    public boolean isStartOfDocument() throws XMLStreamException {
        return this.eventReader.peek().isStartDocument();
    }

    public XMLEvent nextEvent() throws XMLStreamException {
        XMLEvent xMLEvent;
        this.currentEvent = this.attributeIterator != null && this.attributeIterator.hasNext() ? (XMLEvent)this.attributeIterator.next() : this.eventReader.nextEvent();
        if (this.currentEvent.isStartElement()) {
            this.attributeIterator = this.currentEvent.asStartElement().getAttributes();
        }
        this.updateContext(this.currentEvent);
        if (this.eventReader.hasNext() && (xMLEvent = this.eventReader.peek()) != null && xMLEvent.isCharacters()) {
            for (MetadataExpression metadataExpression : this.metadataExpressions) {
                if (!this.testExpression(metadataExpression.expression, metadataExpression.targetDepth)) continue;
                this.metadata.put(metadataExpression.key, xMLEvent.asCharacters().getData());
            }
        }
        return this.currentEvent;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void registerMetadataExpression(String string, int n, String string2) {
        this.metadataExpressions.add(new MetadataExpression(string, n, string2));
    }

    private void updateContext(XMLEvent xMLEvent) {
        if (xMLEvent == null) {
            return;
        }
        if (xMLEvent.isEndElement()) {
            this.stack.pop();
            this.stackString = "";
            for (String string : this.stack) {
                this.stackString = this.stackString + "/" + string;
            }
        } else if (xMLEvent.isStartElement()) {
            this.stack.push(xMLEvent.asStartElement().getName().getLocalPart());
            this.stackString = this.stackString + "/" + xMLEvent.asStartElement().getName().getLocalPart();
        } else if (xMLEvent.isAttribute()) {
            Attribute attribute = (Attribute)xMLEvent;
            this.stackString = "";
            for (String string : this.stack) {
                this.stackString = this.stackString + "/" + string;
            }
            this.stackString = this.stackString + "/@" + attribute.getName().getLocalPart();
        }
    }

    private static class MetadataExpression {
        public String expression;
        public int targetDepth;
        public String key;

        public MetadataExpression(String string, int n, String string2) {
            this.expression = string;
            this.targetDepth = n;
            this.key = string2;
        }
    }
}

