/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkProtectedApi;
import com.amazonaws.transform.AbstractErrorUnmarshaller;
import com.amazonaws.util.XpathUtils;
import javax.xml.xpath.XPath;
import org.w3c.dom.Node;

@SdkProtectedApi
public class StandardErrorUnmarshaller
extends AbstractErrorUnmarshaller<Node> {
    public StandardErrorUnmarshaller() {
    }

    public StandardErrorUnmarshaller(Class<? extends AmazonServiceException> clazz) {
        super(clazz);
    }

    @Override
    public AmazonServiceException unmarshall(Node node) throws Exception {
        XPath xPath = XpathUtils.xpath();
        String string = this.parseErrorCode(node, xPath);
        String string2 = XpathUtils.asString("ErrorResponse/Error/Type", node, xPath);
        String string3 = XpathUtils.asString("ErrorResponse/RequestId", node, xPath);
        String string4 = XpathUtils.asString("ErrorResponse/Error/Message", node, xPath);
        AmazonServiceException amazonServiceException = this.newException(string4);
        amazonServiceException.setErrorCode(string);
        amazonServiceException.setRequestId(string3);
        if (string2 == null) {
            amazonServiceException.setErrorType(AmazonServiceException.ErrorType.Unknown);
        } else if (string2.equalsIgnoreCase("Receiver")) {
            amazonServiceException.setErrorType(AmazonServiceException.ErrorType.Service);
        } else if (string2.equalsIgnoreCase("Sender")) {
            amazonServiceException.setErrorType(AmazonServiceException.ErrorType.Client);
        }
        return amazonServiceException;
    }

    public String parseErrorCode(Node node) throws Exception {
        return XpathUtils.asString("ErrorResponse/Error/Code", node);
    }

    public String parseErrorCode(Node node, XPath xPath) throws Exception {
        return XpathUtils.asString("ErrorResponse/Error/Code", node, xPath);
    }

    public String getErrorPropertyPath(String string) {
        return "ErrorResponse/Error/" + string;
    }
}

